/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.chat.ChatPanelBasic;
import mage.client.components.MageComponents;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.dialog.TableWaitModel;
import mage.client.dialog.UpdateSeatsTask;
import mage.client.util.GUISizeHelper;
import mage.client.util.gui.GuiDisplayUtil;
import mage.client.util.gui.TableUtil;
import mage.client.util.gui.countryBox.CountryCellRenderer;
import mage.view.TableView;
import org.apache.log4j.Logger;

public class TableWaitingDialog
extends MageDialog {
    private static final Logger LOGGER = Logger.getLogger(TableWaitingDialog.class);
    private static final int[] DEFAULT_COLUMNS_WIDTH = new int[]{20, 50, 100, 100, 100, 100};
    private UUID tableId;
    private UUID roomId;
    private boolean isTournament;
    private final TableWaitModel tableWaitModel = new TableWaitModel();
    private UpdateSeatsTask updateTask;
    private JButton btnCancel;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnStart;
    private ChatPanelBasic chatPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTable jTableSeats;

    public TableWaitingDialog() {
        this.initComponents();
        int prefWidth = Integer.parseInt(PreferencesDialog.getCachedValue("tableWaitingPanelWidth", "500"));
        int prefHeight = Integer.parseInt(PreferencesDialog.getCachedValue("tableWaitingPanelHeight", "400"));
        if (prefWidth > 40 && prefHeight > 40) {
            this.setSize(prefWidth, prefHeight);
        }
        this.setGUISize();
        this.jTableSeats.createDefaultColumnsFromModel();
        this.jTableSeats.setDefaultRenderer(Icon.class, new CountryCellRenderer());
        TableUtil.setColumnWidthAndOrder(this.jTableSeats, DEFAULT_COLUMNS_WIDTH, "tableWaitingPanelColumnWidth", "tableWaitingPanelColumnSort");
        this.chatPanel.useExtendedView(ChatPanelBasic.VIEW_MODE.NONE);
        MageFrame.getUI().addButton(MageComponents.TABLE_WAITING_START_BUTTON, this.btnStart);
    }

    @Override
    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        this.jTableSeats.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.jTableSeats.setFont(GUISizeHelper.tableFont);
        this.jTableSeats.setRowHeight(GUISizeHelper.tableRowHeight);
        this.jSplitPane1.setDividerSize(GUISizeHelper.dividerBarSize);
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPane1.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
    }

    public void update(TableView table) {
        try {
            if (table != null) {
                switch (table.getTableState()) {
                    case READY_TO_START: {
                        this.btnStart.setEnabled(true);
                        this.btnMoveDown.setEnabled(true);
                        this.btnMoveUp.setEnabled(true);
                        break;
                    }
                    case WAITING: {
                        this.btnStart.setEnabled(false);
                        this.btnMoveDown.setEnabled(false);
                        this.btnMoveUp.setEnabled(false);
                        break;
                    }
                    default: {
                        this.doClose();
                        return;
                    }
                }
                int row = this.jTableSeats.getSelectedRow();
                if (this.getTitle().equals("Waiting for players")) {
                    this.title = this.getTitle() + " - " + table.getDeckType() + " / " + table.getGameType();
                    this.repaint();
                }
                this.tableWaitModel.loadData(table);
                this.jTableSeats.repaint();
                this.jTableSeats.getSelectionModel().setSelectionInterval(row, row);
            } else {
                this.doClose();
            }
        }
        catch (Exception ex) {
            this.doClose();
        }
    }

    public void showDialog(UUID roomId, UUID tableId, boolean isTournament) {
        Rectangle currentBounds = MageFrame.getDesktop().getBounds();
        Optional<UUID> chatId = SessionHandler.getTableChatId(tableId);
        String tournamentChatDivider = PreferencesDialog.getCachedValue("tablePanelDividerLocation4", null);
        this.updateTask = new UpdateSeatsTask(SessionHandler.getSession(), roomId, tableId, this);
        this.roomId = roomId;
        this.tableId = tableId;
        this.isTournament = isTournament;
        if (SessionHandler.isTableOwner(roomId, tableId)) {
            this.btnStart.setVisible(true);
            this.btnMoveDown.setVisible(true);
            this.btnMoveUp.setVisible(true);
        } else {
            this.btnStart.setVisible(false);
            this.btnMoveDown.setVisible(false);
            this.btnMoveUp.setVisible(false);
        }
        if (chatId.isPresent()) {
            this.chatPanel.connect(chatId.get());
            this.updateTask.execute();
            this.setModal(false);
            this.setLocation(100, 100);
            this.setVisible(true);
            GuiDisplayUtil.restoreDividerLocations(currentBounds, tournamentChatDivider, this.jSplitPane1);
        } else {
            this.doClose();
        }
    }

    public void doClose() {
        if (this.updateTask != null) {
            this.updateTask.cancel(true);
        }
        this.chatPanel.cleanUp();
        MageFrame.getUI().removeButton(MageComponents.TABLE_WAITING_START_BUTTON);
        this.removeDialog();
        TableUtil.saveColumnWidthAndOrderToPrefs(this.jTableSeats, "tableWaitingPanelColumnWidth", "tableWaitingPanelColumnSort");
        GuiDisplayUtil.saveCurrentBoundsToPrefs();
        GuiDisplayUtil.saveDividerLocationToPrefs("tablePanelDividerLocation4", this.jSplitPane1.getDividerLocation());
    }

    private void initComponents() {
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnCancel = new JButton();
        this.btnStart = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSeats = new JTable();
        this.chatPanel = new ChatPanelBasic();
        this.setResizable(true);
        this.setTitle("Waiting for players");
        this.btnMoveUp.setText("Move Up");
        this.btnMoveUp.setEnabled(false);
        this.btnMoveUp.addActionListener(evt -> this.btnMoveUpActionPerformed(evt));
        this.btnMoveDown.setText("Move Down");
        this.btnMoveDown.setEnabled(false);
        this.btnMoveDown.addActionListener(evt -> this.btnMoveDownActionPerformed(evt));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(evt -> this.btnCancelActionPerformed(evt));
        this.btnStart.setText("Start");
        this.btnStart.setEnabled(false);
        this.btnStart.addActionListener(evt -> this.btnStartActionPerformed(evt));
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jTableSeats.setModel(this.tableWaitModel);
        this.jTableSeats.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTableSeats);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jSplitPane1.setRightComponent(this.chatPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addContainerGap()).addComponent(this.jSplitPane1, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnMoveDown).addComponent(this.btnMoveUp).addComponent(this.btnCancel).addComponent(this.btnStart)).addContainerGap()));
        this.pack();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        if (!this.isTournament) {
            if (SessionHandler.startMatch(this.roomId, this.tableId)) {
                this.doClose();
            }
        } else if (SessionHandler.startTournament(this.roomId, this.tableId)) {
            this.doClose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        try {
            if (!SessionHandler.leaveTable(this.roomId, this.tableId)) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        this.doClose();
    }

    private void btnMoveDownActionPerformed(ActionEvent evt) {
        int row = this.jTableSeats.getSelectedRow();
        if (row < this.jTableSeats.getRowCount() - 1) {
            SessionHandler.swapSeats(this.roomId, this.tableId, row, row + 1);
            this.jTableSeats.getSelectionModel().setSelectionInterval(row + 1, row + 1);
        }
    }

    private void btnMoveUpActionPerformed(ActionEvent evt) {
        int row = this.jTableSeats.getSelectedRow();
        if (row > 0) {
            SessionHandler.swapSeats(this.roomId, this.tableId, row, row - 1);
            this.jTableSeats.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        }
    }
}

