/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.icon.CardIconColor;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconOrder;
import mage.abilities.icon.CardIconPosition;
import mage.abilities.icon.CardIconType;
import mage.abilities.keyword.TransformAbility;
import mage.cards.Card;
import mage.cards.CardGraphicInfo;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.MageCard;
import mage.cards.MeldCard;
import mage.cards.decks.Deck;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.cards.CardArea;
import mage.client.dialog.MageDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.game.PlayerPanelExt;
import mage.client.themes.ThemeType;
import mage.client.util.CardRenderMode;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.Listener;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.designations.CitysBlessing;
import mage.game.FakeGame;
import mage.game.FakeMatch;
import mage.game.Game;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.match.Match;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentMeld;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.players.StubPlayer;
import mage.util.CardUtil;
import mage.util.RandomUtil;
import mage.view.AbilityView;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.GameView;
import mage.view.PermanentView;
import mage.view.PlaneView;
import mage.view.PlayerView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.CardPanel;

public class TestCardRenderDialog
extends MageDialog {
    private static final Logger logger = Logger.getLogger(TestCardRenderDialog.class);
    float cardSizeMod = 1.0f;
    float playerSizeMod = 1.0f;
    private Match match = null;
    private Game game = null;
    private BigCard bigCard = null;
    Listener<Event> cardListener = null;
    private PlayerPanelExt player = null;
    private JButton buttonCancel;
    private JButton buttonReloadCards;
    private CardArea cardsPanel;
    private JCheckBox checkBoxGenerateManyCards;
    private JCheckBox checkPlayerAsTarget;
    private JCheckBox checkPlayerSmallMode;
    private JComboBox<String> comboCardColor;
    private JComboBox<String> comboCardIconsOrder;
    private JComboBox<String> comboCardIconsPosition;
    private JComboBox<String> comboPlayerController;
    private JComboBox<String> comboPlayerStatus;
    private JComboBox<String> comboRenderMode;
    private JComboBox<String> comboTheme;
    private JLabel labelCardColor;
    private JLabel labelCardIconsAdditionalAmount;
    private JLabel labelCardIconsMaxVisible;
    private JLabel labelCardIconsOrder;
    private JLabel labelCardIconsPosition;
    private JLabel labelRenderMode;
    private JLabel labelSize;
    private JLabel labelTheme;
    private JPanel otherPanel;
    private JPanel panelBattlefield;
    private JPanel panelCardIcons;
    private JPanel playerOptions;
    private JPanel playerPanel;
    private JSlider sliderSize;
    private JSpinner spinnerCardIconsAdditionalAmount;
    private JSpinner spinnerCardIconsMaxVisible;

    public TestCardRenderDialog() {
        this.initComponents();
    }

    public void showDialog() {
        this.setModal(false);
        this.getRootPane().setDefaultButton(this.buttonCancel);
        this.comboRenderMode.setModel(new DefaultComboBoxModel<String>(CardRenderMode.toList()));
        this.comboRenderMode.setSelectedIndex(PreferencesDialog.getRenderMode());
        this.comboTheme.setModel(new DefaultComboBoxModel<ThemeType>(ThemeType.values()));
        this.comboTheme.setSelectedItem((Object)PreferencesDialog.getCurrentTheme());
        this.comboCardColor.setModel(new DefaultComboBoxModel<CardIconColor>(CardIconColor.values()));
        this.comboCardColor.setSelectedItem((Object)CardIconColor.DEFAULT);
        this.player = new PlayerPanelExt();
        this.playerPanel.setLayout(new BorderLayout(5, 5));
        this.playerPanel.add((Component)this.player, "Center");
        this.reloadCardsAndPlayer(false);
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add((Component)this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();
        this.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.setVisible(true);
    }

    private void onCancel() {
        this.removeDialog();
    }

    private PermanentView createPermanentCard(Game game, UUID controllerId, String code, String cardNumber, int powerBoosted, int toughnessBoosted, int damage, boolean tapped, boolean transform, List<Ability> extraAbilities) {
        CardInfo cardInfo = CardRepository.instance.findCard(code, cardNumber, false);
        ExpansionInfo setInfo = ExpansionRepository.instance.getSetByCode(code);
        CardSetInfo testSet = new CardSetInfo(cardInfo.getName(), setInfo.getCode(), cardNumber, cardInfo.getRarity(), new CardGraphicInfo(cardInfo.getFrameStyle(), cardInfo.usesVariousArt()));
        Card newCard = CardImpl.createCard(cardInfo.getClassName(), testSet);
        HashSet<Card> cardsList = new HashSet<Card>();
        cardsList.add(newCard);
        game.loadCards(cardsList, controllerId);
        Card permCard = CardUtil.getDefaultCardSideForBattlefield(game, newCard);
        if (extraAbilities != null) {
            extraAbilities.forEach(ability -> permCard.addAbility((Ability)ability));
        }
        PermanentCard permanent = permCard instanceof MeldCard ? new PermanentMeld(permCard, controllerId, game) : new PermanentCard(permCard, controllerId, game);
        if (transform) {
            TransformAbility.transformPermanent(permanent, game, null);
        }
        if (damage > 0) {
            permanent.damage(damage, controllerId, null, game);
        }
        if (powerBoosted > 0) {
            permanent.getPower().setBoostedValue(powerBoosted);
        }
        if (toughnessBoosted > 0) {
            permanent.getToughness().setBoostedValue(toughnessBoosted);
        }
        permanent.removeSummoningSickness();
        permanent.setTapped(tapped);
        PermanentView cardView = new PermanentView((Permanent)permanent, permCard, controllerId, game);
        return cardView;
    }

    private CardView createFaceDownCard(Game game, UUID controllerId, String code, String cardNumber, boolean isMorphed, boolean isManifested, boolean tapped) {
        CardInfo cardInfo = CardRepository.instance.findCard(code, cardNumber, false);
        ExpansionInfo setInfo = ExpansionRepository.instance.getSetByCode(code);
        CardSetInfo testSet = new CardSetInfo(cardInfo.getName(), setInfo.getCode(), cardNumber, cardInfo.getRarity(), new CardGraphicInfo(cardInfo.getFrameStyle(), cardInfo.usesVariousArt()));
        Card newCard = CardImpl.createCard(cardInfo.getClassName(), testSet);
        HashSet<Card> cardsList = new HashSet<Card>();
        cardsList.add(newCard);
        game.loadCards(cardsList, controllerId);
        Card permCard = CardUtil.getDefaultCardSideForBattlefield(game, newCard);
        PermanentCard perm = new PermanentCard(permCard, controllerId, game);
        perm.setFaceDown(true, game);
        perm.setMorphed(isMorphed);
        perm.setManifested(isManifested);
        perm.removeSummoningSickness();
        perm.setTapped(tapped);
        if (perm.isTransformable()) {
            perm.setTransformed(true);
        }
        if (perm.isFaceDown(game)) {
            BecomesFaceDownCreatureEffect.makeFaceDownObject(game, null, perm, BecomesFaceDownCreatureEffect.findFaceDownType(game, perm), null);
        }
        PermanentView cardView = new PermanentView((Permanent)perm, permCard, controllerId, game);
        cardView.setInViewerOnly(false);
        return cardView;
    }

    private CardView createHandCard(Game game, UUID controllerId, String code, String cardNumber) {
        CardInfo cardInfo = CardRepository.instance.findCard(code, cardNumber, false);
        ExpansionInfo setInfo = ExpansionRepository.instance.getSetByCode(code);
        CardSetInfo testSet = new CardSetInfo(cardInfo.getName(), setInfo.getCode(), cardNumber, cardInfo.getRarity(), new CardGraphicInfo(cardInfo.getFrameStyle(), cardInfo.usesVariousArt()));
        Card card = CardImpl.createCard(cardInfo.getClassName(), testSet);
        HashSet<Card> cardsList = new HashSet<Card>();
        cardsList.add(card);
        game.loadCards(cardsList, controllerId);
        CardView cardView = new CardView(card);
        return cardView;
    }

    private AbilityView createEmblem(Game game, Emblem emblem) {
        AbilityView emblemView = new AbilityView((Ability)emblem.getAbilities().get(0), emblem.getName(), new CardView(new EmblemView(emblem, game)));
        emblemView.setName(emblem.getName());
        return emblemView;
    }

    private AbilityView createDungeon(Game game, Dungeon dungeon) {
        AbilityView emblemView = new AbilityView((Ability)dungeon.getAbilities().get(0), dungeon.getName(), new CardView(new DungeonView(dungeon)));
        emblemView.setName(dungeon.getName());
        return emblemView;
    }

    private AbilityView createPlane(Game game, Plane plane) {
        AbilityView planeView = new AbilityView((Ability)plane.getAbilities().get(0), plane.getName(), new CardView(new PlaneView(plane, game)));
        planeView.setName(plane.getName());
        return planeView;
    }

    private CardView createToken(Game game, UUID controllerId, Token token, String code, int damage, boolean tapped, boolean transformed) {
        Token sourceToken = token.copy();
        sourceToken.setExpansionSetCode(code);
        PermanentToken perm = new PermanentToken(sourceToken, controllerId, game);
        HashSet<Card> cardsList = new HashSet<Card>();
        cardsList.add(perm);
        game.loadCards(cardsList, controllerId);
        if (damage > 0) {
            perm.damage(damage, controllerId, null, game);
        }
        perm.removeSummoningSickness();
        perm.setTapped(tapped);
        if (perm.isTransformable() && transformed) {
            perm.setTransformed(true);
        }
        PermanentView cardView = new PermanentView((Permanent)perm, game.getCard(perm.getId()), controllerId, game);
        return cardView;
    }

    private void reloadCardsAndPlayer(boolean refreshTheme) {
        UUID controlledId;
        boolean isMe;
        if (refreshTheme) {
            PreferencesDialog.setCurrentTheme((ThemeType)((Object)this.comboTheme.getSelectedItem()));
        }
        this.match = new FakeMatch();
        this.game = new FakeGame();
        Deck deck = new Deck();
        StubPlayer playerYou = new StubPlayer("player1", RangeOfInfluence.ALL);
        playerYou.addDesignation(new CitysBlessing());
        this.game.getState().setMonarchId(playerYou.getId());
        playerYou.addCounters(new Counter(CounterType.POISON.toString(), 10), playerYou.getId(), null, this.game);
        this.match.addPlayer(playerYou, deck);
        this.game.addPlayer(playerYou, deck);
        StubPlayer playerOpponent = new StubPlayer("player2", RangeOfInfluence.ALL);
        this.game.addPlayer(playerOpponent, deck);
        this.match.addPlayer(playerOpponent, deck);
        this.bigCard = new BigCard();
        switch ((String)Objects.requireNonNull(this.comboPlayerStatus.getSelectedItem())) {
            case "Active": {
                this.game.getState().setActivePlayerId(playerYou.getId());
                break;
            }
            case "Inactive": {
                this.game.getState().setActivePlayerId(playerOpponent.getId());
                break;
            }
            case "Dead": {
                playerYou.leave();
                this.game.getState().setActivePlayerId(playerOpponent.getId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown control type");
            }
        }
        switch ((String)Objects.requireNonNull(this.comboPlayerController.getSelectedItem())) {
            case "me": {
                isMe = true;
                controlledId = playerYou.getId();
                break;
            }
            case "opponent": {
                isMe = false;
                controlledId = playerOpponent.getId();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown control type");
            }
        }
        boolean smallMode = this.checkPlayerSmallMode.isSelected();
        LinkedHashSet<UUID> possibleTargets = null;
        if (this.checkPlayerAsTarget.isSelected()) {
            possibleTargets = new LinkedHashSet<UUID>();
            possibleTargets.add(playerYou.getId());
        }
        Set<UUID> chosenTargets = null;
        if (this.player == null) {
            this.playerPanel.setLayout(new BorderLayout(5, 5));
            this.player = new PlayerPanelExt(this.playerSizeMod);
            this.playerPanel.add((Component)this.player, "Center");
        } else {
            this.player.fullRefresh(this.playerSizeMod);
        }
        this.playerPanel.setPreferredSize(new Dimension(Math.round(100.0f * this.playerSizeMod), 10));
        GameView gameView = new GameView(this.game.getState(), this.game, controlledId, null);
        PlayerView currentPlayerView = gameView.getPlayers().stream().filter(p -> p.getPlayerId().equals(playerYou.getId())).findFirst().orElse(null);
        this.player.init(this.game.getId(), playerYou.getId(), isMe, this.bigCard, 0);
        this.player.update(gameView, currentPlayerView, possibleTargets, chosenTargets);
        this.player.sizePlayerPanel(smallMode);
        this.cardsPanel.cleanUp();
        this.cardsPanel.setCustomRenderMode(this.comboRenderMode.getSelectedIndex());
        this.cardsPanel.setCustomNeedFullPermanentRender(true);
        this.cardsPanel.setCustomCardSize(new Dimension(this.getCardWidth(), this.getCardHeight()));
        this.cardsPanel.setCustomXOffsetBetweenCardsOrColumns(10);
        this.cardsPanel.setCustomCardIconsPanelPosition(CardIconPosition.fromString((String)this.comboCardIconsPosition.getSelectedItem()));
        this.cardsPanel.setCustomCardIconsPanelOrder(CardIconOrder.fromString((String)this.comboCardIconsOrder.getSelectedItem()));
        this.cardsPanel.setCustomCardIconsPanelColor((CardIconColor)((Object)this.comboCardColor.getSelectedItem()));
        this.cardsPanel.setCustomCardIconsMaxVisibleCount((Integer)this.spinnerCardIconsMaxVisible.getValue());
        int needAdditionalIcons = Math.min(99, Math.max(0, (Integer)this.spinnerCardIconsAdditionalAmount.getValue()));
        this.cardsPanel.changeGUISize();
        JPopupMenu popupCardMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Card menu 1");
        popupCardMenu.add(item);
        item = new JMenuItem("Card menu 2");
        popupCardMenu.add(item);
        item = new JMenuItem("Card menu 3");
        popupCardMenu.add(item);
        JPopupMenu popupPanelMenu = new JPopupMenu();
        item = new JMenuItem("Panel menu 1");
        popupPanelMenu.add(item);
        item = new JMenuItem("Panel menu 2");
        popupPanelMenu.add(item);
        item = new JMenuItem("Panel menu 3");
        popupPanelMenu.add(item);
        if (this.cardListener == null) {
            this.cardListener = event -> {
                switch (event.getEventType()) {
                    case CARD_CLICK: 
                    case CARD_DOUBLE_CLICK: {
                        this.handleCardClick(event);
                        break;
                    }
                    case CARD_POPUP_MENU: {
                        if (event.getSource() != null) {
                            this.handlePopupMenu(event, popupCardMenu);
                            break;
                        }
                        this.handlePopupMenu(event, popupPanelMenu);
                    }
                }
            };
            this.cardsPanel.addCardEventListener(this.cardListener);
        }
        List<SimpleStaticAbility> additionalIcons = Collections.singletonList(new SimpleStaticAbility(Zone.ALL, null));
        for (int i = 0; i < needAdditionalIcons; ++i) {
            String text = "";
            if (RandomUtil.nextBoolean()) {
                text = RandomUtil.nextBoolean() ? "75" : "8";
            }
            ((Ability)additionalIcons.get(0)).addIcon(new CardIconImpl(CardIconType.PLAYABLE_COUNT, "test icon " + i + 1, text));
        }
        ArrayList<Object> cardViews = new ArrayList<Object>();
        cardViews.add(this.createPermanentCard(this.game, playerYou.getId(), "RNA", "263", 0, 0, 0, false, false, null));
        cardViews.add(this.createPermanentCard(this.game, playerYou.getId(), "RNA", "185", 0, 0, 0, true, false, null));
        cardViews.add(this.createHandCard(this.game, playerYou.getId(), "DIS", "153"));
        cardViews.add(this.createHandCard(this.game, playerYou.getId(), "ELD", "38"));
        cardViews.add(this.createHandCard(this.game, playerYou.getId(), "LEA", "278"));
        cardViews.add(this.createFaceDownCard(this.game, playerOpponent.getId(), "ELD", "38", false, false, false));
        cardViews.add(this.createFaceDownCard(this.game, playerOpponent.getId(), "ELD", "38", true, false, true));
        cardViews.add(this.createFaceDownCard(this.game, playerOpponent.getId(), "ELD", "38", false, true, false));
        if (this.checkBoxGenerateManyCards.isSelected()) {
            while (cardViews.size() < 30) {
                int addingCount = cardViews.size();
                for (int i = 0; i < addingCount; ++i) {
                    CardView view = (CardView)cardViews.get(i);
                    CardView newView = new CardView(view);
                    cardViews.add(newView);
                }
            }
        }
        CardsView view = new CardsView(cardViews);
        this.cardsPanel.loadCards(view, this.bigCard, this.game.getId());
    }

    private void handleCardClick(Event event) {
        MageCard panel = (MageCard)event.getComponent();
        if (event.getEventType() == ClientEventType.CARD_DOUBLE_CLICK) {
            CardPanel main;
            if (panel.getMainPanel() instanceof CardPanel && (main = (CardPanel)panel.getMainPanel()).getGameCard() instanceof PermanentView) {
                PermanentView oldPermanent = (PermanentView)main.getGameCard();
                PermanentView newPermament = new PermanentView(oldPermanent, this.game.getCard(oldPermanent.getId()), UUID.randomUUID(), this.game);
                newPermament.overrideTapped(!oldPermanent.isTapped());
                main.update(newPermament);
            }
        } else {
            panel.setChoosable(!panel.isChoosable());
        }
        this.cardsPanel.redraw();
    }

    private void handlePopupMenu(Event event, JPopupMenu popupMenu) {
        Point p = MouseInfo.getPointerInfo().getLocation();
        popupMenu.show(this, 0, 0);
        popupMenu.setLocation(p);
    }

    private int getCardWidth() {
        if (GUISizeHelper.editorCardDimension == null) {
            return 200;
        }
        return (int)((float)GUISizeHelper.editorCardDimension.width * this.cardSizeMod);
    }

    private int getCardHeight() {
        return (int)(1.4 * (double)this.getCardWidth());
    }

    private void initComponents() {
        this.buttonCancel = new JButton();
        this.buttonReloadCards = new JButton();
        this.labelRenderMode = new JLabel();
        this.comboRenderMode = new JComboBox();
        this.sliderSize = new JSlider();
        this.labelSize = new JLabel();
        this.checkBoxGenerateManyCards = new JCheckBox();
        this.panelCardIcons = new JPanel();
        this.labelCardIconsPosition = new JLabel();
        this.comboCardIconsPosition = new JComboBox();
        this.labelCardIconsMaxVisible = new JLabel();
        this.spinnerCardIconsMaxVisible = new JSpinner();
        this.labelCardIconsAdditionalAmount = new JLabel();
        this.spinnerCardIconsAdditionalAmount = new JSpinner();
        this.labelCardIconsOrder = new JLabel();
        this.comboCardIconsOrder = new JComboBox();
        this.labelTheme = new JLabel();
        this.comboTheme = new JComboBox();
        this.labelCardColor = new JLabel();
        this.comboCardColor = new JComboBox();
        this.panelBattlefield = new JPanel();
        this.cardsPanel = new CardArea();
        this.otherPanel = new JPanel();
        this.playerPanel = new JPanel();
        this.playerOptions = new JPanel();
        this.checkPlayerSmallMode = new JCheckBox();
        this.comboPlayerStatus = new JComboBox();
        this.comboPlayerController = new JComboBox();
        this.checkPlayerAsTarget = new JCheckBox();
        this.setResizable(true);
        this.buttonCancel.setText("Close");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCardRenderDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonReloadCards.setText("Reload cards");
        this.buttonReloadCards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCardRenderDialog.this.buttonReloadCardsActionPerformed(evt);
            }
        });
        this.labelRenderMode.setText("Render mode:");
        this.comboRenderMode.setToolTipText("<HTML>Image - Renders card image with text overlay<br> MTGO - Renders card frame around card art<br> Forced M15 - Renders all cards in the MTGO style with the modern frame<br> Forced Retro - Renders all cards in the MTGO style with the retro frame");
        this.comboRenderMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboRenderModeItemStateChanged(evt);
            }
        });
        this.sliderSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TestCardRenderDialog.this.sliderSizeStateChanged(evt);
            }
        });
        this.labelSize.setText("Card size:");
        this.checkBoxGenerateManyCards.setText("Generate many cards");
        this.checkBoxGenerateManyCards.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.checkBoxGenerateManyCardsItemStateChanged(evt);
            }
        });
        this.labelCardIconsPosition.setText("Card icons position:");
        this.comboCardIconsPosition.setModel(new DefaultComboBoxModel<String>(new String[]{"TOP", "LEFT", "RIGHT", "BOTTOM", "CORNER_TOP_LEFT", "CORNER_TOP_RIGHT", "CORNER_BOTTOM_LEFT", "CORNER_BOTTOM_RIGHT"}));
        this.comboCardIconsPosition.setSelectedIndex(1);
        this.comboCardIconsPosition.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboCardIconsPositionItemStateChanged(evt);
            }
        });
        this.labelCardIconsMaxVisible.setText("Max visible:");
        this.spinnerCardIconsMaxVisible.setValue(3);
        this.spinnerCardIconsMaxVisible.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TestCardRenderDialog.this.spinnerCardIconsMaxVisibleStateChanged(evt);
            }
        });
        this.labelCardIconsAdditionalAmount.setText("Add additional icons:");
        this.spinnerCardIconsAdditionalAmount.setValue(10);
        this.spinnerCardIconsAdditionalAmount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TestCardRenderDialog.this.spinnerCardIconsAdditionalAmountStateChanged(evt);
            }
        });
        this.labelCardIconsOrder.setText("Order:");
        this.comboCardIconsOrder.setModel(new DefaultComboBoxModel<String>(new String[]{"START", "CENTER", "END"}));
        this.comboCardIconsOrder.setSelectedIndex(2);
        this.comboCardIconsOrder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboCardIconsOrderItemStateChanged(evt);
            }
        });
        GroupLayout panelCardIconsLayout = new GroupLayout(this.panelCardIcons);
        this.panelCardIcons.setLayout(panelCardIconsLayout);
        panelCardIconsLayout.setHorizontalGroup(panelCardIconsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCardIconsLayout.createSequentialGroup().addComponent(this.labelCardIconsPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCardIconsPosition, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCardIconsOrder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCardIconsOrder, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCardIconsMaxVisible).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCardIconsMaxVisible, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCardIconsAdditionalAmount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCardIconsAdditionalAmount, -2, 50, -2).addContainerGap(-1, Short.MAX_VALUE)));
        panelCardIconsLayout.setVerticalGroup(panelCardIconsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCardIconsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboCardIconsPosition, -2, -1, -2).addComponent(this.labelCardIconsPosition).addComponent(this.labelCardIconsMaxVisible).addComponent(this.spinnerCardIconsMaxVisible, -2, -1, -2).addComponent(this.labelCardIconsAdditionalAmount).addComponent(this.spinnerCardIconsAdditionalAmount, -2, -1, -2).addComponent(this.labelCardIconsOrder).addComponent(this.comboCardIconsOrder, -2, -1, -2)));
        this.labelTheme.setText("Theme:");
        this.comboTheme.setModel(new DefaultComboBoxModel<String>(new String[]{"loading..."}));
        this.comboTheme.setToolTipText("WARNING, selected theme will be applied to full app, not render dialog only");
        this.comboTheme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboThemeItemStateChanged(evt);
            }
        });
        this.labelCardColor.setText("Card color:");
        this.comboCardColor.setModel(new DefaultComboBoxModel<String>(new String[]{"loading..."}));
        this.comboCardColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboCardColorItemStateChanged(evt);
            }
        });
        this.panelBattlefield.setLayout(new BorderLayout());
        this.panelBattlefield.add((Component)this.cardsPanel, "Center");
        this.otherPanel.setLayout(new BorderLayout());
        this.playerPanel.setPreferredSize(new Dimension(100, 10));
        GroupLayout playerPanelLayout = new GroupLayout(this.playerPanel);
        this.playerPanel.setLayout(playerPanelLayout);
        playerPanelLayout.setHorizontalGroup(playerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        playerPanelLayout.setVerticalGroup(playerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.otherPanel.add((Component)this.playerPanel, "Center");
        this.playerOptions.setLayout(new BoxLayout(this.playerOptions, 1));
        this.checkPlayerSmallMode.setText("Small mode");
        this.checkPlayerSmallMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.checkPlayerSmallModeItemStateChanged(evt);
            }
        });
        this.playerOptions.add(this.checkPlayerSmallMode);
        this.comboPlayerStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"Active", "Inactive", "Dead"}));
        this.comboPlayerStatus.setAlignmentX(0.0f);
        this.comboPlayerStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboPlayerStatusItemStateChanged(evt);
            }
        });
        this.playerOptions.add(this.comboPlayerStatus);
        this.comboPlayerController.setModel(new DefaultComboBoxModel<String>(new String[]{"me", "opponent"}));
        this.comboPlayerController.setAlignmentX(0.0f);
        this.comboPlayerController.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.comboPlayerControllerItemStateChanged(evt);
            }
        });
        this.playerOptions.add(this.comboPlayerController);
        this.checkPlayerAsTarget.setText("As possible target");
        this.checkPlayerAsTarget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TestCardRenderDialog.this.checkPlayerAsTargetItemStateChanged(evt);
            }
        });
        this.playerOptions.add(this.checkPlayerAsTarget);
        this.otherPanel.add((Component)this.playerOptions, "North");
        this.panelBattlefield.add((Component)this.otherPanel, "West");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCardIcons, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonCancel, -2, 100, -2)).addGroup(layout.createSequentialGroup().addComponent(this.buttonReloadCards).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelRenderMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboRenderMode, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTheme, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCardColor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboCardColor, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderSize, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxGenerateManyCards).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.panelBattlefield, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboCardColor, -2, -1, -2).addComponent(this.labelCardColor)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonReloadCards).addComponent(this.labelRenderMode).addComponent(this.comboRenderMode, -2, -1, -2).addComponent(this.labelSize).addComponent(this.comboTheme, -2, -1, -2).addComponent(this.labelTheme))).addComponent(this.sliderSize, -2, -1, -2).addComponent(this.checkBoxGenerateManyCards)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCardIcons, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelBattlefield, -1, 399, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, 30, -2).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.onCancel();
    }

    private void buttonReloadCardsActionPerformed(ActionEvent evt) {
        this.reloadCardsAndPlayer(true);
    }

    private void comboRenderModeItemStateChanged(ItemEvent evt) {
        if (this.isVisible()) {
            this.reloadCardsAndPlayer(false);
        }
    }

    private void sliderSizeStateChanged(ChangeEvent evt) {
        float sliderFrac = (float)(this.sliderSize.getValue() - 50) / 50.0f;
        this.cardSizeMod = (float)Math.pow(2.0, sliderFrac);
        this.playerSizeMod = (float)Math.pow(2.0, sliderFrac);
        this.reloadCardsAndPlayer(false);
    }

    private void checkBoxGenerateManyCardsItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void comboCardIconsPositionItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void spinnerCardIconsMaxVisibleStateChanged(ChangeEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void spinnerCardIconsAdditionalAmountStateChanged(ChangeEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void comboCardIconsOrderItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void comboThemeItemStateChanged(ItemEvent evt) {
        if (this.isVisible()) {
            this.reloadCardsAndPlayer(true);
        }
    }

    private void comboCardColorItemStateChanged(ItemEvent evt) {
        if (this.isVisible()) {
            this.reloadCardsAndPlayer(false);
        }
    }

    private void comboPlayerStatusItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void comboPlayerControllerItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void checkPlayerSmallModeItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }

    private void checkPlayerAsTargetItemStateChanged(ItemEvent evt) {
        this.reloadCardsAndPlayer(false);
    }
}

