/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.client.SessionHandler;
import mage.client.components.tray.MageTray;
import mage.client.dialog.TableWaitingDialog;
import mage.client.util.audio.AudioManager;
import mage.players.PlayerType;
import mage.remote.Session;
import mage.view.SeatView;
import mage.view.TableView;
import org.apache.log4j.Logger;

class UpdateSeatsTask
extends SwingWorker<Void, TableView> {
    private final Session session;
    private final UUID roomId;
    private final UUID tableId;
    private final TableWaitingDialog dialog;
    private int count = 0;
    private static final Logger logger = Logger.getLogger(TableWaitingDialog.class);

    UpdateSeatsTask(Session session, UUID roomId, UUID tableId, TableWaitingDialog dialog) {
        this.session = session;
        this.roomId = roomId;
        this.tableId = tableId;
        this.dialog = dialog;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            Optional<TableView> tableView = SessionHandler.getTable(this.roomId, this.tableId);
            if (tableView.isPresent()) {
                tableView.ifPresent(xva$0 -> this.publish(xva$0));
            } else {
                this.dialog.doClose();
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        return null;
    }

    @Override
    protected void process(List<TableView> view) {
        TableView tableView = view.get(0);
        if (this.count == 0) {
            this.count = this.getPlayersCount(tableView);
        } else {
            int current = this.getPlayersCount(tableView);
            if (current != this.count) {
                if (this.count > 0) {
                    if (current == tableView.getSeats().size()) {
                        MageTray.instance.displayMessage("The game can start.");
                        AudioManager.playGameCanStart();
                    } else if (current > this.count) {
                        MageTray.instance.displayMessage("New player joined your game.");
                        AudioManager.playPlayerJoinedTable();
                    } else {
                        MageTray.instance.displayMessage("A player left your game.");
                        AudioManager.playPlayerLeft();
                    }
                    MageTray.instance.blink();
                }
                this.count = current;
            }
        }
        this.dialog.update(tableView);
    }

    private int getPlayersCount(TableView tableView) {
        int playerCount = 0;
        if (tableView != null) {
            for (SeatView seatView : tableView.getSeats()) {
                if (seatView.getPlayerId() == null || seatView.getPlayerType() != PlayerType.HUMAN) continue;
                ++playerCount;
            }
        }
        return playerCount;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Seats Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

