/*
 * Decompiled with CFR 0.152.
 */
package mage.client.dialog;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import mage.client.MageFrame;
import mage.client.dialog.MageDialog;
import mage.client.util.GUISizeHelper;
import mage.constants.PlayerAction;
import mage.view.UserRequestMessage;

public class UserRequestDialog
extends MageDialog {
    private UserRequestMessage userRequestMessage;
    private JButton btn1;
    private JButton btn2;
    private JButton btn3;
    private JLabel lblText;

    public UserRequestDialog() {
        this.initComponents();
        this.setGUISize();
    }

    private void setGUISize() {
        Font font = GUISizeHelper.dialogFont;
        this.lblText.setFont(font);
        this.lblText.setMaximumSize(new Dimension(300 + font.getSize() * 15, 200 + font.getSize() * 5));
        this.lblText.setMinimumSize(new Dimension(300 + font.getSize() * 15, 20 + font.getSize() * 5));
        this.lblText.setPreferredSize(new Dimension(300 + font.getSize() * 15, 20 + font.getSize() * 5));
        this.btn1.setFont(font);
        this.btn1.setMinimumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn1.setMaximumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn1.setPreferredSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn2.setFont(font);
        this.btn2.setMinimumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn2.setMaximumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn2.setPreferredSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn3.setFont(font);
        this.btn3.setMinimumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn3.setMaximumSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        this.btn3.setPreferredSize(new Dimension(50 + 4 * font.getSize(), 2 * font.getSize() + 10));
        JComponent c = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
        c.setMinimumSize(new Dimension(c.getMinimumSize().width, font.getSize() + 10));
        c.setMaximumSize(new Dimension(c.getMaximumSize().width, font.getSize() + 10));
        c.setPreferredSize(new Dimension(c.getPreferredSize().width, font.getSize() + 10));
        c.setFont(font);
    }

    public void showDialog(UserRequestMessage userRequestMessage) {
        this.userRequestMessage = userRequestMessage;
        this.setTitle(userRequestMessage.getTitle());
        String text = "<html><p style=\"text-align:center; margin-left:10px; margin-right:10px\">" + userRequestMessage.getMessage() + "</p></html>";
        this.lblText.setText(text);
        if (userRequestMessage.getButton1Text() != null) {
            this.btn1.setText(userRequestMessage.getButton1Text());
            this.btn1.setFocusable(false);
        } else {
            this.btn1.setVisible(false);
        }
        if (userRequestMessage.getButton2Text() != null) {
            this.btn2.setText(userRequestMessage.getButton2Text());
            this.btn2.setFocusable(false);
        } else {
            this.btn2.setVisible(false);
        }
        if (userRequestMessage.getButton3Text() != null) {
            this.btn3.setText(userRequestMessage.getButton3Text());
            this.btn3.setFocusable(false);
        } else {
            this.btn3.setVisible(false);
        }
        this.pack();
        Dimension newPreferedSize = new Dimension(this.getPreferredSize());
        newPreferedSize.setSize((double)newPreferedSize.width * userRequestMessage.getWindowSizeRatio(), (double)newPreferedSize.height);
        this.setPreferredSize(newPreferedSize);
        this.pack();
        this.revalidate();
        this.repaint();
        this.setModal(true);
        this.setVisible(true);
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.btn3 = new JButton();
        this.btn2 = new JButton();
        this.btn1 = new JButton();
        this.setResizable(true);
        this.setTitle("UserRequestMessage");
        this.setModal(true);
        this.lblText.setHorizontalAlignment(0);
        this.lblText.setText("message to the user");
        this.lblText.setMaximumSize(new Dimension(1000, 500));
        this.lblText.setMinimumSize(new Dimension(400, 60));
        this.lblText.setPreferredSize(new Dimension(400, 60));
        this.btn3.setText("btn3");
        this.btn3.setMaximumSize(new Dimension(150, 50));
        this.btn3.setMinimumSize(new Dimension(75, 25));
        this.btn3.setPreferredSize(new Dimension(150, 50));
        this.btn3.addActionListener(evt -> this.btn3ActionPerformed(evt));
        this.btn2.setText("btn2");
        this.btn2.setMaximumSize(new Dimension(150, 50));
        this.btn2.setMinimumSize(new Dimension(75, 25));
        this.btn2.setPreferredSize(new Dimension(150, 50));
        this.btn2.addActionListener(evt -> this.btn2ActionPerformed(evt));
        this.btn1.setText("btn1");
        this.btn1.setMaximumSize(new Dimension(150, 50));
        this.btn1.setMinimumSize(new Dimension(75, 25));
        this.btn1.setPreferredSize(new Dimension(150, 50));
        this.btn1.addActionListener(evt -> this.btn1ActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblText, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btn3, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn2, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn1, -2, 1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblText, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btn1, -1, -1, Short.MAX_VALUE).addComponent(this.btn2, -1, -1, Short.MAX_VALUE).addComponent(this.btn3, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)));
        this.pack();
    }

    private void btn1ActionPerformed(ActionEvent evt) {
        if (this.userRequestMessage.getButton1Action() != null) {
            this.sendUserReplay(this.userRequestMessage.getButton1Action());
        }
        this.removeDialog();
    }

    private void btn2ActionPerformed(ActionEvent evt) {
        if (this.userRequestMessage.getButton2Action() != null) {
            this.sendUserReplay(this.userRequestMessage.getButton2Action());
        }
        this.removeDialog();
    }

    private void btn3ActionPerformed(ActionEvent evt) {
        if (this.userRequestMessage.getButton3Action() != null) {
            this.sendUserReplay(this.userRequestMessage.getButton3Action());
        }
        this.removeDialog();
    }

    private void sendUserReplay(PlayerAction playerAction) {
        SwingUtilities.invokeLater(() -> MageFrame.getInstance().sendUserReplay(playerAction, this.userRequestMessage));
    }
}

