/*
 * Decompiled with CFR 0.152.
 */
package mage.client.draft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.cards.CardsList;
import mage.client.components.tray.MageTray;
import mage.client.deckeditor.SortSettingDraft;
import mage.client.dialog.PreferencesDialog;
import mage.client.draft.DraftGrid;
import mage.client.draft.DraftPane;
import mage.client.draft.DraftPickLogger;
import mage.client.plugins.impl.Plugins;
import mage.client.util.AppUtil;
import mage.client.util.CardsViewUtil;
import mage.client.util.ClientEventType;
import mage.client.util.Event;
import mage.client.util.GUISizeHelper;
import mage.client.util.ImageHelper;
import mage.client.util.Listener;
import mage.client.util.audio.AudioManager;
import mage.client.util.gui.BufferedImageBuilder;
import mage.constants.PlayerAction;
import mage.view.CardsView;
import mage.view.DraftPickView;
import mage.view.DraftView;
import mage.view.SimpleCardView;
import mage.view.SimpleCardsView;
import mage.view.UserRequestMessage;
import org.apache.log4j.Logger;

public class DraftPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(DraftPanel.class);
    private UUID draftId;
    private Timer countdown;
    private int timeout;
    private static final int PROTECTION_CLICKS_TIMEOUT_MS = 1500;
    private Timer protectionTimer;
    private int protectionPickNo = 0;
    private final JPopupMenu popupMenuPickedArea;
    private final JPopupMenu popupMenuCardPanel;
    private final Set<UUID> cardsHidden = new HashSet<UUID>();
    protected SimpleCardsView pickedCards;
    protected final SimpleCardsView pickedCardsShown = new SimpleCardsView();
    protected UUID cardIdPopupMenu;
    private DraftPickLogger draftLogger;
    private List<String> setCodes;
    private int packNo = 1;
    private int pickNo = 1;
    private int timeoutPickNo = 0;
    private String[] currentBooster;
    private static final CardsView EMPTY_VIEW = new CardsView();
    private Listener<Event> selectedCardsListener = null;
    private Listener<Event> pickingCardsListener = null;
    private Map<JPanel, List<JLabel>> playerLabels = new LinkedHashMap<JPanel, List<JLabel>>();
    private BigCard bigCard;
    private JButton buttonQuitTournament;
    private JCheckBox checkPack1;
    private JCheckBox checkPack2;
    private JCheckBox checkPack3;
    private DraftGrid draftBooster;
    private CardsList draftPicks;
    private JTextField editPack1;
    private JTextField editPack2;
    private JTextField editPack3;
    private JTextField editTimeRemaining;
    private JSeparator jSeparator1;
    private JLabel labelCardNumber;
    private JLabel labelMessage;
    private JLabel labelPack1;
    private JLabel labelPack2;
    private JLabel labelPack3;
    private JLabel labelPlayer01;
    private JLabel labelPlayer02;
    private JLabel labelPlayer03;
    private JLabel labelPlayer04;
    private JLabel labelPlayer05;
    private JLabel labelPlayer06;
    private JLabel labelPlayer07;
    private JLabel labelPlayer08;
    private JLabel labelPlayer09;
    private JLabel labelPlayer10;
    private JLabel labelPlayer11;
    private JLabel labelPlayer12;
    private JLabel labelPlayer13;
    private JLabel labelPlayer14;
    private JLabel labelPlayer15;
    private JLabel labelPlayer16;
    private JLabel labelTableImage;
    private JPanel panelBigCard;
    private JPanel panelCommands;
    private JPanel panelInfo;
    private JPanel panelLeft;
    private JPanel panelPack1;
    private JPanel panelPack2;
    private JPanel panelPack3;
    private JPanel panelPackCard;
    private JPanel panelPacks;
    private JPanel panelPlayers;
    private JPanel panelPlayersLeft;
    private JPanel panelPlayersRight;
    private JPanel panelRight;

    public DraftPanel() {
        this.initComponents();
        this.playerLabels.put(this.panelPlayersLeft, Arrays.stream(this.panelPlayersLeft.getComponents()).filter(c -> c instanceof JLabel).map(c -> (JLabel)c).collect(Collectors.toList()));
        this.playerLabels.put(this.panelPlayersRight, Arrays.stream(this.panelPlayersRight.getComponents()).filter(c -> c instanceof JLabel).map(c -> (JLabel)c).collect(Collectors.toList()));
        this.hideUnusedPlayerNames(true);
        this.editTimeRemaining.setForeground(Color.BLACK);
        this.draftBooster.setOpaque(false);
        this.draftPicks.setSortSetting(SortSettingDraft.getInstance());
        this.draftPicks.setOpaque(false);
        this.popupMenuPickedArea = new JPopupMenu();
        this.addPopupMenuPickArea();
        this.add(this.popupMenuPickedArea);
        this.popupMenuCardPanel = new JPopupMenu();
        this.addPopupMenuCardPanel();
        this.add(this.popupMenuCardPanel);
        this.countdown = new Timer(1000, e -> {
            if (--this.timeout > 0) {
                this.setTimeout(this.timeout);
            } else {
                this.setTimeout(0);
                this.countdown.stop();
            }
        });
        int protectionTimeout = 1500;
        if (SessionHandler.isTestMode()) {
            protectionTimeout = 100;
        }
        this.protectionTimer = new Timer(protectionTimeout, e -> this.protectionTimer.stop());
    }

    public void cleanUp() {
        this.draftPicks.cleanUp();
        this.draftBooster.clear();
        if (this.countdown != null) {
            this.countdown.stop();
            for (ActionListener al : this.countdown.getActionListeners()) {
                this.countdown.removeActionListener(al);
            }
        }
        if (this.protectionTimer != null) {
            this.protectionTimer.stop();
            for (ActionListener al : this.protectionTimer.getActionListeners()) {
                this.protectionTimer.removeActionListener(al);
            }
        }
    }

    public void changeGUISize() {
        this.draftPicks.changeGUISize();
        this.setGUISize();
    }

    private void setGUISize() {
        GUISizeHelper.changePopupMenuFont(this.popupMenuPickedArea);
    }

    public synchronized void showDraft(UUID draftId) {
        this.draftId = draftId;
        MageFrame.addDraft(draftId, this);
        if (!SessionHandler.joinDraft(draftId)) {
            this.hideDraft();
        }
        if (DraftPanel.isLogging()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String logFilename = "Draft_" + sdf.format(new Date()) + '_' + draftId + ".draft";
            this.draftLogger = new DraftPickLogger(new File("gamelogs"), logFilename);
        } else {
            this.draftLogger = new DraftPickLogger();
        }
    }

    public void updateDraft(DraftView draftView) {
        if (draftView.getSetNames().size() != 3) {
            this.editPack1.setText("Random Boosters");
            this.editPack2.setText("Random Boosters");
            this.editPack3.setText("Random Boosters");
        } else {
            this.editPack1.setText(draftView.getBoosterInfo(0));
            this.editPack2.setText(draftView.getBoosterInfo(1));
            this.editPack3.setText(draftView.getBoosterInfo(2));
        }
        this.editPack1.setCaretPosition(0);
        this.editPack2.setCaretPosition(0);
        this.editPack3.setCaretPosition(0);
        this.checkPack1.setSelected(draftView.getBoosterNum() > 1);
        this.checkPack2.setSelected(draftView.getBoosterNum() > 2);
        this.checkPack3.setSelected(draftView.getBoosterNum() > 3);
        this.labelCardNumber.setText("Card #" + draftView.getCardNum());
        this.packNo = draftView.getBoosterNum();
        this.pickNo = draftView.getCardNum();
        this.setCodes = draftView.getSetCodes();
        this.draftLogger.updateDraft(this.draftId, draftView);
        Image tableImage = ImageHelper.getImageFromResources(draftView.getBoosterNum() % 2 == 1 ? "/draft/table_left.png" : "/draft/table_right.png");
        BufferedImage resizedTable = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(tableImage, 2), this.labelTableImage.getWidth(), this.labelTableImage.getHeight());
        this.labelTableImage.setIcon(new ImageIcon(resizedTable));
        this.clearPlayerNames();
        int count = 0;
        for (String playerName : draftView.getPlayers()) {
            this.setPlayerNameToLabel(playerName, ++count, draftView.getPlayers().size());
        }
        this.hideUnusedPlayerNames(false);
        this.revalidate();
        int rightAmount = draftView.getPlayers().size() / 2;
        int leftAmount = draftView.getPlayers().size() - rightAmount;
        int height = leftAmount * 18;
    }

    private void clearPlayerNames() {
        this.playerLabels.forEach((panel, labels) -> labels.forEach(label -> label.setText("")));
    }

    private void hideUnusedPlayerNames(boolean hideAll) {
        int maxPlayersPerPanel = 8;
        this.playerLabels.forEach((panel, labels) -> {
            AtomicInteger hiddenCount = new AtomicInteger(0);
            labels.forEach(label -> {
                if (hideAll || label.getText().isEmpty()) {
                    hiddenCount.incrementAndGet();
                    panel.remove((Component)label);
                } else {
                    panel.add((Component)label);
                }
            });
            GridLayout gridLayout = (GridLayout)panel.getLayout();
            gridLayout.setRows(maxPlayersPerPanel - hiddenCount.get());
        });
        int maxRows = this.playerLabels.keySet().stream().mapToInt(panel -> ((GridLayout)panel.getLayout()).getRows()).max().orElse(1);
        this.playerLabels.keySet().forEach(panel -> ((GridLayout)panel.getLayout()).setRows(maxRows));
    }

    private void setPlayerNameToLabel(String name, int playerNumber, int totalPlayers) {
        int rightAmount = totalPlayers / 2;
        int leftAmount = totalPlayers - rightAmount;
        int tablePosition = playerNumber <= leftAmount ? playerNumber : 9 + rightAmount - (playerNumber - leftAmount);
        switch (tablePosition) {
            case 1: {
                this.labelPlayer01.setText(name);
                break;
            }
            case 2: {
                this.labelPlayer02.setText(name);
                break;
            }
            case 3: {
                this.labelPlayer03.setText(name);
                break;
            }
            case 4: {
                this.labelPlayer04.setText(name);
                break;
            }
            case 5: {
                this.labelPlayer05.setText(name);
                break;
            }
            case 6: {
                this.labelPlayer06.setText(name);
                break;
            }
            case 7: {
                this.labelPlayer07.setText(name);
                break;
            }
            case 8: {
                this.labelPlayer08.setText(name);
                break;
            }
            case 9: {
                this.labelPlayer09.setText(name);
                break;
            }
            case 10: {
                this.labelPlayer10.setText(name);
                break;
            }
            case 11: {
                this.labelPlayer11.setText(name);
                break;
            }
            case 12: {
                this.labelPlayer12.setText(name);
                break;
            }
            case 13: {
                this.labelPlayer13.setText(name);
                break;
            }
            case 14: {
                this.labelPlayer14.setText(name);
                break;
            }
            case 15: {
                this.labelPlayer15.setText(name);
                break;
            }
            case 16: {
                this.labelPlayer16.setText(name);
            }
        }
    }

    public void loadBooster(DraftPickView draftPickView) {
        this.logLastPick(draftPickView);
        this.loadCardsToPickedCardsArea(draftPickView.getPicks());
        if (this.selectedCardsListener == null) {
            this.selectedCardsListener = event -> {
                if (event.getEventType() == ClientEventType.CARD_POPUP_MENU) {
                    if (event.getSource() != null) {
                        this.cardIdPopupMenu = ((SimpleCardView)event.getSource()).getId();
                        this.popupMenuCardPanel.show(event.getComponent(), event.getxPos(), event.getyPos());
                    } else {
                        this.popupMenuPickedArea.show(event.getComponent(), event.getxPos(), event.getyPos());
                    }
                }
            };
            this.draftPicks.addCardEventListener(this.selectedCardsListener);
        }
        this.draftBooster.loadBooster(CardsViewUtil.convertSimple(draftPickView.getBooster()), this.bigCard);
        if (this.pickingCardsListener == null) {
            this.pickingCardsListener = event -> {
                if (event.getEventType() == ClientEventType.DRAFT_PICK_CARD) {
                    SimpleCardView source = (SimpleCardView)event.getSource();
                    DraftPickView view = SessionHandler.sendCardPick(this.draftId, source.getId(), this.cardsHidden);
                    if (view != null) {
                        this.loadCardsToPickedCardsArea(view.getPicks());
                        this.draftBooster.loadBooster(EMPTY_VIEW, this.bigCard);
                        Plugins.instance.getActionCallback().hideOpenComponents();
                        this.setMessage("Waiting for other players");
                    }
                } else if (event.getEventType() == ClientEventType.DRAFT_MARK_CARD) {
                    SimpleCardView source = (SimpleCardView)event.getSource();
                    SessionHandler.sendCardMark(this.draftId, source.getId());
                }
            };
            this.draftBooster.addCardEventListener(this.pickingCardsListener);
        }
        this.setMessage("Pick a card");
        if (!AppUtil.isAppActive()) {
            MageTray.instance.displayMessage("Pick the next card.");
            MageTray.instance.blink();
        }
        int newTimeout = draftPickView.getTimeout();
        if (this.pickNo != this.timeoutPickNo || newTimeout < this.timeout) {
            this.timeoutPickNo = this.pickNo;
            this.countdown.stop();
            this.timeout = newTimeout;
            this.setTimeout(this.timeout);
            if (this.timeout != 0) {
                this.countdown.start();
            }
        }
        if (!this.draftBooster.isEmptyGrid()) {
            SessionHandler.setBoosterLoaded(this.draftId);
            if (this.pickNo != this.protectionPickNo && !this.protectionTimer.isRunning()) {
                this.protectionPickNo = this.pickNo;
                this.protectionTimer.restart();
            }
        }
    }

    private void loadCardsToPickedCardsArea(SimpleCardsView pickedCards) {
        this.pickedCards = pickedCards;
        for (Map.Entry entry : pickedCards.entrySet()) {
            if (this.cardsHidden.contains(entry.getKey())) continue;
            this.pickedCardsShown.put(entry.getKey(), entry.getValue());
        }
        this.draftPicks.loadCards(CardsViewUtil.convertSimple(this.pickedCardsShown), this.bigCard, null);
    }

    private void setTimeout(int s) {
        int minute = s / 60;
        int second = s - minute * 60;
        String text = minute < 10 ? '0' + Integer.toString(minute) + ':' : Integer.toString(minute) + ':';
        text = second < 10 ? text + '0' + Integer.toString(second) : text + Integer.toString(second);
        this.editTimeRemaining.setText(text);
        Color timerColor = s <= 10 ? Color.RED : (s <= 30 ? new Color(255, 160, 60) : PreferencesDialog.getCurrentTheme().getTextColor());
        this.editTimeRemaining.setForeground(timerColor);
        if (s == 6 && !this.draftBooster.isEmptyGrid()) {
            AudioManager.playOnCountdown1();
        }
    }

    public boolean isAllowedToPick() {
        return !this.protectionTimer.isRunning();
    }

    public void hideDraft() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof DraftPane); c = c.getParent()) {
        }
        if (c != null) {
            ((DraftPane)c).removeDraft();
        }
    }

    protected void setMessage(String message) {
        this.labelMessage.setText(message);
    }

    private void addPopupMenuPickArea() {
        int c = 2;
        KeyStroke ks9 = KeyStroke.getKeyStroke(120, 0);
        this.getInputMap(c).put(ks9, "F9_PRESS");
        this.getActionMap().put("F9_PRESS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DraftPanel.this.showAgainAllHiddenCards();
            }
        });
        JMenuItem menuItem = new JMenuItem("F9 - Show all hidden cards");
        this.popupMenuPickedArea.add(menuItem);
        menuItem.addActionListener(e -> this.showAgainAllHiddenCards());
    }

    private void addPopupMenuCardPanel() {
        JMenuItem menuItem = new JMenuItem("Hide this card");
        this.popupMenuCardPanel.add(menuItem);
        menuItem.addActionListener(e -> this.hideThisCard(this.cardIdPopupMenu));
    }

    private void hideThisCard(UUID card) {
        this.cardsHidden.add(card);
        this.pickedCardsShown.remove((Object)card);
        this.draftPicks.loadCards(CardsViewUtil.convertSimple(this.pickedCardsShown), this.bigCard, null);
    }

    private void showAgainAllHiddenCards() {
        for (UUID card : this.cardsHidden) {
            this.pickedCardsShown.put((Object)card, this.pickedCards.get((Object)card));
        }
        this.cardsHidden.clear();
        this.draftPicks.loadCards(CardsViewUtil.convertSimple(this.pickedCardsShown), this.bigCard, null);
    }

    private void logLastPick(DraftPickView pickView) {
        if (!DraftPanel.isLogging()) {
            return;
        }
        if (this.currentBooster != null) {
            String lastPick = DraftPanel.getCardName(DraftPanel.getLastPick(pickView.getPicks().values()));
            if (lastPick != null && this.currentBooster.length > 1) {
                this.draftLogger.logPick(this.getCurrentSetCode(), this.packNo, this.pickNo - 1, lastPick, this.currentBooster);
            }
            this.currentBooster = null;
        }
        this.setCurrentBoosterForLog(pickView.getBooster());
        if (this.currentBooster.length == 1) {
            this.draftLogger.logPick(this.getCurrentSetCode(), this.packNo, this.pickNo, this.currentBooster[0], this.currentBooster);
        }
    }

    private String getCurrentSetCode() {
        String setCode;
        if (this.setCodes != null && this.setCodes.size() >= this.packNo && (setCode = this.setCodes.get(this.packNo - 1)) != null) {
            return setCode;
        }
        return "   ";
    }

    private static boolean isLogging() {
        String autoSave = PreferencesDialog.getCachedValue("draftLogAutoSave", "true");
        return autoSave.equals("true");
    }

    private void setCurrentBoosterForLog(SimpleCardsView booster) {
        LinkedList<String> cards = new LinkedList<String>();
        for (SimpleCardView simple : booster.values()) {
            String cardName = DraftPanel.getCardName(simple);
            if (cardName == null) continue;
            cards.add(cardName);
        }
        this.currentBooster = cards.toArray(new String[cards.size()]);
    }

    private static SimpleCardView getLastPick(Collection<SimpleCardView> picks) {
        SimpleCardView last = null;
        Iterator<SimpleCardView> iterator = picks.iterator();
        while (iterator.hasNext()) {
            SimpleCardView pick;
            last = pick = iterator.next();
        }
        return last;
    }

    private static String getCardName(SimpleCardView card) {
        if (card == null) {
            return null;
        }
        CardInfo cardInfo = CardRepository.instance.findCard(card.getExpansionSetCode(), card.getCardNumber());
        return cardInfo != null ? cardInfo.getName() : null;
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.panelLeft = new JPanel();
        this.panelCommands = new JPanel();
        this.buttonQuitTournament = new JButton();
        this.panelInfo = new JPanel();
        this.editTimeRemaining = new JTextField();
        this.labelMessage = new JLabel();
        this.panelPacks = new JPanel();
        this.panelPack1 = new JPanel();
        this.labelPack1 = new JLabel();
        this.editPack1 = new JTextField();
        this.checkPack1 = new JCheckBox();
        this.panelPack2 = new JPanel();
        this.labelPack2 = new JLabel();
        this.editPack2 = new JTextField();
        this.checkPack2 = new JCheckBox();
        this.panelPack3 = new JPanel();
        this.labelPack3 = new JLabel();
        this.editPack3 = new JTextField();
        this.checkPack3 = new JCheckBox();
        this.panelPackCard = new JPanel();
        this.labelCardNumber = new JLabel();
        this.panelPlayers = new JPanel();
        this.panelPlayersLeft = new JPanel();
        this.labelPlayer01 = new JLabel();
        this.labelPlayer02 = new JLabel();
        this.labelPlayer03 = new JLabel();
        this.labelPlayer04 = new JLabel();
        this.labelPlayer05 = new JLabel();
        this.labelPlayer06 = new JLabel();
        this.labelPlayer07 = new JLabel();
        this.labelPlayer08 = new JLabel();
        this.labelTableImage = new JLabel();
        this.panelPlayersRight = new JPanel();
        this.labelPlayer09 = new JLabel();
        this.labelPlayer10 = new JLabel();
        this.labelPlayer11 = new JLabel();
        this.labelPlayer12 = new JLabel();
        this.labelPlayer13 = new JLabel();
        this.labelPlayer14 = new JLabel();
        this.labelPlayer15 = new JLabel();
        this.labelPlayer16 = new JLabel();
        this.panelBigCard = new JPanel();
        this.bigCard = new BigCard();
        this.panelRight = new JPanel();
        this.draftPicks = new CardsList();
        this.draftBooster = new DraftGrid();
        this.panelLeft.setFocusable(false);
        this.panelLeft.setRequestFocusEnabled(false);
        this.panelLeft.setVerifyInputWhenFocusTarget(false);
        this.panelCommands.setOpaque(false);
        this.buttonQuitTournament.setText("Quit Tournament");
        this.buttonQuitTournament.setFocusable(false);
        this.buttonQuitTournament.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DraftPanel.this.buttonQuitTournamentActionPerformed(evt);
            }
        });
        this.panelCommands.add(this.buttonQuitTournament);
        this.panelInfo.setOpaque(false);
        this.panelInfo.setLayout(new BorderLayout());
        this.editTimeRemaining.setEditable(false);
        this.editTimeRemaining.setFont(new Font("Tahoma", 0, 36));
        this.editTimeRemaining.setForeground(Color.red);
        this.editTimeRemaining.setHorizontalAlignment(0);
        this.editTimeRemaining.setText("WAITING");
        this.editTimeRemaining.setBorder(null);
        this.editTimeRemaining.setFocusable(false);
        this.editTimeRemaining.setOpaque(false);
        this.panelInfo.add((Component)this.editTimeRemaining, "Center");
        this.labelMessage.setHorizontalAlignment(0);
        this.labelMessage.setText("Waiting start of the draft...");
        this.panelInfo.add((Component)this.labelMessage, "South");
        this.panelPack1.setLayout(new BoxLayout(this.panelPack1, 2));
        this.labelPack1.setText("Pack 1:");
        this.panelPack1.add(this.labelPack1);
        this.editPack1.setEditable(false);
        this.editPack1.setFocusable(false);
        this.editPack1.setPreferredSize(new Dimension(130, 22));
        this.panelPack1.add(this.editPack1);
        this.checkPack1.setEnabled(false);
        this.panelPack1.add(this.checkPack1);
        this.panelPack2.setLayout(new BoxLayout(this.panelPack2, 2));
        this.labelPack2.setText("Pack 2:");
        this.panelPack2.add(this.labelPack2);
        this.editPack2.setEditable(false);
        this.editPack2.setFocusable(false);
        this.editPack2.setPreferredSize(new Dimension(130, 22));
        this.panelPack2.add(this.editPack2);
        this.checkPack2.setEnabled(false);
        this.panelPack2.add(this.checkPack2);
        this.panelPack3.setLayout(new BoxLayout(this.panelPack3, 2));
        this.labelPack3.setText("Pack 3:");
        this.panelPack3.add(this.labelPack3);
        this.editPack3.setEditable(false);
        this.editPack3.setFocusable(false);
        this.editPack3.setPreferredSize(new Dimension(130, 22));
        this.panelPack3.add(this.editPack3);
        this.checkPack3.setEnabled(false);
        this.panelPack3.add(this.checkPack3);
        this.panelPackCard.setLayout(new BorderLayout());
        this.labelCardNumber.setHorizontalAlignment(0);
        this.labelCardNumber.setText("Card #123");
        this.panelPackCard.add((Component)this.labelCardNumber, "Center");
        GroupLayout panelPacksLayout = new GroupLayout(this.panelPacks);
        this.panelPacks.setLayout(panelPacksLayout);
        panelPacksLayout.setHorizontalGroup(panelPacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPacksLayout.createSequentialGroup().addContainerGap().addGroup(panelPacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelPack3, -1, -1, Short.MAX_VALUE).addComponent(this.panelPack1, -1, -1, Short.MAX_VALUE).addComponent(this.panelPack2, -1, -1, Short.MAX_VALUE).addComponent(this.panelPackCard, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panelPacksLayout.setVerticalGroup(panelPacksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPacksLayout.createSequentialGroup().addContainerGap().addComponent(this.panelPack1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPack2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPack3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPackCard, -2, -1, -2).addContainerGap()));
        this.panelPlayers.setOpaque(false);
        this.panelPlayersLeft.setFocusable(false);
        this.panelPlayersLeft.setMaximumSize(new Dimension(80, 132));
        this.panelPlayersLeft.setMinimumSize(new Dimension(80, 132));
        this.panelPlayersLeft.setOpaque(false);
        this.panelPlayersLeft.setPreferredSize(new Dimension(80, 132));
        this.panelPlayersLeft.setRequestFocusEnabled(false);
        this.panelPlayersLeft.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.setLayout(new GridLayout(8, 1));
        this.labelPlayer01.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer01.setHorizontalAlignment(4);
        this.labelPlayer01.setText("player 1");
        this.labelPlayer01.setAlignmentX(1.0f);
        this.labelPlayer01.setAlignmentY(0.0f);
        this.labelPlayer01.setFocusable(false);
        this.labelPlayer01.setRequestFocusEnabled(false);
        this.labelPlayer01.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer01);
        this.labelPlayer02.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer02.setHorizontalAlignment(4);
        this.labelPlayer02.setText("player 2");
        this.labelPlayer02.setAlignmentX(1.0f);
        this.labelPlayer02.setAlignmentY(0.0f);
        this.labelPlayer02.setFocusable(false);
        this.labelPlayer02.setRequestFocusEnabled(false);
        this.labelPlayer02.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer02);
        this.labelPlayer03.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer03.setHorizontalAlignment(4);
        this.labelPlayer03.setText("player 3");
        this.labelPlayer03.setAlignmentX(1.0f);
        this.labelPlayer03.setAlignmentY(0.0f);
        this.labelPlayer03.setFocusable(false);
        this.labelPlayer03.setRequestFocusEnabled(false);
        this.labelPlayer03.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer03);
        this.labelPlayer04.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer04.setHorizontalAlignment(4);
        this.labelPlayer04.setText("player 4");
        this.labelPlayer04.setAlignmentX(1.0f);
        this.labelPlayer04.setAlignmentY(0.0f);
        this.labelPlayer04.setFocusable(false);
        this.labelPlayer04.setRequestFocusEnabled(false);
        this.labelPlayer04.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer04);
        this.labelPlayer05.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer05.setHorizontalAlignment(4);
        this.labelPlayer05.setText("player 5");
        this.labelPlayer05.setAlignmentX(1.0f);
        this.labelPlayer05.setAlignmentY(0.0f);
        this.labelPlayer05.setFocusable(false);
        this.labelPlayer05.setRequestFocusEnabled(false);
        this.labelPlayer05.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer05);
        this.labelPlayer06.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer06.setHorizontalAlignment(4);
        this.labelPlayer06.setText("player 6");
        this.labelPlayer06.setAlignmentX(1.0f);
        this.labelPlayer06.setAlignmentY(0.0f);
        this.labelPlayer06.setFocusable(false);
        this.labelPlayer06.setRequestFocusEnabled(false);
        this.labelPlayer06.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer06);
        this.labelPlayer07.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer07.setHorizontalAlignment(4);
        this.labelPlayer07.setText("player 7");
        this.labelPlayer07.setAlignmentX(1.0f);
        this.labelPlayer07.setAlignmentY(0.0f);
        this.labelPlayer07.setFocusable(false);
        this.labelPlayer07.setRequestFocusEnabled(false);
        this.labelPlayer07.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer07);
        this.labelPlayer08.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer08.setHorizontalAlignment(4);
        this.labelPlayer08.setText("player 8");
        this.labelPlayer08.setAlignmentX(1.0f);
        this.labelPlayer08.setAlignmentY(0.0f);
        this.labelPlayer08.setFocusable(false);
        this.labelPlayer08.setRequestFocusEnabled(false);
        this.labelPlayer08.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersLeft.add(this.labelPlayer08);
        this.labelTableImage.setBackground(new Color(51, 102, 255));
        this.labelTableImage.setHorizontalAlignment(0);
        this.labelTableImage.setBorder(BorderFactory.createBevelBorder(0));
        this.labelTableImage.setFocusable(false);
        this.labelTableImage.setHorizontalTextPosition(0);
        this.labelTableImage.setOpaque(true);
        this.labelTableImage.setRequestFocusEnabled(false);
        this.labelTableImage.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.setFocusable(false);
        this.panelPlayersRight.setFont(new Font("Tahoma", 0, 10));
        this.panelPlayersRight.setMaximumSize(new Dimension(80, 132));
        this.panelPlayersRight.setMinimumSize(new Dimension(80, 132));
        this.panelPlayersRight.setOpaque(false);
        this.panelPlayersRight.setPreferredSize(new Dimension(80, 132));
        this.panelPlayersRight.setRequestFocusEnabled(false);
        this.panelPlayersRight.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.setLayout(new GridLayout(8, 1));
        this.labelPlayer09.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer09.setHorizontalAlignment(2);
        this.labelPlayer09.setText("player 9");
        this.labelPlayer09.setFocusable(false);
        this.labelPlayer09.setRequestFocusEnabled(false);
        this.labelPlayer09.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer09);
        this.labelPlayer10.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer10.setHorizontalAlignment(2);
        this.labelPlayer10.setText("player 10");
        this.labelPlayer10.setFocusable(false);
        this.labelPlayer10.setRequestFocusEnabled(false);
        this.labelPlayer10.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer10);
        this.labelPlayer11.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer11.setHorizontalAlignment(2);
        this.labelPlayer11.setText("player 11");
        this.labelPlayer11.setFocusable(false);
        this.labelPlayer11.setRequestFocusEnabled(false);
        this.labelPlayer11.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer11);
        this.labelPlayer12.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer12.setHorizontalAlignment(2);
        this.labelPlayer12.setText("player 12");
        this.labelPlayer12.setFocusable(false);
        this.labelPlayer12.setRequestFocusEnabled(false);
        this.labelPlayer12.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer12);
        this.labelPlayer13.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer13.setHorizontalAlignment(2);
        this.labelPlayer13.setText("player 13");
        this.labelPlayer13.setFocusable(false);
        this.labelPlayer13.setRequestFocusEnabled(false);
        this.labelPlayer13.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer13);
        this.labelPlayer14.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer14.setHorizontalAlignment(2);
        this.labelPlayer14.setText("player 14");
        this.labelPlayer14.setFocusable(false);
        this.labelPlayer14.setRequestFocusEnabled(false);
        this.labelPlayer14.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer14);
        this.labelPlayer15.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer15.setHorizontalAlignment(2);
        this.labelPlayer15.setText("player 15");
        this.labelPlayer15.setFocusable(false);
        this.labelPlayer15.setRequestFocusEnabled(false);
        this.labelPlayer15.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer15);
        this.labelPlayer16.setFont(new Font("Tahoma", 0, 10));
        this.labelPlayer16.setHorizontalAlignment(2);
        this.labelPlayer16.setText("player 16");
        this.labelPlayer16.setFocusable(false);
        this.labelPlayer16.setRequestFocusEnabled(false);
        this.labelPlayer16.setVerifyInputWhenFocusTarget(false);
        this.panelPlayersRight.add(this.labelPlayer16);
        GroupLayout panelPlayersLayout = new GroupLayout(this.panelPlayers);
        this.panelPlayers.setLayout(panelPlayersLayout);
        panelPlayersLayout.setHorizontalGroup(panelPlayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPlayersLayout.createSequentialGroup().addContainerGap().addComponent(this.panelPlayersLeft, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTableImage, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPlayersRight, -1, -1, Short.MAX_VALUE).addContainerGap()));
        panelPlayersLayout.setVerticalGroup(panelPlayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPlayersLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(panelPlayersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelPlayersLeft, -1, -1, Short.MAX_VALUE).addComponent(this.labelTableImage, -1, -1, Short.MAX_VALUE).addComponent(this.panelPlayersRight, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.panelBigCard.setLayout(new BorderLayout());
        this.panelBigCard.add((Component)this.bigCard, "Center");
        GroupLayout panelLeftLayout = new GroupLayout(this.panelLeft);
        this.panelLeft.setLayout(panelLeftLayout);
        panelLeftLayout.setHorizontalGroup(panelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLeftLayout.createSequentialGroup().addContainerGap().addGroup(panelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelCommands, -1, -1, Short.MAX_VALUE).addComponent(this.panelInfo, -1, -1, Short.MAX_VALUE).addComponent(this.panelPacks, -1, -1, Short.MAX_VALUE).addComponent(this.panelBigCard, -2, 0, Short.MAX_VALUE).addComponent(this.panelPlayers, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panelLeftLayout.setVerticalGroup(panelLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLeftLayout.createSequentialGroup().addComponent(this.panelCommands, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelInfo, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPacks, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPlayers, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 112, Short.MAX_VALUE).addComponent(this.panelBigCard, -2, 285, -2).addContainerGap()));
        this.draftBooster.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout draftBoosterLayout = new GroupLayout(this.draftBooster);
        this.draftBooster.setLayout(draftBoosterLayout);
        draftBoosterLayout.setHorizontalGroup(draftBoosterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 624, Short.MAX_VALUE));
        draftBoosterLayout.setVerticalGroup(draftBoosterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 439, Short.MAX_VALUE));
        GroupLayout panelRightLayout = new GroupLayout(this.panelRight);
        this.panelRight.setLayout(panelRightLayout);
        panelRightLayout.setHorizontalGroup(panelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRightLayout.createSequentialGroup().addContainerGap().addGroup(panelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.draftPicks, -1, 626, Short.MAX_VALUE).addComponent(this.draftBooster, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panelRightLayout.setVerticalGroup(panelRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelRightLayout.createSequentialGroup().addContainerGap().addComponent(this.draftPicks, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.draftBooster, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.panelLeft, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelRight, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelLeft, -1, -1, Short.MAX_VALUE).addComponent(this.panelRight, -1, -1, Short.MAX_VALUE));
    }

    private void buttonQuitTournamentActionPerformed(ActionEvent evt) {
        UserRequestMessage message = new UserRequestMessage("Confirm quit tournament", "Are you sure you want to quit the draft tournament?");
        message.setButton1("No", null);
        message.setButton2("Yes", PlayerAction.CLIENT_QUIT_DRAFT_TOURNAMENT);
        message.setTournamentId(this.draftId);
        MageFrame.getInstance().showUserRequestDialog(message);
    }
}

