/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import mage.abilities.icon.CardIconRenderSettings;
import mage.cards.MageCard;
import mage.cards.MagePermanent;
import mage.client.MageFrame;
import mage.client.cards.BigCard;
import mage.client.dialog.PreferencesDialog;
import mage.client.plugins.impl.Plugins;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.GUISizeHelper;
import mage.client.util.audio.AudioManager;
import mage.client.util.layout.CardLayoutStrategy;
import mage.client.util.layout.impl.CardLayoutStrategyImpl;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.util.DebugUtil;
import mage.view.CardView;
import mage.view.PermanentView;
import org.apache.log4j.Logger;

public class BattlefieldPanel
extends JLayeredPane {
    private static final Logger logger = Logger.getLogger(BattlefieldPanel.class);
    private static final int GAME_REDRAW_TIMEOUT_MS = 300;
    private final Map<UUID, MageCard> permanents = new LinkedHashMap<UUID, MageCard>();
    private UUID gameId;
    private BigCard bigCard;
    private final Map<String, JComponent> uiComponentsList = new HashMap<String, JComponent>();
    protected Map<UUID, PermanentView> battlefield;
    private Dimension cardDimension;
    private JLayeredPane jPanel;
    private JScrollPane jScrollPane;
    private final CardLayoutStrategy layoutStrategy = new CardLayoutStrategyImpl();
    private Timer gameUpdateTimer;
    private boolean addedPermanent;
    private boolean addedArtifact;
    private boolean addedCreature;
    private boolean removedCreature;
    private boolean topPanelBattlefield;

    public BattlefieldPanel() {
        this.uiComponentsList.put("battlefieldPanel", this);
        this.initComponents();
        this.uiComponentsList.put("jPanel", this.jPanel);
        this.uiComponentsList.put("scrollPane", this.jScrollPane);
        this.setGUISize();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BattlefieldPanel.this.updateSize();
            }
        });
        this.gameUpdateTimer = new Timer(300, evt -> SwingUtilities.invokeLater(() -> {
            this.gameUpdateTimer.stop();
            ClientCallback updateMessage = new ClientCallback(ClientCallbackMethod.GAME_REDRAW_GUI, this.gameId);
            MageFrame.getInstance().onCallback(updateMessage);
        }));
    }

    public void updateSize() {
        this.jScrollPane.setSize(this.getWidth(), this.getHeight());
        this.sortLayout();
    }

    public void init(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.bigCard = bigCard;
    }

    public void cleanUp() {
        this.gameUpdateTimer.stop();
        for (Component c : this.jPanel.getComponents()) {
            if (!(c instanceof MageCard) || !(((MageCard)c).getMainPanel() instanceof MagePermanent)) continue;
            this.jPanel.remove(c);
        }
        this.permanents.clear();
        this.bigCard = null;
    }

    public void changeGUISize() {
        this.setGUISize();
        this.sortLayout();
    }

    private void setGUISize() {
        this.jScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        this.cardDimension = GUISizeHelper.battlefieldCardMaxDimension;
    }

    public boolean isTopPanelBattlefield() {
        return this.topPanelBattlefield;
    }

    public void setTopPanelBattlefield(boolean topPanelBattlefield) {
        this.topPanelBattlefield = topPanelBattlefield;
    }

    public void update(Map<UUID, PermanentView> battlefield) {
        this.gameUpdateTimer.stop();
        boolean changed = false;
        ArrayList<PermanentView> permanentsToAdd = new ArrayList<PermanentView>();
        for (PermanentView permanentView : battlefield.values()) {
            if (!permanentView.isPhasedIn()) continue;
            MageCard mageCard = this.permanents.get(permanentView.getId());
            MagePermanent oldMagePermanent = mageCard == null ? null : (MagePermanent)mageCard.getMainPanel();
            int permanentPower = 0;
            int permanentToughness = 0;
            int oldMagePermanentPower = 0;
            int oldMagePermanentToughness = 0;
            if (permanentView != null && oldMagePermanent != null && permanentView.getOriginal() != null && oldMagePermanent.getOriginal() != null) {
                permanentPower = permanentView.getOriginal().getOriginalPower() != null ? permanentView.getOriginal().getOriginalPower().getValue() : 0;
                permanentToughness = permanentView.getOriginal().getOriginalToughness() != null ? permanentView.getOriginal().getOriginalToughness().getValue() : 0;
                oldMagePermanentPower = oldMagePermanent.getOriginal().getOriginalPower() != null ? oldMagePermanent.getOriginal().getOriginalPower().getValue() : 0;
                int n = oldMagePermanentToughness = oldMagePermanent.getOriginal().getOriginalToughness() != null ? oldMagePermanent.getOriginal().getOriginalToughness().getValue() : 0;
                if (permanentPower != oldMagePermanentPower || permanentToughness != oldMagePermanentToughness) {
                    changed = true;
                }
            }
            if (oldMagePermanent == null) {
                permanentsToAdd.add(permanentView);
                changed = true;
                continue;
            }
            if (!changed) {
                boolean bl = changed = oldMagePermanent.getOriginalPermanent().isCreature() != permanentView.isCreature();
                if (!changed) {
                    int attachmentsBefore;
                    int attachments = permanentView.getAttachments() == null ? 0 : permanentView.getAttachments().size();
                    if (attachments != (attachmentsBefore = oldMagePermanent.getLinks().size())) {
                        changed = true;
                    } else if (attachments > 0) {
                        HashSet attachmentIds = new HashSet(permanentView.getAttachments());
                        for (MageCard mageCard2 : oldMagePermanent.getLinks()) {
                            MagePermanent magePermanent = (MagePermanent)mageCard2.getMainPanel();
                            if (attachmentIds.contains(magePermanent.getOriginalPermanent().getId())) continue;
                            changed = true;
                            break;
                        }
                    }
                }
                if (!changed) {
                    UUID attachedToIdBefore = oldMagePermanent.getOriginalPermanent().getAttachedTo();
                    UUID attachedToId = permanentView.getAttachedTo();
                    if (attachedToIdBefore == null && attachedToId != null || attachedToId == null && attachedToIdBefore != null || attachedToIdBefore != null && !attachedToIdBefore.equals(attachedToId)) {
                        changed = true;
                    }
                }
                if (!changed) {
                    List counters1 = oldMagePermanent.getOriginalPermanent().getCounters();
                    List counters2 = permanentView.getCounters();
                    if (counters1 == null && counters2 != null || counters1 != null && counters2 == null) {
                        changed = true;
                    } else if (counters1 != null && counters2 != null && counters1.size() != counters2.size()) {
                        changed = true;
                    }
                }
            }
            oldMagePermanent.update(permanentView);
        }
        this.addedPermanent = false;
        this.addedCreature = false;
        this.addedArtifact = false;
        int count = permanentsToAdd.size();
        for (PermanentView permanentView : permanentsToAdd) {
            this.addPermanent(permanentView, count);
        }
        if (this.addedArtifact) {
            AudioManager.playAddArtifact();
        } else if (this.addedCreature) {
            AudioManager.playSummon();
        } else if (this.addedPermanent) {
            AudioManager.playAddPermanent();
        }
        this.removedCreature = false;
        Iterator<Map.Entry<UUID, MageCard>> iterator = this.permanents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, MageCard> entry = iterator.next();
            if (battlefield.containsKey(entry.getKey()) && battlefield.get(entry.getKey()).isPhasedIn()) continue;
            this.removePermanent(entry.getKey(), 1);
            iterator.remove();
            changed = true;
        }
        if (this.removedCreature) {
            AudioManager.playDiedCreature();
        }
        if (changed) {
            this.battlefield = battlefield;
            this.sortLayout();
        }
    }

    public void sortLayout() {
        if (this.battlefield == null || this.getWidth() < 1) {
            return;
        }
        this.layoutStrategy.doLayout(this, this.getWidth());
        this.jScrollPane.repaint();
        this.jScrollPane.revalidate();
        this.invalidate();
        this.repaint();
    }

    private void addPermanent(PermanentView permanent, int count) {
        if (this.cardDimension == null) {
            this.cardDimension = new Dimension(ClientDefaultSettings.dimensions.getFrameWidth(), ClientDefaultSettings.dimensions.getFrameHeight());
        }
        MageCard perm = Plugins.instance.getMagePermanent(permanent, this.bigCard, new CardIconRenderSettings(), this.cardDimension, this.gameId, true, PreferencesDialog.getRenderMode(), true);
        perm.setCardContainerRef((Container)this.jPanel);
        perm.update((CardView)permanent);
        this.permanents.put(permanent.getId(), perm);
        this.jPanel.add((Component)perm, (Object)10);
        this.moveToFront(this.jPanel);
        Plugins.instance.onAddCard(perm, 1);
        if (permanent.isArtifact()) {
            this.addedArtifact = true;
        } else if (permanent.isCreature()) {
            this.addedCreature = true;
        } else {
            this.addedPermanent = true;
        }
    }

    private void removePermanent(UUID permanentId, int count) {
        for (Component comp : this.jPanel.getComponents()) {
            MageCard mageCard;
            if (!(comp instanceof MageCard) || !((mageCard = (MageCard)comp).getMainPanel() instanceof MagePermanent)) continue;
            MagePermanent magePermanent = (MagePermanent)mageCard.getMainPanel();
            if (magePermanent.getOriginal().getId().equals(permanentId)) {
                Thread t = new Thread(() -> {
                    Plugins.instance.onRemoveCard(mageCard, count);
                    mageCard.setVisible(false);
                    this.jPanel.remove((Component)mageCard);
                });
                t.start();
            }
            if (!magePermanent.getOriginal().isCreature()) continue;
            this.removedCreature = true;
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Map<UUID, MageCard> getPermanentPanels() {
        return this.permanents;
    }

    private void initComponents() {
        this.setOpaque(false);
        this.jPanel = new JLayeredPane();
        this.jPanel.setLayout(null);
        this.jPanel.setOpaque(false);
        this.jScrollPane = new JScrollPane(this.jPanel);
        if (DebugUtil.GUI_GAME_DRAW_BATTLEFIELD_BORDER) {
            this.jPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA));
            this.jScrollPane.setBorder(BorderFactory.createLineBorder(Color.green));
        }
        EmptyBorder empty = new EmptyBorder(0, 0, 0, 0);
        this.jScrollPane.setBorder(empty);
        this.jScrollPane.setViewportBorder(empty);
        this.jScrollPane.setOpaque(false);
        this.jScrollPane.getViewport().setOpaque(false);
        this.jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (BattlefieldPanel.this.gameUpdateTimer.isRunning()) {
                    BattlefieldPanel.this.gameUpdateTimer.restart();
                } else {
                    BattlefieldPanel.this.gameUpdateTimer.start();
                }
            }
        });
        this.add(this.jScrollPane);
    }

    public JLayeredPane getMainPanel() {
        return this.jPanel;
    }

    public Map<UUID, PermanentView> getBattlefield() {
        return this.battlefield;
    }

    public Map<String, JComponent> getUiComponentsList() {
        return this.uiComponentsList;
    }
}

