/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.chat.ChatPanelBasic;
import mage.client.dialog.MageDialog;
import mage.client.game.GamePane;
import mage.client.game.GamePanel;
import mage.client.game.HelperPanel;
import mage.client.util.audio.AudioManager;
import mage.client.util.gui.ArrowBuilder;
import mage.constants.PlayerAction;
import mage.constants.TurnPhase;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;

public class FeedbackPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(FeedbackPanel.class);
    private UUID gameId;
    private FeedbackMode mode;
    private MageDialog connectedDialog;
    private ChatPanelBasic connectedChatPanel;
    private Map<String, Serializable> lastOptions = new HashMap<String, Serializable>();
    private static final int AUTO_CLOSE_END_DIALOG_TIMEOUT_SECS = 8;
    private static final ScheduledExecutorService AUTO_CLOSE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE auto-close timer"));
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnSpecial;
    private JButton btnUndo;
    private HelperPanel helper;

    public FeedbackPanel() {
        this.customInitComponents();
    }

    public void init(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.helper.init(gameId, bigCard);
        this.setGUISize();
    }

    public void changeGUISize() {
        this.setGUISize();
        this.helper.changeGUISize();
    }

    private void setGUISize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareFeedback(FeedbackMode mode, String basicMessage, String additionalMessage, boolean special, Map<String, Serializable> options, boolean gameNeedUserFeedback, TurnPhase gameTurnPhase) {
        String serverSideAdditionalMessage;
        FeedbackPanel feedbackPanel = this;
        synchronized (feedbackPanel) {
            this.lastOptions = options;
            this.mode = mode;
        }
        ArrayList<String> secondaryMessages = new ArrayList<String>();
        if (additionalMessage != null && !additionalMessage.isEmpty()) {
            secondaryMessages.add(additionalMessage);
        }
        String string = serverSideAdditionalMessage = options != null && options.containsKey("secondMessage") ? (String)((Object)options.get("secondMessage")) : null;
        if (serverSideAdditionalMessage != null && !serverSideAdditionalMessage.isEmpty()) {
            secondaryMessages.add(serverSideAdditionalMessage);
        }
        this.helper.setMessages(basicMessage, String.join((CharSequence)"<br>", secondaryMessages));
        this.helper.setOriginalId(null);
        switch (this.mode) {
            case INFORM: {
                this.setButtonState("", "", mode);
                break;
            }
            case QUESTION: {
                this.setButtonState("Yes", "No", mode);
                if (options != null && options.containsKey("originalId")) {
                    this.helper.setOriginalId((UUID)options.get("originalId"));
                }
                if (options != null && options.containsKey("autoAnswerMessage")) {
                    this.helper.setAutoAnswerMessage((String)((Object)options.get("autoAnswerMessage")));
                    break;
                }
                this.helper.setAutoAnswerMessage(basicMessage);
                break;
            }
            case CONFIRM: {
                this.setButtonState("OK", "Cancel", mode);
                break;
            }
            case CANCEL: {
                this.setButtonState("", "Cancel", mode);
                this.helper.setUndoEnabled(false);
                break;
            }
            case SELECT: {
                this.setButtonState("", "Done", mode);
                break;
            }
            case END: {
                this.setButtonState("", "Close game", mode);
                ArrowBuilder.getBuilder().removeAllArrows(this.gameId);
                this.endWithTimeout();
            }
        }
        if (options != null && options.containsKey("specialButton")) {
            this.setSpecial((String)((Object)options.get("specialButton")), true);
        } else {
            this.setSpecial("Special", special);
        }
        this.requestFocusIfPossible();
        this.updateOptions(options);
        this.helper.setLinks(this.btnLeft, this.btnRight, this.btnSpecial, this.btnUndo);
        this.helper.setVisible(true);
        this.helper.setGameNeedFeedback(gameNeedUserFeedback, gameTurnPhase);
        this.helper.autoSizeButtonsAndFeedbackState();
        this.revalidate();
    }

    private void setButtonState(String leftText, String rightText, FeedbackMode mode) {
        this.btnLeft.setVisible(!leftText.isEmpty());
        this.btnLeft.setText(leftText);
        this.btnRight.setVisible(!rightText.isEmpty());
        this.btnRight.setText(rightText);
        this.helper.setState(leftText, !leftText.isEmpty(), rightText, !rightText.isEmpty(), mode);
    }

    private void setSpecial(String text, boolean visible) {
        this.btnSpecial.setText(text);
        this.btnSpecial.setVisible(visible);
        this.helper.setSpecial(text, visible);
    }

    private void endWithTimeout() {
        Runnable task = () -> SwingUtilities.invokeLater(() -> {
            Container c;
            LOGGER.info((Object)"Ending game...");
            for (c = MageFrame.getGame(this.gameId); c != null && !(c instanceof GamePane); c = c.getParent()) {
            }
            if (c != null && c.isVisible()) {
                this.btnRight.doClick();
            }
        });
        AUTO_CLOSE_EXECUTOR.schedule(task, 8L, TimeUnit.SECONDS);
    }

    public void updateOptions(Map<String, Serializable> options) {
        this.lastOptions = options;
        if (this.lastOptions != null) {
            String text;
            if (this.lastOptions.containsKey("UI.left.btn.text")) {
                text = (String)((Object)this.lastOptions.get("UI.left.btn.text"));
                this.btnLeft.setText(text);
                this.helper.setLeft(text, !text.isEmpty());
            }
            if (this.lastOptions.containsKey("UI.right.btn.text")) {
                text = (String)((Object)this.lastOptions.get("UI.right.btn.text"));
                this.btnRight.setText(text);
                this.helper.setRight(text, !text.isEmpty());
            }
            this.updateConnectedDialog(this.lastOptions.getOrDefault("dialog", null));
            this.helper.autoSizeButtonsAndFeedbackState();
        } else {
            this.updateConnectedDialog(null);
        }
    }

    private void updateConnectedDialog(MageDialog newDialog) {
        if (this.connectedDialog != null && this.connectedDialog != newDialog) {
            this.connectedDialog.removeDialog();
        }
        this.connectedDialog = newDialog;
        if (this.connectedDialog != null) {
            this.connectedDialog.setVisible(true);
        }
    }

    private void requestFocusIfPossible() {
        boolean requestFocusAllowed = true;
        if (MageFrame.getInstance().getFocusOwner() == null) {
            requestFocusAllowed = false;
        } else if (this.connectedChatPanel != null && this.connectedChatPanel.getTxtMessageInputComponent() != null && this.connectedChatPanel.getTxtMessageInputComponent().hasFocus()) {
            requestFocusAllowed = false;
        }
        if (requestFocusAllowed) {
            this.btnRight.requestFocus();
            this.helper.requestFocus();
        }
    }

    public void doClick() {
        this.btnRight.doClick();
    }

    public void clear() {
        this.btnLeft.setVisible(false);
        this.btnRight.setVisible(false);
        this.btnSpecial.setVisible(false);
    }

    private void customInitComponents() {
        this.btnRight = new JButton();
        this.btnLeft = new JButton();
        this.btnSpecial = new JButton();
        this.btnUndo = new JButton();
        this.btnUndo.setVisible(true);
        this.setBackground(new Color(0, 0, 0, 80));
        this.btnRight.setText("Cancel");
        this.btnRight.addActionListener(evt -> this.btnRightActionPerformed(evt));
        this.btnLeft.setText("OK");
        this.btnLeft.addActionListener(evt -> this.btnLeftActionPerformed(evt));
        this.btnSpecial.setText("Special");
        this.btnSpecial.addActionListener(evt -> this.btnSpecialActionPerformed(evt));
        this.btnUndo.setText("Undo");
        this.btnUndo.addActionListener(evt -> this.btnUndoActionPerformed(evt));
    }

    private void btnRightActionPerformed(ActionEvent evt) {
        this.updateConnectedDialog(null);
        if (this.mode == FeedbackMode.SELECT && (evt.getModifiers() & 2) == 2) {
            SessionHandler.sendPlayerInteger(this.gameId, 0);
        } else if (this.mode == FeedbackMode.END) {
            GamePanel gamePanel = MageFrame.getGame(this.gameId);
            if (gamePanel != null) {
                gamePanel.removeGame();
            }
        } else {
            SessionHandler.sendPlayerBoolean(this.gameId, false);
        }
    }

    private void btnLeftActionPerformed(ActionEvent evt) {
        SessionHandler.sendPlayerBoolean(this.gameId, true);
        AudioManager.playButtonCancel();
    }

    private void btnSpecialActionPerformed(ActionEvent evt) {
        SessionHandler.sendPlayerString(this.gameId, "special");
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
        SessionHandler.sendPlayerAction(PlayerAction.UNDO, this.gameId, null);
    }

    public void setHelperPanel(HelperPanel helper) {
        this.helper = helper;
    }

    public FeedbackMode getMode() {
        return this.mode;
    }

    public void setConnectedChatPanel(ChatPanelBasic chatPanel) {
        this.connectedChatPanel = chatPanel;
    }

    public void pressOKYesOrDone() {
        if (this.btnLeft.getText().equals("OK") || this.btnLeft.getText().equals("Yes")) {
            this.btnLeft.doClick();
        } else if (this.btnRight.getText().equals("OK") || this.btnRight.getText().equals("Yes") || this.btnRight.getText().equals("Done")) {
            this.btnRight.doClick();
        }
    }

    public void allowUndo(int bookmark) {
        this.helper.setUndoEnabled(true);
    }

    public void disableUndo() {
        this.helper.setUndoEnabled(false);
    }

    public static enum FeedbackMode {
        INFORM,
        QUESTION,
        CONFIRM,
        CANCEL,
        SELECT,
        END;

    }
}

