/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import mage.client.components.KeyboundButton;

public class FirstButtonMousePressedAction
extends MouseAdapter {
    private final Consumer<MouseEvent> callback;
    private boolean pressed = false;
    private boolean inside = false;

    public FirstButtonMousePressedAction(Consumer<MouseEvent> callback) {
        this.callback = callback;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = true;
        if (e.getSource() instanceof KeyboundButton) {
            KeyboundButton button = (KeyboundButton)e.getSource();
            button.setTint(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        if (e.getSource() instanceof KeyboundButton) {
            KeyboundButton button = (KeyboundButton)e.getSource();
            button.setTint(false);
        }
        if (SwingUtilities.isLeftMouseButton(e) && this.inside) {
            this.callback.accept(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.inside = true;
        if (this.pressed && e.getSource() instanceof KeyboundButton) {
            KeyboundButton button = (KeyboundButton)e.getSource();
            button.setTint(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.inside = false;
        if (e.getSource() instanceof KeyboundButton) {
            KeyboundButton button = (KeyboundButton)e.getSource();
            button.setTint(false);
        }
    }
}

