/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.AWTEvent;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import mage.client.MagePane;
import mage.client.game.GamePanel;

public class GamePane
extends MagePane {
    private GamePanel gamePanel;
    private JScrollPane jScrollPane1;
    private UUID currentTableId;
    private UUID parentTableId;
    private UUID gameId;

    public GamePane() {
        this.initComponents();
        SwingUtilities.invokeLater(() -> {
            this.gamePanel.setJLayeredPane(this);
            this.gamePanel.installComponents();
        });
    }

    public void showGame(UUID currentTableId, UUID parentTableId, UUID gameId, UUID playerId) {
        this.setTitle("Game " + gameId);
        this.currentTableId = currentTableId;
        this.parentTableId = parentTableId;
        this.gameId = gameId;
        this.gamePanel.showGame(currentTableId, parentTableId, gameId, playerId, this);
    }

    @Override
    public boolean isActiveTable() {
        return this.gameId != null;
    }

    public void cleanUp() {
        this.gamePanel.cleanUp();
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        this.gamePanel.changeGUISize();
        this.revalidate();
        this.repaint();
    }

    public void removeGame() {
        this.cleanUp();
        this.removeFrame();
    }

    public void watchGame(UUID currentTableId, UUID parentTableId, UUID gameId) {
        this.setTitle("Watching " + gameId);
        this.currentTableId = currentTableId;
        this.parentTableId = parentTableId;
        this.gameId = gameId;
        this.gamePanel.watchGame(currentTableId, parentTableId, gameId, this);
    }

    public void replayGame(UUID gameId) {
        this.setTitle("Replaying " + gameId);
        this.currentTableId = null;
        this.parentTableId = null;
        this.gameId = gameId;
        this.gamePanel.replayGame(gameId);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder());
        this.gamePanel = new GamePanel();
        this.jScrollPane1.setViewportView(this.gamePanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 600, Short.MAX_VALUE).addGap(0, 600, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE).addGap(0, 400, Short.MAX_VALUE));
    }

    public UUID getGameId() {
        return this.gameId;
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.gamePanel.onDeactivated();
    }

    @Override
    public void activated() {
        this.gamePanel.onActivated();
    }

    @Override
    public void handleEvent(AWTEvent event) {
        this.gamePanel.handleEvent(event);
    }

    @Override
    public UUID getSortTableId() {
        return this.parentTableId != null ? this.parentTableId : this.currentTableId;
    }
}

