/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.components.MageTextArea;
import mage.client.game.FeedbackPanel;
import mage.client.util.AppUtil;
import mage.client.util.GUISizeHelper;
import mage.client.util.audio.AudioManager;
import mage.constants.PlayerAction;
import mage.constants.TurnPhase;

public class HelperPanel
extends JPanel {
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnSpecial;
    private JButton btnUndo;
    private JScrollPane textAreaScrollPane;
    private MageTextArea dialogTextArea;
    JPanel mainPanel;
    JPanel buttonGrid;
    JPanel buttonContainer;
    private JButton linkLeft;
    private JButton linkRight;
    private JButton linkSpecial;
    private JButton linkUndo;
    private final Object tooltipBackground = UIManager.get("info");
    private static final String CMD_AUTO_ANSWER_ID_YES = "cmdAutoAnswerIdYes";
    private static final String CMD_AUTO_ANSWER_ID_NO = "cmdAutoAnswerIdNo";
    private static final String CMD_AUTO_ANSWER_NAME_YES = "cmdAutoAnswerNameYes";
    private static final String CMD_AUTO_ANSWER_NAME_NO = "cmdAutoAnswerNameNo";
    private static final String CMD_AUTO_ANSWER_RESET_ALL = "cmdAutoAnswerResetAll";
    private JPopupMenu popupMenuAskYes;
    private JMenuItem popupItemYesAsText;
    private JMenuItem popupItemYesAsTextAndAbility;
    private JPopupMenu popupMenuAskNo;
    private JMenuItem popupItemNoAsText;
    private JMenuItem popupItemNoAsTextAndAbility;
    private UUID originalId;
    private String basicMessage;
    private String secondaryMessage;
    private String autoAnswerMessage;
    private UUID gameId;
    private boolean gameNeedFeedback = false;
    private TurnPhase gameTurnPhase = null;
    private Timer needFeedbackTimer = new Timer(100, evt -> SwingUtilities.invokeLater(() -> {
        this.needFeedbackTimer.stop();
        if (!AppUtil.isAppActive() || !AppUtil.isGameActive(this.gameId)) {
            AudioManager.playFeedbackNeeded();
        }
    }));

    public HelperPanel() {
        this.initComponents();
    }

    public void init(UUID gameId, BigCard bigCard) {
        this.gameId = gameId;
        this.dialogTextArea.setGameData(gameId, bigCard);
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        this.textAreaScrollPane.setMaximumSize(new Dimension(this.getParent().getWidth(), GUISizeHelper.gameFeedbackPanelMaxHeight));
        this.textAreaScrollPane.setPreferredSize(new Dimension(this.getParent().getWidth(), GUISizeHelper.gameFeedbackPanelMaxHeight));
        this.btnLeft.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnRight.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnSpecial.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnUndo.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.redrawMessages();
        this.autoSizeButtonsAndFeedbackState();
        GUISizeHelper.changePopupMenuFont(this.popupMenuAskNo);
        GUISizeHelper.changePopupMenuFont(this.popupMenuAskYes);
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.initPopupMenuTriggerOrder();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(0, 1));
        this.mainPanel.setOpaque(false);
        this.add((Component)this.mainPanel, "Center");
        this.dialogTextArea = new MageTextArea();
        this.dialogTextArea.setText("<Empty>");
        this.dialogTextArea.setOpaque(false);
        this.textAreaScrollPane = new JScrollPane(this.dialogTextArea, 20, 31);
        this.textAreaScrollPane.setOpaque(false);
        this.textAreaScrollPane.setBackground(new Color(0, 0, 0, 0));
        this.textAreaScrollPane.getViewport().setOpaque(false);
        this.textAreaScrollPane.setBorder(null);
        this.textAreaScrollPane.setViewportBorder(null);
        this.mainPanel.add(this.textAreaScrollPane);
        this.buttonContainer = new JPanel();
        this.buttonContainer.setLayout(new FlowLayout(1, 0, 0));
        this.buttonContainer.setOpaque(false);
        this.mainPanel.add(this.buttonContainer);
        this.buttonGrid = new JPanel();
        this.buttonGrid.setOpaque(false);
        this.buttonContainer.add(this.buttonGrid);
        this.btnSpecial = new JButton("Special");
        this.btnSpecial.setVisible(false);
        this.buttonGrid.add(this.btnSpecial);
        this.btnLeft = new JButton("OK");
        this.btnLeft.setVisible(false);
        this.buttonGrid.add(this.btnLeft);
        this.btnRight = new JButton("Cancel");
        this.btnRight.setVisible(false);
        this.buttonGrid.add(this.btnRight);
        this.btnUndo = new JButton("Undo");
        this.btnUndo.setVisible(false);
        this.buttonGrid.add(this.btnUndo);
        MouseAdapter checkPopupAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HelperPanel.this.checkPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                HelperPanel.this.checkPopupMenu(e);
            }
        };
        this.btnLeft.addMouseListener(checkPopupAdapter);
        this.btnLeft.addActionListener(evt -> {
            if (this.linkLeft != null) {
                this.clickButton(this.linkLeft);
            }
        });
        this.btnRight.addMouseListener(checkPopupAdapter);
        this.btnRight.addActionListener(evt -> {
            if (this.linkRight != null) {
                this.clickButton(this.linkRight);
            }
        });
        this.btnSpecial.addActionListener(evt -> {
            if (this.linkSpecial != null) {
                this.clickButton(this.linkSpecial);
            }
        });
        this.btnUndo.addActionListener(evt -> {
            if (this.linkUndo != null) {
                Thread worker = new Thread(() -> SwingUtilities.invokeLater(() -> this.linkUndo.doClick()));
                worker.start();
            }
        });
        this.dialogTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(100000);
                UIManager.put("info", Color.DARK_GRAY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(60000);
                UIManager.put("info", HelperPanel.this.tooltipBackground);
            }
        });
    }

    private void checkPopupMenu(MouseEvent e) {
        JButton source;
        if (e.isPopupTrigger() && (source = (JButton)e.getSource()).getActionCommand().startsWith(FeedbackPanel.FeedbackMode.QUESTION.toString())) {
            this.showPopupMenu(e.getComponent(), source.getActionCommand());
            e.consume();
        }
    }

    private void clickButton(JButton button) {
        Thread worker = new Thread(() -> SwingUtilities.invokeLater(() -> {
            this.setState("", false, "", false, null);
            this.setSpecial("", false);
            button.doClick();
        }));
        worker.start();
    }

    public void setState(String txtLeft, boolean leftVisible, String txtRight, boolean rightVisible, FeedbackPanel.FeedbackMode mode) {
        this.btnLeft.setVisible(leftVisible);
        if (!txtLeft.isEmpty()) {
            this.btnLeft.setText(txtLeft);
            if (mode != null) {
                this.btnLeft.setActionCommand((Object)((Object)mode) + txtLeft);
            }
        }
        this.btnRight.setVisible(rightVisible);
        if (!txtRight.isEmpty()) {
            this.btnRight.setText(txtRight);
            if (mode != null) {
                this.btnRight.setActionCommand((Object)((Object)mode) + txtRight);
            }
        }
        String buttonTooltip = null;
        if (mode == FeedbackPanel.FeedbackMode.QUESTION) {
            buttonTooltip = "Right click on button to make auto-answer.";
        }
        this.btnLeft.setToolTipText(buttonTooltip);
        this.btnRight.setToolTipText(buttonTooltip);
        this.autoSizeButtonsAndFeedbackState();
    }

    public void setSpecial(String txtSpecial, boolean specialVisible) {
        this.btnSpecial.setVisible(specialVisible);
        this.btnSpecial.setText(txtSpecial);
    }

    public void setUndoEnabled(boolean enabled) {
        this.btnUndo.setVisible(enabled);
        this.autoSizeButtonsAndFeedbackState();
    }

    public void setLeft(String text, boolean visible) {
        this.btnLeft.setVisible(visible);
        if (!text.isEmpty()) {
            this.btnLeft.setText(text);
        }
        this.autoSizeButtonsAndFeedbackState();
    }

    public void setRight(String txtRight, boolean rightVisible) {
        this.btnRight.setVisible(rightVisible);
        if (!txtRight.isEmpty()) {
            this.btnRight.setText(txtRight);
        }
        this.autoSizeButtonsAndFeedbackState();
    }

    public void setGameNeedFeedback(boolean need, TurnPhase gameTurnPhase) {
        this.gameNeedFeedback = need;
        this.gameTurnPhase = gameTurnPhase;
        if (this.gameNeedFeedback) {
            this.needFeedbackTimer.restart();
        } else {
            this.needFeedbackTimer.stop();
        }
    }

    public void autoSizeButtonsAndFeedbackState() {
        int BUTTONS_H_GAP = 15;
        Color ACTIVE_FEEDBACK_BACKGROUND_COLOR_MAIN = new Color(0, 0, 255, 50);
        Color ACTIVE_FEEDBACK_BACKGROUND_COLOR_BATTLE = new Color(255, 0, 0, 50);
        Color ACTIVE_FEEDBACK_BACKGROUND_COLOR_OTHER = new Color(0, 255, 0, 50);
        this.buttonGrid.setLayout(new FlowLayout(1, BUTTONS_H_GAP, 0));
        this.buttonGrid.setPreferredSize(null);
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        if (this.btnSpecial.isVisible()) {
            buttons.add(this.btnSpecial);
        }
        if (this.btnLeft.isVisible()) {
            buttons.add(this.btnLeft);
        }
        if (this.btnRight.isVisible()) {
            buttons.add(this.btnRight);
        }
        if (this.btnUndo.isVisible()) {
            buttons.add(this.btnUndo);
        }
        if (this.gameNeedFeedback) {
            this.mainPanel.setOpaque(true);
            Object backColor = ACTIVE_FEEDBACK_BACKGROUND_COLOR_OTHER;
            if (this.gameTurnPhase != null) {
                switch (this.gameTurnPhase) {
                    case PRECOMBAT_MAIN: 
                    case POSTCOMBAT_MAIN: {
                        backColor = ACTIVE_FEEDBACK_BACKGROUND_COLOR_MAIN;
                        break;
                    }
                    case COMBAT: {
                        backColor = ACTIVE_FEEDBACK_BACKGROUND_COLOR_BATTLE;
                        break;
                    }
                }
            }
            this.mainPanel.setBackground((Color)backColor);
        } else {
            this.mainPanel.setOpaque(false);
        }
        if (buttons.isEmpty()) {
            return;
        }
        this.buttonGrid.removeAll();
        for (JButton jButton : buttons) {
            this.buttonGrid.add(jButton);
        }
        int needButtonSizeW = 0;
        for (JButton button : buttons) {
            needButtonSizeW = Math.max(needButtonSizeW, button.getPreferredSize().width);
        }
        int n = GUISizeHelper.gameFeedbackPanelButtonWidth * 200 / 100;
        int constGridSizeW = buttons.size() * n + BUTTONS_H_GAP * (buttons.size() - 1);
        int constGridSizeH = Math.round(GUISizeHelper.gameFeedbackPanelButtonHeight * 150 / 100);
        if (needButtonSizeW < n) {
            GridLayout gl = new GridLayout(1, buttons.size(), BUTTONS_H_GAP, 0);
            this.buttonGrid.setLayout(gl);
            this.buttonGrid.setPreferredSize(new Dimension(constGridSizeW, constGridSizeH));
        }
    }

    public void setLinks(JButton left, JButton right, JButton special, JButton undo) {
        this.linkLeft = left;
        this.linkRight = right;
        this.linkSpecial = special;
        this.linkUndo = undo;
    }

    public void setOriginalId(UUID originalId) {
        this.originalId = originalId;
    }

    public void setMessages(String basicMessage, String secondaryMessage) {
        this.basicMessage = basicMessage;
        this.secondaryMessage = secondaryMessage;
        this.redrawMessages();
    }

    private void redrawMessages() {
        String panelText = this.basicMessage;
        if (this.secondaryMessage != null) {
            panelText = panelText + "<div style='font-size:" + GUISizeHelper.gameFeedbackPanelExtraMessageFontSize + "pt'>" + this.secondaryMessage + "</div>";
        }
        this.dialogTextArea.setText(panelText, this.getWidth());
    }

    public void setAutoAnswerMessage(String autoAnswerMessage) {
        this.autoAnswerMessage = autoAnswerMessage;
    }

    @Override
    public void requestFocus() {
        this.btnRight.requestFocus();
    }

    private void initPopupMenuTriggerOrder() {
        ActionListener actionListener = e -> this.handleAutoAnswerPopupMenuEvent(e);
        this.popupMenuAskYes = new JPopupMenu();
        this.popupMenuAskNo = new JPopupMenu();
        this.popupItemYesAsTextAndAbility = new JMenuItem("Auto-answer YES for the same TEXT and ABILITY");
        this.popupItemYesAsTextAndAbility.setActionCommand(CMD_AUTO_ANSWER_ID_YES);
        this.popupItemYesAsTextAndAbility.addActionListener(actionListener);
        this.popupItemYesAsTextAndAbility.setToolTipText("<HTML>If the same question from the same ability would<br/>be asked again, it's automatically answered with <b>Yes</b>.<br/>You can reset it by battlefield right click menu.");
        this.popupMenuAskYes.add(this.popupItemYesAsTextAndAbility);
        this.popupItemNoAsTextAndAbility = new JMenuItem("Auto-answer NO for the same TEXT and ABILITY");
        this.popupItemNoAsTextAndAbility.setActionCommand(CMD_AUTO_ANSWER_ID_NO);
        this.popupItemNoAsTextAndAbility.setToolTipText("<HTML>If the same question from the same ability would<br/>be asked again, it's automatically answered with <b>No</b>.<br/>You can reset it by battlefield right click menu.");
        this.popupItemNoAsTextAndAbility.addActionListener(actionListener);
        this.popupMenuAskNo.add(this.popupItemNoAsTextAndAbility);
        this.popupItemYesAsText = new JMenuItem("Auto-answer YES for the same TEXT");
        this.popupItemYesAsText.setActionCommand(CMD_AUTO_ANSWER_NAME_YES);
        this.popupItemYesAsText.setToolTipText("<HTML>If the same question would be asked again (regardless from which source),<br/>it's automatically answered with <b>Yes</b>.<br/>You can reset it by battlefield right click menu.");
        this.popupItemYesAsText.addActionListener(actionListener);
        this.popupMenuAskYes.add(this.popupItemYesAsText);
        this.popupItemNoAsText = new JMenuItem("Auto-answer NO for the same TEXT");
        this.popupItemNoAsText.setActionCommand(CMD_AUTO_ANSWER_NAME_NO);
        this.popupItemNoAsText.setToolTipText("<HTML>If the same question would be asked again (regardless from which source),<br/>it's automatically answered with <b>No</b>.<br/>You can reset it by battlefield right click menu.");
        this.popupItemNoAsText.addActionListener(actionListener);
        this.popupMenuAskNo.add(this.popupItemNoAsText);
        JMenuItem menuItem = new JMenuItem("Reset all YES/NO auto-answers");
        menuItem.setActionCommand(CMD_AUTO_ANSWER_RESET_ALL);
        menuItem.addActionListener(actionListener);
        this.popupMenuAskYes.add(menuItem);
        menuItem = new JMenuItem("Reset all YES/NO auto-answers");
        menuItem.setActionCommand(CMD_AUTO_ANSWER_RESET_ALL);
        menuItem.addActionListener(actionListener);
        this.popupMenuAskNo.add(menuItem);
    }

    public void handleAutoAnswerPopupMenuEvent(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "cmdAutoAnswerIdYes": {
                SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_ID_YES, this.gameId, this.originalId.toString() + '#' + this.autoAnswerMessage);
                this.clickButton(this.btnLeft);
                break;
            }
            case "cmdAutoAnswerIdNo": {
                SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_ID_NO, this.gameId, this.originalId.toString() + '#' + this.autoAnswerMessage);
                this.clickButton(this.btnRight);
                break;
            }
            case "cmdAutoAnswerNameYes": {
                SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_TEXT_YES, this.gameId, this.autoAnswerMessage);
                this.clickButton(this.btnLeft);
                break;
            }
            case "cmdAutoAnswerNameNo": {
                SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_TEXT_NO, this.gameId, this.autoAnswerMessage);
                this.clickButton(this.btnRight);
                break;
            }
            case "cmdAutoAnswerResetAll": {
                SessionHandler.sendPlayerAction(PlayerAction.REQUEST_AUTO_ANSWER_RESET_ALL, this.gameId, null);
                break;
            }
        }
    }

    private void showPopupMenu(Component callingComponent, String actionCommand) {
        this.popupItemYesAsText.setEnabled(true);
        this.popupItemYesAsTextAndAbility.setEnabled(this.originalId != null);
        this.popupItemYesAsText.setEnabled(true);
        this.popupItemYesAsTextAndAbility.setEnabled(this.originalId != null);
        this.popupItemNoAsText.setEnabled(true);
        this.popupItemNoAsTextAndAbility.setEnabled(this.originalId != null);
        this.popupItemNoAsText.setEnabled(true);
        this.popupItemNoAsTextAndAbility.setEnabled(this.originalId != null);
        Point p = callingComponent.getLocationOnScreen();
        JPopupMenu menu = actionCommand.endsWith("Yes") ? this.popupMenuAskYes : this.popupMenuAskNo;
        menu.show(this, 0, 0);
        menu.setLocation(p.x, p.y + callingComponent.getHeight());
    }
}

