/*
 * Decompiled with CFR 0.152.
 */
package mage.client.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.cards.BigCard;
import mage.client.components.HoverButton;
import mage.client.components.MageRoundPane;
import mage.client.components.ext.dlg.DialogManager;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.CardsViewUtil;
import mage.client.util.GUISizeHelper;
import mage.client.util.ImageHelper;
import mage.client.util.gui.BufferedImageBuilder;
import mage.client.util.gui.countryBox.CountryUtil;
import mage.components.ImagePanel;
import mage.components.ImagePanelStyle;
import mage.constants.CardType;
import mage.constants.ManaType;
import mage.designations.DesignationType;
import mage.util.DebugUtil;
import mage.utils.timer.PriorityTimer;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.CommandObjectView;
import mage.view.CounterView;
import mage.view.GameView;
import mage.view.ManaPoolView;
import mage.view.PlayerView;
import org.mage.card.arcane.ManaSymbols;

public class PlayerPanelExt
extends JPanel {
    private UUID playerId;
    private UUID gameId;
    private PlayerView player;
    private boolean isMe;
    private BigCard bigCard;
    private static final String DEFAULT_AVATAR_PATH = "/avatars/10.jpg";
    private static final int PANEL_WIDTH = 94;
    private static final int PANEL_HEIGHT = 270;
    private static final int PANEL_HEIGHT_SMALL = 218;
    private static final int PANEL_HEIGHT_EXTRA_FOR_ME = 25;
    private Border GREEN_BORDER;
    private Border RED_BORDER;
    private Border YELLOW_BORDER;
    private Border EMPTY_BORDER;
    float guiScaleMod = 1.0f;
    private Color activeValueColor = new Color(244, 9, 47);
    private Font fontValuesZero;
    private Font fontValuesNonZero;
    private int avatarId = -1;
    private String flagName;
    private String basicTooltipText;
    private static final Map<UUID, Integer> playerLives = new HashMap<UUID, Integer>();
    private final Font defaultFont;
    private PriorityTimer timer;
    private HoverButton avatar;
    private JButton btnPlayer;
    private ImagePanel life;
    private ImagePanel poison;
    private ImagePanel energy;
    private ImagePanel experience;
    private ImagePanel rad;
    private ImagePanel hand;
    private HoverButton grave;
    private HoverButton library;
    private JButton cheat;
    private JButton toolHintsHelper;
    private MageRoundPane panelBackground;
    private JLabel timerLabel;
    private JLabel lifeLabel;
    private JLabel handLabel;
    private JLabel libraryLabel;
    private JLabel poisonLabel;
    private JLabel energyLabel;
    private JLabel experienceLabel;
    private JLabel radLabel;
    private JLabel graveLabel;
    private JLabel commandLabel;
    private JLabel exileLabel;
    private JPanel zonesPanel;
    private HoverButton exileZone;
    private HoverButton commandZone;
    private boolean changedFontLibrary;
    private boolean changedFontLife;
    private boolean changedFontGrave;
    private boolean changedFontExile;
    private final Map<JLabel, ManaType> manaLabels = new HashMap<JLabel, ManaType>();
    private final Map<JLabel, HoverButton> manaButtons = new HashMap<JLabel, HoverButton>();

    public PlayerPanelExt() {
        this(1.0f);
    }

    public PlayerPanelExt(float guiScaleMod) {
        this.defaultFont = this.getFont();
        this.createAllComponents(guiScaleMod);
    }

    public void fullRefresh(float guiScaleMod) {
        this.cleanUp();
        this.removeAll();
        this.createAllComponents(guiScaleMod);
        this.invalidate();
    }

    public void createAllComponents(float guiScaleMod) {
        this.guiScaleMod = guiScaleMod;
        this.setFont(this.defaultFont.deriveFont(this.sizeMod(this.defaultFont.getSize2D())));
        this.fontValuesZero = this.getFont().deriveFont(0);
        this.fontValuesNonZero = this.getFont().deriveFont(1);
        this.GREEN_BORDER = new LineBorder(Color.green, this.sizeMod(3));
        this.RED_BORDER = new LineBorder(Color.red, this.sizeMod(2));
        this.YELLOW_BORDER = new LineBorder(Color.yellow, this.sizeMod(3));
        this.EMPTY_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.setPreferredSize(new Dimension(this.sizeMod(94), this.sizeMod(270)));
        this.initComponents();
        this.setGUISize();
    }

    private int sizeMod(int value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    private float sizeMod(float value) {
        return GUISizeHelper.guiSizeScale(value, this.guiScaleMod);
    }

    public void init(UUID gameId, UUID playerId, boolean controlled, BigCard bigCard, int priorityTime) {
        this.gameId = gameId;
        this.playerId = playerId;
        this.bigCard = bigCard;
        this.isMe = controlled;
        this.cheat.setVisible(SessionHandler.isTestMode() && this.isMe);
        this.cheat.setFocusable(false);
        this.toolHintsHelper.setVisible(this.isMe);
        this.toolHintsHelper.setFocusable(false);
        this.flagName = null;
        this.avatarId = -1;
        if (priorityTime > 0 && priorityTime != Integer.MAX_VALUE) {
            long delay = 1000L;
            PriorityTimer pt = this.timer = new PriorityTimer(priorityTime, delay, () -> {});
            this.timer.setTaskOnTick(() -> {
                Color foregroundColor;
                Color textColor;
                int priorityTimeValue = pt.getCount() + pt.getBufferCount();
                String text = this.getPriorityTimeLeftString(priorityTimeValue);
                if (pt.getBufferCount() > 0) {
                    textColor = Color.GREEN;
                    foregroundColor = Color.GREEN.darker().darker();
                } else if (pt.getCount() < 300) {
                    textColor = Color.RED;
                    foregroundColor = Color.RED.darker().darker();
                } else {
                    textColor = null;
                    foregroundColor = Color.BLACK;
                }
                SwingUtilities.invokeLater(() -> {
                    this.avatar.setTopText(text);
                    this.avatar.setTopTextColor(textColor);
                    this.timerLabel.setText(text);
                    this.timerLabel.setForeground(foregroundColor);
                    this.avatar.repaint();
                });
            });
            this.timer.init(gameId);
        }
    }

    public void cleanUp() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
    }

    private void setTextForLabel(String category, JLabel label, JComponent relatedComponent, int amount, boolean alwaysBlack) {
        this.setTextForLabel(category, label, relatedComponent, amount, alwaysBlack, Color.BLACK);
    }

    private void setTextForLabel(String category, JLabel label, JComponent relatedComponent, int amount, boolean alwaysBlack, Color fontColor) {
        label.setText(Integer.toString(amount));
        label.setToolTipText(category + ": " + amount);
        if (relatedComponent != null) {
            relatedComponent.setToolTipText(category + ": " + amount);
        }
        if (amount != 0 || alwaysBlack) {
            label.setForeground(fontColor);
            label.setFont(this.fontValuesNonZero);
        } else {
            label.setForeground(new Color(100, 100, 100));
            label.setFont(this.fontValuesZero);
        }
    }

    private boolean isCardsPlayable(Collection<CardView> cards, GameView gameView, Set<UUID> possibleTargets) {
        if (cards == null || gameView == null) {
            return false;
        }
        if (gameView.getCanPlayObjects() != null && !gameView.getCanPlayObjects().isEmpty()) {
            for (CardView card : cards) {
                if (!gameView.getCanPlayObjects().containsObject(card.getId())) continue;
                return true;
            }
        }
        if (possibleTargets != null && !possibleTargets.isEmpty()) {
            for (CardView card : cards) {
                if (!possibleTargets.contains(card.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private static int counterOfName(PlayerView player, String name) {
        return player.getCounters().stream().filter(counter -> counter.getName().equals(name)).map(CounterView::getCount).findFirst().orElse(0);
    }

    public void update(GameView game, PlayerView player, Set<UUID> possibleTargets, Set<UUID> chosenTargets) {
        Font font;
        Color exileColor;
        Font font2;
        Font font3;
        Font font4;
        this.player = player;
        int pastLife = player.getLife();
        if (playerLives != null) {
            if (playerLives.containsKey(player.getPlayerId())) {
                pastLife = playerLives.get(player.getPlayerId());
            }
            playerLives.put(player.getPlayerId(), player.getLife());
        }
        int playerLife = player.getLife();
        boolean displayLife = "true".equals(MageFrame.getPreferences().get("displayLiveOnAvatar", "true"));
        this.avatar.setCenterText(displayLife ? String.valueOf(playerLife) : null);
        if (displayLife) {
            if (playerLife != pastLife) {
                if (playerLife > pastLife) {
                    this.avatar.gainLifeDisplay();
                } else {
                    this.avatar.loseLifeDisplay();
                }
            } else {
                this.avatar.stopLifeDisplay();
            }
        }
        this.updateAvatar();
        if (playerLife > 99) {
            font4 = this.lifeLabel.getFont();
            font4 = font4.deriveFont(this.sizeMod(9.0f));
            this.lifeLabel.setFont(font4);
            this.changedFontLife = true;
        } else if (this.changedFontLife) {
            font4 = this.lifeLabel.getFont();
            font4 = font4.deriveFont(this.sizeMod(12.0f));
            this.lifeLabel.setFont(font4);
            this.changedFontLife = false;
        }
        this.setTextForLabel("life", this.lifeLabel, (JComponent)this.life, playerLife, false, PreferencesDialog.getCurrentTheme().getTextColor());
        this.setTextForLabel("poison", this.poisonLabel, (JComponent)this.poison, PlayerPanelExt.counterOfName(player, "poison"), false, PreferencesDialog.getCurrentTheme().getTextColor());
        this.setTextForLabel("energy", this.energyLabel, (JComponent)this.energy, PlayerPanelExt.counterOfName(player, "energy"), false, PreferencesDialog.getCurrentTheme().getTextColor());
        this.setTextForLabel("experience", this.experienceLabel, (JComponent)this.experience, PlayerPanelExt.counterOfName(player, "experience"), false, PreferencesDialog.getCurrentTheme().getTextColor());
        this.setTextForLabel("rad", this.radLabel, (JComponent)this.rad, PlayerPanelExt.counterOfName(player, "rad"), false, PreferencesDialog.getCurrentTheme().getTextColor());
        this.setTextForLabel("hand zone", this.handLabel, (JComponent)this.hand, player.getHandCount(), false, PreferencesDialog.getCurrentTheme().getTextColor());
        int libraryCards = player.getLibraryCount();
        if (libraryCards > 99) {
            font3 = this.libraryLabel.getFont();
            font3 = font3.deriveFont(this.sizeMod(9.0f));
            this.libraryLabel.setFont(font3);
            this.changedFontLibrary = true;
        } else if (this.changedFontLibrary) {
            font3 = this.libraryLabel.getFont();
            font3 = font3.deriveFont(this.sizeMod(12.0f));
            this.libraryLabel.setFont(font3);
            this.changedFontLibrary = false;
        }
        this.setTextForLabel("library zone", this.libraryLabel, this.library, libraryCards, false, PreferencesDialog.getCurrentTheme().getTextColor());
        int graveCards = player.getGraveyard().size();
        if (graveCards > 99) {
            if (!this.changedFontGrave) {
                font2 = this.graveLabel.getFont();
                font2 = font2.deriveFont(this.sizeMod(9.0f));
                this.graveLabel.setFont(font2);
                this.changedFontGrave = true;
            }
        } else if (this.changedFontGrave) {
            font2 = this.lifeLabel.getFont();
            font2 = font2.deriveFont(this.sizeMod(12.0f));
            this.graveLabel.setFont(font2);
            this.changedFontGrave = false;
        }
        Color graveColor = this.isCardsPlayable(player.getGraveyard().values(), game, possibleTargets) ? this.activeValueColor : PreferencesDialog.getCurrentTheme().getTextColor();
        this.setTextForLabel("graveyard zone", this.graveLabel, this.grave, graveCards, false, graveColor);
        this.graveLabel.setToolTipText("Card Types: " + this.qtyCardTypes(player.getGraveyard()));
        Color commandColor = PreferencesDialog.getCurrentTheme().getTextColor();
        for (CommandObjectView com : player.getCommandObjectList()) {
            if (game != null && game.getCanPlayObjects() != null && game.getCanPlayObjects().containsObject(com.getId())) {
                commandColor = this.activeValueColor;
                break;
            }
            if (possibleTargets == null || !possibleTargets.contains(com.getId())) continue;
            commandColor = this.activeValueColor;
            break;
        }
        this.setTextForLabel("command zone", this.commandLabel, this.commandZone, player.getCommandObjectList().size(), false, commandColor);
        int exileCards = player.getExile().size();
        Color color = exileColor = this.isCardsPlayable(player.getExile().values(), game, possibleTargets) ? this.activeValueColor : PreferencesDialog.getCurrentTheme().getTextColor();
        if (exileCards > 99) {
            if (!this.changedFontExile) {
                font = this.exileLabel.getFont();
                font = font.deriveFont(this.sizeMod(9.0f));
                this.exileLabel.setFont(font);
                this.changedFontExile = true;
            }
        } else if (this.changedFontExile) {
            font = this.lifeLabel.getFont();
            font = font.deriveFont(this.sizeMod(12.0f));
            this.exileLabel.setFont(font);
            this.changedFontExile = false;
        }
        this.setTextForLabel("exile zone", this.exileLabel, this.exileZone, exileCards, false, exileColor);
        if (!MageFrame.isLite()) {
            int id = player.getUserData().getAvatarId();
            if (id <= 1000 && id != 64 && (id < 10 || id > 32)) {
                id = 10;
            }
            if (id != this.avatarId) {
                this.avatarId = id;
                String path = "/avatars/" + this.avatarId + ".jpg";
                if (this.avatarId == 64) {
                    path = "/avatars/i64.jpg";
                } else if (this.avatarId >= 1000) {
                    this.avatarId -= 1000;
                    path = "/avatars/special/" + this.avatarId + ".gif";
                }
                Image image = ImageHelper.getImageFromResources(path);
                Rectangle buttonRect = new Rectangle(this.sizeMod(80), this.sizeMod(80));
                BufferedImage buttonImage = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), buttonRect);
                this.avatar.update(this.player.getName(), buttonImage, buttonImage, buttonImage, buttonImage, buttonRect);
            }
        }
        if (this.timer != null) {
            if (player.getPriorityTimeLeftSecs() != Integer.MAX_VALUE) {
                Color foregroundColor;
                Color textColor;
                String priorityTimeValue = this.getPriorityTimeLeftString(player);
                this.timer.setCount(player.getPriorityTimeLeftSecs());
                this.timer.setBufferCount(player.getBufferTimeLeft());
                this.avatar.setTopText(priorityTimeValue);
                this.timerLabel.setText(priorityTimeValue);
                if (player.getBufferTimeLeft() > 0) {
                    textColor = Color.GREEN;
                    foregroundColor = Color.GREEN.darker().darker();
                } else if (player.getPriorityTimeLeftSecs() < 300) {
                    textColor = Color.RED;
                    foregroundColor = Color.RED.darker().darker();
                } else {
                    textColor = null;
                    foregroundColor = Color.BLACK;
                }
                this.avatar.setTopTextColor(textColor);
                this.timerLabel.setForeground(foregroundColor);
            }
            if (player.isTimerActive()) {
                this.timer.resume();
            } else {
                this.timer.pause();
            }
        }
        if (player.isActive()) {
            this.avatar.setBorder(this.GREEN_BORDER);
            this.btnPlayer.setBorder(this.GREEN_BORDER);
            this.setGreenBackgroundColor();
        } else {
            this.resetBackgroundColor();
            if (player.hasLeft()) {
                this.avatar.setBorder(this.RED_BORDER);
                this.btnPlayer.setBorder(this.RED_BORDER);
                this.setDeadBackgroundColor();
            } else {
                this.avatar.setBorder(this.EMPTY_BORDER);
                this.btnPlayer.setBorder(this.EMPTY_BORDER);
            }
        }
        if (possibleTargets != null && possibleTargets.contains(this.playerId)) {
            this.avatar.setBorder(this.YELLOW_BORDER);
            this.btnPlayer.setBorder(this.YELLOW_BORDER);
        }
        if (chosenTargets != null && chosenTargets.contains(this.playerId)) {
            this.avatar.setBorder(this.GREEN_BORDER);
            this.btnPlayer.setBorder(this.GREEN_BORDER);
        }
        this.update(player.getManaPool());
    }

    private void resetBackgroundColor() {
        this.panelBackground.setBackgroundColor(PreferencesDialog.getCurrentTheme().getPlayerPanel_inactiveBackgroundColor());
    }

    private void setGreenBackgroundColor() {
        this.panelBackground.setBackgroundColor(PreferencesDialog.getCurrentTheme().getPlayerPanel_activeBackgroundColor());
    }

    private void setDeadBackgroundColor() {
        this.panelBackground.setBackgroundColor(PreferencesDialog.getCurrentTheme().getPlayerPanel_deadBackgroundColor());
    }

    private void updateAvatar() {
        if (this.flagName == null) {
            this.avatar.setText(this.player.getName());
            this.flagName = this.player.getUserData().getFlagName();
            String flagPath = "/flags/" + this.flagName + (this.flagName.endsWith(".png") ? "" : ".png");
            this.avatar.setTopTextImage(ImageHelper.getImageFromResourcesScaledToHeight(flagPath, this.sizeMod(11)));
            String countryName = CountryUtil.getCountryName(this.flagName);
            this.basicTooltipText = "<HTML>Name: " + this.player.getName() + "<br/>Flag: " + (countryName == null ? "Unknown" : countryName) + "<br/>This match wins: " + this.player.getWins() + " of " + this.player.getWinsNeeded() + " (to win the match)";
        }
        StringBuilder tooltipText = new StringBuilder(this.basicTooltipText);
        tooltipText.append("<br/>Match time remaining: ").append(this.getPriorityTimeLeftString(this.player));
        this.avatar.clearTopTextImagesRight();
        for (String name : this.player.getDesignationNames()) {
            tooltipText.append("<br/>").append(name);
            if (!DesignationType.CITYS_BLESSING.toString().equals(name)) continue;
            this.avatar.addTopTextImageRight(ImageHelper.getImageFromResourcesScaledToHeight("/info/city_blessing.png", this.sizeMod(11)));
        }
        if (this.player.isMonarch()) {
            tooltipText.append("<br/>").append("The Monarch");
            this.avatar.addTopTextImageRight(ImageHelper.getImageFromResourcesScaledToHeight("/info/crown.png", this.sizeMod(11)));
        }
        if (this.player.isInitiative()) {
            tooltipText.append("<br/>").append("Have the Initiative");
            this.avatar.addTopTextImageRight(ImageHelper.getImageFromResourcesScaledToHeight("/info/initiative.png", this.sizeMod(11)));
        }
        for (CounterView counter : this.player.getCounters()) {
            tooltipText.append("<br/>").append(counter.getName()).append(" counters: ").append(counter.getCount());
        }
        this.avatar.setToolTipText(tooltipText.toString());
        this.avatar.repaint();
        this.btnPlayer.setText(this.player.getName());
        this.btnPlayer.setToolTipText(tooltipText.toString());
    }

    private String getPriorityTimeLeftString(PlayerView player) {
        int priorityTimeLeft = player.getPriorityTimeLeftSecs() + player.getBufferTimeLeft();
        return this.getPriorityTimeLeftString(priorityTimeLeft);
    }

    private String getPriorityTimeLeftString(int priorityTimeLeft) {
        int h = priorityTimeLeft / 3600;
        int m = priorityTimeLeft % 3600 / 60;
        int s = priorityTimeLeft % 60;
        return (h < 10 ? "0" : "") + h + ':' + (m < 10 ? "0" : "") + m + ':' + (s < 10 ? "0" : "") + s;
    }

    protected void update(ManaPoolView pool) {
        for (Map.Entry<JLabel, ManaType> mana : this.manaLabels.entrySet()) {
            String category = mana.getValue().toString() + " mana";
            switch (mana.getValue()) {
                case BLACK: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getBlack(), false, this.activeValueColor);
                    break;
                }
                case RED: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getRed(), false, this.activeValueColor);
                    break;
                }
                case WHITE: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getWhite(), false, this.activeValueColor);
                    break;
                }
                case GREEN: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getGreen(), false, this.activeValueColor);
                    break;
                }
                case BLUE: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getBlue(), false, this.activeValueColor);
                    break;
                }
                case COLORLESS: {
                    this.setTextForLabel(category, mana.getKey(), this.manaButtons.get(mana.getKey()), pool.getColorless(), false, this.activeValueColor);
                }
            }
        }
    }

    private void initComponents() {
        this.panelBackground = new MageRoundPane();
        this.panelBackground.setPreferredSize(new Dimension(this.sizeMod(92), this.sizeMod(270)));
        this.timerLabel = new JLabel();
        this.lifeLabel = new JLabel();
        this.handLabel = new JLabel();
        this.poisonLabel = new JLabel();
        this.energyLabel = new JLabel();
        this.experienceLabel = new JLabel();
        this.radLabel = new JLabel();
        this.graveLabel = new JLabel();
        this.commandLabel = new JLabel();
        this.libraryLabel = new JLabel();
        this.setOpaque(false);
        this.panelBackground.setXOffset(this.sizeMod(3));
        this.panelBackground.setYOffset(this.sizeMod(3));
        this.panelBackground.setVisible(true);
        if (DebugUtil.GUI_GAME_DRAW_PLAYER_PANEL_BORDER) {
            this.setBorder(BorderFactory.createLineBorder(Color.green));
            this.panelBackground.setBorder(BorderFactory.createLineBorder(Color.yellow));
        }
        Rectangle r = new Rectangle(this.sizeMod(80), this.sizeMod(80));
        Image image = ImageHelper.getImageFromResources(DEFAULT_AVATAR_PATH);
        BufferedImage resized = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), r);
        this.avatar = new HoverButton("", (Image)resized, (Image)resized, (Image)resized, r, this.guiScaleMod);
        String showPlayerNamePermanently = MageFrame.getPreferences().get("showPlayerNamesPermanently", "true");
        if (showPlayerNamePermanently.equals("true")) {
            this.avatar.setTextAlwaysVisible(true);
        }
        this.avatar.setTextOffsetButtonY(this.sizeMod(10));
        this.avatar.setObserver(() -> SessionHandler.sendPlayerUUID(this.gameId, this.playerId));
        this.btnPlayer = new JButton();
        this.btnPlayer.setFont(this.getFont());
        this.btnPlayer.setText("Player");
        this.btnPlayer.setVisible(false);
        this.btnPlayer.setToolTipText("Player");
        this.btnPlayer.setPreferredSize(new Dimension(this.sizeMod(20), this.sizeMod(40)));
        this.btnPlayer.addActionListener(e -> SessionHandler.sendPlayerUUID(this.gameId, this.playerId));
        this.timerLabel.setToolTipText("Time left");
        this.timerLabel.setSize(this.sizeMod(80), this.sizeMod(12));
        this.timerLabel.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(18), this.sizeMod(18));
        this.lifeLabel.setToolTipText("Life");
        this.lifeLabel.setHorizontalAlignment(0);
        Image imageLife = ImageHelper.getImageFromResources("/info/life.png");
        BufferedImage resizedLife = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageLife, 2), r);
        this.life = new ImagePanel(resizedLife, ImagePanelStyle.ACTUAL);
        this.life.setToolTipText("Life");
        this.life.setOpaque(false);
        r = new Rectangle(this.sizeMod(18), this.sizeMod(18));
        this.handLabel.setToolTipText("Hand");
        this.handLabel.setHorizontalAlignment(0);
        Image imageHand = ImageHelper.getImageFromResources("/info/hand.png");
        BufferedImage resizedHand = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageHand, 2), r);
        this.hand = new ImagePanel(resizedHand, ImagePanelStyle.ACTUAL);
        this.hand.setToolTipText("Hand");
        this.hand.setOpaque(false);
        r = new Rectangle(this.sizeMod(18), this.sizeMod(18));
        Image imagePoison = ImageHelper.getImageFromResources("/info/poison.png");
        BufferedImage resizedPoison = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imagePoison, 2), r);
        this.poison = new ImagePanel(resizedPoison, ImagePanelStyle.ACTUAL);
        this.poison.setOpaque(false);
        this.setTextForLabel("poison", this.poisonLabel, (JComponent)this.poison, 0, false);
        this.poisonLabel.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(19), this.sizeMod(19));
        this.libraryLabel.setToolTipText("Library");
        this.libraryLabel.setHorizontalAlignment(0);
        Image imageLibrary = ImageHelper.getImageFromResources("/info/library.png");
        BufferedImage resizedLibrary = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageLibrary, 2), r);
        this.library = new HoverButton(null, (Image)resizedLibrary, (Image)resizedLibrary, (Image)resizedLibrary, r, this.guiScaleMod);
        this.library.setToolTipText("Library");
        this.library.setOpaque(false);
        this.library.setObserver(() -> this.btnLibraryActionPerformed(null));
        r = new Rectangle(this.sizeMod(18), this.sizeMod(18));
        Image imageEnergy = ImageHelper.getImageFromResources("/info/energy.png");
        BufferedImage resizedEnergy = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageEnergy, 2), r);
        this.energy = new ImagePanel(resizedEnergy, ImagePanelStyle.ACTUAL);
        this.energy.setToolTipText("Energy");
        this.energy.setOpaque(false);
        this.setTextForLabel("energy", this.energyLabel, (JComponent)this.energy, 0, false);
        this.energyLabel.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(18), this.sizeMod(18));
        Image imageExperience = ImageHelper.getImageFromResources("/info/experience.png");
        BufferedImage resizedExperience = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageExperience, 2), r);
        this.experience = new ImagePanel(resizedExperience, ImagePanelStyle.ACTUAL);
        this.experience.setToolTipText("Experience");
        this.experience.setOpaque(false);
        this.setTextForLabel("experience", this.experienceLabel, (JComponent)this.experience, 0, false);
        this.experienceLabel.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(16), this.sizeMod(16));
        Image imageRad = ImageHelper.getImageFromResources("/info/rad.png");
        BufferedImage resizedRad = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageRad, 2), r);
        this.rad = new ImagePanel(resizedRad, ImagePanelStyle.ACTUAL);
        this.rad.setToolTipText("Rad");
        this.rad.setOpaque(false);
        this.setTextForLabel("rad", this.radLabel, (JComponent)this.rad, 0, false);
        this.radLabel.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(21), this.sizeMod(21));
        this.graveLabel.setToolTipText("Card Types: 0");
        this.graveLabel.setHorizontalAlignment(0);
        Image imageGrave = ImageHelper.getImageFromResources("/info/grave.png");
        BufferedImage resizedGrave = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(imageGrave, 2), r);
        this.grave = new HoverButton(null, (Image)resizedGrave, (Image)resizedGrave, (Image)resizedGrave, r, this.guiScaleMod);
        this.grave.setToolTipText("Graveyard");
        this.grave.setOpaque(false);
        this.grave.setObserver(() -> this.btnGraveActionPerformed(null));
        this.exileLabel = new JLabel();
        this.exileLabel.setToolTipText("Exile");
        this.exileLabel.setHorizontalAlignment(0);
        image = ImageHelper.getImageFromResources("/info/exile.png");
        r = new Rectangle(this.sizeMod(21), this.sizeMod(21));
        resized = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), r);
        this.exileZone = new HoverButton(null, (Image)resized, (Image)resized, (Image)resized, r, this.guiScaleMod);
        this.exileZone.setToolTipText("Exile");
        this.exileZone.setOpaque(false);
        this.exileZone.setObserver(() -> this.btnExileZoneActionPerformed(null));
        this.exileZone.setBounds(this.sizeMod(25), 0, this.sizeMod(21), this.sizeMod(21));
        this.zonesPanel = new JPanel();
        this.zonesPanel.setPreferredSize(new Dimension(this.sizeMod(100), this.sizeMod(60)));
        this.zonesPanel.setSize(this.sizeMod(100), this.sizeMod(60));
        this.zonesPanel.setLayout(null);
        this.zonesPanel.setOpaque(false);
        this.toolHintsHelper = new JButton();
        this.toolHintsHelper.setFont(this.getFont());
        this.toolHintsHelper.setText("Hints");
        this.toolHintsHelper.setToolTipText("Open card hints helper window");
        this.toolHintsHelper.addActionListener(this::btnToolHintsHelperActionPerformed);
        this.toolHintsHelper.setBounds(this.sizeMod(3), this.sizeMod(25), this.sizeMod(73), this.sizeMod(21));
        this.zonesPanel.add(this.toolHintsHelper);
        r = new Rectangle(this.sizeMod(21), this.sizeMod(21));
        image = ImageHelper.getImageFromResources("/info/command_zone.png");
        resized = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), r);
        this.commandZone = new HoverButton(null, (Image)resized, (Image)resized, (Image)resized, r, this.guiScaleMod);
        this.commandZone.setToolTipText("Command Zone (Commanders, Emblems, and Planes)");
        this.commandZone.setOpaque(false);
        this.commandZone.setObserver(() -> this.btnCommandZoneActionPerformed(null));
        this.commandZone.setBounds(this.sizeMod(3), 0, this.sizeMod(21), this.sizeMod(21));
        this.zonesPanel.add(this.commandZone);
        this.commandLabel.setToolTipText("Command zone");
        this.commandLabel.setBounds(this.sizeMod(25), 0, this.sizeMod(21), this.sizeMod(21));
        this.zonesPanel.add(this.commandLabel);
        r = new Rectangle(this.sizeMod(25), this.sizeMod(21));
        image = ImageHelper.getImageFromResources("/info/cheat.png");
        resized = ImageHelper.getResizedImage(BufferedImageBuilder.bufferImage(image, 2), r);
        this.cheat = new JButton();
        this.cheat.setIcon(new ImageIcon(resized));
        this.cheat.setToolTipText("Cheat button (activate it on your priority only)");
        this.cheat.addActionListener(this::btnCheatActionPerformed);
        this.cheat.setBounds(this.sizeMod(40), this.sizeMod(2), this.sizeMod(25), this.sizeMod(21));
        this.zonesPanel.add(this.cheat);
        JLabel manaCountLabelW = new JLabel();
        manaCountLabelW.setHorizontalAlignment(0);
        this.manaLabels.put(manaCountLabelW, ManaType.WHITE);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaW = ManaSymbols.getSizedManaSymbol("W", this.sizeMod(15));
        HoverButton btnWhiteMana = new HoverButton(null, (Image)imageManaW, (Image)imageManaW, (Image)imageManaW, r, this.guiScaleMod);
        btnWhiteMana.setOpaque(false);
        btnWhiteMana.setObserver(() -> this.btnManaActionPerformed(ManaType.WHITE));
        this.manaButtons.put(manaCountLabelW, btnWhiteMana);
        this.setTextForLabel(ManaType.WHITE.toString() + " mana", manaCountLabelW, btnWhiteMana, 0, false);
        JLabel manaCountLabelU = new JLabel();
        this.manaLabels.put(manaCountLabelU, ManaType.BLUE);
        manaCountLabelU.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaU = ManaSymbols.getSizedManaSymbol("U", this.sizeMod(15));
        HoverButton btnBlueMana = new HoverButton(null, (Image)imageManaU, (Image)imageManaU, (Image)imageManaU, r, this.guiScaleMod);
        btnBlueMana.setOpaque(false);
        btnBlueMana.setObserver(() -> this.btnManaActionPerformed(ManaType.BLUE));
        this.manaButtons.put(manaCountLabelU, btnBlueMana);
        this.setTextForLabel(ManaType.BLUE.toString() + " mana", manaCountLabelU, btnBlueMana, 0, false);
        JLabel manaCountLabelB = new JLabel();
        this.manaLabels.put(manaCountLabelB, ManaType.BLACK);
        manaCountLabelB.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaB = ManaSymbols.getSizedManaSymbol("B", this.sizeMod(15));
        HoverButton btnBlackMana = new HoverButton(null, (Image)imageManaB, (Image)imageManaB, (Image)imageManaB, r, this.guiScaleMod);
        btnBlackMana.setOpaque(false);
        btnBlackMana.setObserver(() -> this.btnManaActionPerformed(ManaType.BLACK));
        this.manaButtons.put(manaCountLabelB, btnBlackMana);
        this.setTextForLabel(ManaType.BLACK.toString() + " mana", manaCountLabelB, btnBlackMana, 0, false);
        JLabel manaCountLabelR = new JLabel();
        this.manaLabels.put(manaCountLabelR, ManaType.RED);
        manaCountLabelR.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaR = ManaSymbols.getSizedManaSymbol("R", this.sizeMod(15));
        HoverButton btnRedMana = new HoverButton(null, (Image)imageManaR, (Image)imageManaR, (Image)imageManaR, r, this.guiScaleMod);
        btnRedMana.setOpaque(false);
        btnRedMana.setObserver(() -> this.btnManaActionPerformed(ManaType.RED));
        this.manaButtons.put(manaCountLabelR, btnRedMana);
        this.setTextForLabel(ManaType.RED.toString() + " mana", manaCountLabelR, btnRedMana, 0, false);
        JLabel manaCountLabelG = new JLabel();
        this.manaLabels.put(manaCountLabelG, ManaType.GREEN);
        manaCountLabelG.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaG = ManaSymbols.getSizedManaSymbol("G", this.sizeMod(15));
        HoverButton btnGreenMana = new HoverButton(null, (Image)imageManaG, (Image)imageManaG, (Image)imageManaG, r, this.guiScaleMod);
        btnGreenMana.setOpaque(false);
        btnGreenMana.setObserver(() -> this.btnManaActionPerformed(ManaType.GREEN));
        this.manaButtons.put(manaCountLabelG, btnGreenMana);
        this.setTextForLabel(ManaType.GREEN.toString() + " mana", manaCountLabelG, btnGreenMana, 0, false);
        JLabel manaCountLabelX = new JLabel();
        this.manaLabels.put(manaCountLabelX, ManaType.COLORLESS);
        manaCountLabelX.setHorizontalAlignment(0);
        r = new Rectangle(this.sizeMod(15), this.sizeMod(15));
        BufferedImage imageManaX = ManaSymbols.getSizedManaSymbol("C", this.sizeMod(15));
        HoverButton btnColorlessMana = new HoverButton(null, (Image)imageManaX, (Image)imageManaX, (Image)imageManaX, r, this.guiScaleMod);
        btnColorlessMana.setOpaque(false);
        btnColorlessMana.setObserver(() -> this.btnManaActionPerformed(ManaType.COLORLESS));
        this.manaButtons.put(manaCountLabelX, btnColorlessMana);
        this.setTextForLabel((Object)((Object)ManaType.COLORLESS) + " mana", manaCountLabelX, btnColorlessMana, 0, false);
        GroupLayout gl_panelBackground = new GroupLayout(this.panelBackground);
        gl_panelBackground.setHorizontalGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(7)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnPlayer, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.timerLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.avatar, GroupLayout.Alignment.TRAILING, -1, this.sizeMod(80), Short.MAX_VALUE)).addGap(this.sizeMod(6))).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(9)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.life, -2, this.sizeMod(18), -2).addComponent(this.lifeLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.poison, -2, this.sizeMod(18), -2).addComponent(this.poisonLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.energy, -2, this.sizeMod(18), -2).addComponent(this.energyLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.rad, -2, this.sizeMod(18), -2).addComponent(this.radLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnWhiteMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelW, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnBlueMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelU, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnBlackMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelB, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent(this.grave, -2, this.sizeMod(18), -2).addComponent(this.graveLabel, -2, this.sizeMod(20), -2))).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.hand, -2, this.sizeMod(18), -2).addComponent(this.handLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent(this.library, -2, this.sizeMod(18), -2).addComponent(this.libraryLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent((Component)this.experience, -2, this.sizeMod(18), -2).addComponent(this.experienceLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnRedMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelR, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnGreenMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelG, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(2)).addComponent(btnColorlessMana, -2, this.sizeMod(15), -2).addComponent(manaCountLabelX, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createSequentialGroup().addComponent(this.exileZone, -2, this.sizeMod(18), -2).addComponent(this.exileLabel, -2, this.sizeMod(20), -2))).addGap(this.sizeMod(4))).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(6)).addComponent(this.zonesPanel, -1, -2, -2).addGap(this.sizeMod(6))));
        gl_panelBackground.setVerticalGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(6)).addComponent(this.avatar, -2, this.sizeMod(80), -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPlayer, -2, this.sizeMod(30), -2).addComponent(this.timerLabel).addGap(this.sizeMod(2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.life, -2, this.sizeMod(18), -2)).addComponent(this.lifeLabel, -2, this.sizeMod(20), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.hand, -2, this.sizeMod(18), -2)).addComponent(this.handLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.poison, -2, this.sizeMod(18), -2)).addComponent(this.poisonLabel, -2, this.sizeMod(20), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(this.library, -2, this.sizeMod(18), -2)).addComponent(this.libraryLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.energy, -2, this.sizeMod(18), -2)).addComponent(this.energyLabel, -2, this.sizeMod(20), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.experience, -2, this.sizeMod(18), -2)).addComponent(this.experienceLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent((Component)this.rad, -2, this.sizeMod(18), -2)).addComponent(this.radLabel, -2, this.sizeMod(20), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnWhiteMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelW, -2, this.sizeMod(17), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnRedMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelR, -2, this.sizeMod(17), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnBlueMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelU, -2, this.sizeMod(17), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnGreenMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelG, -2, this.sizeMod(17), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnBlackMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelB, -2, this.sizeMod(17), -2).addGroup(gl_panelBackground.createSequentialGroup().addGap(this.sizeMod(1)).addComponent(btnColorlessMana, -2, this.sizeMod(15), -2)).addComponent(manaCountLabelX, -2, this.sizeMod(17), -2)).addGroup(gl_panelBackground.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panelBackground.createSequentialGroup().addComponent(this.grave, -2, this.sizeMod(20), -2)).addComponent(this.graveLabel, -2, this.sizeMod(20), -2).addGroup(gl_panelBackground.createSequentialGroup().addComponent(this.exileZone, -2, this.sizeMod(20), -2)).addComponent(this.exileLabel, -2, this.sizeMod(20), -2)).addGap(this.sizeMod(2)).addComponent(this.zonesPanel, -2, -2, -2)));
        this.panelBackground.setLayout(gl_panelBackground);
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.panelBackground, -2, -2, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.panelBackground, -2, -2, -2)));
        this.setLayout(groupLayout);
    }

    public void sizePlayerPanel(boolean smallMode) {
        int extraForMe;
        int n = extraForMe = this.isMe ? 25 : 0;
        if (smallMode) {
            this.avatar.setVisible(false);
            this.btnPlayer.setVisible(true);
            this.timerLabel.setVisible(true);
            this.panelBackground.setPreferredSize(new Dimension(this.sizeMod(92), this.sizeMod(218 + extraForMe)));
            this.panelBackground.setBounds(0, 0, this.sizeMod(92), this.sizeMod(218 + extraForMe));
        } else {
            this.avatar.setVisible(true);
            this.btnPlayer.setVisible(false);
            this.timerLabel.setVisible(false);
            this.panelBackground.setPreferredSize(new Dimension(this.sizeMod(92), this.sizeMod(270 + extraForMe)));
            this.panelBackground.setBounds(0, 0, this.sizeMod(92), this.sizeMod(270 + extraForMe));
        }
    }

    private void btnManaActionPerformed(ManaType manaType) {
        SessionHandler.sendPlayerManaType(this.gameId, this.player.getPlayerId(), manaType);
    }

    private void btnGraveActionPerformed(ActionEvent evt) {
        MageFrame.getGame(this.gameId).openGraveyardWindow(this.player.getName());
    }

    private void btnLibraryActionPerformed(ActionEvent evt) {
        MageFrame.getGame(this.gameId).openTopLibraryWindow(this.player.getName());
    }

    private void btnCommandZoneActionPerformed(ActionEvent evt) {
        DialogManager.getManager(this.gameId).showEmblemsDialog(CardsViewUtil.convertCommandObject(this.player.getCommandObjectList()), this.bigCard, this.gameId);
    }

    private void btnExileZoneActionPerformed(ActionEvent evt) {
        DialogManager.getManager(this.gameId).showExileDialog(this.player.getExile(), this.bigCard, this.gameId);
    }

    private void btnCheatActionPerformed(ActionEvent evt) {
        SessionHandler.cheatShow(this.gameId, this.playerId);
    }

    private void btnToolHintsHelperActionPerformed(ActionEvent evt) {
        MageFrame.getGame(this.gameId).openCardHintsWindow("main");
    }

    public PlayerView getPlayer() {
        return this.player;
    }

    private int qtyCardTypes(CardsView cardsView) {
        LinkedHashSet<String> cardTypesPresent = new LinkedHashSet<String>(){};
        for (CardView card : cardsView.values()) {
            EnumSet<CardType> cardTypes = EnumSet.noneOf(CardType.class);
            cardTypes.addAll(card.getCardTypes());
            for (CardType cardType : cardTypes) {
                cardTypesPresent.add(cardType.toString());
            }
        }
        if (cardTypesPresent.isEmpty()) {
            return 0;
        }
        return cardTypesPresent.size();
    }
}

