/*
 * Decompiled with CFR 0.152.
 */
package mage.client.remote;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mage.cards.decks.Deck;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.chat.ChatPanelBasic;
import mage.client.constants.Constants;
import mage.client.dialog.PreferencesDialog;
import mage.client.draft.DraftPanel;
import mage.client.game.GamePanel;
import mage.client.plugins.impl.Plugins;
import mage.client.util.DeckUtil;
import mage.client.util.GUISizeHelper;
import mage.client.util.IgnoreList;
import mage.client.util.audio.AudioManager;
import mage.client.util.object.SaveObjectUtil;
import mage.interfaces.callback.CallbackClient;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackType;
import mage.remote.ActionData;
import mage.remote.Session;
import mage.util.DebugUtil;
import mage.view.AbilityPickerView;
import mage.view.ChatMessage;
import mage.view.DeckView;
import mage.view.DraftClientMessage;
import mage.view.GameClientMessage;
import mage.view.GameEndView;
import mage.view.GameView;
import mage.view.TableClientMessage;
import mage.view.UserRequestMessage;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbols;

public class CallbackClientImpl
implements CallbackClient {
    private static final Logger logger = Logger.getLogger(CallbackClientImpl.class);
    private final MageFrame frame;
    private final Map<ClientCallbackType, Integer> lastMessages;
    private final Map<UUID, GameClientMessage> firstGameData;

    public CallbackClientImpl(MageFrame frame) {
        this.frame = frame;
        this.lastMessages = new HashMap<ClientCallbackType, Integer>();
        this.firstGameData = new HashMap<UUID, GameClientMessage>();
        Arrays.stream(ClientCallbackType.values()).forEach(t -> this.lastMessages.put((ClientCallbackType)t, 0));
    }

    public void onNewConnection() {
        this.lastMessages.clear();
        this.firstGameData.clear();
    }

    public synchronized void onCallback(ClientCallback callback) {
        callback.decompressData();
        SaveObjectUtil.saveObject(callback.getData(), callback.getMethod().toString());
        if (callback.getData() instanceof GameClientMessage) {
            this.firstGameData.putIfAbsent(callback.getObjectId(), (GameClientMessage)callback.getData());
        }
        SwingUtilities.invokeLater(() -> {
            try {
                if (DebugUtil.NETWORK_SHOW_CLIENT_CALLBACK_MESSAGES_LOG) {
                    logger.info((Object)callback.getInfo());
                }
                if (!callback.getMethod().getType().equals((Object)ClientCallbackType.CLIENT_SIDE_EVENT)) {
                    int lastAnyMessageId = this.lastMessages.values().stream().mapToInt(x -> x).max().orElse(0);
                    if (lastAnyMessageId > callback.getMessageId()) {
                        if (callback.getMethod().getType().mustIgnoreOnOutdated()) {
                            logger.warn((Object)String.format("ignore un-synced message %d - %s - %s, possible reason: slow connection/performance", callback.getMessageId(), callback.getMethod().getType(), callback.getMethod()));
                            return;
                        }
                        logger.debug((Object)String.format("processing un-synced message %d - %s - %s, possible reason: slow connection/performance", callback.getMessageId(), callback.getMethod().getType(), callback.getMethod()));
                    }
                    if (!callback.getMethod().getType().canComeInAnyOrder()) {
                        this.lastMessages.put(callback.getMethod().getType(), callback.getMessageId());
                    }
                }
                switch (callback.getMethod()) {
                    case START_GAME: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.gameStarted(callback.getMessageId(), message.getCurrentTableId(), message.getParentTableId(), message.getGameId(), message.getPlayerId());
                        GamePanel gamePanel = MageFrame.getGame(callback.getObjectId());
                        if (gamePanel == null || !gamePanel.isMissGameData()) break;
                        GameClientMessage mes = this.firstGameData.getOrDefault(callback.getObjectId(), null);
                        if (mes != null) {
                            logger.warn((Object)"Found miss game data, requesting latest info... (possible reason: reconnect)");
                            gamePanel.init(callback.getMessageId(), mes.getGameView(), true);
                            SessionHandler.sendPlayerUUID(callback.getObjectId(), UUID.randomUUID());
                        }
                        break;
                    }
                    case START_TOURNAMENT: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.tournamentStarted(callback.getMessageId(), callback.getObjectId(), message.getCurrentTableId(), message.getPlayerId());
                        break;
                    }
                    case REPLAY_GAME: {
                        this.replayGame(callback.getObjectId());
                        break;
                    }
                    case SHOW_TOURNAMENT: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.showTournament(message.getCurrentTableId(), callback.getObjectId());
                        break;
                    }
                    case WATCHGAME: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.watchGame(message.getCurrentTableId(), message.getParentTableId(), callback.getObjectId());
                        break;
                    }
                    case CHATMESSAGE: {
                        ChatPanelBasic panel;
                        String serverAddress;
                        ChatMessage message = (ChatMessage)callback.getData();
                        if (message.getUsername() != null && IgnoreList.IGNORED_MESSAGE_TYPES.contains(message.getMessageType()) && IgnoreList.userIsIgnored(serverAddress = SessionHandler.getSession().getServerHost(), message.getUsername()) || (panel = MageFrame.getChat(callback.getObjectId())) == null) break;
                        if (message.getSoundToPlay() != null) {
                            switch (message.getSoundToPlay()) {
                                case PlayerLeft: {
                                    AudioManager.playPlayerLeft();
                                    break;
                                }
                                case PlayerQuitTournament: {
                                    AudioManager.playPlayerQuitTournament();
                                    break;
                                }
                                case PlayerSubmittedDeck: {
                                    AudioManager.playPlayerSubmittedDeck();
                                    break;
                                }
                                case PlayerWhispered: {
                                    AudioManager.playPlayerWhispered();
                                }
                            }
                        }
                        if (!panel.isStartMessageDone()) {
                            this.createChatStartMessage(panel);
                        }
                        if (message.getMessageType() != ChatMessage.MessageType.GAME && panel.getConnectedChat() != null) {
                            panel.getConnectedChat().receiveMessage(message.getUsername(), message.getMessage(), message.getTime(), message.getTurnInfo(), message.getMessageType(), ChatMessage.MessageColor.BLACK);
                            break;
                        }
                        panel.receiveMessage(message.getUsername(), message.getMessage(), message.getTime(), message.getTurnInfo(), message.getMessageType(), message.getColor());
                        break;
                    }
                    case SERVER_MESSAGE: {
                        if (callback.getData() == null) break;
                        ChatMessage message = (ChatMessage)callback.getData();
                        this.showMessageDialog(null, message.getMessage(), "Server message");
                        break;
                    }
                    case JOINED_TABLE: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.joinedTable(message.getRoomId(), message.getCurrentTableId(), message.getFlag());
                        break;
                    }
                    case REPLAY_INIT: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        panel.init(callback.getMessageId(), (GameView)callback.getData(), true);
                        break;
                    }
                    case REPLAY_DONE: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        panel.endMessage(callback.getMessageId(), null, null, (String)callback.getData());
                        break;
                    }
                    case REPLAY_UPDATE: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        panel.updateGame(callback.getMessageId(), (GameView)callback.getData());
                        break;
                    }
                    case GAME_INIT: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_INIT", callback.getObjectId(), callback.getData());
                        panel.init(callback.getMessageId(), (GameView)callback.getData(), true);
                        break;
                    }
                    case GAME_OVER: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        Session session = SessionHandler.getSession();
                        if (session.isJsonLogActive()) {
                            this.appendJsonEvent("GAME_OVER", callback.getObjectId(), message);
                        }
                        panel.endMessage(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage());
                        break;
                    }
                    case GAME_ERROR: {
                        this.frame.showErrorDialog("SERVER", "game error", (String)callback.getData());
                        break;
                    }
                    case GAME_ASK: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_ASK", callback.getObjectId(), message);
                        panel.ask(callback.getMessageId(), message.getGameView(), message.getMessage(), message.getOptions());
                        break;
                    }
                    case GAME_TARGET: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_TARGET", callback.getObjectId(), message);
                        panel.pickTarget(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage(), message.getCardsView1(), message.getTargets(), message.isFlag());
                        break;
                    }
                    case GAME_SELECT: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_SELECT", callback.getObjectId(), message);
                        panel.select(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage());
                        break;
                    }
                    case GAME_CHOOSE_ABILITY: {
                        AbilityPickerView abilityPickerView = (AbilityPickerView)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_CHOOSE_ABILITY", callback.getObjectId(), callback.getData());
                        panel.pickAbility(callback.getMessageId(), abilityPickerView.getGameView(), null, abilityPickerView);
                        break;
                    }
                    case GAME_CHOOSE_PILE: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_CHOOSE_PILE", callback.getObjectId(), message);
                        panel.pickPile(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage(), message.getCardsView1(), message.getCardsView2());
                        break;
                    }
                    case GAME_CHOOSE_CHOICE: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_CHOOSE_CHOICE", callback.getObjectId(), message);
                        panel.getChoice(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getChoice(), callback.getObjectId());
                        break;
                    }
                    case GAME_PLAY_MANA: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_PLAY_MANA", callback.getObjectId(), message);
                        panel.playMana(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage());
                        break;
                    }
                    case GAME_PLAY_XMANA: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_PLAY_XMANA", callback.getObjectId(), message);
                        panel.playXMana(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMessage());
                        break;
                    }
                    case GAME_GET_AMOUNT: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_GET_AMOUNT", callback.getObjectId(), message);
                        panel.getAmount(callback.getMessageId(), message.getGameView(), message.getOptions(), message.getMin(), message.getMax(), message.getMessage());
                        break;
                    }
                    case GAME_GET_MULTI_AMOUNT: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_GET_MULTI_AMOUNT", callback.getObjectId(), message);
                        panel.getMultiAmount(callback.getMessageId(), message.getGameView(), message.getMessages(), message.getOptions(), message.getMin(), message.getMax());
                        break;
                    }
                    case GAME_UPDATE: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_UPDATE", callback.getObjectId(), callback.getData());
                        panel.updateGame(callback.getMessageId(), (GameView)callback.getData(), true, null, null);
                        break;
                    }
                    case GAME_REDRAW_GUI: {
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        panel.updateGame();
                        break;
                    }
                    case END_GAME_INFO: {
                        MageFrame.getInstance().showGameEndDialog((GameEndView)callback.getData());
                        break;
                    }
                    case SHOW_USERMESSAGE: {
                        List messageData = (List)callback.getData();
                        if (messageData.size() != 2) break;
                        this.showMessageDialog(null, (String)messageData.get(1), (String)messageData.get(0));
                        break;
                    }
                    case GAME_UPDATE_AND_INFORM: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.appendJsonEvent("GAME_INFORM", callback.getObjectId(), message);
                        panel.inform(callback.getMessageId(), message.getGameView(), message.getMessage());
                        break;
                    }
                    case GAME_INFORM_PERSONAL: {
                        GameClientMessage message = (GameClientMessage)callback.getData();
                        GamePanel panel = MageFrame.getGame(callback.getObjectId());
                        if (panel == null) break;
                        this.showMessageDialog(panel, message.getMessage(), "Game message");
                        break;
                    }
                    case SIDEBOARD: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        DeckView deckView = message.getDeck();
                        Deck deck = DeckUtil.construct(deckView);
                        if (message.getFlag()) {
                            this.construct_sideboard(deck, message.getCurrentTableId(), message.getParentTableId(), message.getTime());
                            break;
                        }
                        this.sideboard(deck, message.getCurrentTableId(), message.getParentTableId(), message.getTime());
                        break;
                    }
                    case VIEW_LIMITED_DECK: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        DeckView deckView = message.getDeck();
                        Deck deck = DeckUtil.construct(deckView);
                        this.viewLimitedDeck(deck, message.getCurrentTableId(), message.getParentTableId(), message.getTime());
                        break;
                    }
                    case VIEW_SIDEBOARD: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.viewSideboard(message.getGameId(), message.getPlayerId());
                        break;
                    }
                    case CONSTRUCT: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        DeckView deckView = message.getDeck();
                        Deck deck = DeckUtil.construct(deckView);
                        this.construct(deck, message.getCurrentTableId(), message.getParentTableId(), message.getTime());
                        break;
                    }
                    case START_DRAFT: {
                        TableClientMessage message = (TableClientMessage)callback.getData();
                        this.draftStarted(callback.getMessageId(), message.getCurrentTableId(), callback.getObjectId(), message.getPlayerId());
                        break;
                    }
                    case DRAFT_OVER: {
                        MageFrame.removeDraft(callback.getObjectId());
                        break;
                    }
                    case DRAFT_INIT: 
                    case DRAFT_PICK: {
                        DraftClientMessage message = (DraftClientMessage)callback.getData();
                        DraftPanel panel = MageFrame.getDraft(callback.getObjectId());
                        if (panel == null) break;
                        panel.loadBooster(message.getDraftPickView());
                        break;
                    }
                    case DRAFT_UPDATE: {
                        DraftPanel panel = MageFrame.getDraft(callback.getObjectId());
                        DraftClientMessage message = (DraftClientMessage)callback.getData();
                        if (panel == null) break;
                        panel.updateDraft(message.getDraftView());
                        break;
                    }
                    case TOURNAMENT_INIT: {
                        break;
                    }
                    case USER_REQUEST_DIALOG: {
                        this.frame.showUserRequestDialog((UserRequestMessage)callback.getData());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        });
    }

    private void showMessageDialog(Component parentComponent, String message, String title) {
        message = ManaSymbols.replaceSymbolsWithHTML(message, ManaSymbols.Type.DIALOG);
        message = GUISizeHelper.textToHtmlWithSize(message, GUISizeHelper.dialogFont);
        JOptionPane.showMessageDialog(parentComponent, message, title, 1);
    }

    private ActionData appendJsonEvent(String name, UUID gameId, Object value) {
        Session session = SessionHandler.getSession();
        if (session.isJsonLogActive()) {
            ActionData actionData = new ActionData(name, gameId);
            actionData.value = value;
            session.appendJsonLog(actionData);
            return actionData;
        }
        return null;
    }

    private void createChatStartMessage(ChatPanelBasic chatPanel) {
        chatPanel.setStartMessageDone(true);
        ChatPanelBasic usedPanel = chatPanel;
        if (chatPanel.getConnectedChat() != null) {
            usedPanel = chatPanel.getConnectedChat();
        }
        switch (usedPanel.getChatType()) {
            case GAME: {
                usedPanel.receiveMessage("", "HOTKEYS:" + "<br/>Turn mousewheel up (ALT-e) - enlarge image of card the mousepointer hovers over" + "<br/>Turn mousewheel down (ALT-s) - enlarge original/alternate image of card the mousepointer hovers over" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlConfirm")) + "</b> - Confirm \"Ok\", \"Yes\" or \"Done\" button" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlNextTurn")) + "</b> - Skip current turn but stop on declare attackers/blockers and something on the stack" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlEndStep")) + "</b> - Skip to next end step but stop on declare attackers/blockers and something on the stack" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlSkipTurn")) + "</b> - Skip current turn but stop on declare attackers/blockers" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlMainStep")) + "</b> - Skip to next main phase but stop on declare attackers/blockers and something on the stack" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlYourTurn")) + "</b> - Skip everything until your next turn" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlPriorEnd")) + "</b> - Skip everything until the end step just prior to your turn" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlCancelSkip")) + "</b> - Undo F4/F5/F7/F9/F11" + "<br/><b>" + KeyEvent.getKeyText(PreferencesDialog.getCurrentControlKey("controlSwitchChat")) + "</b> - Switch in/out to chat text field" + "<br/><b>ALT + D</b> - show/hide panel with big card from the right side" + "<br/><b>Hold ALT + E</b> - force to show card popup in image mode" + "<br/>" + "<br/>" + "CHAT COMMANDS:" + "<br/>" + "<b>/h username </b> - show player's stats (history)" + "<br/>" + "<b>/w username message</b> - send private message to player (whisper)" + "<br/>" + "<b>/pings</b> - show players and watchers ping" + "<br/>" + "<b>/fix</b> - fix frozen game" + "<br/>" + "<b>[[card name]]</b> - insert card with popup info", null, null, ChatMessage.MessageType.USER_INFO, ChatMessage.MessageColor.BLUE);
                break;
            }
            case TOURNAMENT: {
                usedPanel.receiveMessage("", "On this panel you can see the players, their state and the results of the games of the tournament. Also you can chat with the competitors of the tournament.", null, null, ChatMessage.MessageType.USER_INFO, ChatMessage.MessageColor.BLUE);
                break;
            }
            case TABLES: {
                String serverAddress = SessionHandler.getSession().getServerHost();
                usedPanel.receiveMessage("", "Download card images by using the \"Images\" main menu." + "<br/>Download icons and symbols by using the \"Symbols\" main menu." + "<br/>\\list - show a list of available chat commands." + "<br/>" + IgnoreList.usage(serverAddress) + "<br/>Type <font color=green>\\w yourUserName profanity 0 (or 1 or 2)</font> to turn off/on the profanity filter", null, null, ChatMessage.MessageType.USER_INFO, ChatMessage.MessageColor.BLUE);
                break;
            }
        }
    }

    private void joinedTable(UUID roomId, UUID tableId, boolean isTournament) {
        try {
            this.frame.showTableWaitingDialog(roomId, tableId, isTournament);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void gameStarted(int messageId, UUID currentTableId, UUID parentTableId, UUID gameId, UUID playerId) {
        try {
            logger.info((Object)("Game " + gameId + " started for player " + playerId));
            this.frame.showGame(currentTableId, parentTableId, gameId, playerId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (Plugins.instance.isCounterPluginLoaded()) {
            Plugins.instance.addGamesPlayed();
        }
    }

    protected void draftStarted(int messageId, UUID tableId, UUID draftId, UUID playerId) {
        try {
            logger.info((Object)("Draft " + draftId + " started for player " + playerId));
            this.frame.showDraft(tableId, draftId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void tournamentStarted(int messageId, UUID tournamentId, UUID tableId, UUID playerId) {
        try {
            logger.info((Object)("Tournament " + tournamentId + " started for player " + playerId));
            this.frame.showTournament(tableId, tournamentId);
            AudioManager.playTournamentStarted();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void showTournament(UUID tableId, UUID tournamentId) {
        try {
            logger.info((Object)("Showing tournament " + tournamentId));
            this.frame.showTournament(tableId, tournamentId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void watchGame(UUID currentTableId, UUID parentTableId, UUID gameId) {
        try {
            logger.info((Object)("Watching game " + gameId));
            this.frame.watchGame(currentTableId, parentTableId, gameId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void replayGame(UUID gameId) {
        try {
            logger.info((Object)("Replaying game " + gameId));
            this.frame.replayGame(gameId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void sideboard(Deck deck, UUID currentTableId, UUID parentTableId, int time) {
        this.frame.showDeckEditor(Constants.DeckEditorMode.SIDEBOARDING, deck, currentTableId, parentTableId, time);
    }

    protected void construct(Deck deck, UUID currentTableId, UUID parentTableId, int time) {
        this.frame.showDeckEditor(Constants.DeckEditorMode.LIMITED_BUILDING, deck, currentTableId, parentTableId, time);
    }

    protected void construct_sideboard(Deck deck, UUID currentTableId, UUID parentTableId, int time) {
        this.frame.showDeckEditor(Constants.DeckEditorMode.LIMITED_SIDEBOARD_BUILDING, deck, currentTableId, parentTableId, time);
    }

    protected void viewLimitedDeck(Deck deck, UUID currentTableId, UUID parentTableId, int time) {
        this.frame.showDeckEditor(Constants.DeckEditorMode.VIEW_LIMITED_DECK, deck, currentTableId, parentTableId, time);
    }

    protected void viewSideboard(UUID gameId, UUID playerId) {
        SwingUtilities.invokeLater(() -> {
            GamePanel panel = MageFrame.getGame(gameId);
            if (panel != null) {
                panel.openSideboardWindow(playerId);
            }
        });
    }

    private void handleException(Exception e) {
        logger.fatal((Object)"General error\n", (Throwable)e);
        this.frame.showErrorDialog("General error", e);
    }
}

