/*
 * Decompiled with CFR 0.152.
 */
package mage.client.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import mage.client.dialog.PreferencesDialog;
import mage.remote.Connection;
import mage.util.DebugUtil;
import mage.utils.MageVersion;
import org.apache.log4j.Logger;

public class XmageURLConnection {
    private static final MageVersion version = new MageVersion(XmageURLConnection.class);
    private static final Logger logger = Logger.getLogger(XmageURLConnection.class);
    private static final int CONNECTION_STARTING_TIMEOUT_MS = 10000;
    private static final int CONNECTION_READING_TIMEOUT_MS = 60000;
    private static final AtomicLong debugLastRequestTimeMs = new AtomicLong(0L);
    private static final ReentrantLock debugLogsWriterlock = new ReentrantLock();
    final String url;
    Proxy proxy = null;
    HttpURLConnection connection = null;
    HttpLoggingType loggingType = HttpLoggingType.ERRORS;
    boolean forceGZipEncoding = false;

    public XmageURLConnection(String url) {
        this.url = url;
    }

    public void setRequestHeaders(Map<String, String> additionalHeaders) {
        this.makeSureConnectionStarted();
        for (String key : additionalHeaders.keySet()) {
            this.connection.setRequestProperty(key, additionalHeaders.get(key));
        }
    }

    public void setForceGZipEncoding(boolean enable) {
        this.forceGZipEncoding = enable;
    }

    public void startConnection() {
        this.initDefaultProxy();
        try {
            URI uri = new URI(this.url);
            URL url = new URL(uri.toASCIIString());
            this.connection = this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
            this.connection.setConnectTimeout(10000);
            this.connection.setReadTimeout(60000);
            this.initDefaultHeaders();
        }
        catch (IOException | URISyntaxException e) {
            this.connection = null;
        }
    }

    public void initDefaultProxy() {
        Connection.ProxyType configProxyType = Connection.ProxyType.valueByText((String)PreferencesDialog.getCachedValue("proxyType", "None"));
        switch (configProxyType) {
            case HTTP: {
                Proxy.Type type = Proxy.Type.HTTP;
                break;
            }
            case SOCKS: {
                Proxy.Type type = Proxy.Type.SOCKS;
                break;
            }
            default: {
                Proxy.Type type = Proxy.Type.DIRECT;
            }
        }
        this.proxy = Proxy.NO_PROXY;
    }

    private void initDefaultHeaders() {
        if (this.forceGZipEncoding) {
            this.connection.setRequestProperty("Accept-Encoding", "gzip");
        }
        this.connection.setRequestProperty("User-Agent", XmageURLConnection.getDefaultUserAgent());
    }

    public static String getDefaultUserAgent() {
        return String.format("XMage/%s build: %s", version.toString(false), version.getBuildTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        long currentTime;
        long oldTime;
        this.makeSureConnectionStarted();
        long diffTime = 0L;
        if (DebugUtil.NETWORK_PROFILE_REQUESTS && (oldTime = debugLastRequestTimeMs.getAndSet(currentTime = System.currentTimeMillis())) > 0L) {
            diffTime = currentTime - oldTime;
        }
        this.connection.connect();
        this.connection.getResponseCode();
        if (DebugUtil.NETWORK_PROFILE_REQUESTS) {
            String debugInfo = String.format("+%d %d %s %s", diffTime, this.connection.getResponseCode(), this.connection.getResponseMessage(), this.url) + System.lineSeparator();
            debugLogsWriterlock.lock();
            try {
                Files.write(Paths.get(DebugUtil.NETWORK_PROFILE_REQUESTS_DUMP_FILE_NAME, new String[0]), debugInfo.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            finally {
                debugLogsWriterlock.unlock();
            }
        }
        this.printHttpResult();
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public int getResponseCode() {
        this.makeSureConnectionStarted();
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException ignore) {
            return -1;
        }
    }

    public int getContentLength() {
        this.makeSureConnectionStarted();
        return this.connection.getContentLength();
    }

    public String getResponseMessage() {
        this.makeSureConnectionStarted();
        try {
            return this.connection.getResponseMessage();
        }
        catch (IOException ignore) {
            return "";
        }
    }

    public String getErrorResponseAsString() {
        this.makeSureConnectionStarted();
        Scanner s = new Scanner(this.connection.getErrorStream()).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public InputStream getGoodResponseAsStream() throws IOException {
        this.makeSureConnectionStarted();
        return this.connection.getInputStream();
    }

    public String getGoodResponseAsString() {
        this.makeSureConnectionStarted();
        StringBuffer tmp = new StringBuffer();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getGoodResponseAsStream()));
            while ((line = in.readLine()) != null) {
                tmp.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Network: can't get text data from " + this.url + " - " + e, e);
        }
        return String.valueOf(tmp);
    }

    private void makeSureConnectionStarted() {
        if (!this.isConnected()) {
            throw new IllegalArgumentException("Wrong code usage: must call startConnection first", new Throwable());
        }
    }

    public static String downloadText(String resourceUrl) {
        return XmageURLConnection.downloadText(resourceUrl, null);
    }

    public static String downloadText(String resourceUrl, Map<String, String> additionalHeaders) {
        XmageURLConnection con = new XmageURLConnection(resourceUrl);
        con.startConnection();
        if (con.isConnected()) {
            try {
                if (additionalHeaders != null) {
                    con.setRequestHeaders(additionalHeaders);
                }
                con.connect();
                if (con.getResponseCode() == 200) {
                    return con.getGoodResponseAsString();
                }
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return "";
    }

    public static InputStream downloadBinary(String resourceUrl) {
        return XmageURLConnection.downloadBinary(resourceUrl, false);
    }

    public static InputStream downloadBinary(String resourceUrl, boolean downloadAsGZip) {
        XmageURLConnection con = new XmageURLConnection(resourceUrl);
        con.setForceGZipEncoding(downloadAsGZip);
        con.startConnection();
        if (con.isConnected()) {
            try {
                con.connect();
                if (con.getResponseCode() == 200) {
                    return con.getGoodResponseAsStream();
                }
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private void printHttpResult() {
        boolean needPrint;
        if (this.connection == null) {
            return;
        }
        switch (this.loggingType) {
            case NONE: {
                needPrint = false;
                break;
            }
            case ERRORS: {
                needPrint = this.getResponseCode() != 200;
                break;
            }
            default: {
                needPrint = true;
            }
        }
        if (needPrint) {
            logger.info((Object)String.format("http request %d %s %s", this.getResponseCode(), this.getResponseMessage(), this.url));
        }
    }

    static {
        System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
    }

    static enum HttpLoggingType {
        NONE,
        ERRORS,
        ALL;

    }
}

