/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mage.client.cards.BigCard;
import mage.client.chat.ChatPanelBasic;
import mage.client.chat.ChatPanelSeparated;
import mage.client.components.ColorPane;
import mage.client.util.GUISizeHelper;
import mage.client.util.MageTableRowSorter;
import mage.client.util.gui.TableUtil;
import mage.client.util.gui.countryBox.CountryCellRenderer;
import mage.components.table.MageTable;
import mage.components.table.TableInfo;
import mage.remote.MageRemoteException;
import mage.view.RoomUsersView;
import mage.view.UsersView;

public class PlayersChatPanel
extends JPanel {
    private final List<String> players = new ArrayList<String>();
    private final UserTableModel userTableModel = new UserTableModel();
    private static final TableInfo tableInfo = new TableInfo().addColumn(Integer.valueOf(0), Integer.valueOf(20), Icon.class, "Flag", null).addColumn(Integer.valueOf(1), Integer.valueOf(100), String.class, "Players", "<b>User name</b><br>(the number behind the header text is the number of users online)").addColumn(Integer.valueOf(2), Integer.valueOf(40), Integer.class, "Constructed Rating", null).addColumn(Integer.valueOf(3), Integer.valueOf(40), Integer.class, "Limited Rating", null).addColumn(Integer.valueOf(4), Integer.valueOf(40), String.class, "Matches", "<b>Number of matches the user played so far</b><br>Q = number of matches quit<br>I = number of matches lost because of idle timeout<br>T = number of matches lost because of match timeout").addColumn(Integer.valueOf(5), Integer.valueOf(100), Integer.class, "MQP", "<b>Percent-Ratio of matches played related to matches quit</b><br>this calculation does not include tournament matches").addColumn(Integer.valueOf(6), Integer.valueOf(40), String.class, "Tourneys", "<b>Number of tournaments the user played so far</b><br>D = number of tournaments left during draft phase<br>C = number of tournaments left during constructing phase<br>R = number of tournaments left during rounds").addColumn(Integer.valueOf(7), Integer.valueOf(100), Integer.class, "TQP", "<b>Percent-Ratio of tournament matches played related to tournament matches quit</b><br>this calculation does not include non tournament matches").addColumn(Integer.valueOf(8), Integer.valueOf(80), String.class, "Games", "<b>Current activities of the player</b><BR>the header itself shows the number of currently active games<BR>T: = number of games threads <BR><i>(that can vary from active games because of sideboarding or crashed games)</i><BR>limt: the maximum of games the server is configured to<BR><i>(if the number of started games exceed that limit, the games have to wait<BR>until active games end)</i>").addColumn(Integer.valueOf(9), Integer.valueOf(80), String.class, "Ping", null);
    private ColorPane colorPaneSystem;
    private JScrollPane jScrollPanePlayers;
    private JScrollPane jScrollPaneSystem;
    private ChatPanelSeparated jScrollPaneTalk;
    private JSpinner jSpinner1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPaneText;
    private MageTable jTablePlayers;

    public PlayersChatPanel() {
        this.initComponents();
        this.setBackground(new Color(0, 0, 0, 80));
        this.jTablePlayers.setBackground(new Color(0, 0, 0, 80));
        this.jTablePlayers.setForeground(Color.white);
        this.jTablePlayers.setRowSorter((RowSorter)new MageTableRowSorter(this.userTableModel));
        this.setGUISize();
        TableUtil.setColumnWidthAndOrder((JTable)this.jTablePlayers, tableInfo.getColumnsWidth(), "userPanelColumnWidth", "userPanelColumnSort");
        this.jTablePlayers.setDefaultRenderer(Icon.class, (TableCellRenderer)new CountryCellRenderer());
        this.jScrollPaneTalk.setSystemMessagesPane(this.colorPaneSystem);
        this.jScrollPaneTalk.setOpaque(false);
        this.jScrollPaneSystem.getViewport().setOpaque(false);
        this.jScrollPaneSystem.setViewportBorder(null);
        this.colorPaneSystem.setExtBackgroundColor(new Color(0, 0, 0, 80));
        this.colorPaneSystem.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (this.jScrollPanePlayers != null) {
            this.jScrollPanePlayers.setBackground(new Color(0, 0, 0, 80));
            this.jScrollPanePlayers.getViewport().setBackground(new Color(0, 0, 0, 80));
            this.jScrollPanePlayers.setViewportBorder(null);
        }
    }

    public ChatPanelBasic getUserChatPanel() {
        return this.jScrollPaneTalk;
    }

    public void cleanUp() {
        TableUtil.saveColumnWidthAndOrderToPrefs((JTable)this.jTablePlayers, "userPanelColumnWidth", "userPanelColumnSort");
        this.jScrollPaneTalk.cleanUp();
    }

    public void setGameData(UUID gameId, BigCard bigCard) {
        this.colorPaneSystem.setGameData(gameId, bigCard);
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        this.jTablePlayers.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.jTablePlayers.setFont(GUISizeHelper.tableFont);
        this.jTablePlayers.setRowHeight(GUISizeHelper.tableRowHeight);
        this.jScrollPanePlayers.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPanePlayers.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        this.jScrollPaneSystem.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPaneSystem.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        this.jTabbedPaneText.setFont(GUISizeHelper.tableFont);
        this.jSplitPane1.setDividerSize(GUISizeHelper.dividerBarSize);
        this.colorPaneSystem.changeGUISize(GUISizeHelper.chatFont);
        this.jScrollPaneTalk.changeGUISize(GUISizeHelper.chatFont);
    }

    public void setSplitDividerLocation(int location) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerLocation(location);
        }
    }

    public int getSplitDividerLocation() {
        if (this.jSplitPane1 == null) {
            return 0;
        }
        return this.jSplitPane1.getDividerLocation();
    }

    private void initComponents() {
        this.jSpinner1 = new JSpinner();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPanePlayers = new JScrollPane();
        this.jTablePlayers = new MageTable(tableInfo);
        this.jTabbedPaneText = new JTabbedPane();
        this.jScrollPaneTalk = new ChatPanelSeparated();
        this.jScrollPaneSystem = new JScrollPane();
        this.colorPaneSystem = new ColorPane();
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.25);
        this.jScrollPanePlayers.setBorder(null);
        this.jTablePlayers.setModel((TableModel)this.userTableModel);
        this.jTablePlayers.setToolTipText("Connected players");
        this.jTablePlayers.setAutoscrolls(false);
        this.jTablePlayers.setCursor(new Cursor(0));
        this.jTablePlayers.setOpaque(false);
        this.jTablePlayers.setRequestFocusEnabled(false);
        this.jTablePlayers.setRowSelectionAllowed(false);
        this.jTablePlayers.setShowHorizontalLines(false);
        this.jTablePlayers.setShowVerticalLines(false);
        this.jTablePlayers.setUpdateSelectionOnSort(false);
        this.jTablePlayers.setVerifyInputWhenFocusTarget(false);
        this.jScrollPanePlayers.setViewportView((Component)this.jTablePlayers);
        this.jTablePlayers.getAccessibleContext().setAccessibleDescription("");
        this.jSplitPane1.setTopComponent(this.jScrollPanePlayers);
        this.jTabbedPaneText.setTabPlacement(3);
        this.jTabbedPaneText.addTab("Talk", this.jScrollPaneTalk);
        this.jScrollPaneSystem.setBorder(null);
        this.jScrollPaneSystem.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneSystem.setCursor(new Cursor(0));
        this.jScrollPaneSystem.setFocusable(false);
        this.jScrollPaneSystem.setOpaque(false);
        this.colorPaneSystem.setEditable(false);
        this.colorPaneSystem.setBackground(new Color(0, 0, 0));
        this.colorPaneSystem.setBorder(null);
        this.colorPaneSystem.setFont(new Font("Arial", 0, 14));
        this.colorPaneSystem.setMargin(new Insets(0, 0, 0, 0));
        this.colorPaneSystem.setOpaque(false);
        this.jScrollPaneSystem.setViewportView(this.colorPaneSystem);
        this.jTabbedPaneText.addTab("System", this.jScrollPaneSystem);
        this.jSplitPane1.setRightComponent(this.jTabbedPaneText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 350, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1).addGap(0, 0, 0)));
    }

    public void setRoomUserInfo(List<Collection<RoomUsersView>> view) {
        try {
            this.userTableModel.loadData(view.get(0));
        }
        catch (Exception ex) {
            this.players.clear();
        }
    }

    class UserTableModel
    extends AbstractTableModel {
        private UsersView[] players = new UsersView[0];

        UserTableModel() {
        }

        public void loadData(Collection<RoomUsersView> roomUserInfoList) throws MageRemoteException {
            RoomUsersView roomUserInfo = roomUserInfoList.iterator().next();
            this.players = roomUserInfo.getUsersView().toArray(new UsersView[0]);
            JTableHeader th = PlayersChatPanel.this.jTablePlayers.getTableHeader();
            TableColumnModel tcm = th.getColumnModel();
            tcm.getColumn(PlayersChatPanel.this.jTablePlayers.convertColumnIndexToView(tableInfo.getColumnByName("Players").getIndex().intValue())).setHeaderValue("Players (" + this.players.length + ')');
            tcm.getColumn(PlayersChatPanel.this.jTablePlayers.convertColumnIndexToView(tableInfo.getColumnByName("Games").getIndex().intValue())).setHeaderValue("Games " + roomUserInfo.getNumberActiveGames() + (roomUserInfo.getNumberActiveGames() != roomUserInfo.getNumberGameThreads() ? " (T:" + roomUserInfo.getNumberGameThreads() : " (") + " limit: " + roomUserInfo.getNumberMaxGames() + ')');
            th.repaint();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.players.length;
        }

        @Override
        public int getColumnCount() {
            return tableInfo.getColumns().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            switch (colIndex) {
                case 0: {
                    return this.players[rowIndex].getFlagName();
                }
                case 1: {
                    return this.players[rowIndex].getUserName();
                }
                case 2: {
                    return this.players[rowIndex].getConstructedRating();
                }
                case 3: {
                    return this.players[rowIndex].getLimitedRating();
                }
                case 4: {
                    return this.players[rowIndex].getMatchHistory();
                }
                case 5: {
                    return this.players[rowIndex].getMatchQuitRatio();
                }
                case 6: {
                    return this.players[rowIndex].getTourneyHistory();
                }
                case 7: {
                    return this.players[rowIndex].getTourneyQuitRatio();
                }
                case 8: {
                    return this.players[rowIndex].getInfoGames();
                }
                case 9: {
                    return this.players[rowIndex].getInfoPing();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int columnIndex) {
            return tableInfo.getColumnByIndex(columnIndex).getHeaderName();
        }

        public Class getColumnClass(int columnIndex) {
            return tableInfo.getColumnByIndex(columnIndex).getColClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

