/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import mage.client.table.TablesUtil;
import mage.client.util.GUISizeHelper;

public class TablesButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener {
    private final JTable table;
    private final Action action;
    private final JButton renderButton;
    private final JButton editButton;
    private String text;
    private boolean isButtonColumnEditor;

    public TablesButtonColumn(JTable table, Action action, int column) {
        this.table = table;
        this.action = action;
        this.renderButton = new JButton();
        this.editButton = new JButton();
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        this.setGUISize();
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
        table.addMouseListener(this);
    }

    public void changeGUISize() {
        this.setGUISize();
    }

    private void setGUISize() {
        this.renderButton.setFont(GUISizeHelper.tableFont);
        this.editButton.setFont(GUISizeHelper.tableFont);
    }

    @Override
    public Object getCellEditorValue() {
        return this.text;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            this.renderButton.setForeground(table.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        } else if (isSelected) {
            this.renderButton.setForeground(table.getSelectionForeground());
            this.renderButton.setBackground(table.getSelectionBackground());
        } else {
            this.renderButton.setForeground(table.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        }
        this.renderButton.setText(value == null ? "" : value.toString());
        return this.renderButton;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.text = value == null ? "" : value.toString();
        this.editButton.setText(this.text);
        return this.editButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.table.getRowCount() > 0 && this.table.getRowCount() >= this.table.getEditingRow() && this.table.getEditingRow() >= 0) {
            int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
            this.fireEditingStopped();
            ActionEvent event = new ActionEvent(this.table, 1001, TablesUtil.getSearchIdFromTable(this.table, row));
            this.action.actionPerformed(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }
}

