/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.client.MageFrame;
import mage.client.SessionHandler;
import mage.client.chat.ChatPanelBasic;
import mage.client.components.MageComponents;
import mage.client.dialog.JoinTableDialog;
import mage.client.dialog.NewTableDialog;
import mage.client.dialog.NewTournamentDialog;
import mage.client.dialog.PreferencesDialog;
import mage.client.dialog.TableWaitingDialog;
import mage.client.table.GameChooser;
import mage.client.table.MatchesTableModel;
import mage.client.table.PlayersChatPanel;
import mage.client.table.TablesButtonColumn;
import mage.client.table.TablesPane;
import mage.client.table.TablesTableModel;
import mage.client.table.TablesUtil;
import mage.client.table.UpdateMatchesTask;
import mage.client.table.UpdatePlayersTask;
import mage.client.table.UpdateTablesTask;
import mage.client.util.GUISizeHelper;
import mage.client.util.IgnoreList;
import mage.client.util.MageTableRowSorter;
import mage.client.util.URLHandler;
import mage.client.util.gui.GuiDisplayUtil;
import mage.client.util.gui.TableUtil;
import mage.components.table.MageTable;
import mage.components.table.TableInfo;
import mage.components.table.TimeAgoTableCellRenderer;
import mage.constants.MatchBufferTime;
import mage.constants.MatchTimeLimit;
import mage.constants.MultiplayerAttackOption;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.SkillLevel;
import mage.game.match.MatchOptions;
import mage.players.PlayerType;
import mage.remote.MageRemoteException;
import mage.util.DeckUtil;
import mage.util.RandomUtil;
import mage.view.MatchView;
import mage.view.TableView;
import mage.view.UserRequestMessage;
import org.apache.log4j.Logger;
import org.mage.card.arcane.CardRendererUtils;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.PrettyTime;

public class TablesPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(TablesPanel.class);
    private static final int[] DEFAULT_COLUMNS_WIDTH = new int[]{35, 150, 100, 50, 120, 180, 80, 120, 80, 60, 40, 40, 60};
    public static final int PING_SERVER_SECS = 20;
    public static final int REFRESH_ACTIVE_TABLES_SECS = 5;
    public static final int REFRESH_FINISHED_TABLES_SECS = 30;
    public static final int REFRESH_PLAYERS_SECS = 10;
    public static final double REFRESH_TIMEOUTS_INCREASE_FACTOR = 0.8;
    private final TablesTableModel tableModel;
    private static final TableInfo tableInfo = new TableInfo().addColumn(Integer.valueOf(0), Integer.valueOf(35), Icon.class, "M/T", "<b>Basic table type</b><br>A symbol for match or a tournament table").addColumn(Integer.valueOf(1), Integer.valueOf(150), String.class, "Deck Type", null).addColumn(Integer.valueOf(2), Integer.valueOf(100), String.class, "Name", "<b>Table name</b><br>A name for the table the table creator has set").addColumn(Integer.valueOf(3), Integer.valueOf(50), String.class, "Seats", "<b>Seats of the table</b><br>Occupied Seats / Total number of seats ").addColumn(Integer.valueOf(4), Integer.valueOf(120), String.class, "Owner / Players", "<b>Joined players</b><br>Owner = First name is the creator of the table<br>Players = Names of the other players joint to the table").addColumn(Integer.valueOf(5), Integer.valueOf(180), String.class, "Game Type", null).addColumn(Integer.valueOf(6), Integer.valueOf(80), String.class, "Info", "<b>Match / Tournament settings</b><br>Wins = Number of games you need to wins to win a match<br>Time = Time limit per player<br>Constr.: = Construction time for limited tournament formats<br>RB = Rollbacks allowed<br>SP = Spectators allowed<br>Rng: Range of visibility for multiplayer matches<br>Custom options: Nonstandard options, hover for details").addColumn(Integer.valueOf(7), Integer.valueOf(120), String.class, "Status", "<b>Table status</b><br>Information about the progress of the match or tournament").addColumn(Integer.valueOf(8), Integer.valueOf(80), String.class, "Password", "<b>Password set</b><br>Yes = You need the password of this table<br>to join the table").addColumn(Integer.valueOf(9), Integer.valueOf(60), Date.class, "Created / Started", "<b>Creation and starting time</b><br>When was the table created<br>when started the match or tournament").addColumn(Integer.valueOf(10), Integer.valueOf(40), SkillLevel.class, "Skill Level", "<b>Defined skill level</b><br>Expectations of the table creator<br>on the level of experience of the joining players").addColumn(Integer.valueOf(11), Integer.valueOf(40), String.class, "Rated", "<b>Rating status</b><br>Yes = The matches of this table are rated").addColumn(Integer.valueOf(12), Integer.valueOf(60), String.class, "Quit %", "<b>Needed maximal quit ratio</b><br>Your calculated quit ratio of your past games<br>needs to be below or equal to the given value<br>to be able to join to the table").addColumn(Integer.valueOf(13), Integer.valueOf(40), String.class, "Min Rating", "<b>Rating restriction</b><br>You need at least this rating<br> to be able to join the table").addColumn(Integer.valueOf(14), Integer.valueOf(80), String.class, "Action", "<b>Actions related to this table</b><br>Depending on the state of the table<br>the possible actions you can take<br>are shown here as buttons");
    private final MatchesTableModel matchesModel;
    private UUID roomId;
    private UpdateTablesTask updateTablesTask;
    private UpdatePlayersTask updatePlayersTask;
    private UpdateMatchesTask updateMatchesTask;
    private JoinTableDialog joinTableDialog;
    private NewTableDialog newTableDialog;
    private NewTournamentDialog newTournamentDialog;
    private final GameChooser gameChooser;
    private List<String> messages;
    private int currentMessage;
    private final MageTableRowSorter activeTablesSorter;
    private final MageTableRowSorter completedTablesSorter;
    private final TablesButtonColumn actionButton1;
    private final TablesButtonColumn actionButton2;
    private final Map<JTable, String> tablesLastSelection = new HashMap<JTable, String>();
    final JToggleButton[] filterButtons;
    private final PrettyTime timeFormatter = new PrettyTime(Locale.ENGLISH);
    TableCellRenderer durationCellRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Long ms = (Long)value;
            if (ms != 0L) {
                Duration dur = TablesPanel.this.timeFormatter.approximateDuration(new Date(ms));
                label.setText(TablesPanel.this.timeFormatter.formatDuration(dur));
            } else {
                label.setText("");
            }
            return label;
        }
    };
    TableCellRenderer datetimeCellRenderer = new DefaultTableCellRenderer(){
        final DateFormat datetimeFormater = new SimpleDateFormat("HH:mm:ss");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Date d = (Date)value;
            if (d != null) {
                label.setText(this.datetimeFormater.format(d));
            } else {
                label.setText("");
            }
            return label;
        }
    };
    TableCellRenderer skillCellRenderer = new DefaultTableCellRenderer(){
        private final JPanel renderPanel = new JPanel();
        private final ImageIcon skillIcon = new ImageIcon(this.getClass().getResource("/info/yellow_star_16.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer baseRenderer = (DefaultTableCellRenderer)table.getDefaultRenderer(String.class);
            JLabel baseComp = (JLabel)baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String skillCode = baseComp.getText();
            this.renderPanel.setOpaque(baseComp.isOpaque());
            this.renderPanel.setForeground(CardRendererUtils.copyColor(baseComp.getForeground()));
            this.renderPanel.setBackground(CardRendererUtils.copyColor(baseComp.getBackground()));
            this.renderPanel.setBorder(baseComp.getBorder());
            this.renderPanel.removeAll();
            this.renderPanel.setLayout(new BoxLayout(this.renderPanel, 0));
            for (char skillSymbol : skillCode.toCharArray()) {
                JLabel symbolLabel = new JLabel();
                symbolLabel.setBorder(new EmptyBorder(0, 3, 0, 0));
                symbolLabel.setIcon(this.skillIcon);
                this.renderPanel.add(symbolLabel);
            }
            return this.renderPanel;
        }
    };
    TableCellRenderer seatsCellRenderer = new DefaultTableCellRenderer(){
        final JLabel greenLabel = new JLabel();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel defaultLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            defaultLabel.setHorizontalAlignment(0);
            String val = (String)value;
            int[] seats = TablesPanel.this.parseSeatsInfo(val);
            if (seats[0] != seats[1]) {
                Color defaultBack = defaultLabel.getBackground();
                this.greenLabel.setText(val);
                this.greenLabel.setHorizontalAlignment(0);
                this.greenLabel.setFont(defaultLabel.getFont());
                this.greenLabel.setForeground(Color.black);
                this.greenLabel.setOpaque(true);
                this.greenLabel.setBackground(new Color(156, 240, 146));
                this.greenLabel.setBorder(new LineBorder(defaultBack, 1));
                return this.greenLabel;
            }
            return defaultLabel;
        }
    };
    private JToggleButton btnFormatBlock;
    private JToggleButton btnFormatCommander;
    private JToggleButton btnFormatLegacy;
    private JToggleButton btnFormatLimited;
    private JToggleButton btnFormatModern;
    private JToggleButton btnFormatOathbreaker;
    private JToggleButton btnFormatOther;
    private JToggleButton btnFormatPioneer;
    private JToggleButton btnFormatPremodern;
    private JToggleButton btnFormatStandard;
    private JToggleButton btnFormatTinyLeader;
    private JToggleButton btnFormatVintage;
    private JButton btnNewTable;
    private JButton btnNewTournament;
    private JToggleButton btnOpen;
    private JToggleButton btnPassword;
    private JButton btnQuickStart4Player;
    private JButton btnQuickStart2Player;
    private JButton btnQuickStartMCTS;
    private JToggleButton btnRated;
    private JToggleButton btnSkillBeginner;
    private JToggleButton btnSkillCasual;
    private JToggleButton btnSkillSerious;
    private JToggleButton btnStateActive;
    private JToggleButton btnStateFinished;
    private JToggleButton btnStateWaiting;
    private JToggleButton btnTypeMatch;
    private JToggleButton btnTypeTourneyConstructed;
    private JToggleButton btnTypeTourneyLimited;
    private JToggleButton btnUnrated;
    private JButton buttonNextMessage;
    private JButton buttonWhatsNew;
    private PlayersChatPanel chatPanelMain;
    private JToolBar filterBar1;
    private JToolBar filterBar2;
    private JPanel jPanelBottom;
    private JPanel jPanelTables;
    private JPanel jPanelTop;
    private JScrollPane jScrollPaneTablesActive;
    private JScrollPane jScrollPaneTablesFinished;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPaneTables;
    private JLabel labelMessageHeader;
    private JLabel labelMessageText;
    private JTable tableCompleted;
    private JTable tableTables;

    private int[] parseSeatsInfo(String info) {
        String[] valsList = info.split("/");
        int[] res = new int[]{0, 0};
        if (valsList.length == 2) {
            res[0] = Integer.parseInt(valsList[0]);
            res[1] = Integer.parseInt(valsList[1]);
        }
        return res;
    }

    public static int randomizeTimout(int minTimout) {
        int increase = (int)((double)minTimout * 0.8);
        return minTimout + RandomUtil.nextInt(increase);
    }

    public TablesPanel() {
        JComponent[] components;
        this.tableModel = new TablesTableModel();
        this.matchesModel = new MatchesTableModel();
        this.gameChooser = new GameChooser();
        this.initComponents();
        MageTable.fixTimeFormatter((PrettyTime)this.timeFormatter);
        this.tableTables.createDefaultColumnsFromModel();
        ((MageTable)this.tableTables).setTableInfo(tableInfo);
        this.activeTablesSorter = new MageTableRowSorter(this.tableModel){

            @Override
            public void toggleSortOrder(int column) {
                if (column == 9 || column == 3) {
                    List<RowSorter.SortKey> sortKeys = this.getSortKeys();
                    if (sortKeys.size() == 2) {
                        this.setSortKeys(null);
                    } else {
                        ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
                        list.add(new RowSorter.SortKey(3, SortOrder.ASCENDING));
                        list.add(new RowSorter.SortKey(9, SortOrder.DESCENDING));
                        this.setSortKeys(list);
                    }
                } else {
                    super.toggleSortOrder(column);
                }
            }
        };
        this.tableTables.setRowSorter(this.activeTablesSorter);
        this.tableTables.getColumnModel().getColumn(9).setCellRenderer((TableCellRenderer)TimeAgoTableCellRenderer.getInstance());
        this.tableTables.getColumnModel().getColumn(10).setCellRenderer(this.skillCellRenderer);
        this.tableTables.getColumnModel().getColumn(3).setCellRenderer(this.seatsCellRenderer);
        this.activeTablesSorter.setComparator(3, new Comparator<String>(){

            @Override
            public int compare(String v1, String v2) {
                boolean free2;
                int[] seats1 = TablesPanel.this.parseSeatsInfo(v1);
                int[] seats2 = TablesPanel.this.parseSeatsInfo(v2);
                boolean free1 = seats1[0] != seats1[1];
                boolean bl = free2 = seats2[0] != seats2[1];
                if (free1 || free2) {
                    return Boolean.compare(free2, free1);
                }
                return 0;
            }
        });
        ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
        list.add(new RowSorter.SortKey(3, SortOrder.ASCENDING));
        list.add(new RowSorter.SortKey(9, SortOrder.DESCENDING));
        this.activeTablesSorter.setSortKeys(list);
        TableUtil.setColumnWidthAndOrder(this.tableTables, DEFAULT_COLUMNS_WIDTH, "tablePanelColumnWidth", "tablePanelColumnSort");
        this.completedTablesSorter = new MageTableRowSorter(this.matchesModel);
        this.tableCompleted.setRowSorter(this.completedTablesSorter);
        this.tableCompleted.getColumnModel().getColumn(5).setCellRenderer(this.durationCellRenderer);
        this.tableCompleted.getColumnModel().getColumn(6).setCellRenderer(this.datetimeCellRenderer);
        this.tableCompleted.getColumnModel().getColumn(7).setCellRenderer(this.datetimeCellRenderer);
        ArrayList<RowSorter.SortKey> list2 = new ArrayList<RowSorter.SortKey>();
        list2.add(new RowSorter.SortKey(7, SortOrder.DESCENDING));
        this.completedTablesSorter.setSortKeys(list2);
        this.chatPanelMain.getUserChatPanel().useExtendedView(ChatPanelBasic.VIEW_MODE.NONE);
        this.chatPanelMain.getUserChatPanel().setBorder(null);
        this.chatPanelMain.getUserChatPanel().setChatType(ChatPanelBasic.ChatType.TABLES);
        this.filterButtons = new JToggleButton[]{this.btnStateWaiting, this.btnStateActive, this.btnStateFinished, this.btnTypeMatch, this.btnTypeTourneyConstructed, this.btnTypeTourneyLimited, this.btnFormatBlock, this.btnFormatStandard, this.btnFormatModern, this.btnFormatLegacy, this.btnFormatVintage, this.btnFormatPremodern, this.btnFormatCommander, this.btnFormatTinyLeader, this.btnFormatLimited, this.btnFormatOther, this.btnSkillBeginner, this.btnSkillCasual, this.btnSkillSerious, this.btnRated, this.btnUnrated, this.btnOpen, this.btnPassword, this.btnFormatOathbreaker, this.btnFormatPioneer};
        for (JComponent component : components = new JComponent[]{this.chatPanelMain, this.jSplitPane1, this.jScrollPaneTablesActive, this.jScrollPaneTablesFinished, this.jPanelTop, this.jPanelTables}) {
            component.setOpaque(false);
        }
        this.jScrollPaneTablesActive.getViewport().setBackground(new Color(255, 255, 255, 50));
        this.jScrollPaneTablesFinished.getViewport().setBackground(new Color(255, 255, 255, 50));
        this.restoreFilters();
        this.setGUISize();
        AbstractAction openTableAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchID = e.getActionCommand();
                int modelRow = TablesUtil.findTableRowFromSearchId(TablesPanel.this.tableModel, searchID);
                if (modelRow == -1) {
                    return;
                }
                UUID tableId = (UUID)TablesPanel.this.tableModel.getValueAt(modelRow, 17);
                UUID gameId = (UUID)TablesPanel.this.tableModel.getValueAt(modelRow, 16);
                String action = (String)TablesPanel.this.tableModel.getValueAt(modelRow, 14);
                String gameType = (String)TablesPanel.this.tableModel.getValueAt(modelRow, 5);
                boolean isTournament = (Boolean)TablesPanel.this.tableModel.getValueAt(modelRow, 15);
                String owner = (String)TablesPanel.this.tableModel.getValueAt(modelRow, 4);
                String pwdColumn = (String)TablesPanel.this.tableModel.getValueAt(modelRow, 8);
                switch (action) {
                    case "Join": {
                        if (owner.equals(SessionHandler.getUserName()) || owner.startsWith(SessionHandler.getUserName() + ',')) {
                            try {
                                JInternalFrame[] windows;
                                JDesktopPane desktopPane = (JDesktopPane)MageFrame.getUI().getComponent(MageComponents.DESKTOP_PANE);
                                for (JInternalFrame frame : windows = desktopPane.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER)) {
                                    if (!frame.getTitle().equals("Waiting for players")) continue;
                                    frame.toFront();
                                    frame.setVisible(true);
                                    try {
                                        frame.setSelected(true);
                                    }
                                    catch (PropertyVetoException ve) {
                                        LOGGER.error((Object)ve);
                                    }
                                }
                            }
                            catch (InterruptedException ex) {
                                LOGGER.error((Object)ex);
                            }
                            return;
                        }
                        if (isTournament) {
                            LOGGER.info((Object)("Joining tournament " + tableId));
                            if (!gameType.startsWith("Constructed")) {
                                if ("YES".equals(pwdColumn)) {
                                    TablesPanel.this.joinTableDialog.showDialog(TablesPanel.this.roomId, tableId, true, !gameType.startsWith("Constructed"));
                                    break;
                                }
                                SessionHandler.joinTournamentTable(TablesPanel.this.roomId, tableId, SessionHandler.getUserName(), PlayerType.HUMAN, 1, null, "");
                                break;
                            }
                            TablesPanel.this.joinTableDialog.showDialog(TablesPanel.this.roomId, tableId, true, !gameType.startsWith("Constructed"));
                            break;
                        }
                        LOGGER.info((Object)("Joining table " + tableId));
                        TablesPanel.this.joinTableDialog.showDialog(TablesPanel.this.roomId, tableId, false, false);
                        break;
                    }
                    case "Remove": {
                        UserRequestMessage message = new UserRequestMessage("Removing table", "Are you sure you want to remove table?");
                        message.setButton1("No", null);
                        message.setButton2("Yes", PlayerAction.CLIENT_REMOVE_TABLE);
                        MageFrame.getInstance().showUserRequestDialog(message);
                        break;
                    }
                    case "Show": {
                        if (!isTournament) break;
                        LOGGER.info((Object)("Showing tournament table " + tableId));
                        SessionHandler.watchTable(TablesPanel.this.roomId, tableId);
                        break;
                    }
                    case "Watch": {
                        if (isTournament) break;
                        LOGGER.info((Object)("Watching table " + tableId));
                        SessionHandler.watchTable(TablesPanel.this.roomId, tableId);
                        break;
                    }
                    case "Replay": {
                        LOGGER.info((Object)("Replaying game " + gameId));
                        SessionHandler.replayGame(gameId);
                    }
                }
            }
        };
        AbstractAction closedTableAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action;
                String searchID = e.getActionCommand();
                int modelRow = TablesUtil.findTableRowFromSearchId(TablesPanel.this.matchesModel, searchID);
                if (modelRow == -1) {
                    return;
                }
                switch (action = (String)TablesPanel.this.matchesModel.getValueAt(modelRow, 8)) {
                    case "Replay": {
                        List<UUID> gameList = TablesPanel.this.matchesModel.getListofGames(modelRow);
                        if (gameList == null || gameList.isEmpty()) break;
                        if (gameList.size() == 1) {
                            SessionHandler.replayGame(gameList.get(0));
                            break;
                        }
                        TablesPanel.this.gameChooser.show(gameList, MageFrame.getDesktop().getMousePosition());
                        break;
                    }
                    case "Show": {
                        if (!TablesPanel.this.matchesModel.isTournament(modelRow)) break;
                        LOGGER.info((Object)("Showing tournament table " + TablesPanel.this.matchesModel.getTableId(modelRow)));
                        SessionHandler.watchTable(TablesPanel.this.roomId, TablesPanel.this.matchesModel.getTableId(modelRow));
                    }
                }
            }
        };
        this.actionButton1 = new TablesButtonColumn(this.tableTables, openTableAction, this.tableTables.convertColumnIndexToView(14));
        this.actionButton2 = new TablesButtonColumn(this.tableCompleted, closedTableAction, this.tableCompleted.convertColumnIndexToView(8));
        this.tablesLastSelection.put(this.tableTables, "");
        this.tablesLastSelection.put(this.tableCompleted, "");
        this.addTableSelectListener(this.tableTables);
        this.addTableSelectListener(this.tableCompleted);
        this.addTableDoubleClickListener(this.tableTables, openTableAction);
        this.addTableDoubleClickListener(this.tableCompleted, closedTableAction);
    }

    private void addTableSelectListener(final JTable table) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int modelRow = MageTable.getSelectedModelRow((JTable)table);
                if (modelRow != -1) {
                    String rowId = TablesUtil.getSearchIdFromTable(table, modelRow);
                    TablesPanel.this.tablesLastSelection.put(table, rowId);
                }
            }
        });
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String lastRowID = (String)TablesPanel.this.tablesLastSelection.get(table);
                        int needModelRow = TablesUtil.findTableRowFromSearchId(table.getModel(), lastRowID);
                        int needViewRow = MageTable.getViewRowFromModel((JTable)table, (int)needModelRow);
                        if (needViewRow != -1) {
                            table.clearSelection();
                            table.addRowSelectionInterval(needViewRow, needViewRow);
                        }
                    }
                });
            }
        });
    }

    private void addTableDoubleClickListener(final JTable table, final Action action) {
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int modelRow = MageTable.getSelectedModelRow((JTable)table);
                if (e.getClickCount() == 2 && modelRow != -1) {
                    action.actionPerformed(new ActionEvent(table, 1001, TablesUtil.getSearchIdFromTable(table, modelRow)));
                }
            }
        });
    }

    public void cleanUp() {
        this.saveGuiSettings();
        this.chatPanelMain.cleanUp();
        this.stopTasks();
    }

    public void changeGUISize() {
        this.chatPanelMain.changeGUISize();
        this.actionButton1.changeGUISize();
        this.actionButton2.changeGUISize();
        this.setGUISize();
    }

    private void setGUISize() {
        this.tableTables.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.tableTables.setFont(GUISizeHelper.tableFont);
        this.tableTables.setRowHeight(GUISizeHelper.tableRowHeight);
        this.tableCompleted.getTableHeader().setFont(GUISizeHelper.tableFont);
        this.tableCompleted.setFont(GUISizeHelper.tableFont);
        this.tableCompleted.setRowHeight(GUISizeHelper.tableRowHeight);
        this.jSplitPane1.setDividerSize(GUISizeHelper.dividerBarSize);
        this.jSplitPaneTables.setDividerSize(GUISizeHelper.dividerBarSize);
        this.jScrollPaneTablesActive.getVerticalScrollBar().setPreferredSize(new Dimension(GUISizeHelper.scrollBarSize, 0));
        this.jScrollPaneTablesActive.getHorizontalScrollBar().setPreferredSize(new Dimension(0, GUISizeHelper.scrollBarSize));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/buttons/state_waiting.png"));
        Image img = icon.getImage();
        Image newimg = img.getScaledInstance(GUISizeHelper.dialogFont.getSize(), GUISizeHelper.dialogFont.getSize(), 4);
        this.btnStateWaiting.setIcon(new ImageIcon(newimg));
        icon = new ImageIcon(this.getClass().getResource("/buttons/state_active.png"));
        img = icon.getImage();
        newimg = img.getScaledInstance(GUISizeHelper.dialogFont.getSize(), GUISizeHelper.dialogFont.getSize(), 4);
        this.btnStateActive.setIcon(new ImageIcon(newimg));
        icon = new ImageIcon(this.getClass().getResource("/buttons/state_finished.png"));
        img = icon.getImage();
        newimg = img.getScaledInstance(GUISizeHelper.dialogFont.getSize(), GUISizeHelper.dialogFont.getSize(), 4);
        this.btnStateFinished.setIcon(new ImageIcon(newimg));
        int iconSize = 48 + GUISizeHelper.dialogFont.getSize() * 2 - 15;
        icon = new ImageIcon(this.getClass().getResource("/buttons/match_new.png"));
        img = icon.getImage();
        newimg = img.getScaledInstance(iconSize, iconSize, 4);
        this.btnNewTable.setIcon(new ImageIcon(newimg));
        icon = new ImageIcon(this.getClass().getResource("/buttons/tourney_new.png"));
        img = icon.getImage();
        newimg = img.getScaledInstance(iconSize, iconSize, 4);
        this.btnNewTournament.setIcon(new ImageIcon(newimg));
        for (JToggleButton component : this.filterButtons) {
            component.setFont(GUISizeHelper.dialogFont);
        }
        Dimension newDimension = new Dimension((int)this.jPanelBottom.getPreferredSize().getWidth(), GUISizeHelper.dialogFont.getSize() + 28);
        this.jPanelBottom.setMinimumSize(newDimension);
        this.jPanelBottom.setPreferredSize(newDimension);
        this.buttonWhatsNew.setFont(GUISizeHelper.dialogFont);
        this.buttonNextMessage.setFont(GUISizeHelper.dialogFont);
        this.labelMessageHeader.setFont(new Font(GUISizeHelper.dialogFont.getName(), 1, GUISizeHelper.dialogFont.getSize()));
        this.labelMessageText.setFont(GUISizeHelper.dialogFont);
        this.btnQuickStart2Player.setFont(GUISizeHelper.dialogFont);
        this.btnQuickStart4Player.setFont(GUISizeHelper.dialogFont);
        this.btnQuickStartMCTS.setFont(GUISizeHelper.dialogFont);
    }

    private void restoreDividerLocations() {
        Rectangle currentBounds = MageFrame.getDesktop().getBounds();
        if (currentBounds != null) {
            String firstDivider = PreferencesDialog.getCachedValue("tablePanelDividerLocation1", null);
            String tableDivider = PreferencesDialog.getCachedValue("tablePanelDividerLocation2", null);
            String chatDivider = PreferencesDialog.getCachedValue("tablePanelDividerLocation3", null);
            GuiDisplayUtil.restoreDividerLocations(currentBounds, firstDivider, this.jSplitPane1);
            GuiDisplayUtil.restoreDividerLocations(currentBounds, tableDivider, this.jSplitPaneTables);
            GuiDisplayUtil.restoreDividerLocations(currentBounds, chatDivider, this.chatPanelMain);
        }
    }

    private void saveDividerLocations() {
        if (this.jSplitPane1.getDividerLocation() == -1) {
            return;
        }
        GuiDisplayUtil.saveCurrentBoundsToPrefs();
        GuiDisplayUtil.saveDividerLocationToPrefs("tablePanelDividerLocation1", this.jSplitPane1.getDividerLocation());
        GuiDisplayUtil.saveDividerLocationToPrefs("tablePanelDividerLocation2", this.jSplitPaneTables.getDividerLocation());
        GuiDisplayUtil.saveDividerLocationToPrefs("tablePanelDividerLocation3", this.chatPanelMain.getSplitDividerLocation());
    }

    private void restoreFilters() {
        TableUtil.setActiveFilters("tablePanelFilterSettings", this.filterButtons);
        this.setTableFilter();
    }

    private void saveGuiSettings() {
        TableUtil.saveActiveFiltersToPrefs("tablePanelFilterSettings", this.filterButtons);
        TableUtil.saveColumnWidthAndOrderToPrefs(this.tableTables, "tablePanelColumnWidth", "tablePanelColumnSort");
    }

    public Map<String, JComponent> getUIComponents() {
        HashMap<String, JComponent> components = new HashMap<String, JComponent>();
        components.put("jScrollPane1", this.jScrollPaneTablesActive);
        components.put("jScrollPane1ViewPort", this.jScrollPaneTablesActive.getViewport());
        components.put("jPanel1", this.jPanelTop);
        components.put("tablesPanel", this);
        return components;
    }

    public void updateTables(Collection<TableView> tables) {
        try {
            this.tableModel.loadData(tables);
            this.tableTables.repaint();
        }
        catch (MageRemoteException ex) {
            this.hideTables();
        }
    }

    public void updateMatches(Collection<MatchView> matches) {
        try {
            this.matchesModel.loadData(matches);
            this.tableCompleted.repaint();
        }
        catch (MageRemoteException ex) {
            this.hideTables();
        }
    }

    public void startUpdateTasks(boolean refreshImmediately) {
        if (SessionHandler.getSession() != null) {
            if (this.updateTablesTask == null || this.updateTablesTask.isDone() || refreshImmediately) {
                if (this.updateTablesTask != null) {
                    this.updateTablesTask.cancel(true);
                }
                this.updateTablesTask = new UpdateTablesTask(this.roomId, this);
                this.updateTablesTask.execute();
            }
            if (this.btnStateFinished.isSelected()) {
                if (this.updateMatchesTask == null || this.updateMatchesTask.isDone() || refreshImmediately) {
                    if (this.updateMatchesTask != null) {
                        this.updateMatchesTask.cancel(true);
                    }
                    this.updateMatchesTask = new UpdateMatchesTask(this.roomId, this);
                    this.updateMatchesTask.execute();
                }
            } else if (this.updateMatchesTask != null) {
                this.updateMatchesTask.cancel(true);
            }
            if (this.updatePlayersTask == null || this.updatePlayersTask.isDone() || refreshImmediately) {
                if (this.updatePlayersTask != null) {
                    this.updatePlayersTask.cancel(true);
                }
                this.updatePlayersTask = new UpdatePlayersTask(this.roomId, this.chatPanelMain);
                this.updatePlayersTask.execute();
            }
        }
    }

    public void stopTasks() {
        if (this.updateTablesTask != null) {
            this.updateTablesTask.cancel(true);
        }
        if (this.updatePlayersTask != null) {
            this.updatePlayersTask.cancel(true);
        }
        if (this.updateMatchesTask != null) {
            this.updateMatchesTask.cancel(true);
        }
    }

    public void showTables(UUID roomId) {
        this.roomId = roomId;
        UUID chatRoomId = null;
        if (SessionHandler.getSession() != null) {
            this.btnQuickStart2Player.setVisible(SessionHandler.isTestMode());
            this.btnQuickStart4Player.setVisible(SessionHandler.isTestMode());
            this.btnQuickStartMCTS.setVisible(SessionHandler.isTestMode());
            this.gameChooser.init();
            chatRoomId = SessionHandler.getRoomChatId(roomId).orElse(null);
        }
        if (this.newTableDialog == null) {
            this.newTableDialog = new NewTableDialog();
            MageFrame.getDesktop().add((Component)this.newTableDialog, this.newTableDialog.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        }
        if (this.newTournamentDialog == null) {
            this.newTournamentDialog = new NewTournamentDialog();
            MageFrame.getDesktop().add((Component)this.newTournamentDialog, this.newTournamentDialog.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        }
        if (this.joinTableDialog == null) {
            this.joinTableDialog = new JoinTableDialog();
            MageFrame.getDesktop().add((Component)this.joinTableDialog, this.joinTableDialog.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        }
        if (chatRoomId != null) {
            this.chatPanelMain.getUserChatPanel().connect(chatRoomId);
            this.startUpdateTasks(true);
            this.setVisible(true);
            this.repaint();
        } else {
            this.hideTables();
        }
        this.reloadServerMessages();
        MageFrame.getUI().addButton(MageComponents.NEW_GAME_BUTTON, this.btnNewTable);
        this.restoreDividerLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadServerMessages() {
        List<String> serverMessages = SessionHandler.getServerMessages();
        TablesPanel tablesPanel = this;
        synchronized (tablesPanel) {
            this.messages = serverMessages != null ? serverMessages : new ArrayList<String>();
            this.currentMessage = 0;
        }
        if (this.messages.isEmpty()) {
            this.jPanelBottom.setVisible(false);
        } else {
            this.jPanelBottom.setVisible(true);
            URLHandler.RemoveMouseAdapter(this.labelMessageText);
            URLHandler.handleMessage(this.messages.get(0), this.labelMessageText);
            this.buttonNextMessage.setVisible(this.messages.size() > 1);
        }
    }

    public void hideTables() {
        Container c;
        this.saveDividerLocations();
        for (Component component : MageFrame.getDesktop().getComponents()) {
            if (!(component instanceof TableWaitingDialog)) continue;
            ((TableWaitingDialog)component).doClose();
        }
        this.stopTasks();
        this.chatPanelMain.cleanUp();
        for (c = this.getParent(); c != null && !(c instanceof TablesPane); c = c.getParent()) {
        }
        if (c != null) {
            ((TablesPane)c).hideFrame();
        }
    }

    public ChatPanelBasic getChatPanel() {
        return this.chatPanelMain.getUserChatPanel();
    }

    public void setTableFilter() {
        ArrayList stateFilterList = new ArrayList();
        if (this.btnStateWaiting.isSelected()) {
            stateFilterList.add(RowFilter.regexFilter("Waiting", 7));
        }
        if (this.btnStateActive.isSelected()) {
            stateFilterList.add(RowFilter.regexFilter("Dueling|Constructing|Drafting|Sideboard", 7));
        }
        ArrayList typeFilterList = new ArrayList();
        if (this.btnTypeMatch.isSelected()) {
            typeFilterList.add(RowFilter.regexFilter("Two|Commander|Free|Tiny|Momir", 5));
        }
        if (this.btnTypeTourneyConstructed.isSelected()) {
            typeFilterList.add(RowFilter.regexFilter("Constructed", 5));
        }
        if (this.btnTypeTourneyLimited.isSelected()) {
            typeFilterList.add(RowFilter.regexFilter("Booster|Sealed|Jumpstart", 5));
        }
        ArrayList formatFilterList = new ArrayList();
        if (this.btnFormatBlock.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed.*Block", 1));
        }
        if (this.btnFormatStandard.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Standard", 1));
        }
        if (this.btnFormatModern.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Modern", 1));
        }
        if (this.btnFormatPioneer.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Pioneer", 1));
        }
        if (this.btnFormatLegacy.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Legacy", 1));
        }
        if (this.btnFormatVintage.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Vintage", 1));
        }
        if (this.btnFormatPremodern.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Constructed - Premodern", 1));
        }
        if (this.btnFormatCommander.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Commander|^Duel Commander|^Centurion Commander|^Penny Dreadful Commander|^Freeform Commander|^Freeform Unlimited Commander|^MTGO 1v1 Commander|^Duel Brawl|^Brawl", 1));
        }
        if (this.btnFormatTinyLeader.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Tiny", 1));
        }
        if (this.btnFormatOathbreaker.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Oathbreaker", 1));
        }
        if (this.btnFormatLimited.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Limited", 1));
        }
        if (this.btnFormatOther.isSelected()) {
            formatFilterList.add(RowFilter.regexFilter("^Momir Basic|^Constructed - Pauper|^Constructed - Frontier|^Constructed - Extended|^Constructed - Eternal|^Constructed - Historical|^Constructed - Super|^Constructed - Freeform|^Constructed - Freeform Unlimited|^Australian Highlander|^European Highlander|^Canadian Highlander|^Constructed - Old|^Constructed - Historic", 1));
        }
        ArrayList skillFilterList = new ArrayList();
        if (this.btnSkillBeginner.isSelected()) {
            skillFilterList.add(RowFilter.regexFilter(this.tableModel.getSkillLevelAsCode(SkillLevel.BEGINNER, true), 10));
        }
        if (this.btnSkillCasual.isSelected()) {
            skillFilterList.add(RowFilter.regexFilter(this.tableModel.getSkillLevelAsCode(SkillLevel.CASUAL, true), 10));
        }
        if (this.btnSkillSerious.isSelected()) {
            skillFilterList.add(RowFilter.regexFilter(this.tableModel.getSkillLevelAsCode(SkillLevel.SERIOUS, true), 10));
        }
        String ratedMark = "YES";
        ArrayList ratingFilterList = new ArrayList();
        if (this.btnRated.isSelected()) {
            ratingFilterList.add(RowFilter.regexFilter("^" + ratedMark, 11));
        }
        if (this.btnUnrated.isSelected()) {
            ratingFilterList.add(RowFilter.regexFilter("^((?!" + ratedMark + ").)*$", 11));
        }
        String passwordMark = "YES";
        ArrayList passwordFilterList = new ArrayList();
        if (this.btnPassword.isSelected()) {
            passwordFilterList.add(RowFilter.regexFilter("^" + passwordMark, 8));
        }
        if (this.btnOpen.isSelected()) {
            passwordFilterList.add(RowFilter.regexFilter("^((?!" + passwordMark + ").)*$", 8));
        }
        ArrayList<12> ignoreListFilterList = new ArrayList<12>();
        String serverAddress = SessionHandler.getSession().getServerHost();
        final Set<String> ignoreListCopy = IgnoreList.getIgnoredUsers(serverAddress);
        if (!ignoreListCopy.isEmpty()) {
            ignoreListFilterList.add(new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                    String owner = entry.getStringValue(4);
                    return !ignoreListCopy.contains(owner);
                }
            });
        }
        if (stateFilterList.isEmpty() || typeFilterList.isEmpty() || formatFilterList.isEmpty() || skillFilterList.isEmpty() || ratingFilterList.isEmpty() || passwordFilterList.isEmpty()) {
            this.activeTablesSorter.setRowFilter(RowFilter.regexFilter("Nothing", 10));
        } else {
            ArrayList filterList = new ArrayList();
            if (stateFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(stateFilterList));
            } else if (stateFilterList.size() == 1) {
                filterList.addAll(stateFilterList);
            }
            if (typeFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(typeFilterList));
            } else if (typeFilterList.size() == 1) {
                filterList.addAll(typeFilterList);
            }
            if (formatFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(formatFilterList));
            } else if (formatFilterList.size() == 1) {
                filterList.addAll(formatFilterList);
            }
            if (skillFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(skillFilterList));
            } else if (skillFilterList.size() == 1) {
                filterList.addAll(skillFilterList);
            }
            if (ratingFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(ratingFilterList));
            } else if (ratingFilterList.size() == 1) {
                filterList.addAll(ratingFilterList);
            }
            if (passwordFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(passwordFilterList));
            } else if (passwordFilterList.size() == 1) {
                filterList.addAll(passwordFilterList);
            }
            if (ignoreListFilterList.size() > 1) {
                filterList.add(RowFilter.orFilter(ignoreListFilterList));
            } else if (ignoreListFilterList.size() == 1) {
                filterList.addAll(ignoreListFilterList);
            }
            if (filterList.size() == 1) {
                this.activeTablesSorter.setRowFilter((RowFilter)filterList.get(0));
            } else {
                this.activeTablesSorter.setRowFilter(RowFilter.andFilter(filterList));
            }
        }
    }

    private void initComponents() {
        this.jPanelTop = new JPanel();
        this.btnNewTable = new JButton();
        this.btnNewTournament = new JButton();
        this.filterBar1 = new JToolBar();
        this.btnStateWaiting = new JToggleButton();
        this.btnStateActive = new JToggleButton();
        this.btnStateFinished = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnTypeMatch = new JToggleButton();
        this.btnTypeTourneyConstructed = new JToggleButton();
        this.btnTypeTourneyLimited = new JToggleButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.btnSkillBeginner = new JToggleButton();
        this.btnSkillCasual = new JToggleButton();
        this.btnSkillSerious = new JToggleButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.btnRated = new JToggleButton();
        this.btnUnrated = new JToggleButton();
        this.filterBar2 = new JToolBar();
        this.btnFormatBlock = new JToggleButton();
        this.btnFormatStandard = new JToggleButton();
        this.btnFormatModern = new JToggleButton();
        this.btnFormatPioneer = new JToggleButton();
        this.btnFormatLegacy = new JToggleButton();
        this.btnFormatVintage = new JToggleButton();
        this.btnFormatPremodern = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnFormatCommander = new JToggleButton();
        this.btnFormatOathbreaker = new JToggleButton();
        this.btnFormatTinyLeader = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnFormatLimited = new JToggleButton();
        this.btnFormatOther = new JToggleButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.btnOpen = new JToggleButton();
        this.btnPassword = new JToggleButton();
        this.btnQuickStart2Player = new JButton();
        this.btnQuickStart4Player = new JButton();
        this.btnQuickStartMCTS = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanelTables = new JPanel();
        this.jSplitPaneTables = new JSplitPane();
        this.jScrollPaneTablesActive = new JScrollPane();
        this.tableTables = new MageTable();
        this.jScrollPaneTablesFinished = new JScrollPane();
        this.tableCompleted = new JTable();
        this.chatPanelMain = new PlayersChatPanel();
        this.jPanelBottom = new JPanel();
        this.buttonWhatsNew = new JButton();
        this.buttonNextMessage = new JButton();
        this.labelMessageHeader = new JLabel();
        this.labelMessageText = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanelTop.setBackground(Color.white);
        this.jPanelTop.setOpaque(false);
        this.btnNewTable.setIcon(new ImageIcon(this.getClass().getResource("/buttons/match_new.png")));
        this.btnNewTable.setToolTipText("Creates a new match table.");
        this.btnNewTable.setMargin(new Insets(2, 2, 2, 2));
        this.btnNewTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnNewTableActionPerformed(evt);
            }
        });
        this.btnNewTournament.setIcon(new ImageIcon(this.getClass().getResource("/buttons/tourney_new.png")));
        this.btnNewTournament.setToolTipText("Creates a new tourney table.");
        this.btnNewTournament.setMargin(new Insets(2, 2, 2, 2));
        this.btnNewTournament.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnNewTournamentActionPerformed(evt);
            }
        });
        this.filterBar1.setFloatable(false);
        this.filterBar1.setForeground(new Color(102, 102, 255));
        this.filterBar1.setFocusable(false);
        this.filterBar1.setOpaque(false);
        this.btnStateWaiting.setSelected(true);
        this.btnStateWaiting.setToolTipText("Shows all tables waiting for players.");
        this.btnStateWaiting.setActionCommand("stateWait");
        this.btnStateWaiting.setFocusPainted(false);
        this.btnStateWaiting.setFocusable(false);
        this.btnStateWaiting.setHorizontalTextPosition(0);
        this.btnStateWaiting.setRequestFocusEnabled(false);
        this.btnStateWaiting.setVerifyInputWhenFocusTarget(false);
        this.btnStateWaiting.setVerticalTextPosition(3);
        this.btnStateWaiting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnStateWaiting);
        this.btnStateActive.setSelected(true);
        this.btnStateActive.setToolTipText("Shows all tables with active matches.");
        this.btnStateActive.setActionCommand("stateActive");
        this.btnStateActive.setFocusPainted(false);
        this.btnStateActive.setFocusable(false);
        this.btnStateActive.setHorizontalTextPosition(0);
        this.btnStateActive.setRequestFocusEnabled(false);
        this.btnStateActive.setVerifyInputWhenFocusTarget(false);
        this.btnStateActive.setVerticalTextPosition(3);
        this.btnStateActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnStateActive);
        this.btnStateFinished.setSelected(true);
        this.btnStateFinished.setToolTipText("<HTML>Toggles the visibility of the table of completed <br>matches and tournaments in the lower area.\n<br>Showing the last 50 finished matches.");
        this.btnStateFinished.setActionCommand("stateFinished");
        this.btnStateFinished.setFocusPainted(false);
        this.btnStateFinished.setFocusable(false);
        this.btnStateFinished.setHorizontalTextPosition(0);
        this.btnStateFinished.setRequestFocusEnabled(false);
        this.btnStateFinished.setVerifyInputWhenFocusTarget(false);
        this.btnStateFinished.setVerticalTextPosition(3);
        this.btnStateFinished.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnStateFinishedActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnStateFinished);
        this.filterBar1.add(this.jSeparator1);
        this.btnTypeMatch.setSelected(true);
        this.btnTypeMatch.setText("Matches");
        this.btnTypeMatch.setToolTipText("Shows all non tournament tables.");
        this.btnTypeMatch.setActionCommand("typeMatch");
        this.btnTypeMatch.setFocusPainted(false);
        this.btnTypeMatch.setFocusable(false);
        this.btnTypeMatch.setHorizontalTextPosition(0);
        this.btnTypeMatch.setRequestFocusEnabled(false);
        this.btnTypeMatch.setVerifyInputWhenFocusTarget(false);
        this.btnTypeMatch.setVerticalTextPosition(3);
        this.btnTypeMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnTypeMatch);
        this.btnTypeTourneyConstructed.setSelected(true);
        this.btnTypeTourneyConstructed.setText("Constructed tourney");
        this.btnTypeTourneyConstructed.setToolTipText("Shows all constructed tournament tables.");
        this.btnTypeTourneyConstructed.setActionCommand("typeTourneyConstructed");
        this.btnTypeTourneyConstructed.setFocusPainted(false);
        this.btnTypeTourneyConstructed.setFocusable(false);
        this.btnTypeTourneyConstructed.setRequestFocusEnabled(false);
        this.btnTypeTourneyConstructed.setVerifyInputWhenFocusTarget(false);
        this.btnTypeTourneyConstructed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnTypeTourneyConstructed);
        this.btnTypeTourneyLimited.setSelected(true);
        this.btnTypeTourneyLimited.setText("Limited tourney");
        this.btnTypeTourneyLimited.setToolTipText("Shows all limited tournament tables.");
        this.btnTypeTourneyLimited.setActionCommand("typeTourneyLimited");
        this.btnTypeTourneyLimited.setFocusPainted(false);
        this.btnTypeTourneyLimited.setFocusable(false);
        this.btnTypeTourneyLimited.setMaximumSize(new Dimension(72, 20));
        this.btnTypeTourneyLimited.setRequestFocusEnabled(false);
        this.btnTypeTourneyLimited.setVerifyInputWhenFocusTarget(false);
        this.btnTypeTourneyLimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnTypeTourneyLimited);
        this.filterBar1.add(this.jSeparator4);
        this.btnSkillBeginner.setSelected(true);
        this.btnSkillBeginner.setText("Beginner");
        this.btnSkillBeginner.setToolTipText("Shows all tables with skill level beginner.");
        this.btnSkillBeginner.setActionCommand("typeMatch");
        this.btnSkillBeginner.setFocusPainted(false);
        this.btnSkillBeginner.setFocusable(false);
        this.btnSkillBeginner.setHorizontalTextPosition(0);
        this.btnSkillBeginner.setRequestFocusEnabled(false);
        this.btnSkillBeginner.setVerifyInputWhenFocusTarget(false);
        this.btnSkillBeginner.setVerticalTextPosition(3);
        this.btnSkillBeginner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnSkillBeginner);
        this.btnSkillCasual.setSelected(true);
        this.btnSkillCasual.setText("Casual");
        this.btnSkillCasual.setToolTipText("Shows all tables with skill level casual.");
        this.btnSkillCasual.setActionCommand("typeMatch");
        this.btnSkillCasual.setFocusPainted(false);
        this.btnSkillCasual.setFocusable(false);
        this.btnSkillCasual.setHorizontalTextPosition(0);
        this.btnSkillCasual.setRequestFocusEnabled(false);
        this.btnSkillCasual.setVerifyInputWhenFocusTarget(false);
        this.btnSkillCasual.setVerticalTextPosition(3);
        this.btnSkillCasual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnSkillCasual);
        this.btnSkillSerious.setSelected(true);
        this.btnSkillSerious.setText("Serious");
        this.btnSkillSerious.setToolTipText("Shows all tables with skill level serious.");
        this.btnSkillSerious.setActionCommand("typeMatch");
        this.btnSkillSerious.setFocusPainted(false);
        this.btnSkillSerious.setFocusable(false);
        this.btnSkillSerious.setHorizontalTextPosition(0);
        this.btnSkillSerious.setRequestFocusEnabled(false);
        this.btnSkillSerious.setVerifyInputWhenFocusTarget(false);
        this.btnSkillSerious.setVerticalTextPosition(3);
        this.btnSkillSerious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnSkillSerious);
        this.filterBar1.add(this.jSeparator6);
        this.btnRated.setSelected(true);
        this.btnRated.setText("Rated");
        this.btnRated.setToolTipText("Shows all rated tables.");
        this.btnRated.setActionCommand("typeMatch");
        this.btnRated.setFocusPainted(false);
        this.btnRated.setFocusable(false);
        this.btnRated.setHorizontalTextPosition(0);
        this.btnRated.setRequestFocusEnabled(false);
        this.btnRated.setVerifyInputWhenFocusTarget(false);
        this.btnRated.setVerticalTextPosition(3);
        this.btnRated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnRated);
        this.btnUnrated.setSelected(true);
        this.btnUnrated.setText("Unrated");
        this.btnUnrated.setToolTipText("Shows all unrated tables.");
        this.btnUnrated.setActionCommand("typeMatch");
        this.btnUnrated.setFocusPainted(false);
        this.btnUnrated.setFocusable(false);
        this.btnUnrated.setHorizontalTextPosition(0);
        this.btnUnrated.setRequestFocusEnabled(false);
        this.btnUnrated.setVerifyInputWhenFocusTarget(false);
        this.btnUnrated.setVerticalTextPosition(3);
        this.btnUnrated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar1.add(this.btnUnrated);
        this.filterBar2.setFloatable(false);
        this.filterBar2.setFocusable(false);
        this.filterBar2.setOpaque(false);
        this.btnFormatBlock.setSelected(true);
        this.btnFormatBlock.setText("Block");
        this.btnFormatBlock.setToolTipText("Block constructed formats.");
        this.btnFormatBlock.setFocusPainted(false);
        this.btnFormatBlock.setFocusable(false);
        this.btnFormatBlock.setHorizontalTextPosition(0);
        this.btnFormatBlock.setRequestFocusEnabled(false);
        this.btnFormatBlock.setVerifyInputWhenFocusTarget(false);
        this.btnFormatBlock.setVerticalTextPosition(3);
        this.btnFormatBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatBlock);
        this.btnFormatStandard.setSelected(true);
        this.btnFormatStandard.setText("Standard");
        this.btnFormatStandard.setToolTipText("Standard format.");
        this.btnFormatStandard.setFocusPainted(false);
        this.btnFormatStandard.setFocusable(false);
        this.btnFormatStandard.setHorizontalTextPosition(0);
        this.btnFormatStandard.setRequestFocusEnabled(false);
        this.btnFormatStandard.setVerifyInputWhenFocusTarget(false);
        this.btnFormatStandard.setVerticalTextPosition(3);
        this.btnFormatStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatStandard);
        this.btnFormatModern.setSelected(true);
        this.btnFormatModern.setText("Modern");
        this.btnFormatModern.setToolTipText("Modern format.");
        this.btnFormatModern.setFocusPainted(false);
        this.btnFormatModern.setFocusable(false);
        this.btnFormatModern.setRequestFocusEnabled(false);
        this.btnFormatModern.setVerifyInputWhenFocusTarget(false);
        this.btnFormatModern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatModern);
        this.btnFormatPioneer.setSelected(true);
        this.btnFormatPioneer.setText("Pioneer");
        this.btnFormatPioneer.setToolTipText("Pioneer format.");
        this.btnFormatPioneer.setFocusPainted(false);
        this.btnFormatPioneer.setFocusable(false);
        this.btnFormatPioneer.setRequestFocusEnabled(false);
        this.btnFormatPioneer.setVerifyInputWhenFocusTarget(false);
        this.btnFormatPioneer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatPioneer);
        this.btnFormatLegacy.setSelected(true);
        this.btnFormatLegacy.setText("Legacy");
        this.btnFormatLegacy.setToolTipText("Legacy format.");
        this.btnFormatLegacy.setFocusPainted(false);
        this.btnFormatLegacy.setFocusable(false);
        this.btnFormatLegacy.setHorizontalTextPosition(0);
        this.btnFormatLegacy.setRequestFocusEnabled(false);
        this.btnFormatLegacy.setVerifyInputWhenFocusTarget(false);
        this.btnFormatLegacy.setVerticalTextPosition(3);
        this.btnFormatLegacy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatLegacy);
        this.btnFormatVintage.setSelected(true);
        this.btnFormatVintage.setText("Vintage");
        this.btnFormatVintage.setToolTipText("Vintage format.");
        this.btnFormatVintage.setFocusPainted(false);
        this.btnFormatVintage.setFocusable(false);
        this.btnFormatVintage.setHorizontalTextPosition(0);
        this.btnFormatVintage.setRequestFocusEnabled(false);
        this.btnFormatVintage.setVerifyInputWhenFocusTarget(false);
        this.btnFormatVintage.setVerticalTextPosition(3);
        this.btnFormatVintage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatVintage);
        this.btnFormatPremodern.setSelected(true);
        this.btnFormatPremodern.setText("Premodern");
        this.btnFormatPremodern.setToolTipText("Premodern format.");
        this.btnFormatPremodern.setFocusPainted(false);
        this.btnFormatPremodern.setFocusable(false);
        this.btnFormatPremodern.setHorizontalTextPosition(0);
        this.btnFormatPremodern.setRequestFocusEnabled(false);
        this.btnFormatPremodern.setVerifyInputWhenFocusTarget(false);
        this.btnFormatPremodern.setVerticalTextPosition(3);
        this.btnFormatPremodern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatPremodern);
        this.filterBar2.add(this.jSeparator3);
        this.btnFormatCommander.setSelected(true);
        this.btnFormatCommander.setText("Commander");
        this.btnFormatCommander.setToolTipText("Commander format.");
        this.btnFormatCommander.setFocusPainted(false);
        this.btnFormatCommander.setFocusable(false);
        this.btnFormatCommander.setHorizontalTextPosition(0);
        this.btnFormatCommander.setRequestFocusEnabled(false);
        this.btnFormatCommander.setVerifyInputWhenFocusTarget(false);
        this.btnFormatCommander.setVerticalTextPosition(3);
        this.btnFormatCommander.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatCommander);
        this.btnFormatOathbreaker.setSelected(true);
        this.btnFormatOathbreaker.setText("Oathbreaker");
        this.btnFormatOathbreaker.setToolTipText("Oathbreaker format.");
        this.btnFormatOathbreaker.setFocusPainted(false);
        this.btnFormatOathbreaker.setFocusable(false);
        this.btnFormatOathbreaker.setHorizontalTextPosition(0);
        this.btnFormatOathbreaker.setRequestFocusEnabled(false);
        this.btnFormatOathbreaker.setVerifyInputWhenFocusTarget(false);
        this.btnFormatOathbreaker.setVerticalTextPosition(3);
        this.btnFormatOathbreaker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatOathbreaker);
        this.btnFormatTinyLeader.setSelected(true);
        this.btnFormatTinyLeader.setText("Tiny Leader");
        this.btnFormatTinyLeader.setToolTipText("Tiny Leader format.");
        this.btnFormatTinyLeader.setFocusPainted(false);
        this.btnFormatTinyLeader.setFocusable(false);
        this.btnFormatTinyLeader.setRequestFocusEnabled(false);
        this.btnFormatTinyLeader.setVerifyInputWhenFocusTarget(false);
        this.btnFormatTinyLeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatTinyLeader);
        this.filterBar2.add(this.jSeparator2);
        this.btnFormatLimited.setSelected(true);
        this.btnFormatLimited.setText("Limited");
        this.btnFormatLimited.setToolTipText("Limited format.");
        this.btnFormatLimited.setFocusPainted(false);
        this.btnFormatLimited.setFocusable(false);
        this.btnFormatLimited.setHorizontalTextPosition(0);
        this.btnFormatLimited.setRequestFocusEnabled(false);
        this.btnFormatLimited.setVerifyInputWhenFocusTarget(false);
        this.btnFormatLimited.setVerticalTextPosition(3);
        this.btnFormatLimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatLimited);
        this.btnFormatOther.setSelected(true);
        this.btnFormatOther.setText("Other");
        this.btnFormatOther.setToolTipText("Other formats (Freeform, Pauper, Historic, Extended, etc.)");
        this.btnFormatOther.setFocusPainted(false);
        this.btnFormatOther.setFocusable(false);
        this.btnFormatOther.setRequestFocusEnabled(false);
        this.btnFormatOther.setVerifyInputWhenFocusTarget(false);
        this.btnFormatOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnFormatOther);
        this.filterBar2.add(this.jSeparator5);
        this.btnOpen.setSelected(true);
        this.btnOpen.setText("Open");
        this.btnOpen.setToolTipText("Show open games");
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.setFocusable(false);
        this.btnOpen.setHorizontalTextPosition(0);
        this.btnOpen.setRequestFocusEnabled(false);
        this.btnOpen.setVerifyInputWhenFocusTarget(false);
        this.btnOpen.setVerticalTextPosition(3);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnOpen);
        this.btnPassword.setSelected(true);
        this.btnPassword.setText("PW");
        this.btnPassword.setToolTipText("Show passworded games");
        this.btnPassword.setFocusPainted(false);
        this.btnPassword.setFocusable(false);
        this.btnPassword.setHorizontalTextPosition(0);
        this.btnPassword.setRequestFocusEnabled(false);
        this.btnPassword.setVerifyInputWhenFocusTarget(false);
        this.btnPassword.setVerticalTextPosition(3);
        this.btnPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnFilterActionPerformed(evt);
            }
        });
        this.filterBar2.add(this.btnPassword);
        this.btnQuickStart2Player.setText("Quick 2 player");
        this.btnQuickStart2Player.setFocusable(false);
        this.btnQuickStart2Player.setHorizontalTextPosition(0);
        this.btnQuickStart2Player.setVerticalTextPosition(3);
        this.btnQuickStart2Player.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnQuickStart2PlayerActionPerformed(evt);
            }
        });
        this.btnQuickStart4Player.setText("Quick 4 player");
        this.btnQuickStart4Player.setFocusable(false);
        this.btnQuickStart4Player.setHorizontalTextPosition(0);
        this.btnQuickStart4Player.setVerticalTextPosition(3);
        this.btnQuickStart4Player.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnQuickStart4PlayerActionPerformed(evt);
            }
        });
        this.btnQuickStartMCTS.setText("Quick start MCTS");
        this.btnQuickStartMCTS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.btnQuickStartMCTSActionPerformed(evt);
            }
        });
        GroupLayout jPanelTopLayout = new GroupLayout(this.jPanelTop);
        this.jPanelTop.setLayout(jPanelTopLayout);
        jPanelTopLayout.setHorizontalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addContainerGap().addComponent(this.btnNewTable).addGap(6, 6, 6).addComponent(this.btnNewTournament).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.filterBar1, -1, -1, Short.MAX_VALUE).addComponent(this.filterBar2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.btnQuickStart2Player).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnQuickStartMCTS)).addComponent(this.btnQuickStart4Player)).addContainerGap(540, Short.MAX_VALUE)));
        jPanelTopLayout.setVerticalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNewTable).addComponent(this.btnNewTournament)).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterBar1, -1, -1, Short.MAX_VALUE).addGroup(jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnQuickStart2Player).addComponent(this.btnQuickStartMCTS)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterBar2, -1, -1, Short.MAX_VALUE).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.btnQuickStart4Player).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanelTop, gridBagConstraints);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPaneTables.setBorder(null);
        this.jSplitPaneTables.setDividerSize(10);
        this.jSplitPaneTables.setOrientation(0);
        this.jSplitPaneTables.setResizeWeight(0.5);
        this.jScrollPaneTablesActive.setBorder(null);
        this.jScrollPaneTablesActive.setViewportBorder(null);
        this.tableTables.setModel(this.tableModel);
        this.jScrollPaneTablesActive.setViewportView(this.tableTables);
        this.jSplitPaneTables.setLeftComponent(this.jScrollPaneTablesActive);
        this.jScrollPaneTablesFinished.setBorder(null);
        this.jScrollPaneTablesFinished.setViewportBorder(null);
        this.jScrollPaneTablesFinished.setMinimumSize(new Dimension(23, 0));
        this.tableCompleted.setModel(this.matchesModel);
        this.jScrollPaneTablesFinished.setViewportView(this.tableCompleted);
        this.jSplitPaneTables.setRightComponent(this.jScrollPaneTablesFinished);
        GroupLayout jPanelTablesLayout = new GroupLayout(this.jPanelTables);
        this.jPanelTables.setLayout(jPanelTablesLayout);
        jPanelTablesLayout.setHorizontalGroup(jPanelTablesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneTables, -1, 23, Short.MAX_VALUE));
        jPanelTablesLayout.setVerticalGroup(jPanelTablesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneTables, -1, 672, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanelTables);
        this.jSplitPane1.setRightComponent(this.chatPanelMain);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanelBottom.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanelBottom.setPreferredSize(new Dimension(516, 37));
        this.jPanelBottom.setLayout(new FlowLayout(0));
        this.buttonWhatsNew.setText("Show what's new");
        this.buttonWhatsNew.setHorizontalAlignment(2);
        this.buttonWhatsNew.setHorizontalTextPosition(0);
        this.buttonWhatsNew.setOpaque(false);
        this.buttonWhatsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.buttonWhatsNewActionPerformed(evt);
            }
        });
        this.jPanelBottom.add(this.buttonWhatsNew);
        this.buttonNextMessage.setText("Next message");
        this.buttonNextMessage.setHorizontalAlignment(2);
        this.buttonNextMessage.setHorizontalTextPosition(0);
        this.buttonNextMessage.setOpaque(false);
        this.buttonNextMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TablesPanel.this.buttonNextMessageActionPerformed(evt);
            }
        });
        this.jPanelBottom.add(this.buttonNextMessage);
        this.labelMessageHeader.setFont(new Font("Tahoma", 1, 11));
        this.labelMessageHeader.setHorizontalAlignment(2);
        this.labelMessageHeader.setText("Message of the Day:");
        this.labelMessageHeader.setAlignmentY(0.3f);
        this.jPanelBottom.add(this.labelMessageHeader);
        this.labelMessageText.setHorizontalAlignment(2);
        this.labelMessageText.setText("You are playing Mage version 0.7.5. Welcome! -- Mage dev team --");
        this.jPanelBottom.add(this.labelMessageText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanelBottom, gridBagConstraints);
    }

    private void btnNewTournamentActionPerformed(ActionEvent evt) {
        this.newTournamentDialog.showDialog(this.roomId);
    }

    private void createTestGame(String gameName, String gameType, boolean useMonteCarloAI) {
        try {
            String testDeckFile = "test.dck";
            File f = new File(testDeckFile);
            if (!f.exists()) {
                testDeckFile = DeckUtil.writeTextToTempFile("5 Swamp" + System.lineSeparator() + "5 Forest" + System.lineSeparator() + "5 Island" + System.lineSeparator() + "5 Mountain" + System.lineSeparator() + "5 Plains");
            }
            DeckCardLists testDeck = DeckImporter.importDeckFromFile(testDeckFile, false);
            PlayerType aiType = useMonteCarloAI ? PlayerType.COMPUTER_MONTE_CARLO : PlayerType.COMPUTER_MAD;
            int numPlayers = gameName.contains("2") || gameName.contains("Monte Carlo") ? 2 : 4;
            boolean multiPlayer = numPlayers > 2;
            MatchOptions options = new MatchOptions(gameName, gameType, multiPlayer);
            options.getPlayerTypes().add(PlayerType.HUMAN);
            options.getPlayerTypes().add(aiType);
            for (int i = 2; i < numPlayers; ++i) {
                options.getPlayerTypes().add(aiType);
            }
            options.setDeckType("Variant Magic - Freeform Commander");
            options.setAttackOption(MultiplayerAttackOption.MULTIPLE);
            options.setRange(RangeOfInfluence.ONE);
            options.setWinsNeeded(2);
            options.setMatchTimeLimit(MatchTimeLimit.NONE);
            options.setMatchBufferTime(MatchBufferTime.NONE);
            options.setFreeMulligans(2);
            options.setSkillLevel(SkillLevel.CASUAL);
            options.setRollbackTurnsAllowed(true);
            options.setQuitRatio(100);
            options.setMinimumRating(0);
            String serverAddress = SessionHandler.getSession().getServerHost();
            options.setBannedUsers(IgnoreList.getIgnoredUsers(serverAddress));
            TableView table = SessionHandler.createTable(this.roomId, options);
            SessionHandler.joinTable(this.roomId, table.getTableId(), "Human", PlayerType.HUMAN, 1, testDeck, "");
            SessionHandler.joinTable(this.roomId, table.getTableId(), "Computer", aiType, 1, testDeck, "");
            for (int i = 2; i < numPlayers; ++i) {
                SessionHandler.joinTable(this.roomId, table.getTableId(), "Computer" + i, aiType, 1, testDeck, "");
            }
            SessionHandler.startMatch(this.roomId, table.getTableId());
        }
        catch (HeadlessException ex) {
            this.handleError(ex);
        }
    }

    private void btnNewTableActionPerformed(ActionEvent evt) {
        this.newTableDialog.showDialog(this.roomId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buttonNextMessageActionPerformed(ActionEvent evt) {
        TablesPanel tablesPanel = this;
        synchronized (tablesPanel) {
            if (this.messages != null && !this.messages.isEmpty()) {
                ++this.currentMessage;
                if (this.currentMessage >= this.messages.size()) {
                    this.currentMessage = 0;
                }
                URLHandler.RemoveMouseAdapter(this.labelMessageText);
                URLHandler.handleMessage(this.messages.get(this.currentMessage), this.labelMessageText);
            }
        }
    }

    private void btnFilterActionPerformed(ActionEvent evt) {
        this.setTableFilter();
    }

    private void btnStateFinishedActionPerformed(ActionEvent evt) {
        if (this.btnStateFinished.isSelected()) {
            this.jSplitPaneTables.setDividerLocation(-1);
        } else {
            this.jSplitPaneTables.setDividerLocation(this.jPanelTables.getHeight());
        }
        this.startUpdateTasks(true);
    }

    private void buttonWhatsNewActionPerformed(ActionEvent evt) {
        MageFrame.getInstance().showWhatsNewDialog(true);
    }

    private void btnQuickStart2PlayerActionPerformed(ActionEvent evt) {
        this.createTestGame("Test 2 player", "Commander Free For All", false);
    }

    private void btnQuickStart4PlayerActionPerformed(ActionEvent evt) {
        this.createTestGame("Test 4 player", "Commander Free For All", false);
    }

    private void btnQuickStartMCTSActionPerformed(ActionEvent evt) {
        this.createTestGame("Test Monte Carlo AI", "Two Player Duel", true);
    }

    private void handleError(Exception ex) {
        LOGGER.fatal((Object)"Error loading deck: ", (Throwable)ex);
        JOptionPane.showMessageDialog(MageFrame.getDesktop(), "Error loading deck.", "Error", 0);
    }
}

