/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import mage.client.SessionHandler;
import mage.components.table.TableModelWithTooltip;
import mage.constants.SkillLevel;
import mage.remote.MageRemoteException;
import mage.view.TableView;

public class TablesTableModel
extends AbstractTableModel
implements TableModelWithTooltip {
    final ImageIcon tourneyIcon = new ImageIcon(this.getClass().getResource("/tables/tourney_icon.png")){

        @Override
        public String toString() {
            return "Tourney";
        }
    };
    final ImageIcon matchIcon = new ImageIcon(this.getClass().getResource("/tables/match_icon.png")){

        @Override
        public String toString() {
            return "Match";
        }
    };
    public static final int COLUMN_ICON = 0;
    public static final int COLUMN_DECK_TYPE = 1;
    public static final int COLUMN_NAME = 2;
    public static final int COLUMN_SEATS = 3;
    public static final int COLUMN_OWNER = 4;
    public static final int COLUMN_GAME_TYPE = 5;
    public static final int COLUMN_INFO = 6;
    public static final int COLUMN_STATUS = 7;
    public static final int COLUMN_PASSWORD = 8;
    public static final int COLUMN_CREATED = 9;
    public static final int COLUMN_SKILL = 10;
    public static final int COLUMN_RATING = 11;
    public static final int COLUMN_QUIT_RATIO = 12;
    public static final int COLUMN_MINIMUM_RATING = 13;
    public static final int ACTION_COLUMN = 14;
    public static final String RATED_VALUE_YES = "YES";
    public static final String RATED_VALUE_NO = "";
    public static final String PASSWORD_VALUE_YES = "YES";
    private final String[] columnNames = new String[]{"M/T", "Deck Type", "Name", "Seats", "Owner / Players", "Game Type", "Info", "Status", "Password", "Created / Started", "Skill Level", "Rated", "Quit %", "Min Rating", "Action"};
    private TableView[] tables = new TableView[0];

    TablesTableModel() {
    }

    public void loadData(Collection<TableView> tables) throws MageRemoteException {
        this.tables = tables.toArray(new TableView[0]);
        this.fireTableDataChanged();
    }

    public String getTableAndGameInfo(int row) {
        return this.tables[row].getTableId().toString() + ";" + (!this.tables[row].getGames().isEmpty() ? ((UUID)this.tables[row].getGames().get(0)).toString() : "null");
    }

    public String findTableAndGameInfoByRow(int row) {
        if (row >= 0 && row < this.tables.length) {
            return this.getTableAndGameInfo(row);
        }
        return null;
    }

    public int findRowByTableAndGameInfo(String tableAndGame) {
        for (int i = 0; i < this.tables.length; ++i) {
            String rowID = this.tables[i].getTableId().toString() + ";" + (!this.tables[i].getGames().isEmpty() ? ((UUID)this.tables[i].getGames().get(0)).toString() : "null");
            if (!tableAndGame.equals(rowID)) continue;
            return i;
        }
        return -1;
    }

    public String getSkillLevelAsCode(SkillLevel skill, boolean asRegExp) {
        String res;
        switch (skill) {
            case BEGINNER: {
                res = "*";
                break;
            }
            case CASUAL: {
                res = "**";
                break;
            }
            case SERIOUS: {
                res = "***";
                break;
            }
            default: {
                res = RATED_VALUE_NO;
            }
        }
        if (asRegExp) {
            res = String.format("^%s$", res.replace("*", "\\*"));
        }
        return res;
    }

    @Override
    public int getRowCount() {
        return this.tables.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.tables[rowIndex].isTournament() ? this.tourneyIcon : this.matchIcon;
            }
            case 1: {
                return this.tables[rowIndex].getDeckType();
            }
            case 2: {
                return this.tables[rowIndex].getTableName();
            }
            case 3: {
                return this.tables[rowIndex].getSeatsInfo();
            }
            case 4: {
                return this.tables[rowIndex].getControllerName();
            }
            case 5: {
                return this.tables[rowIndex].getGameType();
            }
            case 6: {
                return this.tables[rowIndex].getAdditionalInfoShort();
            }
            case 7: {
                return this.tables[rowIndex].getTableStateText();
            }
            case 8: {
                return this.tables[rowIndex].isPassworded() ? "YES" : RATED_VALUE_NO;
            }
            case 9: {
                return this.tables[rowIndex].getCreateTime();
            }
            case 10: {
                return this.getSkillLevelAsCode(this.tables[rowIndex].getSkillLevel(), false);
            }
            case 11: {
                return this.tables[rowIndex].isRated() ? "YES" : RATED_VALUE_NO;
            }
            case 12: {
                return this.tables[rowIndex].getQuitRatio();
            }
            case 13: {
                return this.tables[rowIndex].getMinimumRating();
            }
            case 14: {
                switch (this.tables[rowIndex].getTableState()) {
                    case WAITING: {
                        String owner = this.tables[rowIndex].getControllerName();
                        if (SessionHandler.getSession() != null && owner.equals(SessionHandler.getUserName())) {
                            return RATED_VALUE_NO;
                        }
                        return "Join";
                    }
                    case CONSTRUCTING: 
                    case DRAFTING: {
                        if (this.tables[rowIndex].isTournament()) {
                            return "Show";
                        }
                    }
                    case DUELING: {
                        if (this.tables[rowIndex].isTournament()) {
                            return "Show";
                        }
                        String owner = this.tables[rowIndex].getControllerName();
                        if (SessionHandler.getSession() != null && owner.equals(SessionHandler.getUserName())) {
                            return RATED_VALUE_NO;
                        }
                        if (this.tables[rowIndex].getSpectatorsAllowed()) {
                            return "Watch";
                        }
                        return RATED_VALUE_NO;
                    }
                }
                return RATED_VALUE_NO;
            }
            case 15: {
                return this.tables[rowIndex].isTournament();
            }
            case 16: {
                if (!this.tables[rowIndex].getGames().isEmpty()) {
                    return this.tables[rowIndex].getGames().get(0);
                }
                return null;
            }
            case 17: {
                return this.tables[rowIndex].getTableId();
            }
        }
        return RATED_VALUE_NO;
    }

    public String getTooltipAt(int rowIndex, int columnIndex) {
        Object res;
        switch (columnIndex) {
            case 6: {
                res = this.tables[rowIndex].getAdditionalInfoFull();
                break;
            }
            default: {
                res = this.getValueAt(rowIndex, columnIndex);
            }
        }
        return res.toString();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colName = RATED_VALUE_NO;
        if (columnIndex <= this.getColumnCount()) {
            colName = this.columnNames[columnIndex];
        }
        return colName;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
            case 10: {
                return SkillLevel.class;
            }
            case 9: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 14;
    }
}

