/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import mage.cards.decks.DeckCardLists;
import mage.client.SessionHandler;
import mage.client.table.TablePlayerPanel;
import mage.client.util.ClientDefaultSettings;
import mage.players.PlayerType;

public class TournamentPlayerPanel
extends JPanel {
    private JComboBox cbPlayerType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel lblPlayerNum;
    private JPanel pnlPlayerName;
    private JSpinner spnLevel;
    private JTextField txtPlayerName;

    public TournamentPlayerPanel() {
        this.initComponents();
        this.pnlPlayerName.setVisible(false);
    }

    public void init(int playerNum, PlayerType playerType, int playerSkill) {
        this.cbPlayerType.setModel(new DefaultComboBoxModel<PlayerType>(SessionHandler.getPlayerTypes()));
        this.lblPlayerNum.setText("Player " + playerNum);
        if (ClientDefaultSettings.otherPlayerIndex != null) {
            Integer index = Integer.parseInt(ClientDefaultSettings.otherPlayerIndex);
            if (index >= this.cbPlayerType.getItemCount()) {
                this.cbPlayerType.setSelectedIndex(this.cbPlayerType.getItemCount() - 1);
            } else {
                this.cbPlayerType.setSelectedIndex(index);
            }
        }
        if (playerType != null) {
            this.cbPlayerType.setSelectedItem((Object)playerType);
        }
        this.spnLevel.setValue(playerSkill);
    }

    public JComboBox getPlayerType() {
        return this.cbPlayerType;
    }

    public int getPlayerSkill() {
        return (Integer)this.spnLevel.getValue();
    }

    public boolean joinTournamentTable(UUID roomId, UUID tableId, DeckCardLists deckCardLists) {
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            return SessionHandler.joinTournamentTable(roomId, tableId, this.txtPlayerName.getText(), (PlayerType)((Object)this.cbPlayerType.getSelectedItem()), (Integer)this.spnLevel.getValue(), deckCardLists, "");
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbPlayerType = new JComboBox();
        this.lblPlayerNum = new JLabel();
        this.pnlPlayerName = new JPanel();
        this.txtPlayerName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.spnLevel = new JSpinner();
        this.jLabel1.setLabelFor(this.cbPlayerType);
        this.jLabel1.setText("Type:");
        this.cbPlayerType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPlayerType.addActionListener(evt -> this.cbPlayerTypeActionPerformed(evt));
        this.lblPlayerNum.setFont(new Font("Tahoma", 1, 11));
        this.lblPlayerNum.setText("Player Num:");
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Skill:");
        this.spnLevel.setModel(new SpinnerNumberModel(2, 1, 10, 1));
        this.spnLevel.setRequestFocusEnabled(false);
        GroupLayout pnlPlayerNameLayout = new GroupLayout(this.pnlPlayerName);
        this.pnlPlayerName.setLayout(pnlPlayerNameLayout);
        pnlPlayerNameLayout.setHorizontalGroup(pnlPlayerNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPlayerNameLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnLevel, -2, 51, -2).addGap(67, 67, 67).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPlayerName, -1, 130, Short.MAX_VALUE)));
        pnlPlayerNameLayout.setVerticalGroup(pnlPlayerNameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPlayerNameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPlayerName, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.spnLevel, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblPlayerNum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlayerType, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPlayerName, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblPlayerNum).addComponent(this.jLabel1).addComponent(this.cbPlayerType, -2, -1, -2)).addComponent(this.pnlPlayerName, -2, -1, -2));
    }

    private void cbPlayerTypeActionPerformed(ActionEvent evt) {
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            this.pnlPlayerName.setVisible(true);
            this.txtPlayerName.setText(TablePlayerPanel.extractAiPlayerNumberFromLabel(this.lblPlayerNum.getText()));
            this.txtPlayerName.setEditable(false);
            this.txtPlayerName.setEnabled(false);
        } else {
            this.pnlPlayerName.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }
}

