/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.client.SessionHandler;
import mage.client.table.TablesPanel;
import mage.client.table.UpdateTablesTask;
import mage.view.MatchView;
import org.apache.log4j.Logger;

class UpdateMatchesTask
extends SwingWorker<Void, Collection<MatchView>> {
    private final UUID roomId;
    private final TablesPanel panel;
    private static final Logger logger = Logger.getLogger(UpdateTablesTask.class);

    UpdateMatchesTask(UUID roomId, TablesPanel panel) {
        this.roomId = roomId;
        this.panel = panel;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            this.publish(SessionHandler.getFinishedMatches(this.roomId));
            TimeUnit.SECONDS.sleep(TablesPanel.randomizeTimout(30));
        }
        return null;
    }

    @Override
    protected void process(List<Collection<MatchView>> view) {
        this.panel.updateMatches(view.get(0));
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Matches Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

