/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.client.SessionHandler;
import mage.client.table.PlayersChatPanel;
import mage.client.table.TablesPanel;
import mage.view.RoomUsersView;
import org.apache.log4j.Logger;

class UpdatePlayersTask
extends SwingWorker<Void, Collection<RoomUsersView>> {
    private final UUID roomId;
    private final PlayersChatPanel chat;
    private static final Logger logger = Logger.getLogger(UpdatePlayersTask.class);

    UpdatePlayersTask(UUID roomId, PlayersChatPanel chat) {
        this.roomId = roomId;
        this.chat = chat;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            this.publish(SessionHandler.getRoomUsers(this.roomId));
            TimeUnit.SECONDS.sleep(TablesPanel.randomizeTimout(10));
        }
        return null;
    }

    @Override
    protected void process(List<Collection<RoomUsersView>> roomUserInfo) {
        this.chat.setRoomUserInfo(roomUserInfo);
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Players Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

