/*
 * Decompiled with CFR 0.152.
 */
package mage.client.table;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import mage.client.SessionHandler;
import mage.client.table.TablesPanel;
import mage.view.TableView;
import org.apache.log4j.Logger;

class UpdateTablesTask
extends SwingWorker<Void, Collection<TableView>> {
    private final UUID roomId;
    private final TablesPanel panel;
    private boolean isFirstRun = true;
    private static final Logger logger = Logger.getLogger(UpdateTablesTask.class);
    private int count = 0;

    UpdateTablesTask(UUID roomId, TablesPanel panel) {
        this.roomId = roomId;
        this.panel = panel;
    }

    @Override
    protected Void doInBackground() throws Exception {
        while (!this.isCancelled()) {
            Collection<TableView> tables = SessionHandler.getTables(this.roomId);
            if (tables != null) {
                this.publish(tables);
            }
            TimeUnit.SECONDS.sleep(TablesPanel.randomizeTimout(5));
        }
        return null;
    }

    @Override
    protected void process(List<Collection<TableView>> view) {
        this.panel.updateTables(view.get(0));
        ++this.count;
        if (this.isFirstRun || this.count > 60) {
            this.count = 0;
            this.isFirstRun = false;
            this.panel.reloadServerMessages();
        }
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.fatal((Object)"Update Tables Task error", (Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

