/*
 * Decompiled with CFR 0.152.
 */
package mage.client.themes;

import java.awt.Color;
import mage.abilities.hint.HintUtils;
import mage.abilities.icon.CardIconColor;
import mage.client.util.GUISizeHelper;
import org.mage.card.arcane.SvgUtils;

public enum ThemeType {
    DEFAULT("Default", "", true, false, true, true, true, true, true, new Color(169, 176, 190), new Color(214, 217, 223), new Color(255, 255, 255), new Color(242, 242, 189), new Color(51, 98, 140), null, new Color(200, 200, 180, 200), new Color(200, 255, 200, 200), new Color(131, 94, 83, 200), new Color(250, 250, 250, 150), new Color(169, 176, 190), Color.black, new Color(51, 98, 140), Color.black),
    GREY("Grey", "grey-theme/", false, false, false, false, false, true, true, new Color(158, 158, 158), new Color(212, 212, 212), new Color(215, 215, 215), new Color(189, 189, 164), new Color(102, 102, 102), null, new Color(172, 172, 172, 200), new Color(180, 234, 180, 200), new Color(99, 99, 99, 200), new Color(250, 250, 250, 150), new Color(158, 158, 158), Color.black, Color.black, Color.black),
    SUNSET_VAPORWAVE("Vaporwave Sunset", "16bit-theme/", true, true, false, true, true, true, false, new Color(246, 136, 158), new Color(243, 233, 164), new Color(204, 236, 201), new Color(117, 174, 238), new Color(106, 0, 255), new Color(192, 166, 232), new Color(243, 233, 164), new Color(204, 236, 201), new Color(106, 0, 255), new Color(250, 250, 250, 150), new Color(246, 136, 158), Color.black, new Color(106, 0, 255), Color.black),
    COFFEE("Coffee", "coffee-theme/", true, true, true, true, true, true, false, new Color(219, 193, 172), new Color(182, 157, 135), new Color(219, 193, 172), new Color(219, 197, 182), new Color(97, 27, 0), new Color(219, 193, 172), new Color(219, 193, 172), new Color(204, 236, 201), new Color(99, 72, 50, 255), new Color(250, 250, 250, 150), new Color(219, 193, 172), Color.black, new Color(97, 27, 0), Color.black),
    ISLAND("Island", "island-theme/", true, true, false, true, true, true, false, new Color(172, 197, 219), new Color(135, 158, 182), new Color(172, 197, 219), new Color(182, 200, 219), new Color(0, 78, 97), new Color(172, 195, 219), new Color(172, 195, 219), new Color(204, 236, 201), new Color(50, 68, 99, 255), new Color(250, 250, 250, 150), new Color(172, 197, 219), Color.black, new Color(0, 78, 97), Color.black),
    CARBON_FIBER("Carbon Fiber", "carbon_fiber-theme/", true, true, true, true, true, true, true, new Color(43, 45, 49), new Color(49, 51, 56), new Color(58, 56, 64), new Color(58, 56, 64), new Color(25, 25, 25), new Color(43, 45, 49), new Color(43, 45, 49), new Color(64, 61, 56), new Color(50, 68, 99, 255), new Color(50, 50, 50, 250), new Color(172, 197, 219), Color.BLACK, new Color(0, 78, 97), new Color(220, 220, 220));

    private final String name;
    private final String path;
    private final boolean hasBackground;
    private final boolean hasLoginBackground;
    private final boolean hasBattleBackground;
    private final boolean hasSkipButtons;
    private final boolean hasPhaseIcons;
    private final boolean hasWinLossImages;
    private final boolean shortcutsVisibleForSkipButtons;
    private final Color nimbusBlueGrey;
    private final Color control;
    private final Color nimbusLightBackground;
    private final Color info;
    private final Color nimbusBase;
    private final Color mageToolbar;
    private final Color playerPanel_inactiveBackgroundColor;
    private final Color playerPanel_activeBackgroundColor;
    private final Color playerPanel_deadBackgroundColor;
    private final Color deckEditorToolbarBackgroundColor;
    private final Color cardIconsFillColor;
    private final Color cardIconsStrokeColor;
    private final Color cardIconsTextColor;
    private final Color textColor;

    private ThemeType(String name, String path, boolean hasBackground, boolean hasLoginBackground, boolean hasBattleBackground, boolean hasSkipButtons, boolean hasPhaseIcons, boolean hasWinLossImages, boolean shortcutsVisibleForSkipButtons, Color nimbusBlueGrey, Color control, Color nimbusLightBackground, Color info, Color nimbusBase, Color mageToolbar, Color playerPanel_inactiveBackgroundColor, Color playerPanel_activeBackgroundColor, Color playerPanel_deadBackgroundColor, Color deckEditorToolbarBackgroundColor, Color cardIconsFillColor, Color cardIconsStrokeColor, Color cardIconsTextColor, Color textColor) {
        this.name = name;
        this.path = path;
        this.hasBackground = hasBackground;
        this.hasLoginBackground = hasLoginBackground;
        this.hasBattleBackground = hasBattleBackground;
        this.hasSkipButtons = hasSkipButtons;
        this.hasPhaseIcons = hasPhaseIcons;
        this.hasWinLossImages = hasWinLossImages;
        this.shortcutsVisibleForSkipButtons = shortcutsVisibleForSkipButtons;
        this.nimbusBlueGrey = nimbusBlueGrey;
        this.control = control;
        this.nimbusLightBackground = nimbusLightBackground;
        this.info = info;
        this.nimbusBase = nimbusBase;
        this.mageToolbar = mageToolbar;
        this.playerPanel_activeBackgroundColor = playerPanel_activeBackgroundColor;
        this.playerPanel_deadBackgroundColor = playerPanel_deadBackgroundColor;
        this.playerPanel_inactiveBackgroundColor = playerPanel_inactiveBackgroundColor;
        this.deckEditorToolbarBackgroundColor = deckEditorToolbarBackgroundColor;
        this.cardIconsFillColor = cardIconsFillColor;
        this.cardIconsStrokeColor = cardIconsStrokeColor;
        this.cardIconsTextColor = cardIconsTextColor;
        this.textColor = textColor;
    }

    public String toString() {
        return this.name;
    }

    public static ThemeType valueByName(String value) {
        for (ThemeType themeType : ThemeType.values()) {
            if (!themeType.name.equals(value)) continue;
            return themeType;
        }
        return DEFAULT;
    }

    public String getName() {
        return this.name;
    }

    public boolean isShortcutsVisibleForSkipButtons() {
        return this.shortcutsVisibleForSkipButtons;
    }

    public Color getNimbusBlueGrey() {
        return this.nimbusBlueGrey;
    }

    public Color getControl() {
        return this.control;
    }

    public Color getNimbusLightBackground() {
        return this.nimbusLightBackground;
    }

    public Color getInfo() {
        return this.info;
    }

    public Color getNimbusBase() {
        return this.nimbusBase;
    }

    public Color getMageToolbar() {
        return this.mageToolbar;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getPlayerPanel_inactiveBackgroundColor() {
        return this.playerPanel_inactiveBackgroundColor;
    }

    public Color getPlayerPanel_activeBackgroundColor() {
        return this.playerPanel_activeBackgroundColor;
    }

    public Color getPlayerPanel_deadBackgroundColor() {
        return this.playerPanel_deadBackgroundColor;
    }

    public Color getDeckEditorToolbarBackgroundColor() {
        return this.deckEditorToolbarBackgroundColor;
    }

    private String getImagePath(String imageType, String name) {
        return "/" + imageType + "/" + this.path + name;
    }

    public String getButtonPath(String name) {
        if (this.hasSkipButtons) {
            return this.getImagePath("buttons", name);
        }
        return "/buttons/" + name;
    }

    public String getPhasePath(String name) {
        if (this.hasPhaseIcons) {
            return this.getImagePath("phases", name);
        }
        return "/phases/" + name;
    }

    public String getWinlossPath(String name) {
        if (this.hasWinLossImages) {
            return this.getImagePath("winloss", name);
        }
        return "/winloss/" + name;
    }

    public String getBackgroundPath() {
        if (this.hasBackground) {
            return this.getImagePath("background", "background.png");
        }
        return "/background/background.png";
    }

    public String getLoginBackgroundPath() {
        if (this.hasLoginBackground) {
            return this.getImagePath("background", "login-background.png");
        }
        return this.getBackgroundPath();
    }

    public String getBattleBackgroundPath() {
        if (this.hasBattleBackground) {
            return this.getImagePath("background", "battle-background.png");
        }
        return this.getBackgroundPath();
    }

    public Color getCardIconsFillColor(CardIconColor cardIconColor) {
        return cardIconColor.getFillColor() != null ? cardIconColor.getFillColor() : this.cardIconsFillColor;
    }

    public Color getCardIconsStrokeColor(CardIconColor cardIconColor) {
        return cardIconColor.getStrokeColor() != null ? cardIconColor.getStrokeColor() : this.cardIconsStrokeColor;
    }

    public Color getCardIconsTextColor(CardIconColor cardIconColor) {
        return cardIconColor.getTextColor() != null ? cardIconColor.getTextColor() : this.cardIconsTextColor;
    }

    public String getCardIconsResourcePath(String resourceName) {
        return "/card/icons/" + resourceName;
    }

    public String getCardIconsCssFile(CardIconColor cardIconColor) {
        return String.format("card-icons-svg-settings-%s.css", cardIconColor.toString());
    }

    public String getCardIconsCssSettings(CardIconColor cardIconColor) {
        String fillColorVal = HintUtils.colorToHtml(this.getCardIconsFillColor(cardIconColor));
        String strokeColorVal = HintUtils.colorToHtml(this.getCardIconsStrokeColor(cardIconColor));
        return String.format("fill: %s;stroke: %s;stroke-width: 0.5;stroke-opacity: 0.7;", fillColorVal, strokeColorVal);
    }

    public void reload() {
        for (CardIconColor cardIconColor : CardIconColor.values()) {
            SvgUtils.prepareCss(this.getCardIconsCssFile(cardIconColor), this.getCardIconsCssSettings(cardIconColor), true);
        }
        GUISizeHelper.refreshGUIAndCards(true);
    }
}

