/*
 * Decompiled with CFR 0.152.
 */
package mage.client.tournament;

import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import mage.view.TournamentPlayerView;
import mage.view.TournamentView;

class TournamentPlayersTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Loc", "Player Name", "State", "Points", "Results", "History"};
    private TournamentPlayerView[] players = new TournamentPlayerView[0];

    TournamentPlayersTableModel() {
    }

    public void loadData(TournamentView tournament) {
        this.players = tournament.getPlayers().toArray(new TournamentPlayerView[0]);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.players.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        switch (arg1) {
            case 0: {
                return this.players[arg0].getFlagName();
            }
            case 1: {
                return this.players[arg0].getName();
            }
            case 2: {
                return this.players[arg0].getState();
            }
            case 3: {
                return Integer.toString(this.players[arg0].getPoints());
            }
            case 4: {
                return this.players[arg0].getResults();
            }
            case 5: {
                return this.players[arg0].getHistory();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        String colName = "";
        if (columnIndex <= this.getColumnCount()) {
            colName = this.columnNames[columnIndex];
        }
        return colName;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

