/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.view.DeckView;
import mage.view.SimpleCardView;
import org.apache.log4j.Logger;

public final class DeckUtil {
    private static final Logger log = Logger.getLogger(DeckUtil.class);

    private DeckUtil() {
    }

    public static Deck construct(DeckView view) {
        Card card;
        CardInfo cardInfo;
        Deck deck = new Deck();
        deck.setName(view.getName());
        for (SimpleCardView cardView : view.getCards().values()) {
            cardInfo = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber());
            Card card2 = card = cardInfo != null ? cardInfo.createMockCard() : null;
            if (card != null) {
                deck.getCards().add(card);
                continue;
            }
            log.fatal((Object)("(Deck constructing) Couldn't find card: set=" + cardView.getExpansionSetCode() + ", cid=" + Integer.valueOf(cardView.getCardNumber())));
        }
        for (SimpleCardView cardView : view.getSideboard().values()) {
            cardInfo = CardRepository.instance.findCard(cardView.getExpansionSetCode(), cardView.getCardNumber());
            Card card3 = card = cardInfo != null ? cardInfo.createMockCard() : null;
            if (card != null) {
                deck.getSideboard().add(card);
                continue;
            }
            log.fatal((Object)("(Deck constructing) Couldn't find card: set=" + cardView.getExpansionSetCode() + ", cid=" + Integer.valueOf(cardView.getCardNumber())));
        }
        return deck;
    }
}

