/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.util.HashMap;
import java.util.Map;
import mage.client.MageFrame;
import org.apache.log4j.Logger;

public class EDTExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(EDTExceptionHandler.class);
    private static final Map<String, Integer> foundErrors = new HashMap<String, Integer>();
    private static MageFrame mainApp = null;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.handle(e);
    }

    public void handle(Throwable throwable) {
        try {
            logger.fatal((Object)"MAGE Client UI error", throwable);
            String errorKey = throwable.toString();
            int foundCount = foundErrors.getOrDefault(errorKey, 0);
            if (foundCount < 5 && mainApp != null) {
                mainApp.showErrorDialog("CLIENT - unhandled error in GUI", throwable);
                ++foundCount;
            }
            foundErrors.put(errorKey, foundCount);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static void registerExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new EDTExceptionHandler());
        System.setProperty("sun.awt.exception.handler", EDTExceptionHandler.class.getName());
    }

    public static void registerMainApp(MageFrame app) {
        mainApp = app;
    }
}

