/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mage.client.util.Event;
import mage.client.util.Listener;

public abstract class EventDispatcher<E extends Event>
implements Serializable {
    private final List<Listener<E>> listeners = new CopyOnWriteArrayList<Listener<E>>();

    public void addListener(Listener<E> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener<E> listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(E event) {
        for (Listener<E> listener : this.listeners) {
            listener.event(event);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

