/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import mage.client.util.TransformedImageCache;
import mage.view.CardView;
import org.mage.card.arcane.UI;

public final class ImageHelper {
    protected static final HashMap<String, BufferedImage> images = new HashMap();
    protected static final HashMap<String, BufferedImage> backgrounds = new HashMap();

    public static BufferedImage loadImage(String ref, int width, int height) {
        BufferedImage image = ImageHelper.loadImage(ref);
        if (image != null) {
            return ImageHelper.scaleImage(image, width, height);
        }
        return null;
    }

    public static BufferedImage loadImage(String ref) {
        if (!images.containsKey(ref)) {
            try {
                images.put(ref, ImageIO.read(ImageHelper.class.getResourceAsStream(ref)));
            }
            catch (Exception e) {
                return null;
            }
        }
        return images.get(ref);
    }

    public static BufferedImage getBackground(CardView card, String backgroundName) {
        if (backgrounds.containsKey(backgroundName)) {
            return backgrounds.get(backgroundName);
        }
        BufferedImage background = new BufferedImage(256, 367, 1);
        backgrounds.put(backgroundName, background);
        return background;
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        return TransformedImageCache.getResizedImage(image, width, height);
    }

    public static void drawCosts(List<String> costs, Graphics2D g, int xOffset, int yOffset, ImageObserver o) {
        if (!costs.isEmpty()) {
            int costLeft = xOffset;
            for (int i = costs.size() - 1; i >= 0; --i) {
                String symbol = costs.get(i);
                g.drawString(symbol, costLeft, yOffset + 14);
                costLeft -= 18;
            }
        }
    }

    public static BufferedImage getResizedImage(BufferedImage original, int width, int height) {
        return TransformedImageCache.getResizedImage(original, width, height);
    }

    public static BufferedImage scale(BufferedImage sbi, int imageType, int dWidth, int dHeight) {
        return TransformedImageCache.getResizedImage(sbi, dWidth, dHeight);
    }

    public static BufferedImage getResizedImage(BufferedImage original, Rectangle sizeNeed) {
        return TransformedImageCache.getResizedImage(original, sizeNeed.width, sizeNeed.height);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getImageFromResources(String path) {
        try (InputStream stream = UI.class.getResourceAsStream(path);){
            BufferedImage image;
            ImageIO.setUseCache(false);
            BufferedImage bufferedImage = image = ImageIO.read(stream);
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image getImageFromResourcesScaledToHeight(String pathToImage, int height) {
        BufferedImage res = null;
        Image image = ImageHelper.getImageFromResources(pathToImage);
        if (image != null) {
            int width = Math.round(height * image.getWidth(null) / image.getHeight(null));
            res = ImageHelper.scale((BufferedImage)image, 6, width, height);
        }
        return res;
    }
}

