/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.Window;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class MacFullscreenUtil {
    public static final String OS_NAME = "os.name";
    public static final String MAC_OS_X = "Mac OS X";
    private static final Logger logger = Logger.getLogger(MacFullscreenUtil.class);

    private MacFullscreenUtil() {
    }

    public static boolean isMacOSX() {
        return System.getProperty(OS_NAME).contains(MAC_OS_X);
    }

    public static void enableMacOSFullScreenMode(Window window) {
        if (MacFullscreenUtil.supportsAppleEAWT()) {
            String className = "com.apple.eawt.FullScreenUtilities";
            String methodName = "setWindowCanFullScreen";
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getMethod(methodName, Window.class, Boolean.TYPE);
                method.invoke(null, window, true);
            }
            catch (Throwable e) {
                logger.error((Object)("Can't enable full screen support in Mac OS - " + e), e);
            }
        }
    }

    public static void toggleMacOSFullScreenMode(Window window) {
        if (MacFullscreenUtil.supportsAppleEAWT()) {
            String className = "com.apple.eawt.Application";
            String methodName = "getApplication";
            String methodName2 = "requestToggleFullScreen";
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getMethod(methodName, new Class[0]);
                Object appInstance = method.invoke(clazz, new Object[0]);
                Class[] params = new Class[]{Window.class};
                method = clazz.getMethod(methodName2, params);
                method.invoke(appInstance, window);
            }
            catch (Throwable e) {
                logger.error((Object)("Can't toggle full screen in Mac OS - " + e), e);
            }
        }
    }

    private static boolean supportsAppleEAWT() {
        return System.getProperty("java.version").startsWith("1.8");
    }
}

