/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import mage.client.util.AppUtil;

public class URLHandler {
    private static MouseAdapter currentMouseAdapter;

    public static void handleMessage(String message, JLabel label) {
        String url = URLHandler.detectURL(message);
        if (!url.equals("")) {
            label.addMouseListener(URLHandler.createMouseAdapter(url));
        }
        label.setText(URLHandler.convertToHTML(message));
    }

    public static void RemoveMouseAdapter(JLabel label) {
        label.removeMouseListener(currentMouseAdapter);
        currentMouseAdapter = null;
    }

    private static MouseAdapter createMouseAdapter(final String url) {
        currentMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() > 0) {
                    AppUtil.openUrlInSystemBrowser(url);
                }
            }
        };
        return currentMouseAdapter;
    }

    public static String convertToHTML(String input) {
        String[] parts;
        String s = input;
        String output = "<html>";
        for (String item : parts = s.split("\\s+")) {
            try {
                URL url = new URL(item);
                output = output + "<a href=\"" + url + "\">" + url + "</a> ";
            }
            catch (MalformedURLException e) {
                output = item.startsWith("www.") ? output + "<a href=\"" + item + "\">" + item + "</a> " : output + item + " ";
            }
        }
        output = output + "</html>";
        return output;
    }

    public static String detectURL(String input) {
        String[] parts;
        String s = input;
        String output = "";
        for (String item : parts = s.split("\\s+")) {
            try {
                URL url = new URL(item);
                output = url.toString();
            }
            catch (MalformedURLException e) {
                if (!item.startsWith("www.")) continue;
                output = "http://" + item;
            }
        }
        return output;
    }
}

