/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.audio;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import mage.client.util.audio.AudioGroup;
import org.apache.log4j.Logger;

public class MageClip {
    private static final Logger log = Logger.getLogger(MageClip.class);
    private final AudioGroup audioGroup;
    private final String filename;
    private final byte[] buf;

    public MageClip(String filename, AudioGroup audioGroup) {
        this.filename = filename;
        this.audioGroup = audioGroup;
        this.buf = this.loadStream();
    }

    private byte[] loadStream() {
        File file = new File(this.filename);
        try {
            AudioInputStream soundIn = AudioSystem.getAudioInputStream(file);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            MageClip.copy(soundIn, bytesOut);
            return bytesOut.toByteArray();
        }
        catch (IOException | UnsupportedAudioFileException e) {
            log.warn((Object)("Failed to read " + this.filename), (Throwable)e);
            return null;
        }
    }

    private static void copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }

    public AudioGroup getAudioGroup() {
        return this.audioGroup;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public String getFilename() {
        return this.filename;
    }
}

