/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.gui;

import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import mage.choices.ChoiceImpl;
import mage.client.dialog.CheckBoxList;
import mage.client.dialog.PickCheckBoxDialog;
import mage.client.dialog.PickChoiceDialog;

public class FastSearchUtil {
    public static final String DEFAULT_EXPANSION_SEARCH_MESSAGE = "Select set or expansion";
    public static final String DEFAULT_EXPANSION_TOOLTIP_MESSAGE = "Fast search set or expansion";

    public static void showFastSearchForStringComboBox(JComboBox combo, String chooseMessage) {
        FastSearchUtil.showFastSearchForStringComboBox(combo, chooseMessage, 300, 500);
    }

    public static void showFastSearchForStringComboBox(JComboBox combo, String chooseMessage, int windowWidth, int windowHeight) {
        ChoiceImpl choice = new ChoiceImpl(false);
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)combo.getModel();
        HashMap<String, String> choiceItems = new HashMap<String, String>(comboModel.getSize());
        HashMap<String, Integer> choiceSorting = new HashMap<String, Integer>(comboModel.getSize());
        for (int i = 0; i < comboModel.getSize(); ++i) {
            String item = comboModel.getElementAt(i).toString();
            choiceItems.put(item, item);
            choiceSorting.put(item, i);
        }
        choice.setKeyChoices(choiceItems);
        choice.setSortData(choiceSorting);
        choice.setMessage(chooseMessage);
        String needSelectValue = comboModel.getSelectedItem().toString();
        PickChoiceDialog dlg = new PickChoiceDialog();
        dlg.setWindowSize(windowWidth, windowHeight);
        dlg.showDialog(choice, needSelectValue, () -> {
            if (choice.isChosen()) {
                String item = choice.getChoiceKey();
                for (int i = 0; i < comboModel.getSize(); ++i) {
                    if (!comboModel.getElementAt(i).toString().equals(item)) continue;
                    combo.setSelectedIndex(i);
                }
            }
        });
    }

    public static void showFastSearchForStringComboBox(CheckBoxList combo, String chooseMessage, PickCheckBoxDialog.PickCheckBoxCallback additionalCallbackOnDone) {
        ChoiceImpl choice = new ChoiceImpl(false);
        DefaultListModel comboModel = (DefaultListModel)combo.getModel();
        HashMap<String, String> choiceItems = new HashMap<String, String>(comboModel.getSize());
        HashMap<String, Integer> choiceSorting = new HashMap<String, Integer>(comboModel.getSize());
        for (int i = 0; i < comboModel.size(); ++i) {
            String item = comboModel.getElementAt(i).toString();
            choiceItems.put(item, item);
            choiceSorting.put(item, i);
        }
        choice.setKeyChoices(choiceItems);
        choice.setSortData(choiceSorting);
        choice.setMessage(chooseMessage);
        String needSelectValue = null;
        if (comboModel.size() > 0) {
            needSelectValue = comboModel.firstElement().toString();
        }
        PickCheckBoxDialog dlg = new PickCheckBoxDialog(combo);
        dlg.setWindowSize(300, 500);
        dlg.showDialog(choice, needSelectValue, () -> {
            if (choice.isChosen()) {
                String item = choice.getChoiceKey();
                for (int i = 0; i < comboModel.getSize(); ++i) {
                    if (!comboModel.getElementAt(i).toString().equals(item)) continue;
                    combo.setSelectedIndex(i);
                }
            }
            additionalCallbackOnDone.onChoiceDone();
        });
    }
}

