/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.gui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import mage.client.cards.CardsList;

public class TableSpinnerEditor
extends DefaultCellEditor {
    final JSpinner spinner;
    final JSpinner.DefaultEditor editor;
    final JTextField textField;
    boolean valueSet;
    private JTable table;
    private int lastRow = -1;
    private int currentRow = -1;
    private int lastOriginalHeigh;
    private int currentOriginalHeigh;
    private static final int NEEDED_HIGH = 24;
    final CardsList cardsList;

    public TableSpinnerEditor(CardsList cardsList) {
        super(new JTextField());
        this.cardsList = cardsList;
        this.spinner = new JSpinner();
        this.spinner.setBorder(BorderFactory.createEmptyBorder());
        this.spinner.setModel(new SpinnerNumberModel(0, 0, 999, 1));
        this.editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        this.textField = this.editor.getTextField();
        this.textField.setHorizontalAlignment(2);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                TableSpinnerEditor.this.lastOriginalHeigh = TableSpinnerEditor.this.currentOriginalHeigh;
                TableSpinnerEditor.this.currentOriginalHeigh = 0;
                TableSpinnerEditor.this.lastRow = TableSpinnerEditor.this.currentRow;
                TableSpinnerEditor.this.currentRow = -1;
                if (TableSpinnerEditor.this.lastOriginalHeigh < 24) {
                    TableSpinnerEditor.this.table.setRowHeight(TableSpinnerEditor.this.lastRow, 24);
                }
                SwingUtilities.invokeLater(() -> {
                    if (TableSpinnerEditor.this.valueSet) {
                        TableSpinnerEditor.this.textField.setCaretPosition(1);
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent fe) {
                TableSpinnerEditor.this.resetRow();
                if (TableSpinnerEditor.this.currentRow < 0) {
                    TableSpinnerEditor.this.stopCellEditing();
                }
            }
        });
        this.textField.addActionListener(ae -> this.stopCellEditing());
    }

    private synchronized void resetRow() {
        if (this.lastRow >= 0) {
            this.cardsList.handleSetNumber((Integer)this.spinner.getValue());
            this.table.setRowHeight(this.lastRow, this.lastOriginalHeigh);
            this.lastRow = -1;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.table == null) {
            this.table = table;
        }
        this.currentOriginalHeigh = table.getRowHeight(row);
        this.currentRow = row;
        if (!this.valueSet) {
            this.spinner.setValue(value);
        }
        SwingUtilities.invokeLater(() -> this.textField.requestFocus());
        return this.spinner;
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        if (eo instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)eo;
            this.textField.setText(String.valueOf(ke.getKeyChar()));
            this.valueSet = true;
        } else {
            this.valueSet = false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.editor.commitEdit();
            this.spinner.commitEdit();
            this.resetRow();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, "Invalid value, discarding.");
        }
        return super.stopCellEditing();
    }
}

