/*
 * Decompiled with CFR 0.152.
 */
package mage.client.util.layout.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import java.util.UUID;
import javax.swing.JLayeredPane;
import mage.cards.MageCard;
import mage.client.game.BattlefieldPanel;
import mage.client.plugins.impl.Plugins;
import mage.client.util.layout.CardLayoutStrategy;
import mage.view.PermanentView;

public class CardLayoutStrategyImpl
implements CardLayoutStrategy {
    private static final int ATTACHMENTS_OFFSET_ALL_X = 12;
    private static final int ATTACHMENTS_OFFSET_SINGLE_Y = 12;
    private static final int ATTACHMENTS_MAX_COLUMNS = 10;

    @Override
    public void doLayout(BattlefieldPanel battlefieldPanel, int battlefieldWidth) {
        Map<UUID, MageCard> cards = battlefieldPanel.getPermanentPanels();
        JLayeredPane mainPanel = battlefieldPanel.getMainPanel();
        int height = Plugins.instance.sortPermanents(battlefieldPanel.getUiComponentsList(), cards, battlefieldPanel.isTopPanelBattlefield());
        mainPanel.setPreferredSize(new Dimension(battlefieldWidth - 30, height));
        for (PermanentView permanent : battlefieldPanel.getBattlefield().values()) {
            if (permanent.getAttachments() == null || permanent.isAttachedTo()) continue;
            this.groupAttachments(battlefieldPanel, mainPanel, cards, permanent);
        }
    }

    private void groupAttachments(BattlefieldPanel battlefieldPanel, JLayeredPane mainPanel, Map<UUID, MageCard> cards, PermanentView permanentWithAttachmentsView) {
        MageCard cardWithAttachments = cards.get(permanentWithAttachmentsView.getId());
        if (cardWithAttachments == null) {
            return;
        }
        AttachmentLayoutInfos attachmentLayoutInfos = this.calculateNeededNumberOfVerticalColumns(0, battlefieldPanel, cards, permanentWithAttachmentsView);
        this.layoutAttachements(cardWithAttachments.getCardLocation().getCardX(), attachmentLayoutInfos.getColumns(), attachmentLayoutInfos.getAttachments(), permanentWithAttachmentsView, cards, battlefieldPanel, mainPanel, cardWithAttachments.getCardLocation().getCardBounds());
        mainPanel.setComponentZOrder((Component)cardWithAttachments, 0);
    }

    private void layoutAttachements(int startingCardX, int maxColumnLevels, int ZOrder, PermanentView permanentWithAttachmentsView, Map<UUID, MageCard> cards, BattlefieldPanel battlefieldPanel, JLayeredPane mainPanel, Rectangle lastAttachmentRect) {
        MageCard cardWithAttachments = cards.get(permanentWithAttachmentsView.getId());
        if (cardWithAttachments == null) {
            return;
        }
        int col = this.getVerticalCul(permanentWithAttachmentsView, battlefieldPanel);
        int currentAttachmentCol = col + 1;
        cardWithAttachments.getLinks().clear();
        int verticalIndex = permanentWithAttachmentsView.getAttachments().size();
        for (UUID attachmentId : permanentWithAttachmentsView.getAttachments()) {
            MageCard attachedCard;
            PermanentView attachedPermanentView = battlefieldPanel.getBattlefield().get(attachmentId);
            if (attachedPermanentView != null && attachedPermanentView.getAttachments() != null && !attachedPermanentView.getAttachments().isEmpty()) {
                this.layoutAttachements(startingCardX, maxColumnLevels, ZOrder, attachedPermanentView, cards, battlefieldPanel, mainPanel, lastAttachmentRect);
            }
            if ((attachedCard = cards.get(attachmentId)) == null) continue;
            Point point = new Point();
            point.setLocation((double)(startingCardX + (maxColumnLevels - currentAttachmentCol) * Math.max(cardWithAttachments.getCardLocation().getCardWidth() / 10, 12)), lastAttachmentRect.getY());
            lastAttachmentRect.setLocation(point);
            attachedCard.setCardLocation(lastAttachmentRect.x, lastAttachmentRect.y);
            cardWithAttachments.getLinks().add(attachedCard);
            int dyOffset = Math.max(cardWithAttachments.getCardLocation().getCardHeight() / 10, 12);
            if (verticalIndex == 1) {
                lastAttachmentRect.translate(Math.max(cardWithAttachments.getCardLocation().getCardWidth() / 10, 12), dyOffset);
            } else {
                lastAttachmentRect.translate(0, dyOffset);
            }
            cardWithAttachments.setCardLocation(lastAttachmentRect.x, lastAttachmentRect.y);
            battlefieldPanel.moveToFront((Component)attachedCard);
            battlefieldPanel.moveToFront((Component)cardWithAttachments);
            mainPanel.setComponentZOrder((Component)attachedCard, ZOrder--);
            --verticalIndex;
        }
    }

    private AttachmentLayoutInfos calculateNeededNumberOfVerticalColumns(int currentCol, BattlefieldPanel battlefieldPanel, Map<UUID, MageCard> cards, PermanentView permanentWithAttachmentsView) {
        int maxCol = ++currentCol;
        int attachments = 0;
        for (UUID attachmentId : permanentWithAttachmentsView.getAttachments()) {
            AttachmentLayoutInfos attachmentLayoutInfos;
            PermanentView attachedPermanent = battlefieldPanel.getBattlefield().get(attachmentId);
            if (attachedPermanent == null) continue;
            ++attachments;
            if (attachedPermanent.getAttachments() == null || attachedPermanent.getAttachments().isEmpty() || (attachmentLayoutInfos = this.calculateNeededNumberOfVerticalColumns(currentCol, battlefieldPanel, cards, attachedPermanent)).getColumns() <= maxCol) continue;
            maxCol = attachmentLayoutInfos.getColumns();
            attachments += attachmentLayoutInfos.getAttachments();
        }
        return new AttachmentLayoutInfos(maxCol, attachments);
    }

    private int getVerticalCul(PermanentView permanentView, BattlefieldPanel battlefieldPanel) {
        int cul = 0;
        if (permanentView.isAttachedTo()) {
            PermanentView attachedToPermanent = battlefieldPanel.getBattlefield().get(permanentView.getAttachedTo());
            if (attachedToPermanent != null) {
                cul = this.getVerticalCul(attachedToPermanent, battlefieldPanel);
            }
            ++cul;
        }
        return cul;
    }

    @Override
    public int getDefaultZOrder() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void onAdd(BattlefieldPanel jLayeredPane) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    final class AttachmentLayoutInfos {
        private int columns;
        private int attachments;

        public AttachmentLayoutInfos(int columns, int attachments) {
            this.columns = columns;
            this.attachments = attachments;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getAttachments() {
            return this.attachments;
        }

        public void increaseAttachments() {
            ++this.attachments;
        }

        public void increaseColumns() {
            ++this.columns;
        }
    }
}

