/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import mage.cards.MageCard;
import org.mage.card.arcane.CardPanel;
import org.mage.card.arcane.UI;

public abstract class Animation {
    private static final boolean ENABLED = true;
    private static final long TARGET_MILLIS_PER_FRAME = 30L;
    private static final Timer timer = new Timer("Animation", true);
    private static CardPanel enlargedCardPanel;
    private static CardPanel enlargedAnimationPanel;
    private static final Object enlargeLock;
    private final TimerTask timerTask;
    private FrameTimer frameTimer;
    private long elapsed;

    public Animation(long duration) {
        this(duration, 0L);
    }

    public Animation(final long duration, long delay) {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Animation.this.frameTimer == null) {
                    Animation.this.start();
                    Animation.this.frameTimer = new FrameTimer();
                }
                Animation.this.elapsed = Animation.this.elapsed + Animation.this.frameTimer.getTimeSinceLastFrame();
                if (Animation.this.elapsed >= duration) {
                    this.cancel();
                    Animation.this.elapsed = duration;
                }
                Animation.this.update((float)Animation.this.elapsed / (float)duration);
                if (Animation.this.elapsed == duration) {
                    Animation.this.end();
                }
            }
        };
        timer.scheduleAtFixedRate(this.timerTask, delay, 30L);
    }

    protected abstract void update(float var1);

    protected void cancel() {
        this.timerTask.cancel();
        this.end();
    }

    protected void start() {
    }

    protected void end() {
    }

    public static void tapCardToggle(CardPanel source, final boolean tapped, final boolean flipped) {
        final CardPanel mainPanel = source;
        final MageCard parentPanel = mainPanel.getTopPanelRef();
        new Animation(300L){

            @Override
            protected void start() {
                parentPanel.onBeginAnimation();
            }

            @Override
            protected void update(float percentage) {
                if (tapped) {
                    mainPanel.setTappedAngle(1.5707963267948966 * (double)percentage);
                    if (!mainPanel.isTapped()) {
                        mainPanel.setTappedAngle(1.5707963267948966 - mainPanel.getTappedAngle());
                    }
                }
                if (flipped) {
                    mainPanel.setFlippedAngle(Math.PI * (double)percentage);
                    if (!mainPanel.isFlipped()) {
                        mainPanel.setFlippedAngle(Math.PI - mainPanel.getFlippedAngle());
                    }
                }
                parentPanel.repaint();
            }

            @Override
            protected void end() {
                if (tapped) {
                    mainPanel.setTappedAngle(mainPanel.isTapped() ? 1.5707963267948966 : 0.0);
                }
                if (flipped) {
                    mainPanel.setFlippedAngle(mainPanel.isFlipped() ? Math.PI : 0.0);
                }
                parentPanel.onEndAnimation();
                parentPanel.repaint();
            }
        };
    }

    public static void transformCard(CardPanel source) {
        final CardPanel mainPanel = source;
        final MageCard parentPanel = mainPanel.getTopPanelRef();
        new Animation(600L){
            private boolean state;
            {
                super(duration);
                this.state = false;
            }

            @Override
            protected void start() {
                parentPanel.onBeginAnimation();
            }

            @Override
            protected void update(float percentage) {
                double p = percentage * 2.0f;
                if ((double)percentage > 0.5) {
                    if (!this.state) {
                        parentPanel.toggleTransformed();
                    }
                    this.state = true;
                    p = (p - 0.5) * 2.0;
                }
                mainPanel.transformAngle = !this.state ? Math.max(0.01, 1.0 - p) : Math.max(0.01, p - 1.0);
                parentPanel.repaint();
            }

            @Override
            protected void end() {
                if (!this.state) {
                    parentPanel.toggleTransformed();
                }
                this.state = true;
                mainPanel.transformAngle = 1.0;
                parentPanel.onEndAnimation();
                parentPanel.repaint();
            }
        };
    }

    public static void moveCardToPlay(final int startX, final int startY, final int startWidth, final int endX, final int endY, final int endWidth, CardPanel cardToAnimate, final CardPanel placeholder, final JLayeredPane layeredPane, int speed) {
        final CardPanel cardPanel = (CardPanel)cardToAnimate.getMainPanel();
        final MageCard mainPanel = cardToAnimate.getTopPanelRef();
        UI.invokeLater(() -> {
            final int startHeight = Math.round((float)startWidth * 1.4f);
            final int endHeight = Math.round((float)endWidth * 1.4f);
            final float a = 2.0f;
            final float sqrta = (float)Math.sqrt(0.5);
            mainPanel.setCardBounds(startX, startY, startWidth, startHeight);
            cardPanel.setAnimationPanel(true);
            Container parent = mainPanel.getParent();
            if (parent != null && !parent.equals(layeredPane)) {
                layeredPane.add((Component)mainPanel);
                layeredPane.setLayer((Component)mainPanel, JLayeredPane.MODAL_LAYER);
            }
            new Animation(700L){

                @Override
                protected void update(float percentage) {
                    int currentHeight;
                    int currentWidth;
                    float percent = percentage;
                    if (placeholder != null && !placeholder.isShowing()) {
                        this.cancel();
                        return;
                    }
                    int currentX = startX + Math.round(((float)(endX - startX) + (float)endWidth / 2.0f) * percent);
                    int currentY = startY + Math.round(((float)(endY - startY) + (float)endHeight / 2.0f) * percent);
                    int midWidth = Math.max(200, endWidth * 2);
                    int midHeight = Math.round((float)midWidth * 1.4f);
                    if (percent <= 0.5f) {
                        float pp = sqrta * (1.0f - (percent *= 2.0f));
                        percent = 1.0f - a * pp * pp;
                        currentWidth = startWidth + Math.round((float)(midWidth - startWidth) * percent);
                        currentHeight = startHeight + Math.round((float)(midHeight - startHeight) * percent);
                    } else {
                        percent = (percent - 0.5f) * 2.0f;
                        float pp = sqrta * percent;
                        percent = a * pp * pp;
                        currentWidth = midWidth + Math.round((float)(endWidth - midWidth) * percent);
                        currentHeight = midHeight + Math.round((float)(endHeight - midHeight) * percent);
                    }
                    mainPanel.setCardBounds(currentX -= currentWidth / 2, currentY -= currentHeight / 2, currentWidth, currentHeight);
                }

                @Override
                protected void end() {
                    EventQueue.invokeLater(() -> {
                        if (placeholder != null) {
                            placeholder.setDisplayEnabled(true);
                            placeholder.transferResources(cardPanel);
                        }
                        mainPanel.setVisible(false);
                        mainPanel.repaint();
                        layeredPane.remove((Component)mainPanel);
                    });
                }
            };
        });
    }

    public static void moveCard(final int startX, final int startY, final int startWidth, final int endX, final int endY, final int endWidth, MageCard cardToAnimate, final CardPanel placeholder, final JLayeredPane layeredPane, int speed) {
        final CardPanel cardPanel = (CardPanel)cardToAnimate.getMainPanel();
        final MageCard mainPanel = cardToAnimate.getTopPanelRef();
        UI.invokeLater(() -> {
            final int startHeight = Math.round((float)startWidth * 1.4f);
            final int endHeight = Math.round((float)endWidth * 1.4f);
            mainPanel.setCardBounds(startX, startY, startWidth, startHeight);
            cardPanel.setAnimationPanel(true);
            Container parent = mainPanel.getParent();
            if (parent != null && !parent.equals(layeredPane)) {
                layeredPane.add((Component)mainPanel);
                layeredPane.setLayer((Component)mainPanel, JLayeredPane.MODAL_LAYER);
            }
            new Animation(speed){

                @Override
                protected void update(float percentage) {
                    int currentX = startX + Math.round((float)(endX - startX) * percentage);
                    int currentY = startY + Math.round((float)(endY - startY) * percentage);
                    int currentWidth = startWidth + Math.round((float)(endWidth - startWidth) * percentage);
                    int currentHeight = startHeight + Math.round((float)(endHeight - startHeight) * percentage);
                    mainPanel.setCardBounds(currentX, currentY, currentWidth, currentHeight);
                }

                @Override
                protected void end() {
                    EventQueue.invokeLater(() -> {
                        if (placeholder != null) {
                            placeholder.setDisplayEnabled(true);
                            placeholder.transferResources(cardPanel);
                        }
                        mainPanel.setVisible(false);
                        mainPanel.repaint();
                        layeredPane.remove((Component)mainPanel);
                    });
                }
            };
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shrinkCard() {
        CardPanel animationPanel;
        CardPanel overPanel;
        Object object = enlargeLock;
        synchronized (object) {
            overPanel = enlargedCardPanel;
            animationPanel = enlargedAnimationPanel;
            if (animationPanel == null) {
                return;
            }
            enlargedCardPanel = null;
            enlargedAnimationPanel = null;
        }
        animationPanel.setAnimationPanel(true);
        final JLayeredPane layeredPane = SwingUtilities.getRootPane((Component)((Object)overPanel)).getLayeredPane();
        layeredPane.setLayer((Component)((Object)animationPanel), JLayeredPane.MODAL_LAYER);
        final int startWidth = animationPanel.getCardWidth();
        final int startHeight = Math.round((float)startWidth * 1.4f);
        final int endWidth = overPanel.getCardWidth();
        final int endHeight = Math.round((float)endWidth * 1.4f);
        new Animation(200L){

            @Override
            protected void update(float percentage) {
                int currentWidth = startWidth + Math.round((float)(endWidth - startWidth) * percentage);
                int currentHeight = startHeight + Math.round((float)(endHeight - startHeight) * percentage);
                Point startPos = SwingUtilities.convertPoint(overPanel.getParent(), overPanel.getCardLocation().getCardPoint(), layeredPane);
                int centerX = startPos.x + Math.round((float)endWidth / 2.0f);
                int centerY = startPos.y + Math.round((float)endHeight / 2.0f);
                int currentX = Math.max(0, centerX - Math.round((float)currentWidth / 2.0f));
                currentX = Math.min(currentX, layeredPane.getWidth() - currentWidth);
                int currentY = Math.max(0, centerY - Math.round((float)currentHeight / 2.0f));
                currentY = Math.min(currentY, layeredPane.getHeight() - currentHeight);
                animationPanel.setTappedAngle(overPanel.getTappedAngle() * (double)percentage);
                animationPanel.setCardBounds(currentX, currentY, currentWidth, currentHeight);
            }

            @Override
            protected void end() {
                animationPanel.setVisible(false);
                animationPanel.repaint();
                EventQueue.invokeLater(() -> layeredPane.remove((Component)((Object)animationPanel)));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isShowingEnlargedCard() {
        Object object = enlargeLock;
        synchronized (object) {
            return enlargedAnimationPanel != null;
        }
    }

    public static void showCard(final MageCard card, int count) {
        if (count == 0) {
            return;
        }
        new Animation((long)(600 / count)){

            @Override
            protected void start() {
            }

            @Override
            protected void update(float percentage) {
                float alpha = percentage;
                card.setAlpha(alpha);
                card.repaint();
            }

            @Override
            protected void end() {
                card.setAlpha(1.0f);
            }
        };
    }

    public static void hideCard(final MageCard card, int count) {
        if (count == 0) {
            return;
        }
        new Animation((long)(600 / count)){

            @Override
            protected void start() {
            }

            @Override
            protected void update(float percentage) {
                float alpha = 1.0f - percentage;
                card.setAlpha(alpha);
                card.repaint();
            }

            @Override
            protected void end() {
                card.setAlpha(0.0f);
            }
        };
    }

    private /* synthetic */ void lambda$new$0() {
        this.start();
        this.end();
    }

    static {
        enlargeLock = new Object();
    }

    private static class FrameTimer {
        private static final int SAMPLES = 6;
        private static final long MAX_FRAME = 100L;
        private final long[] samples = new long[6];
        private int sampleIndex;

        public FrameTimer() {
            long currentTime = System.currentTimeMillis();
            for (int i = 5; i >= 0; --i) {
                this.samples[i] = currentTime - (long)(6 - i) * 30L;
            }
        }

        public long getTimeSinceLastFrame() {
            long timeSinceLastSample;
            long currentTime = System.currentTimeMillis();
            int id = this.sampleIndex - 1;
            if (id < 0) {
                id += 6;
            }
            if ((timeSinceLastSample = currentTime - this.samples[id]) > 100L) {
                long diff = timeSinceLastSample - 100L;
                int i = 0;
                while (i < 6) {
                    int n = i++;
                    this.samples[n] = this.samples[n] + diff;
                }
            }
            long timeSinceOldestSample = currentTime - this.samples[this.sampleIndex];
            this.samples[this.sampleIndex] = currentTime;
            this.sampleIndex = (this.sampleIndex + 1) % 6;
            return timeSinceOldestSample / 6L;
        }
    }
}

