/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import mage.cards.action.ActionCallback;
import mage.client.util.ImageCaches;
import mage.constants.CardType;
import mage.view.CardView;
import mage.view.CounterView;
import mage.view.PermanentView;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.mage.card.arcane.CardPanel;
import org.mage.card.arcane.CardPanelAttributes;
import org.mage.card.arcane.CardRenderer;
import org.mage.card.arcane.CardRendererFactory;
import org.mage.card.arcane.UI;
import org.mage.card.arcane.Util;
import org.mage.plugins.card.images.ImageCache;

public class CardPanelRenderModeMTGO
extends CardPanel {
    private static final boolean MTGO_MODE_RENDER_SMOOTH_IMAGES_ENABLED = false;
    private static final int MTGO_MODE_RENDER_SCALED_IMAGES_COEF = 1;
    private static final Cache<ImageKey, BufferedImage> MTGO_MODE_RENDERED_CACHE = ImageCaches.register(CacheBuilder.newBuilder().maximumSize(3000L).expireAfterAccess(60L, TimeUnit.MINUTES).softValues().build());
    private BufferedImage artImage;
    private final CardRendererFactory cardRendererFactory = new CardRendererFactory();
    private BufferedImage cardImage;
    private CardRenderer cardRenderer;
    private int updateArtImageStamp;
    private final int cardRenderMode;

    public CardPanelRenderModeMTGO(CardView newGameCard, UUID gameId, boolean loadImage, ActionCallback callback, boolean foil, Dimension dimension, boolean needFullPermanentRender, int renderMode) {
        super(newGameCard, gameId, loadImage, callback, foil, dimension, needFullPermanentRender);
        this.cardRenderMode = renderMode;
        this.cardRenderer = this.cardRendererFactory.create(this.getGameCard(), this.cardRenderMode);
        this.initialDraw();
    }

    public Image getImage() {
        if (this.artImage == null) {
            return null;
        }
        return ImageCache.getCardImageOriginal(this.getGameCard()).getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintCard(Graphics2D g) {
        if (this.cardImage == null) {
            ImageKey key = new ImageKey(this.getGameCard(), this.artImage, this.getCardWidth() * 1, this.getCardHeight() * 1, this.isChoosable(), this.isSelected(), this.isTransformed());
            try {
                this.cardImage = (BufferedImage)MTGO_MODE_RENDERED_CACHE.get((Object)key, this::renderCard);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        int cardOffsetX = 0;
        int cardOffsetY = 0;
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.drawImage((Image)this.cardImage, cardOffsetX, cardOffsetY, null);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void setCardBounds(int x, int y, int cardWidth, int cardHeight) {
        int oldCardWidth = this.getCardWidth();
        int oldCardHeight = this.getCardHeight();
        super.setCardBounds(x, y, cardWidth, cardHeight);
        if (this.getCardWidth() != oldCardWidth || this.getCardHeight() != oldCardHeight) {
            this.cardImage = null;
        }
    }

    @Override
    public void setChoosable(boolean choosable) {
        if (choosable != this.isChoosable()) {
            super.setChoosable(choosable);
            this.cardImage = null;
            this.repaint();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected != this.isSelected()) {
            super.setSelected(selected);
            this.cardImage = null;
            this.repaint();
        }
    }

    public void showCardTitle() {
    }

    @Override
    public void transferResources(CardPanel panel) {
        if (panel instanceof CardPanelRenderModeMTGO) {
            CardPanelRenderModeMTGO impl = (CardPanelRenderModeMTGO)panel;
            this.artImage = impl.artImage;
            this.cardRenderer.setArtImage(this.artImage);
            this.cardImage = impl.cardImage;
        }
    }

    @Override
    public void update(CardView card) {
        super.update(card);
        this.cardImage = null;
        this.cardRenderer = this.cardRendererFactory.create(this.getGameCard(), this.cardRenderMode);
        this.cardRenderer.setArtImage(this.artImage);
        this.repaint();
    }

    public void updateArtImage() {
        this.artImage = null;
        this.cardImage = null;
        this.cardRenderer.setArtImage(null);
        this.setTappedAngle(this.isTapped() ? 1.5707963267948966 : 0.0);
        this.setFlippedAngle(this.isFlipped() ? Math.PI : 0.0);
        this.repaint();
        if (this.artImage == null) {
            int stamp = ++this.updateArtImageStamp;
            Util.threadPool.submit(() -> {
                try {
                    BufferedImage srcImage = ImageCache.getCardImage(this.getGameCard(), this.getCardWidth(), this.getCardHeight()).getImage();
                    UI.invokeLater(() -> {
                        if (stamp == this.updateArtImageStamp) {
                            this.artImage = srcImage;
                            this.cardRenderer.setArtImage(srcImage);
                            if (srcImage != null) {
                                this.cardImage = null;
                                this.repaint();
                            }
                        }
                    });
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private CardPanelAttributes getAttributes() {
        return new CardPanelAttributes(this.getCardWidth(), this.getCardHeight(), this.isChoosable(), this.isSelected(), this.isTransformed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage renderCard() {
        int cardWidth = this.getCardWidth();
        int cardHeight = this.getCardHeight();
        BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage((int)cardWidth, (int)cardHeight);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.cardRenderer.draw(g2, this.getAttributes(), image);
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    private static class ImageKey {
        final BufferedImage artImage;
        final int width;
        final int height;
        final boolean isChoosable;
        final boolean isSelected;
        final boolean isTransformed;
        final CardView view;
        final int hashCode;

        public ImageKey(CardView view, BufferedImage artImage, int width, int height, boolean isChoosable, boolean isSelected, boolean isTransformed) {
            this.view = view;
            this.artImage = artImage;
            this.width = width;
            this.height = height;
            this.isChoosable = isChoosable;
            this.isSelected = isSelected;
            this.isTransformed = isTransformed;
            this.hashCode = this.hashCodeImpl();
        }

        private int hashCodeImpl() {
            StringBuilder sb = new StringBuilder();
            sb.append((char)(this.artImage != null ? 1 : 0));
            sb.append((char)this.width);
            sb.append((char)this.height);
            sb.append((char)(this.isSelected ? 1 : 0));
            sb.append((char)(this.isChoosable ? 1 : 0));
            sb.append((char)(this.isTransformed ? 1 : 0));
            sb.append((char)(this.view.isPlayable() ? 1 : 0));
            sb.append((char)(this.view.isCanAttack() ? 1 : 0));
            sb.append((char)(this.view.isCanBlock() ? 1 : 0));
            sb.append((char)(this.view.isFaceDown() ? 1 : 0));
            sb.append((char)(this.view.getFrameStyle() != null ? this.view.getFrameStyle().ordinal() : -1));
            if (this.view instanceof PermanentView) {
                sb.append((char)(((PermanentView)this.view).hasSummoningSickness() ? 1 : 0));
                sb.append((char)((PermanentView)this.view).getDamage());
            }
            sb.append(this.view.getDisplayName());
            sb.append(this.view.getPower());
            sb.append(this.view.getToughness());
            sb.append(this.view.getLoyalty());
            sb.append(this.view.getDefense());
            sb.append(this.view.getColor().toString());
            sb.append(this.view.getImageNumber());
            sb.append(this.view.getExpansionSetCode());
            for (CardType type : this.view.getCardTypes()) {
                sb.append((char)type.ordinal());
            }
            for (Object s : this.view.getSuperTypes()) {
                sb.append(s);
            }
            for (Object s : this.view.getSubTypes()) {
                sb.append(s);
            }
            sb.append(this.view.getManaCostStr());
            for (Object s : this.view.getRules()) {
                sb.append((String)s);
            }
            if (this.view.getCounters() != null) {
                for (CounterView v : this.view.getCounters()) {
                    sb.append(v.getName()).append(v.getCount());
                }
            }
            return sb.toString().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ImageKey that = (ImageKey)object;
            return this.artImage == null == (that.artImage == null) && this.width == that.width && this.height == that.height && this.isChoosable == that.isChoosable && this.isSelected == that.isSelected && CardView.cardViewEquals((CardView)this.view, (CardView)that.view);
        }
    }
}

