/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import mage.cards.FrameStyle;
import mage.client.dialog.PreferencesDialog;
import mage.client.util.CardRenderMode;
import mage.view.CardView;
import org.mage.card.arcane.CardRenderer;
import org.mage.card.arcane.ModernCardRenderer;
import org.mage.card.arcane.ModernSplitCardRenderer;
import org.mage.card.arcane.RetroCardRenderer;

public class CardRendererFactory {
    public CardRenderer create(CardView card) {
        return this.create(card, -1);
    }

    public CardRenderer create(CardView card, int renderModeOverride) {
        if (card.isSplitCard()) {
            return new ModernSplitCardRenderer(card);
        }
        if (CardRendererFactory.shouldRenderRetro(card, renderModeOverride)) {
            return new RetroCardRenderer(card);
        }
        return new ModernCardRenderer(card);
    }

    private static boolean shouldRenderRetro(CardView card, int renderModeOverride) {
        int renderMode = PreferencesDialog.getRenderMode();
        if (renderModeOverride != -1) {
            renderMode = renderModeOverride;
        }
        boolean renderMTGO = (card.getFrameStyle().equals((Object)FrameStyle.RETRO) || card.getFrameStyle().equals((Object)FrameStyle.LEA_ORIGINAL_DUAL_LAND_ART_BASIC)) && renderMode == CardRenderMode.MTGO.ordinal();
        boolean forcedRetro = renderMode == CardRenderMode.FORCED_RETRO.ordinal();
        return renderMTGO || forcedRetro;
    }
}

