/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mage.MageInt;
import mage.util.DebugUtil;
import mage.view.CardView;
import mage.view.PermanentView;

public final class CardRendererUtils {
    private static final Color CARD_TEXT_COLOR_GOOD_LIGHT = new Color(182, 235, 168);
    private static final Color CARD_TEXT_COLOR_GOOD_DARK = new Color(52, 135, 88);
    private static final Color CARD_TEXT_COLOR_BAD_LIGHT = new Color(234, 153, 153);
    private static final Color CARD_TEXT_COLOR_BAD_DARK = new Color(200, 33, 33);
    private static final Pattern abbreviationPattern;
    private static final Map<String, String> abbreviations;
    private static final Pattern killReminderTextPattern;

    public static BufferedImage toBufferedImage(Image img) {
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = bimage.createGraphics();
        try {
            g2.drawImage(img, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return bimage;
    }

    public static Color abitbrighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int alpha = c.getAlpha();
        int plus_r = (255 - r) / 2;
        int plus_g = (255 - g) / 2;
        int plus_b = (255 - b) / 2;
        return new Color(r + plus_r, g + plus_g, b + plus_b, alpha);
    }

    public static Color abitdarker(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int alpha = c.getAlpha();
        int plus_r = Math.min(255 - r, r) / 2;
        int plus_g = Math.min(255 - g, g) / 2;
        int plus_b = Math.min(255 - b, b) / 2;
        return new Color(r - plus_r, g - plus_g, b - plus_b, alpha);
    }

    public static void drawRoundedBox(Graphics2D g, int x, int y, int w, int h, int bevel, Paint border, Paint fill) {
        g.setColor(new Color(0, 0, 0, 150));
        g.drawOval(x - 1, y - 1, bevel * 2, h);
        g.setPaint(border);
        g.fillOval(x, y, bevel * 2 - 1, h - 2);
        g.drawOval(x + w - bevel * 2, y, bevel * 2 - 1, h - 1);
        g.drawOval(x + 1, y + 1, bevel * 2 - 3, h - 3);
        g.drawOval(x + 1 + w - bevel * 2, y + 1, bevel * 2 - 3, h - 3);
        g.drawRect(x + bevel, y, w - 2 * bevel, h - 1);
        g.drawRect(x + 1 + bevel, y + 1, w - 2 * bevel - 2, h - 3);
        g.setPaint(fill);
        g.fillOval(x + 2, y + 2, bevel * 2 - 4, h - 4);
        g.fillOval(x + 2 + w - bevel * 2, y + 2, bevel * 2 - 4, h - 4);
        g.fillRect(x + bevel, y + 2, w - 2 * bevel, h - 4);
        g.setPaint(fill);
        g.setColor(CardRendererUtils.abitbrighter(g.getColor()));
        g.drawLine(x + 1 + bevel, y + 1, x + 1 + bevel + w - 2 * bevel - 2, y + 1);
        g.setPaint(fill);
        g.setColor(CardRendererUtils.abitdarker(g.getColor()));
        g.drawLine(x + 1 + bevel, y + h - 2, x + 1 + bevel + w - 2 * bevel - 2, y + h - 2);
    }

    public static void drawZendikarLandBox(Graphics2D g, int x, int y, int w, int h, int bevel, Paint border, Paint fill) {
        g.setColor(new Color(0, 0, 0, 150));
        g.drawOval(x - 1, y, bevel * 2, h);
        g.setPaint(border);
        g.drawOval(x, y, bevel * 2 - 1, h - 1);
        g.drawOval(x + w - bevel * 2, y, bevel * 2 - 1, h - 1);
        g.drawOval(x + 1, y + 1, bevel * 2 - 3, h - 3);
        g.drawOval(x + 1 + w - bevel * 2, y + 1, bevel * 2 - 3, h - 3);
        g.drawOval(x + w / 2 - h - h / 8, y - 3 * h / 4, 9 * h / 4, 9 * h / 4);
        g.drawRect(x + bevel, y, w - 2 * bevel, h - 1);
        g.drawRect(x + 1 + bevel, y + 1, w - 2 * bevel - 2, h - 3);
        g.setPaint(fill);
        g.setColor(CardRendererUtils.abitbrighter(g.getColor()));
        g.drawLine(x + 1 + bevel, y + 1, x + 1 + bevel + w - 2 * bevel - 2, y + 1);
        g.setPaint(fill);
        g.setColor(CardRendererUtils.abitdarker(g.getColor()));
        g.drawLine(x + 1 + bevel, y + h - 2, x + 1 + bevel + w - 2 * bevel - 2, y + h - 2);
        g.fillOval(x + 2, y + 2, bevel * 2 - 4, h - 4);
        g.fillOval(x + 2 + w - bevel * 2, y + 2, bevel * 2 - 4, h - 4);
        g.fillRect(x + bevel, y + 2, w - 2 * bevel, h - 4);
        g.fillOval(x + w / 2 - h - h / 8, y - 3 * h / 4, 9 * h / 4, 9 * h / 4);
    }

    public static int getManaCostWidth(String manaCost, int symbolSize) {
        int width = 0;
        manaCost = manaCost.replace("\\", "");
        StringTokenizer tok = new StringTokenizer(manaCost, " ");
        while (tok.hasMoreTokens()) {
            tok.nextToken();
            width += symbolSize;
        }
        return width;
    }

    public static String abbreviateRule(String rule) {
        StringBuffer build = new StringBuffer();
        Matcher match = abbreviationPattern.matcher(rule);
        while (match.find()) {
            match.appendReplacement(build, abbreviations.get(match.group(1)));
        }
        match.appendTail(build);
        return build.toString();
    }

    public static String killReminderText(String rule) {
        return killReminderTextPattern.matcher(rule).replaceAll("").replaceAll("<i>", "").replaceAll("</i>", "");
    }

    public static Color copyColor(Color color) {
        if (color != null) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return null;
    }

    public static String getCardLifeWithDamage(CardView cardView) {
        String originLife = cardView.getToughness();
        if (cardView instanceof PermanentView) {
            int damage = ((PermanentView)cardView).getDamage();
            try {
                int life = Integer.parseInt(originLife);
                originLife = String.valueOf(Math.max(0, life - damage));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return originLife;
    }

    public static boolean isCardWithDamage(CardView cardView) {
        boolean haveDamage = false;
        if (cardView instanceof PermanentView) {
            haveDamage = ((PermanentView)cardView).getDamage() > 0;
        }
        return haveDamage;
    }

    public static Color getCardTextColor(MageInt value, boolean drawAsDamaged, Color defaultColor, boolean textLight) {
        if (drawAsDamaged) {
            return textLight ? CARD_TEXT_COLOR_BAD_LIGHT : CARD_TEXT_COLOR_BAD_DARK;
        }
        if (value != null) {
            int baseValue;
            int currentValue = value.getValue();
            if (currentValue < (baseValue = value.getModifiedBaseValue())) {
                return textLight ? CARD_TEXT_COLOR_BAD_LIGHT : CARD_TEXT_COLOR_BAD_DARK;
            }
            if (currentValue > baseValue) {
                return textLight ? CARD_TEXT_COLOR_GOOD_LIGHT : CARD_TEXT_COLOR_GOOD_DARK;
            }
            return defaultColor;
        }
        return defaultColor;
    }

    public static Rectangle reduceRect(Rectangle rect, float reduceFactor) {
        float newWidth = (float)rect.width * reduceFactor;
        float newHeight = (float)rect.height * reduceFactor;
        int offsetX = Math.round(((float)rect.width - newWidth) / 2.0f);
        int offsetY = Math.round(((float)rect.height - newHeight) / 2.0f);
        return new Rectangle(rect.x + offsetX, rect.y + offsetY, Math.round(newWidth), Math.round(newHeight));
    }

    public static void drawCenteredText(Graphics2D g2d, String text, Rectangle rect, Font font, boolean isAutoScaleFont) {
        if (DebugUtil.GUI_RENDER_CENTERED_TEXT_DRAW_DEBUG_LINES) {
            g2d.drawLine(rect.x, rect.y + rect.height / 2, rect.x + rect.width, rect.y + rect.height / 2);
            g2d.drawLine(rect.x + rect.width / 2, rect.y, rect.x + rect.width / 2, rect.y + rect.height);
        }
        Font affectedFont = font;
        if (isAutoScaleFont) {
            affectedFont = CardRendererUtils.scaleFont(g2d, text, rect, font);
        }
        g2d.setFont(affectedFont);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector gv = affectedFont.createGlyphVector(frc, text);
        Rectangle2D box = gv.getVisualBounds();
        float offsetX = (float)((rect.getWidth() - box.getWidth()) / 2.0 + -box.getX());
        float offsetY = (float)((rect.getHeight() - box.getHeight()) / 2.0 + -box.getY());
        g2d.drawString(text, (float)rect.x + offsetX, (float)rect.y + offsetY);
    }

    private static Font scaleFont(Graphics2D g2d, String text, Rectangle rect, Font font) {
        FontRenderContext frc = g2d.getFontRenderContext();
        double needWidth = rect.getWidth();
        double needHeight = rect.getHeight();
        float fontMinSize = 1.0f;
        float fontMaxSize = 1000.0f;
        Font scaledFont = font;
        float scaledFontSize = scaledFont.getSize();
        while (fontMaxSize - fontMinSize > 1.0f) {
            scaledFont = scaledFont.deriveFont(scaledFontSize);
            TextLayout layout = new TextLayout(text, scaledFont, frc);
            float currentWidth = layout.getVisibleAdvance();
            LineMetrics metrics = scaledFont.getLineMetrics(text, frc);
            float currentHeight = metrics.getHeight();
            if ((double)currentWidth > needWidth || (double)currentHeight > needHeight) {
                fontMaxSize = scaledFontSize;
            } else {
                fontMinSize = scaledFontSize;
            }
            scaledFontSize = (fontMinSize + fontMaxSize) / 2.0f;
        }
        return scaledFont.deriveFont((float)Math.floor(scaledFontSize));
    }

    static {
        abbreviations = new HashMap<String, String>();
        abbreviations.put("enters the battlefield", "ETB");
        abbreviations.put("less than", "<");
        abbreviations.put("greater than", ">");
        String patternString = "(";
        Iterator<String> it = abbreviations.keySet().iterator();
        while (it.hasNext()) {
            patternString = patternString + it.next();
            if (!it.hasNext()) continue;
            patternString = patternString + "|";
        }
        patternString = patternString + ")";
        abbreviationPattern = Pattern.compile(patternString);
        killReminderTextPattern = Pattern.compile("\\([^\\)]*\\)");
    }
}

