/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import mage.abilities.icon.CardIconCategory;
import mage.abilities.icon.CardIconRenderSettings;
import mage.abilities.icon.system.PlayableCountIcon;
import mage.cards.MageCard;
import mage.cards.MageCardAnimationSettings;
import mage.cards.MageCardLocation;
import mage.cards.MageCardSpace;
import mage.client.cards.CardIconsPanel;
import mage.client.cards.CardIconsPanelFactory;
import mage.client.dialog.PreferencesDialog;
import mage.constants.Zone;
import mage.util.DebugUtil;
import mage.view.CardView;
import org.apache.log4j.Logger;

public class MageLayer
extends MageCard {
    private static final Logger logger = Logger.getLogger(MageLayer.class);
    JLayeredPane mainContainer;
    JPanel mainLayerCard;
    JPanel mainLayerIcons;
    JPanel mainLayerDebug = null;
    MageCard mainPanel;
    JPanel spaceLeft;
    JPanel spaceRight;
    JPanel spaceTop;
    JPanel spaceBottom;
    MageCardSpace lastOuterSpace = MageCardSpace.empty;
    CardIconRenderSettings iconsRender;
    List<CardIconsPanel> iconsPanels = new ArrayList<CardIconsPanel>();
    CardIconsPanel iconsDebugPanel;
    CardIconsPanel iconsAbilitiesPanel;
    CardIconsPanel iconsPlayablePanel;
    CardIconsPanel iconsCommanderPanel;

    public MageLayer(MageCard mainPanel, CardIconRenderSettings iconsRender) {
        this.mainPanel = mainPanel;
        this.mainPanel.setTopPanelRef((MageCard)this);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.mainContainer = new JLayeredPane();
        this.mainContainer.setOpaque(false);
        this.add(this.mainContainer, "Center");
        this.mainLayerCard = new JPanel(new BorderLayout());
        this.mainLayerCard.setOpaque(false);
        this.mainContainer.add((Component)this.mainLayerCard, (Object)0);
        this.mainLayerCard.add((Component)this.mainPanel, "Center");
        this.initEmptySpaces();
        this.mainLayerIcons = new JPanel(null);
        this.mainLayerIcons.setOpaque(false);
        this.mainContainer.add((Component)this.mainLayerIcons, (Object)10);
        if (DebugUtil.GUI_CARD_DRAW_MOUSE_CONTAINS_BOUNDS) {
            this.mainLayerDebug = new JPanel(null);
            this.mainLayerDebug.setOpaque(false);
            this.mainLayerDebug.setBorder(BorderFactory.createLineBorder(Color.MAGENTA));
            this.mainContainer.add((Component)this.mainLayerDebug, (Object)20);
        }
        this.iconsRender = iconsRender;
        this.initCardIconsPanels();
        if (DebugUtil.GUI_CARD_DRAW_OUTER_BORDER) {
            this.setBorder(BorderFactory.createLineBorder(Color.red));
        }
        if (DebugUtil.GUI_CARD_DRAW_INNER_BORDER) {
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.green));
        }
    }

    private void initEmptySpaces() {
        this.spaceLeft = new JPanel(null);
        this.spaceLeft.setOpaque(false);
        this.mainLayerCard.add((Component)this.spaceLeft, "West");
        this.spaceRight = new JPanel(null);
        this.spaceRight.setOpaque(false);
        this.mainLayerCard.add((Component)this.spaceRight, "East");
        this.spaceTop = new JPanel(null);
        this.spaceTop.setOpaque(false);
        this.mainLayerCard.add((Component)this.spaceTop, "North");
        this.spaceBottom = new JPanel(null);
        this.spaceBottom.setOpaque(false);
        this.mainLayerCard.add((Component)this.spaceBottom, "South");
    }

    private void initCardIconsPanels() {
        this.iconsDebugPanel = null;
        this.iconsAbilitiesPanel = null;
        this.iconsPlayablePanel = null;
        this.iconsCommanderPanel = null;
        if (this.iconsRender.isDebugMode()) {
            this.iconsDebugPanel = CardIconsPanelFactory.createDebugPanel(this.iconsRender);
            this.iconsPanels.add(this.iconsDebugPanel);
        } else {
            if (PreferencesDialog.getRenderIconsForAbilities()) {
                this.iconsAbilitiesPanel = CardIconsPanelFactory.createAbilitiesPanel();
                this.iconsPanels.add(this.iconsAbilitiesPanel);
                this.iconsCommanderPanel = CardIconsPanelFactory.createCommanderPanel();
                this.iconsPanels.add(this.iconsCommanderPanel);
            }
            if (PreferencesDialog.getRenderIconsForPlayable()) {
                this.iconsPlayablePanel = CardIconsPanelFactory.createPlayablePanel();
                this.iconsPanels.add(this.iconsPlayablePanel);
            }
        }
        this.iconsPanels.forEach(panel -> this.mainLayerIcons.add((Component)panel));
    }

    private void setEmptySpaces(int left, int right, int top, int bottom) {
        this.setEmptySpaces(new MageCardSpace(left, right, top, bottom));
    }

    private void setEmptySpaces(MageCardSpace space) {
        Border border = space.getDebugColor() == null ? null : BorderFactory.createLineBorder(space.getDebugColor());
        this.spaceLeft.setPreferredSize(new Dimension(space.getLeft(), 0));
        this.spaceLeft.setBorder(border);
        this.spaceRight.setPreferredSize(new Dimension(space.getRight(), 0));
        this.spaceRight.setBorder(border);
        this.spaceTop.setPreferredSize(new Dimension(0, space.getTop()));
        this.spaceTop.setBorder(border);
        this.spaceBottom.setPreferredSize(new Dimension(0, space.getBottom()));
        this.spaceBottom.setBorder(border);
    }

    public MageCard getMainPanel() {
        return this.mainPanel.getMainPanel();
    }

    public void onBeginAnimation() {
        this.mainPanel.onBeginAnimation();
    }

    public void onEndAnimation() {
        this.mainPanel.onEndAnimation();
    }

    public boolean isTapped() {
        return this.mainPanel.isTapped();
    }

    public boolean isFlipped() {
        return this.mainPanel.isFlipped();
    }

    public void setAlpha(float transparency) {
        this.mainPanel.setAlpha(transparency);
    }

    public float getAlpha() {
        return this.mainPanel.getAlpha();
    }

    public CardView getOriginal() {
        return this.mainPanel.getOriginal();
    }

    public void setCardCaptionTopOffset(int yOffsetPercent) {
        this.mainPanel.setCardCaptionTopOffset(yOffsetPercent);
    }

    private MageCardSpace getAdditionalSpaces(int renderWidth, int renderHeight) {
        return new MageCardSpace(0, 0, Math.round((float)renderHeight * 0.0f), 0);
    }

    public void setCardBounds(int x, int y, int width, int height) {
        if (this.getTopPanelRef() == this) {
            MageCardSpace outerSpace;
            MageCardSpace innerSpace = this.getAdditionalSpaces(width, height);
            this.lastOuterSpace = outerSpace = new MageCardSpace(width * 2, width * 2, height * 2, height * 2);
            MageCardSpace fullSpace = MageCardSpace.combine((MageCardSpace[])new MageCardSpace[]{innerSpace, outerSpace}).withDebugColor(innerSpace.getDebugColor());
            this.setEmptySpaces(fullSpace);
            this.setBounds(x - outerSpace.getLeft(), y - outerSpace.getTop(), width + outerSpace.getWidth(), height + outerSpace.getHeight());
            this.mainPanel.setCardBounds(x + innerSpace.getLeft(), y + innerSpace.getTop(), width - innerSpace.getWidth(), height - innerSpace.getHeight());
        } else {
            this.setEmptySpaces(0, 0, 0, 0);
            this.setBounds(x, y, width, height);
            this.mainPanel.setCardBounds(x, y, width, height);
        }
        MageCardLocation location = this.getCardLocation();
        this.mainLayerCard.setBounds(0, 0, location.getComponentWidth(), location.getComponentHeight());
        this.mainLayerIcons.setBounds(0, 0, location.getComponentWidth(), location.getComponentHeight());
        Rectangle cardSize = new Rectangle(location.getCardRelativeX(), location.getCardRelativeY(), location.getCardWidth(), location.getCardHeight());
        this.iconsPanels.forEach(panel -> panel.updateSizes(cardSize));
    }

    public void update(CardView card) {
        this.updateCardIcons(card);
        this.mainPanel.update(card);
    }

    private void updateCardIcons(CardView card) {
        HashMap newIcons = new HashMap();
        this.iconsPanels.forEach(panel -> {
            List cfr_ignored_0 = newIcons.put(panel, new ArrayList());
        });
        ArrayList<PlayableCountIcon> allIcons = new ArrayList<PlayableCountIcon>();
        allIcons.addAll(card.getCardIcons());
        if (card.getPlayableStats().getPlayableImportantAmount() > 0) {
            allIcons.add(new PlayableCountIcon(card.getPlayableStats()));
        }
        allIcons.forEach(cardIcon -> {
            CardIconCategory category = cardIcon.getIconType().getCategory();
            if (this.iconsDebugPanel != null) {
                ((List)newIcons.get(this.iconsDebugPanel)).add(cardIcon);
            }
            if (this.iconsPlayablePanel != null && category == CardIconCategory.PLAYABLE_COUNT) {
                ((List)newIcons.get(this.iconsPlayablePanel)).add(cardIcon);
            }
            if (this.iconsAbilitiesPanel != null && category == CardIconCategory.ABILITY) {
                ((List)newIcons.get(this.iconsAbilitiesPanel)).add(cardIcon);
            }
            if (this.iconsCommanderPanel != null && category == CardIconCategory.COMMANDER) {
                ((List)newIcons.get(this.iconsCommanderPanel)).add(cardIcon);
            }
        });
        this.iconsPanels.forEach(panel -> panel.updateIcons((List)newIcons.get(panel)));
    }

    public void updateArtImage() {
        this.mainPanel.updateArtImage();
    }

    public Image getImage() {
        return this.mainPanel.getImage();
    }

    public void setZone(Zone zone) {
        this.mainPanel.setZone(zone);
    }

    public Zone getZone() {
        return this.mainPanel.getZone();
    }

    public void toggleTransformed() {
        this.mainPanel.toggleTransformed();
    }

    public boolean isTransformed() {
        return this.mainPanel.isTransformed();
    }

    public void showCardTitle() {
        this.mainPanel.showCardTitle();
    }

    public void setSelected(boolean selected) {
        this.mainPanel.setSelected(selected);
    }

    public void setCardContainerRef(Container cardContainer) {
        this.mainPanel.setCardContainerRef(cardContainer);
    }

    public void setTopPanelRef(MageCard mageCard) {
        this.mainPanel.setTopPanelRef(mageCard);
    }

    public MageCard getTopPanelRef() {
        return this.mainPanel.getTopPanelRef();
    }

    public Container getCardContainer() {
        return this.mainPanel.getCardContainer();
    }

    public void setChoosable(boolean isChoosable) {
        this.mainPanel.setChoosable(isChoosable);
    }

    public boolean isChoosable() {
        return this.mainPanel.isChoosable();
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.mainPanel.setPopupMenu(popupMenu);
    }

    public JPopupMenu getPopupMenu() {
        return this.mainPanel.getPopupMenu();
    }

    public void cleanUp() {
        this.mainPanel.cleanUp();
    }

    public int getCardWidth() {
        return this.mainPanel.getCardWidth();
    }

    public int getCardHeight() {
        return this.mainPanel.getCardHeight();
    }

    public MageCardAnimationSettings getAnimationSettings(int offsetX, int offsetY, float cardBoundWidth, float cardBoundHeight) {
        return this.mainPanel.getAnimationSettings(offsetX, offsetY, cardBoundWidth, cardBoundHeight);
    }

    public List<MageCard> getLinks() {
        return this.mainPanel.getLinks();
    }

    public MageCardSpace getOuterSpace() {
        return this.lastOuterSpace;
    }

    public MageCardLocation getCardLocation() {
        if (this.getTopPanelRef() == this) {
            return new MageCardLocation(this.getLocation(), this.getOuterSpace(), this.getBounds());
        }
        return super.getCardLocation();
    }

    public void setCardLocation(int x, int y) {
        if (this.getTopPanelRef() == this) {
            this.setLocation(x - this.lastOuterSpace.getLeft(), y - this.lastOuterSpace.getTop());
        } else {
            this.getTopPanelRef().setCardLocation(x, y);
        }
    }

    public MageCardLocation getCardLocationOnScreen() {
        if (this.getTopPanelRef() == this) {
            return new MageCardLocation(this.getLocationOnScreen(), this.getOuterSpace(), this.getBounds());
        }
        return super.getCardLocationOnScreen();
    }

    public int hashCode() {
        return this.mainPanel.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.mainPanel.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        this.mainPanel.removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mainPanel.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mainPanel.removeMouseMotionListener(l);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        this.mainPanel.addMouseWheelListener(l);
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        this.mainPanel.removeMouseWheelListener(l);
    }

    public void paint(Graphics g) {
        int offsetX = this.getOuterSpace().getLeft();
        int offsetY = this.getOuterSpace().getTop();
        int extraWidth = this.getOuterSpace().getWidth();
        int extraHeight = this.getOuterSpace().getHeight();
        Rectangle componentRect = this.getCardLocation().getComponentBounds();
        MageCardAnimationSettings settings = this.getAnimationSettings(offsetX, offsetY, componentRect.width - extraWidth, componentRect.height - extraHeight);
        if (!settings.isVisible()) {
            return;
        }
        if (!this.isValid() || !this.mainPanel.isValid()) {
            this.mainPanel.validate();
            super.validate();
        }
        Graphics2D g2d = (Graphics2D)g;
        settings.doTransforms(g2d);
        super.paint(g);
    }

    public boolean contains(int x, int y) {
        MageCardLocation needLocation = this.getCardLocation();
        Rectangle iconsOffset = new Rectangle(0, 0);
        if (this.iconsPanels.stream().anyMatch(Component::isVisible)) {
            CardIconsPanel samplePanel = (CardIconsPanel)this.iconsPanels.stream().findFirst().get();
            iconsOffset.x = -samplePanel.getHalfSize();
            iconsOffset.y = -samplePanel.getHalfSize();
            iconsOffset.height = samplePanel.getHalfSize();
            iconsOffset.width = samplePanel.getHalfSize();
        }
        Rectangle normalRect = new Rectangle(needLocation.getCardRelativeX() + iconsOffset.x, needLocation.getCardRelativeY() + iconsOffset.y, needLocation.getCardWidth() + iconsOffset.width, needLocation.getCardHeight() + iconsOffset.height);
        Rectangle animatedRect = MageLayer.animateCoords(this, normalRect);
        if (DebugUtil.GUI_CARD_DRAW_MOUSE_CONTAINS_BOUNDS) {
            this.mainLayerDebug.setBounds(animatedRect.x, animatedRect.y, animatedRect.width, animatedRect.height);
            if (animatedRect.contains(x, y)) {
                this.mainLayerDebug.setBorder(BorderFactory.createLineBorder(Color.green));
            } else {
                this.mainLayerDebug.setBorder(BorderFactory.createLineBorder(Color.MAGENTA));
            }
        }
        return animatedRect.contains(x, y);
    }

    public static Rectangle animateCoords(MageCard card, Rectangle normalRect) {
        int needX = normalRect.x;
        int needY = normalRect.y;
        int needW = normalRect.width;
        int needH = normalRect.height;
        int cx = needX;
        int cy = needY;
        int cw = needW;
        int ch = needH;
        if (card.isTapped()) {
            cx = needX;
            cy = needY + needH - needW;
            cw = needH;
            ch = needW;
        }
        return new Rectangle(cx, cy, cw, ch);
    }
}

