/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.ObjectColor;
import mage.cards.ArtRect;
import mage.constants.CardType;
import mage.view.CardView;
import org.mage.card.arcane.CardPanelAttributes;
import org.mage.card.arcane.CardRendererUtils;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.ModernCardRenderer;
import org.mage.card.arcane.TextboxRule;

public class ModernSplitCardRenderer
extends ModernCardRenderer {
    public static final Color ADVENTURE_BOX_WHITE = new Color(135, 122, 103);
    public static final Color ADVENTURE_BOX_BLUE = new Color(2, 96, 131);
    public static final Color ADVENTURE_BOX_BLACK = new Color(52, 44, 46);
    public static final Color ADVENTURE_BOX_RED = new Color(126, 61, 42);
    public static final Color ADVENTURE_BOX_GREEN = new Color(9, 51, 30);
    public static final Color ADVENTURE_BOX_GOLD = new Color(118, 92, 42);
    public static final Color ADVENTURE_BOX_COLORLESS = new Color(131, 133, 135);
    static String RULES_MARK_FUSE = "Fuse";
    static String RULES_MARK_AFTERMATH = "Aftermath";
    private static final List<CardType> ONLY_LAND_TYPE = Arrays.asList(CardType.LAND);
    private HalfCardProps rightHalf = new HalfCardProps();
    private HalfCardProps leftHalf = new HalfCardProps();
    private int dividerAt;
    private int dividerSize;
    private boolean isFuse = false;
    private boolean isAftermath = false;

    private static String trimAdventure(String rule) {
        if (rule.startsWith("Adventure") || rule.startsWith("Omen")) {
            return rule.substring(rule.lastIndexOf("&mdash;") + 8);
        }
        return rule;
    }

    public ModernSplitCardRenderer(CardView view) {
        super(view);
        this.rightHalf.manaCostString = ManaSymbols.getClearManaCost(this.cardView.getRightSplitCostsStr());
        this.leftHalf.manaCostString = ManaSymbols.getClearManaCost(this.cardView.getLeftSplitCostsStr());
        this.rightHalf.color = new ObjectColor(this.cardView.getRightSplitCostsStr());
        this.leftHalf.color = new ObjectColor(this.cardView.getLeftSplitCostsStr());
        if (this.isCardWithSpellOption()) {
            ArrayList<String> trimmedRules = new ArrayList<String>();
            for (String rule2 : view.getRightSplitRules()) {
                trimmedRules.add(ModernSplitCardRenderer.trimAdventure(rule2));
            }
            this.parseRules(trimmedRules, this.rightHalf.keywords, this.rightHalf.rules);
        } else {
            this.parseRules(view.getRightSplitRules(), this.rightHalf.keywords, this.rightHalf.rules);
        }
        this.parseRules(view.getLeftSplitRules(), this.leftHalf.keywords, this.leftHalf.rules);
        this.rightHalf.typeLineString = this.cardView.getRightSplitTypeLine();
        this.leftHalf.typeLineString = this.cardView.getLeftSplitTypeLine();
        this.rightHalf.name = this.cardView.getRightSplitName();
        this.leftHalf.name = this.cardView.getLeftSplitName();
        this.isFuse = view.getRules().stream().anyMatch(rule -> rule.contains(RULES_MARK_FUSE));
        this.isAftermath = view.getRightSplitRules().stream().anyMatch(rule -> rule.contains(RULES_MARK_AFTERMATH));
        if (this.isCardWithSpellOption()) {
            this.manaCostString = this.leftHalf.manaCostString;
            this.textboxKeywords = this.leftHalf.keywords;
            this.textboxRules = this.leftHalf.rules;
        } else if (!this.isAftermath()) {
            HalfCardProps tmp = this.leftHalf;
            this.leftHalf = this.rightHalf;
            this.rightHalf = tmp;
        }
    }

    private boolean isAftermath() {
        return this.isAftermath;
    }

    private boolean isFuse() {
        return this.isFuse;
    }

    @Override
    protected void layout(int cardWidth, int cardHeight) {
        super.layout(cardWidth, cardHeight);
        if (this.isAftermath()) {
            this.dividerSize = this.borderWidth;
            this.dividerAt = (int)((double)cardHeight * 0.54);
        } else {
            int availHeight = cardHeight - this.totalContentInset - 3 * this.borderWidth;
            this.dividerSize = this.borderWidth * 2;
            this.dividerAt = (int)((double)this.totalContentInset + (double)availHeight * 0.5 - (double)this.borderWidth);
        }
        this.rightHalf.x = this.leftHalf.x = this.totalContentInset;
        this.rightHalf.w = this.leftHalf.w = cardWidth - 2 * this.totalContentInset;
        this.leftHalf.y = this.totalContentInset;
        this.leftHalf.h = this.dividerAt - this.totalContentInset;
        this.rightHalf.y = this.dividerAt + this.dividerSize;
        this.rightHalf.h = cardHeight - this.rightHalf.y - this.borderWidth * 3;
        if (this.isAftermath()) {
            this.leftHalf.cw = this.leftHalf.w;
            this.leftHalf.ch = this.leftHalf.h;
        } else {
            this.leftHalf.cw = this.leftHalf.h;
            this.leftHalf.ch = this.leftHalf.w;
        }
        this.rightHalf.cw = this.rightHalf.h;
        this.rightHalf.ch = this.rightHalf.w;
        if (this.isFuse()) {
            this.rightHalf.ch -= this.boxHeight;
            this.leftHalf.ch -= this.boxHeight;
        }
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        if (this.cardView.isFaceDown()) {
            this.drawCardBackTexture(g);
        }
        if (this.isCardWithSpellOption()) {
            super.drawBackground(g);
        } else {
            g.setPaint(ModernSplitCardRenderer.getBackgroundPaint(this.leftHalf.color, this.cardView.getCardTypes(), this.cardView.getSubTypes()));
            g.fillRoundRect(this.borderWidth, this.borderWidth, this.cardWidth - 2 * this.borderWidth, this.leftHalf.h + this.contentInset - this.borderWidth - 2 * this.cornerRadius + (this.cornerRadius - 1), this.cornerRadius - 1, this.cornerRadius - 1);
            g.fillRoundRect(this.borderWidth, this.dividerAt - this.borderWidth - 4 * this.cornerRadius, this.cardWidth - 2 * this.borderWidth, this.cornerRadius * 4, this.cornerRadius * 2, this.cornerRadius * 2);
            g.fillRect(this.borderWidth + this.contentInset, this.dividerAt - 2 * this.borderWidth, this.cardWidth - this.borderWidth * 2 - this.contentInset * 2, this.borderWidth * 2);
            g.setPaint(ModernSplitCardRenderer.getBackgroundPaint(this.rightHalf.color, this.cardView.getCardTypes(), this.cardView.getSubTypes()));
            g.fillRoundRect(this.borderWidth, this.dividerAt + this.dividerSize + this.borderWidth, this.cardWidth - 2 * this.borderWidth, this.rightHalf.h - 2 * this.borderWidth, this.cornerRadius * 2, this.cornerRadius * 2);
            g.fillRect(this.borderWidth + this.contentInset, this.dividerAt + this.dividerSize, this.cardWidth - this.borderWidth * 2 - this.contentInset * 2, this.rightHalf.h);
        }
    }

    @Override
    protected void drawArt(Graphics2D g) {
        if (this.isCardWithSpellOption) {
            super.drawArt(g);
        } else if (this.artImage != null) {
            if (this.isAftermath()) {
                Rectangle2D topRect = ArtRect.AFTERMATH_TOP.rect;
                int topLineY = (int)((float)this.leftHalf.ch * 0.57f);
                this.drawArtIntoRect(g, this.leftHalf.x, this.leftHalf.y + this.boxHeight, this.leftHalf.cw, topLineY - this.boxHeight, topRect, false);
                Rectangle2D bottomRect = ArtRect.AFTERMATH_BOTTOM.rect;
                int bottomLineY = (this.rightHalf.ch - this.boxHeight) / 2;
                this.drawArtIntoRect(g, this.rightHalf.x + this.rightHalf.w - bottomLineY, this.rightHalf.y, bottomLineY - this.boxHeight, this.rightHalf.h, bottomRect, false);
            } else {
                Rectangle2D topRect = ArtRect.SPLIT_RIGHT.rect;
                int topLineY = (int)((float)this.leftHalf.ch * 0.57f);
                this.drawArtIntoRect(g, this.leftHalf.x + this.boxHeight, this.leftHalf.y, topLineY - this.boxHeight, this.leftHalf.h, topRect, false);
                Rectangle2D bottomRect = ArtRect.SPLIT_LEFT.rect;
                int bottomLineY = (int)((float)this.rightHalf.ch * 0.57f);
                this.drawArtIntoRect(g, this.rightHalf.x + this.boxHeight, this.rightHalf.y, bottomLineY - this.boxHeight, this.rightHalf.h, bottomRect, false);
            }
        }
    }

    protected void drawSplitHalfFrame(Graphics2D g, CardPanelAttributes attribs, HalfCardProps half, int typeLineY) {
        Color boxColor = this.getBoxColor(half.color, this.cardView.getCardTypes(), attribs.isTransformed);
        Paint textboxPaint = ModernSplitCardRenderer.getTextboxPaint(half.color, this.cardView.getCardTypes(), this.cardWidth, false);
        Paint borderPaint = ModernSplitCardRenderer.getBorderPaint(half.color, this.cardView.getCardTypes(), this.cardWidth);
        g.setPaint(borderPaint);
        g.drawRect(0, 0, half.cw - 1, half.ch - 1);
        g.setPaint(textboxPaint);
        g.fillRect(1, typeLineY, half.cw - 2, half.ch - typeLineY - 1);
        CardRendererUtils.drawRoundedBox(g, -this.borderWidth, 0, half.cw + 2 * this.borderWidth, this.boxHeight, this.contentInset, borderPaint, boxColor);
        CardRendererUtils.drawRoundedBox(g, -this.borderWidth, typeLineY, half.cw + 2 * this.borderWidth, this.boxHeight - 4, this.contentInset, borderPaint, boxColor);
        this.drawNameLine(g, attribs, half.name, half.manaCostString, 0, 0, half.cw, this.boxHeight);
        this.drawTypeLine(g, attribs, half.typeLineString, 0, typeLineY, half.cw, this.boxHeight - 4, true);
        this.drawRulesText(g, half.keywords, half.rules, 2, typeLineY + this.boxHeight + 2 - 4, half.cw - 4, half.ch - typeLineY - this.boxHeight, false);
    }

    private Graphics2D getUnmodifiedHalfContext(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.leftHalf.x, this.leftHalf.y);
        return g2;
    }

    private Graphics2D getAftermathHalfContext(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.rightHalf.x, this.rightHalf.y);
        g2.rotate(1.5707963267948966);
        g2.translate(0, -this.rightHalf.w);
        return g2;
    }

    private Graphics2D getLeftHalfContext(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.leftHalf.x, this.leftHalf.y);
        g2.rotate(-1.5707963267948966);
        g2.translate(-this.leftHalf.cw, 0);
        return g2;
    }

    private Graphics2D getRightHalfContext(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(this.rightHalf.x, this.rightHalf.y);
        g2.rotate(-1.5707963267948966);
        g2.translate(-this.rightHalf.cw, 0);
        return g2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawFrame(Graphics2D g, CardPanelAttributes attribs, BufferedImage image, boolean lessOpaqueRulesTextBox) {
        if (this.isCardWithSpellOption()) {
            super.drawFrame(g, attribs, image, lessOpaqueRulesTextBox);
            CardPanelAttributes adventureAttribs = new CardPanelAttributes(attribs.cardWidth, attribs.cardHeight, attribs.isChoosable, attribs.isSelected, true);
            g.setPaint(this.getBoxColor(this.rightHalf.color, this.cardView.getCardTypes(), true));
            g.fillRect(this.totalContentInset, this.typeLineY + this.boxHeight + 1, this.contentWidth / 2 - 1, this.boxHeight - 2);
            g.setPaint(this.getAdventureBoxColor(this.rightHalf.color));
            g.fillRect(this.totalContentInset, this.typeLineY + this.boxHeight * 2 - 1, this.contentWidth / 2 - 1, this.boxHeight - 2);
            g.setPaint(ModernSplitCardRenderer.getTextboxPaint(this.rightHalf.color, this.cardView.getCardTypes(), this.cardWidth, lessOpaqueRulesTextBox));
            g.fillRect(this.totalContentInset, this.typeLineY + this.boxHeight * 3 - 3, this.contentWidth / 2 - 1, this.cardHeight - this.borderWidth * 3 - this.typeLineY - this.boxHeight * 3 + 2);
            this.drawNameLine(g, adventureAttribs, this.rightHalf.name, this.rightHalf.manaCostString, this.totalContentInset + 2, this.typeLineY + this.boxHeight, this.contentWidth / 2 - 8, this.boxHeight - 2);
            this.drawTypeLine(g, adventureAttribs, this.rightHalf.typeLineString, this.totalContentInset + 2, this.typeLineY + this.boxHeight * 2 - 2, this.contentWidth / 2 - 8, this.boxHeight - 2, true);
            this.drawRulesText(g, this.rightHalf.keywords, this.rightHalf.rules, this.totalContentInset + 3, this.typeLineY + this.boxHeight * 3 - 1, this.contentWidth / 2 - 8, this.cardHeight - this.borderWidth * 3 - this.typeLineY - this.boxHeight * 3 + 2, false);
        } else {
            if (this.isAftermath()) {
                Graphics2D g2 = this.getUnmodifiedHalfContext(g);
                try {
                    this.drawSplitHalfFrame(g2, attribs, this.leftHalf, (int)((float)this.leftHalf.ch * 0.57f));
                }
                finally {
                    g2.dispose();
                }
                g2 = this.getAftermathHalfContext(g);
                try {
                    this.drawSplitHalfFrame(g2, attribs, this.rightHalf, (this.rightHalf.ch - this.boxHeight) / 2);
                }
                finally {
                    g2.dispose();
                }
            }
            Graphics2D g2 = this.getLeftHalfContext(g);
            try {
                this.drawSplitHalfFrame(g2, attribs, this.leftHalf, (int)((float)this.leftHalf.ch * 0.57f));
            }
            finally {
                g2.dispose();
            }
            g2 = this.getRightHalfContext(g);
            try {
                this.drawSplitHalfFrame(g2, attribs, this.rightHalf, (int)((float)this.rightHalf.ch * 0.57f));
            }
            finally {
                g2.dispose();
            }
            if (this.isFuse()) {
                g2 = this.getRightHalfContext(g);
                try {
                    int totalFuseBoxWidth = this.rightHalf.cw * 2 + 2 * this.borderWidth + this.dividerSize;
                    Paint boxColor = ModernSplitCardRenderer.getTextboxPaint(this.cardView.getColor(), ONLY_LAND_TYPE, totalFuseBoxWidth, false);
                    Paint borderPaint = ModernSplitCardRenderer.getBorderPaint(this.cardView.getColor(), ONLY_LAND_TYPE, totalFuseBoxWidth);
                    CardRendererUtils.drawRoundedBox(g2, -this.borderWidth, this.rightHalf.ch, totalFuseBoxWidth, this.boxHeight, this.contentInset, borderPaint, boxColor);
                    this.drawNameLine(g2, attribs, "Fuse <i>(You may cast one or both halves of this card from your hand.)</i>", "", 0, this.rightHalf.ch, totalFuseBoxWidth - 2 * this.borderWidth, this.boxHeight);
                }
                finally {
                    g2.dispose();
                }
            }
        }
    }

    protected Color getAdventureBoxColor(ObjectColor colors) {
        if (colors.isMulticolored()) {
            return ADVENTURE_BOX_GOLD;
        }
        if (colors.isColorless()) {
            return ADVENTURE_BOX_COLORLESS;
        }
        if (colors.isWhite()) {
            return ADVENTURE_BOX_WHITE;
        }
        if (colors.isBlue()) {
            return ADVENTURE_BOX_BLUE;
        }
        if (colors.isBlack()) {
            return ADVENTURE_BOX_BLACK;
        }
        if (colors.isRed()) {
            return ADVENTURE_BOX_RED;
        }
        if (colors.isGreen()) {
            return ADVENTURE_BOX_GREEN;
        }
        return ERROR_COLOR;
    }

    private static class HalfCardProps {
        int x;
        int y;
        int w;
        int h;
        int cw;
        int ch;
        String name;
        String typeLineString;
        String manaCostString;
        ObjectColor color;
        ArrayList<TextboxRule> rules = new ArrayList();
        ArrayList<TextboxRule> keywords = new ArrayList();

        private HalfCardProps() {
        }
    }
}

