/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Base64;
import mage.abilities.icon.CardIconColor;
import mage.abilities.icon.CardIconImpl;
import mage.utils.StreamUtils;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.log4j.Logger;
import org.mage.plugins.card.utils.CardImageUtils;
import org.mage.plugins.card.utils.impl.ImageManagerImpl;

public class SvgUtils {
    private static final Logger logger = Logger.getLogger(SvgUtils.class);
    private static boolean haveSvgSupport = false;
    private static final String CSS_BASE_SETTINGS = "shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;";

    private static String getSvgTempFolder() {
        return CardImageUtils.getImagesDir() + File.separator + "temp";
    }

    public static String getSvgTempFile(String fileName) {
        return SvgUtils.getSvgTempFolder() + File.separator + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareCss(String cssFileName, String cssAdditionalSettings, Boolean forceToCreateCss) {
        File cssFile = new File(SvgUtils.getSvgTempFile(cssFileName));
        if (forceToCreateCss.booleanValue() || !cssFile.exists()) {
            String css = "svg {shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;" + cssAdditionalSettings + "}";
            FileWriter w = null;
            try {
                cssFile.getParentFile().mkdirs();
                cssFile.createNewFile();
                w = new FileWriter(cssFile);
                w.write(css);
            }
            catch (Throwable e) {
                try {
                    logger.error((Object)("Can't create css file for svg: " + cssFile.toPath().toAbsolutePath().toString()), e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(w);
                    throw throwable;
                }
                StreamUtils.closeQuietly((Closeable)w);
            }
            StreamUtils.closeQuietly((Closeable)w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadSVG(InputStream svgFile, String svgInfo, String cssFileName, String cssAdditionalSettings, int resizeToWidth, int resizeToHeight, boolean useShadow) throws IOException {
        if (svgFile == null) {
            throw new IllegalArgumentException("Empty svg data or unknown file");
        }
        useShadow = false;
        if (useShadow && (resizeToWidth <= 0 || resizeToHeight <= 0)) {
            throw new IllegalArgumentException("Must use non zero sizes for shadow");
        }
        final BufferedImage[] imagePointer = new BufferedImage[1];
        SvgUtils.prepareCss(cssFileName, cssAdditionalSettings, false);
        File cssFile = new File(SvgUtils.getSvgTempFile(cssFileName));
        byte[] cssFileContent = Files.readAllBytes(cssFile.toPath());
        String cssDataURI = "data:text/css;base64," + Base64.getEncoder().encodeToString(cssFileContent);
        TranscodingHints transcoderHints = new TranscodingHints();
        int shadowX = 0;
        int shadowY = 0;
        if (useShadow) {
            shadowX = 1 * Math.round(0.0625f * (float)resizeToWidth);
            shadowY = 2 * Math.round(0.0625f * (float)resizeToHeight);
            resizeToWidth -= shadowX;
            resizeToHeight -= shadowY;
        }
        if (resizeToWidth > 0) {
            transcoderHints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(resizeToWidth));
        }
        if (resizeToHeight > 0) {
            transcoderHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(resizeToHeight));
        }
        transcoderHints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)cssDataURI);
        try {
            TranscoderInput input = new TranscoderInput(svgFile);
            ImageTranscoder t = new ImageTranscoder(){

                public BufferedImage createImage(int w, int h) {
                    return new BufferedImage(w, h, 2);
                }

                public void writeImage(BufferedImage image, TranscoderOutput out) {
                    imagePointer[0] = image;
                }
            };
            t.setTranscodingHints(transcoderHints);
            t.transcode(input, null);
        }
        catch (Exception e) {
            throw new IOException("Can't load svg file: " + svgInfo + " , reason: " + e.getMessage());
        }
        BufferedImage originImage = imagePointer[0];
        if (useShadow && originImage.getWidth() > 0) {
            FilteredImageSource prod = new FilteredImageSource(originImage.getSource(), new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    if (rgb == 0) {
                        return 0;
                    }
                    return -16777216;
                }
            });
            Image shadow = Toolkit.getDefaultToolkit().createImage(prod);
            BufferedImage result = new BufferedImage(originImage.getWidth() + shadowX, originImage.getHeight() + shadowY, originImage.getType());
            Graphics2D g2 = result.createGraphics();
            try {
                g2.drawImage(shadow, -1 * shadowX, shadowY, null);
                g2.drawImage((Image)originImage, 0, 0, null);
            }
            finally {
                g2.dispose();
            }
            return result;
        }
        return originImage;
    }

    public static boolean checkSvgSupport() {
        BufferedImage sampleImage = ImageManagerImpl.instance.getCardIcon(CardIconImpl.ABILITY_FLYING.getIconType().getResourceName(), 32, CardIconColor.DEFAULT);
        boolean bl = haveSvgSupport = sampleImage != null && sampleImage.getWidth() > 0;
        if (!haveSvgSupport) {
            logger.warn((Object)"WARNING, your system doesn't support svg images, so card icons will be disabled. Please, make a bug report in the github.");
        }
        return haveSvgSupport;
    }

    public static boolean haveSvgSupport() {
        return haveSvgSupport;
    }
}

