/*
 * Decompiled with CFR 0.152.
 */
package org.mage.card.arcane;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.regex.Pattern;
import mage.view.CardView;
import org.apache.log4j.Logger;
import org.mage.card.arcane.ManaSymbols;
import org.mage.card.arcane.TextboxBasicManaRule;
import org.mage.card.arcane.TextboxKeywordRule;
import org.mage.card.arcane.TextboxLevelRule;
import org.mage.card.arcane.TextboxLoyaltyRule;
import org.mage.card.arcane.TextboxRule;

public final class TextboxRuleParser {
    private static final Logger LOGGER = Logger.getLogger(TextboxRuleParser.class);
    private static final Pattern BasicManaAbility = Pattern.compile("\\{T\\}: Add \\{(\\w)\\}\\.");
    private static final Pattern LevelAbilityPattern = Pattern.compile("Level (\\d+)-?(\\d*)(\\+?)");
    private static final Pattern LoyaltyAbilityPattern = Pattern.compile("^(\\+|\\-)(\\d+|X): ");
    private static final Pattern SimpleKeywordPattern = Pattern.compile("^(\\w+( \\w+)?)\\s*(\\([^\\)]*\\))?\\s*$");
    private static final Pattern FontColorValuePattern = Pattern.compile("color\\s*=\\s*[\"'](\\w+)[\"']");

    /*
     * Unable to fully structure code
     */
    public static TextboxRule parse(CardView source, String rule, String cardNameToUse) {
        regions = new ArrayList<TextboxRule.AttributeRegion>();
        isLeveler = false;
        levelFrom = 0;
        levelTo = 0;
        isLoyalty = false;
        loyaltyChange = 0;
        isBasicMana = false;
        basicManaSymbol = "";
        index = 0;
        outputIndex = 0;
        simpleKeywordMatch = TextboxRuleParser.SimpleKeywordPattern.matcher(rule);
        if (simpleKeywordMatch.find()) {
            return new TextboxKeywordRule(simpleKeywordMatch.group(1), regions);
        }
        basicManaMatcher = TextboxRuleParser.BasicManaAbility.matcher(rule);
        if (basicManaMatcher.find()) {
            isBasicMana = true;
            basicManaSymbol = basicManaMatcher.group(1);
        }
        if ((loyaltyMatch = TextboxRuleParser.LoyaltyAbilityPattern.matcher(rule)).find()) {
            if (loyaltyMatch.group(2).equals("X")) {
                loyaltyChange = 100;
            } else {
                loyaltyChange = Integer.parseInt(loyaltyMatch.group(2));
                if (loyaltyMatch.group(1).equals("-")) {
                    loyaltyChange = -loyaltyChange;
                }
            }
            isLoyalty = true;
            index = loyaltyMatch.group().length();
        }
        openingStack = new ArrayDeque<Integer>();
        build = new StringBuilder();
        while (index < rule.length()) {
            initialIndex = index;
            ch = rule.charAt(index);
            switch (ch) {
                case '{': {
                    closeIndex = rule.indexOf(125, index);
                    if (closeIndex == -1) {
                        ++index;
                        ++outputIndex;
                        build.append(ch);
                        break;
                    }
                    contents = rule.substring(index + 1, closeIndex);
                    if (contents.equals("this") || contents.equals("source")) {
                        build.append(cardNameToUse);
                        index += contents.length() + 2;
                        outputIndex += cardNameToUse.length();
                        break;
                    }
                    symbol = ManaSymbols.getSizedManaSymbol(contents.replace("/", ""), 10);
                    if (symbol != null) {
                        build.append('#');
                        regions.add(new TextboxRule.EmbeddedSymbol(contents, outputIndex));
                        ++outputIndex;
                        index = closeIndex + 1;
                        break;
                    }
                    if (contents.equals("{*}")) {
                        build.append(" / ");
                        outputIndex += contents.length() - " / ".length();
                    } else {
                        build.append('{');
                        build.append(contents);
                        build.append('}');
                        outputIndex += contents.length() + 2;
                    }
                    index = closeIndex + 1;
                    break;
                }
                case '&': {
                    if (rule.startsWith("&mdash;", index)) {
                        build.append('\u2014');
                        index += 7;
                        ++outputIndex;
                        break;
                    }
                    if (rule.startsWith("&bull", index)) {
                        build.append('\u2022');
                        index += 5;
                        ++outputIndex;
                        break;
                    }
                    TextboxRuleParser.LOGGER.error((Object)("Bad &...; sequence `" + rule.substring(index, Math.min(rule.length(), index + 10)) + "` in rule."));
                    build.append('&');
                    ++index;
                    ++outputIndex;
                    break;
                }
                case '<': {
                    closeIndex = rule.indexOf(62, index);
                    if (closeIndex == -1) ** GOTO lbl159
                    tag = rule.substring(index + 1, closeIndex);
                    if (tag.charAt(tag.length() - 1) != '/') ** GOTO lbl104
                    if (tag.equals("br/")) {
                        build.append('\n');
                        ++outputIndex;
                    } else {
                        build.append('<').append(tag).append('>');
                        outputIndex += tag.length() + 2;
                    }
                    ** GOTO lbl157
lbl104:
                    // 1 sources

                    if (tag.charAt(0) != '/') ** GOTO lbl151
                    openingIndex = openingStack.isEmpty() != false ? outputIndex : (Integer)openingStack.pop();
                    var20_21 = tag;
                    var21_22 = -1;
                    switch (var20_21.hashCode()) {
                        case 1562: {
                            if (!var20_21.equals("/i")) break;
                            var21_22 = 0;
                            break;
                        }
                        case 1555: {
                            if (!var20_21.equals("/b")) break;
                            var21_22 = 1;
                            break;
                        }
                        case 46554366: {
                            if (!var20_21.equals("/font")) break;
                            var21_22 = 2;
                        }
                    }
                    switch (var21_22) {
                        case 0: {
                            regions.add(new TextboxRule.ItalicRegion(openingIndex, outputIndex));
                            break;
                        }
                        case 1: {
                            content = build.substring(openingIndex);
                            levelMatch = TextboxRuleParser.LevelAbilityPattern.matcher(content);
                            if (levelMatch.find()) {
                                try {
                                    levelFrom = Integer.parseInt(levelMatch.group(1));
                                    if (!levelMatch.group(2).isEmpty()) {
                                        levelTo = Integer.parseInt(levelMatch.group(2));
                                    }
                                    if (!levelMatch.group(3).isEmpty()) {
                                        levelTo = 100;
                                    }
                                    isLeveler = true;
                                }
                                catch (Exception e) {
                                    TextboxRuleParser.LOGGER.error((Object)("Bad leveler levels in rule `" + rule + "`."));
                                }
                                break;
                            }
                            ** GOTO lbl157
                        }
                        case 2: {
                            regions.add(new TextboxRule.ColorRegion(openingIndex, outputIndex, Color.BLUE));
                            break;
                        }
                        default: {
                            build.append('<').append(tag).append('>');
                            outputIndex += tag.length() + 2;
                            break;
                        }
                    }
                    ** GOTO lbl157
lbl151:
                    // 1 sources

                    if (tag.equals("br")) {
                        build.append('\n');
                        ++outputIndex;
                    } else {
                        openingStack.push(outputIndex);
                    }
lbl157:
                    // 7 sources

                    index = closeIndex + 1;
                    break;
lbl159:
                    // 1 sources

                    build.append('<');
                    ++outputIndex;
                    ++index;
                    break;
                }
                default: {
                    ++index;
                    ++outputIndex;
                    build.append(ch);
                }
            }
            if (outputIndex != build.length()) {
                TextboxRuleParser.LOGGER.error((Object)("The human is dead; mismatch! Failed on rule: `" + rule + "` due to not updating outputIndex properly."));
                build = new StringBuilder(rule);
                regions.clear();
                break;
            }
            if (index != initialIndex) continue;
            TextboxRuleParser.LOGGER.error((Object)("Failed on rule `" + rule + "` due to not consuming a character."));
            build = new StringBuilder(rule);
            regions.clear();
            break;
        }
        rule = build.toString();
        if (isLoyalty) {
            return new TextboxLoyaltyRule(rule, regions, loyaltyChange);
        }
        if (isLeveler) {
            return new TextboxLevelRule(rule, regions, levelFrom, levelTo);
        }
        if (isBasicMana) {
            return new TextboxBasicManaRule(rule, regions, basicManaSymbol);
        }
        return new TextboxRule(rule, regions);
    }
}

