/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.mage.plugins.card.dl.DownloadJob;
import org.mage.plugins.card.dl.Downloader;

public class DownloadGui
extends JPanel {
    private static final long serialVersionUID = -7346572382493844327L;
    private final Downloader downloader;
    private final DownloadListener listener = new DownloadListener();
    private final BoundedRangeModel progressModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private final JProgressBar progressBar = new JProgressBar(this.progressModel);
    private final Map<DownloadJob, DownloadPanel> jobPanels = new HashMap<DownloadJob, DownloadPanel>();
    private final JPanel basicPanel = new JPanel();

    public DownloadGui(Downloader downloader) {
        super(new BorderLayout());
        this.downloader = downloader;
        downloader.addPropertyChangeListener(this.listener);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Progress:"));
        p.add(this.progressBar);
        JButton closeButton = new JButton("X");
        closeButton.addActionListener(e -> this.downloader.cleanup());
        p.add((Component)closeButton, "East");
        this.add((Component)p, "North");
        this.basicPanel.setLayout(new BoxLayout(this.basicPanel, 1));
        JScrollPane pane = new JScrollPane(this.basicPanel);
        pane.setPreferredSize(new Dimension(500, 300));
        this.add(pane);
        for (int i = 0; i < downloader.getJobs().size(); ++i) {
            this.addJob(i, downloader.getJobs().get(i));
        }
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    private synchronized void addJob(int index, DownloadJob job) {
        job.addPropertyChangeListener(this.listener);
        this.changeProgress(0, 1);
        DownloadPanel p = new DownloadPanel(job);
        this.jobPanels.put(job, p);
        this.basicPanel.add((Component)p, index);
        this.basicPanel.revalidate();
    }

    private synchronized void removeJob(int index, DownloadJob job) {
        assert (this.jobPanels.get(job) == this.basicPanel.getComponent(index));
        job.removePropertyChangeListener(this.listener);
        this.changeProgress(0, -1);
        this.jobPanels.remove(job);
        this.basicPanel.remove(index);
        this.basicPanel.revalidate();
    }

    private synchronized void changeProgress(int progress, int total) {
        this.progressModel.setMaximum(total += this.progressModel.getMaximum());
        this.progressModel.setValue(progress += this.progressModel.getValue());
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(progress + "/" + total);
    }

    private class DownloadPanel
    extends JPanel {
        private static final long serialVersionUID = 1187986738303477168L;
        private final DownloadJob job;
        private final JProgressBar bar;

        DownloadPanel(DownloadJob job) {
            super(new BorderLayout());
            this.job = job;
            this.setBorder(BorderFactory.createTitledBorder(job.getName()));
            this.bar = new JProgressBar(job.getProgress());
            this.add(this.bar);
            JButton b = new JButton("X");
            b.addActionListener(e -> {
                switch (this.job.getState()) {
                    case NEW: 
                    case PREPARING: 
                    case WORKING: {
                        this.job.setState(DownloadJob.State.ABORTED);
                    }
                }
            });
            this.add((Component)b, "East");
            if (job.getState() == DownloadJob.State.FINISHED | job.getState() == DownloadJob.State.ABORTED) {
                DownloadGui.this.changeProgress(1, 0);
            }
            this.setVisible(job.getState() != DownloadJob.State.FINISHED);
            String message = job.getMessage();
            this.bar.setStringPainted(message != null);
            this.bar.setString(message);
            Dimension d = this.getPreferredSize();
            d.width = Integer.MAX_VALUE;
            this.setMaximumSize(d);
        }

        DownloadJob getJob() {
            return this.job;
        }

        JProgressBar getBar() {
            return this.bar;
        }
    }

    private class DownloadListener
    implements PropertyChangeListener {
        private DownloadListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (evt.getSource() instanceof DownloadJob) {
                DownloadPanel panel = (DownloadPanel)DownloadGui.this.jobPanels.get(evt.getSource());
                switch (name) {
                    case "state": {
                        if (evt.getOldValue() == DownloadJob.State.FINISHED || evt.getOldValue() == DownloadJob.State.ABORTED) {
                            DownloadGui.this.changeProgress(-1, 0);
                        }
                        if (evt.getNewValue() == DownloadJob.State.FINISHED || evt.getOldValue() == DownloadJob.State.ABORTED) {
                            DownloadGui.this.changeProgress(1, 0);
                        }
                        if (panel == null) break;
                        panel.setVisible(panel.getJob().getState() != DownloadJob.State.FINISHED);
                        panel.revalidate();
                        break;
                    }
                    case "message": {
                        if (panel == null) break;
                        JProgressBar bar = panel.getBar();
                        String message = panel.getJob().getMessage();
                        bar.setStringPainted(message != null);
                        bar.setString(message);
                    }
                }
            } else if (evt.getSource() == DownloadGui.this.downloader && "jobs".equals(name)) {
                DownloadJob newValue;
                IndexedPropertyChangeEvent ev = (IndexedPropertyChangeEvent)evt;
                int index = ev.getIndex();
                DownloadJob oldValue = (DownloadJob)ev.getOldValue();
                if (oldValue != null) {
                    DownloadGui.this.removeJob(index, oldValue);
                }
                if ((newValue = (DownloadJob)ev.getNewValue()) != null) {
                    DownloadGui.this.addJob(index, newValue);
                }
            }
        }
    }
}

