/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import mage.client.remote.XmageURLConnection;
import mage.util.XmageThreadFactory;
import org.apache.log4j.Logger;
import org.jetlang.channels.Channel;
import org.jetlang.channels.MemoryChannel;
import org.jetlang.core.Callback;
import org.jetlang.core.DisposingExecutor;
import org.jetlang.fibers.Fiber;
import org.jetlang.fibers.PoolFiberFactory;
import org.mage.plugins.card.dl.DownloadJob;
import org.mage.plugins.card.dl.lm.AbstractLaternaBean;

public class Downloader
extends AbstractLaternaBean {
    private static final Logger logger = Logger.getLogger(Downloader.class);
    private final List<DownloadJob> jobs;
    private final Channel<DownloadJob> jobsQueue;
    private CountDownLatch worksCount;
    private final ExecutorService pool;
    private final List<Fiber> fibers;

    public Downloader() {
        this.jobs = this.properties.list("jobs");
        this.jobsQueue = new MemoryChannel();
        this.worksCount = null;
        this.pool = Executors.newCachedThreadPool(new XmageThreadFactory("XMAGE symbols downloader", false));
        this.fibers = new ArrayList<Fiber>();
        int maxThreads = 3;
        PoolFiberFactory f = new PoolFiberFactory((Executor)this.pool);
        int numThreads = maxThreads;
        for (int i = 0; i < numThreads; ++i) {
            Fiber fiber = f.create();
            fiber.start();
            this.fibers.add(fiber);
            this.jobsQueue.subscribe((DisposingExecutor)fiber, (Callback)new DownloadCallback());
        }
    }

    public void cleanup() {
        for (DownloadJob j : this.jobs) {
            switch (j.getState()) {
                case NEW: 
                case PREPARING: 
                case WORKING: {
                    j.setState(DownloadJob.State.ABORTED);
                    break;
                }
            }
        }
        for (Fiber f : this.fibers) {
            f.dispose();
        }
        this.pool.shutdown();
        while (this.worksCount.getCount() != 0L) {
            this.worksCount.countDown();
        }
    }

    public void add(DownloadJob job) {
        if (job.getState() == DownloadJob.State.PREPARING) {
            throw new IllegalArgumentException("Job already preparing");
        }
        if (job.getState() == DownloadJob.State.WORKING) {
            throw new IllegalArgumentException("Job already working");
        }
        if (job.getState() == DownloadJob.State.FINISHED) {
            throw new IllegalArgumentException("Job already finished");
        }
        job.setState(DownloadJob.State.NEW);
        this.jobs.add(job);
    }

    public void publishAllJobs() {
        this.worksCount = new CountDownLatch(this.jobs.size());
        for (DownloadJob job : this.jobs) {
            this.jobsQueue.publish((Object)job);
        }
    }

    public void waitFinished() {
        try {
            while (this.worksCount.getCount() != 0L) {
                this.worksCount.await(60L, TimeUnit.SECONDS);
                if (this.worksCount.getCount() == 0L) continue;
                logger.warn((Object)"Download: symbols downloading too long");
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"Download: symbols downloading must be stopped");
        }
    }

    public List<DownloadJob> getJobs() {
        return this.jobs;
    }

    private class DownloadCallback
    implements Callback<DownloadJob> {
        private DownloadCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(DownloadJob job) {
            DownloadJob downloadJob = job;
            synchronized (downloadJob) {
                if (job.getState() == DownloadJob.State.NEW) {
                    job.doPrepareAndStartWork();
                    if (job.getState() != DownloadJob.State.WORKING) {
                        logger.warn((Object)("Download: can't prepare symbols download job: " + job.getName() + ", reason: " + job.getError()));
                        Downloader.this.worksCount.countDown();
                        return;
                    }
                } else {
                    return;
                }
            }
            try {
                DownloadJob.Destination dst = job.getDestination();
                BoundedRangeModel progress = job.getProgress();
                if (dst.isValid() && !job.isForceToDownload()) {
                    progress.setMaximum(1);
                    progress.setValue(1);
                } else {
                    if (dst.exists()) {
                        try {
                            dst.delete();
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Download: can't delete old file " + e), (Throwable)e);
                        }
                    }
                    XmageURLConnection connection = new XmageURLConnection(job.getUrl());
                    connection.startConnection();
                    if (connection.isConnected()) {
                        connection.connect();
                        if (connection.getResponseCode() == 200) {
                            progress.setMaximum(connection.getContentLength());
                            try (InputStream inputStream = connection.getGoodResponseAsStream();
                                 BufferedOutputStream outputStream = new BufferedOutputStream(dst.open());){
                                int len;
                                byte[] buf = new byte[8192];
                                int total = 0;
                                while ((len = inputStream.read(buf)) != -1) {
                                    if (job.getState() == DownloadJob.State.ABORTED) {
                                        throw new IOException("job was aborted");
                                    }
                                    progress.setValue(total += len);
                                    ((OutputStream)outputStream).write(buf, 0, len);
                                }
                            }
                            catch (IOException e) {
                                logger.warn((Object)("Download: " + job.getName() + " - catch error on downloading network resource " + job.getUrl() + " - " + e), (Throwable)e);
                            }
                            finally {
                                if (!dst.isValid()) {
                                    logger.warn((Object)("Download: " + job.getName() + " - downloaded invalid network resource (not exists?) " + job.getUrl()));
                                    dst.delete();
                                }
                            }
                        } else {
                            logger.warn((Object)("Download: " + job.getName() + " - can't find network resource " + job.getUrl()));
                        }
                    } else {
                        logger.warn((Object)("Download: " + job.getName() + " - can't connect to network resource " + job.getUrl()));
                    }
                }
                job.setState(DownloadJob.State.FINISHED);
            }
            catch (Exception e) {
                job.setError(e);
                logger.warn((Object)("Download: " + job.getName() + " - unknown error for network resource " + job.getUrl() + " - " + e), (Throwable)e);
            }
            finally {
                Downloader.this.worksCount.countDown();
            }
        }
    }
}

