/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.beans;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class EventListenerList
extends javax.swing.event.EventListenerList {
    private static final long serialVersionUID = -7545754245081842909L;

    public <T extends EventListener> Iterable<T> getIterable(Class<? extends T> ... listenerClass) {
        List l = Lists.transform(Arrays.asList(listenerClass), new ClassToIterableFunction());
        Iterable it = Iterables.concat(new ArrayList(l));
        return () -> new SingletonIterator(it.iterator());
    }

    public <T extends EventListener> Iterator<T> getIterator(Class<T> ... listenerClass) {
        return this.getIterable(listenerClass).iterator();
    }

    private static class SingletonIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<T> it;
        private final HashSet<T> previous = new HashSet();

        public SingletonIterator(Iterator<T> it) {
            this.it = it;
        }

        protected T computeNext() {
            while (this.it.hasNext()) {
                T next = this.it.next();
                if (!this.previous.add(next)) continue;
                return next;
            }
            return (T)this.endOfData();
        }
    }

    private class ClassToIterableFunction<T>
    implements Function<Class<? extends T>, Iterable<T>> {
        private ClassToIterableFunction() {
        }

        public Iterable<T> apply(Class<? extends T> from) {
            return () -> new ListenerIterator(from);
        }
    }

    private class ListenerIterator<T>
    extends AbstractIterator<T> {
        private final Class<? extends T> listenerClass;
        private final Object[] listeners;
        private int index;

        private ListenerIterator(Class<? extends T> listenerClass) {
            this.listeners = EventListenerList.this.listenerList;
            this.index = this.listeners.length;
            this.listenerClass = listenerClass;
        }

        protected T computeNext() {
            this.index -= 2;
            while (this.index >= 0) {
                if (this.listenerClass == this.listeners[this.index]) {
                    return (T)this.listeners[this.index + 1];
                }
                this.index -= 2;
            }
            return (T)this.endOfData();
        }
    }
}

