/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mage.client.util.CardLanguage;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.images.CardDownloadData;

public interface CardImageSource {
    public CardImageUrls generateCardUrl(CardDownloadData var1) throws Exception;

    public CardImageUrls generateTokenUrl(CardDownloadData var1) throws Exception;

    public boolean prepareDownloadList(DownloadServiceInfo var1, List<CardDownloadData> var2);

    public String getNextHttpImageUrl();

    public String getFileForHttpImage(String var1);

    public String getSourceName();

    public float getAverageSizeKb();

    public int getTotalImages();

    default public int getTokenImages() {
        return 0;
    }

    public boolean isCardSource();

    public boolean isTokenSource();

    default public boolean isLanguagesSupport() {
        return false;
    }

    default public void setCurrentLanguage(CardLanguage cardLanguage) {
    }

    default public CardLanguage getCurrentLanguage() {
        return CardLanguage.ENGLISH;
    }

    default public void doPause(String fullUrl) {
    }

    default public Map<String, String> getHttpRequestHeaders(String fullUrl) {
        return new LinkedHashMap<String, String>();
    }

    default public List<String> getSupportedSets() {
        return new ArrayList<String>();
    }

    public boolean isCardImageProvided(String var1, String var2);

    default public boolean isTokenImageProvided(String setCode, String cardName, Integer tokenNumber) {
        return false;
    }

    default public void onFinished() {
    }
}

