/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mage.cards.Sets;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageSource;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.dl.sources.CopyPasteImageSourceDialog;
import org.mage.plugins.card.images.CardDownloadData;

public enum CopyPasteImageSource implements CardImageSource
{
    instance;

    private final Set<String> supportedSets = new LinkedHashSet<String>();
    private final Set<String> missingCards = new LinkedHashSet<String>();
    Map<String, String> singleLinks = null;
    boolean loadedFromDialog = false;
    boolean viewMissingCards = true;
    Map<String, Integer> singleLinksDone = null;
    private static int maxTimes;
    int ls_size_mc = 0;
    int ls_size_ss = 0;
    int ls_size_sl = 0;
    int num_nos = 0;

    @Override
    public String getSourceName() {
        return "";
    }

    @Override
    public float getAverageSizeKb() {
        return 260.7f;
    }

    @Override
    public String getNextHttpImageUrl() {
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        for (String key : this.singleLinksDone.keySet()) {
            if (this.singleLinksDone.get(key) >= maxTimes) continue;
            this.singleLinksDone.put(key, maxTimes);
            return key;
        }
        if (maxTimes < 2) {
            ++maxTimes;
        }
        for (String key : this.singleLinksDone.keySet()) {
            if (this.singleLinksDone.get(key) >= maxTimes) continue;
            this.singleLinksDone.put(key, maxTimes);
            return key;
        }
        return null;
    }

    @Override
    public String getFileForHttpImage(String httpImageUrl) {
        String copy = httpImageUrl;
        if (copy != null) {
            return this.singleLinks.get(copy);
        }
        return null;
    }

    @Override
    public boolean prepareDownloadList(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        return true;
    }

    @Override
    public CardImageUrls generateCardUrl(CardDownloadData card) throws Exception {
        String url;
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        if ((url = this.singleLinks.get(card.getSet() + "/" + card.getName())) != null && url.length() > 0) {
            return new CardImageUrls(url);
        }
        url = this.singleLinks.get(card.getSet() + "/" + card.getName() + "." + card.getCollectorId());
        if (url != null && url.length() > 0) {
            return new CardImageUrls(url);
        }
        return null;
    }

    private boolean isDifferent() {
        boolean isdiff = false;
        if (this.ls_size_mc != this.missingCards.size()) {
            this.ls_size_mc = this.missingCards.size();
            isdiff = true;
        }
        if (this.ls_size_ss != this.supportedSets.size()) {
            this.ls_size_ss = this.supportedSets.size();
            isdiff = true;
        }
        if (this.ls_size_sl != this.singleLinks.size()) {
            this.ls_size_sl = this.singleLinks.size();
            isdiff = true;
        }
        ++this.num_nos;
        if (this.num_nos > 2) {
            this.num_nos = 0;
            isdiff = true;
        }
        return isdiff;
    }

    private void setupLinks() {
        String[] lines;
        if (this.singleLinks != null && this.loadedFromDialog) {
            if (!this.viewMissingCards) {
                if (this.isDifferent() && JOptionPane.showConfirmDialog(null, "View your missing cards and reset the list of card images to download again?", "View missing cards (found " + this.missingCards.size() + ") / Reset URLs to download ", 0) == 0) {
                    this.viewMissingCards = true;
                    this.singleLinks.clear();
                    this.loadedFromDialog = false;
                    this.supportedSets.clear();
                } else {
                    return;
                }
            }
            if (!this.viewMissingCards || this.missingCards.size() <= 0) {
                return;
            }
        }
        this.singleLinks = new HashMap<String, String>();
        this.loadedFromDialog = false;
        CopyPasteImageSourceDialog dialog = new CopyPasteImageSourceDialog();
        dialog.pack();
        int count = 0;
        if (this.viewMissingCards && !this.missingCards.isEmpty() && this.singleLinks.isEmpty()) {
            this.viewMissingCards = false;
            String displayMissingCardsStr = "Up to the first 20 cards are:\n";
            String missingCardsStr = "";
            for (String card : this.missingCards) {
                if (count < 20) {
                    displayMissingCardsStr = displayMissingCardsStr + card + "\n";
                }
                missingCardsStr = missingCardsStr + card + "\n";
                ++count;
            }
            StringSelection stringSelection = new StringSelection(missingCardsStr);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            if (this.isDifferent() && JOptionPane.showConfirmDialog(null, displayMissingCardsStr + "\n\nReset the list again?\n(NB: The full list has been copied to the clipboard)", "Your missing cards (found " + this.missingCards.size() + "): ", 0) == 0) {
                this.viewMissingCards = true;
                this.singleLinks.clear();
                this.loadedFromDialog = false;
                this.supportedSets.clear();
            } else {
                return;
            }
        }
        dialog.setVisible(true);
        for (String line : lines = dialog.getPastedData().split(System.getProperty("line.separator"))) {
            Pattern regex = Pattern.compile("\\s*\"(.*?)/(.*?)\"\\s*,\\s*\"(.*?)\"");
            Matcher regexMatcher = regex.matcher(line);
            while (regexMatcher.find()) {
                String setCode = regexMatcher.group(1);
                String cardName = regexMatcher.group(2);
                String imageURL = regexMatcher.group(3);
                this.supportedSets.add(setCode);
                this.singleLinks.put(setCode + "/" + cardName, imageURL);
                this.isDifferent();
            }
        }
        this.loadedFromDialog = true;
        if (lines.length == 0) {
            this.loadedFromDialog = false;
            this.viewMissingCards = true;
        }
    }

    @Override
    public CardImageUrls generateTokenUrl(CardDownloadData card) throws IOException {
        try {
            return this.generateCardUrl(card);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getTotalImages() {
        if (this.singleLinks == null) {
            this.setupLinks();
        }
        if (this.singleLinks != null) {
            return this.singleLinks.size();
        }
        return -1;
    }

    @Override
    public boolean isTokenSource() {
        return true;
    }

    @Override
    public boolean isCardSource() {
        return true;
    }

    @Override
    public List<String> getSupportedSets() {
        this.setupLinks();
        if (this.supportedSets.isEmpty()) {
            this.supportedSets.addAll(Sets.getInstance().keySet());
        }
        ArrayList<String> supportedSetsCopy = new ArrayList<String>(this.supportedSets);
        return supportedSetsCopy;
    }

    @Override
    public boolean isCardImageProvided(String setCode, String cardName) {
        this.missingCards.add(setCode + "/" + cardName);
        if (this.singleLinks != null) {
            return this.singleLinks.containsKey(setCode + "/" + cardName) || this.singleLinks.containsKey(setCode + "/" + cardName + "-a");
        }
        return false;
    }

    @Override
    public boolean isTokenImageProvided(String setCode, String cardName, Integer tokenNumber) {
        return false;
    }

    static {
        maxTimes = 2;
    }
}

