/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.util.Iterator;
import mage.client.constants.Constants;
import org.mage.plugins.card.dl.DownloadJob;
import org.mage.plugins.card.utils.CardImageUtils;

public class GathererSymbols
implements Iterable<DownloadJob> {
    private static File outDir;
    private static final String urlFmt = "https://gatherer.wizards.com/handlers/image.ashx?size=%1$s&name=%2$s&type=symbol";
    private static final String[] sizes;
    private static final String[] symbols;
    private static final int minNumeric = 0;
    private static final int maxNumeric = 16;

    public GathererSymbols() {
        outDir = new File(CardImageUtils.getImagesDir() + Constants.RESOURCE_PATH_SYMBOLS);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
    }

    @Override
    public Iterator<DownloadJob> iterator() {
        return new AbstractIterator<DownloadJob>(){
            private int sizeIndex;
            private int symIndex;
            private int numeric = 0;
            private File dir = new File(GathererSymbols.access$000(), GathererSymbols.access$100()[this.sizeIndex]);

            protected DownloadJob computeNext() {
                File dst;
                String symbol;
                String sym;
                block33: while (true) {
                    if (this.symIndex < symbols.length) {
                        sym = symbols[this.symIndex++];
                    } else if (this.numeric <= 16) {
                        sym = String.valueOf(this.numeric++);
                    } else {
                        ++this.sizeIndex;
                        if (this.sizeIndex == sizes.length) {
                            return (DownloadJob)this.endOfData();
                        }
                        this.symIndex = 0;
                        this.numeric = 0;
                        this.dir = new File(outDir, sizes[this.sizeIndex]);
                        continue;
                    }
                    symbol = sym.replaceAll("/", "");
                    dst = new File(this.dir, symbol + ".png");
                    switch (symbol) {
                        case "WUP": 
                        case "BRP": 
                        case "BGP": 
                        case "WBP": 
                        case "UBP": 
                        case "URP": {
                            continue block33;
                        }
                    }
                    break;
                }
                int modSizeIndex = this.sizeIndex;
                if (this.sizeIndex == 2) {
                    switch (symbol) {
                        case "GUP": 
                        case "GWP": 
                        case "RGP": 
                        case "RWP": 
                        case "H": {
                            modSizeIndex = 1;
                            break;
                        }
                    }
                }
                switch (symbol) {
                    case "T": {
                        symbol = "tap";
                        break;
                    }
                    case "Q": {
                        symbol = "untap";
                        break;
                    }
                    case "S": {
                        symbol = "snow";
                        break;
                    }
                    case "H": {
                        symbol = "h";
                    }
                }
                String url = String.format(GathererSymbols.urlFmt, sizes[modSizeIndex], symbol);
                return new DownloadJob(sym, url, DownloadJob.toFile(dst), false);
            }
        };
    }

    static {
        sizes = new String[]{"small", "medium", "large"};
        symbols = new String[]{"W", "U", "B", "R", "G", "W/U", "U/B", "B/R", "R/G", "G/W", "W/B", "U/R", "B/G", "R/W", "G/U", "W/U/P", "U/B/P", "B/R/P", "R/G/P", "G/W/P", "W/B/P", "U/R/P", "B/G/P", "R/W/P", "G/U/P", "2/W", "2/U", "2/B", "2/R", "2/G", "C/W", "C/U", "C/B", "C/R", "C/G", "WP", "UP", "BP", "RP", "GP", "X", "S", "T", "Q", "C", "E", "H", "P"};
    }
}

