/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.util.List;
import java.util.Map;
import mage.cards.decks.CardNameUtil;
import org.mage.plugins.card.dl.sources.ScryfallApiCardFace;

public class ScryfallApiCard {
    public String id;
    public String name;
    public String set;
    public String collector_number;
    public String lang;
    public String layout;
    public List<ScryfallApiCardFace> card_faces;
    public String image_status;
    public Map<String, String> image_uris;
    public transient String imageSmall = "";
    public transient String imageNormal = "";
    public transient String imageLarge = "";

    public void prepareCompatibleData() {
        if (this.image_uris != null) {
            this.imageSmall = this.image_uris.getOrDefault("small", "");
            this.imageNormal = this.image_uris.getOrDefault("normal", "");
            this.imageLarge = this.image_uris.getOrDefault("large", "");
            this.image_uris = null;
        }
        if (this.card_faces != null) {
            this.card_faces.forEach(ScryfallApiCardFace::prepareCompatibleData);
        }
        if (this.layout.equals("adventure")) {
            this.name = this.card_faces.get((int)0).name;
        }
        if (this.layout.equals("flip")) {
            if (!this.card_faces.get((int)0).imageNormal.isEmpty() || !this.card_faces.get((int)1).imageNormal.isEmpty()) {
                throw new IllegalArgumentException("Scryfall: unsupported data type, flip parts must not have images data in scryfall " + this.set + " - " + this.collector_number + " - " + this.name);
            }
            this.name = this.card_faces.get((int)0).name;
            this.card_faces.get((int)0).image_uris = this.image_uris;
            this.card_faces.get((int)0).imageSmall = this.imageSmall;
            this.card_faces.get((int)0).imageNormal = this.imageNormal;
            this.card_faces.get((int)0).imageLarge = this.imageLarge;
            this.card_faces.get((int)1).image_uris = this.image_uris;
            this.card_faces.get((int)1).imageSmall = this.imageSmall;
            this.card_faces.get((int)1).imageNormal = this.imageNormal;
            this.card_faces.get((int)1).imageLarge = this.imageLarge;
        }
        if (this.layout.equals("reversible_card")) {
            if (this.card_faces == null) {
                if (this.name.contains("//")) {
                    throw new IllegalArgumentException("Scryfall: unsupported data type, broken reversible_card must have same simple name" + this.set + " - " + this.collector_number + " - " + this.name);
                }
            } else if (this.card_faces.get((int)0).layout.equals("reversible_card")) {
                this.name = this.card_faces.get((int)0).name;
            } else if (this.card_faces.get((int)0).layout == null || this.card_faces.get((int)0).layout.equals("normal")) {
                if (!this.card_faces.get((int)0).name.equals(this.card_faces.get((int)1).name)) {
                    throw new IllegalArgumentException("Scryfall: unsupported data type, normal reversible_card must have same name in faces" + this.set + " - " + this.collector_number + " - " + this.name);
                }
                this.name = this.card_faces.get((int)0).name;
            } else if (this.card_faces.get((int)0).layout.equals("adventure")) {
                this.name = this.card_faces.get((int)0).name;
                if (this.card_faces.get((int)0).name.equals(this.card_faces.get((int)1).name)) {
                    throw new IllegalArgumentException("Scryfall: unsupported data type, adventure/omen's reversible_card must have diff names in faces " + this.set + " - " + this.collector_number + " - " + this.name);
                }
            } else if (this.card_faces.get((int)0).layout.equals("token")) {
                this.name = this.card_faces.get((int)0).name;
            } else {
                throw new IllegalArgumentException("Scryfall: unsupported layout type in reversible_card - " + this.card_faces.get((int)0).layout + " - " + this.set + " - " + this.collector_number + " - " + this.name);
            }
        }
        this.name = CardNameUtil.normalizeCardName(this.name);
        this.collector_number = ScryfallApiCard.transformCardNumberFromScryfallToXmage(this.collector_number);
    }

    public static String transformCardNumberFromXmageToScryfall(String cardNumber) {
        String res = cardNumber;
        if (res.endsWith("*")) {
            res = res.substring(0, res.length() - 1) + "\u2605";
        }
        if (res.endsWith("+")) {
            res = res.substring(0, res.length() - 1) + "\u2020";
        }
        if (res.endsWith("Ph")) {
            res = res.substring(0, res.length() - 2) + "\u03a6";
        }
        return res;
    }

    public static String transformCardNumberFromScryfallToXmage(String cardNumber) {
        String res = cardNumber;
        if (res.endsWith("\u2605")) {
            res = res.substring(0, res.length() - 1) + "*";
        }
        if (res.endsWith("\u2020")) {
            res = res.substring(0, res.length() - 1) + "+";
        }
        if (res.endsWith("\u03a6")) {
            res = res.substring(0, res.length() - 1) + "Ph";
        }
        return res;
    }

    public String findImage(String imageSize) {
        switch (imageSize) {
            case "small": {
                return this.imageSmall;
            }
            case "normal": {
                return this.imageNormal;
            }
            case "large": {
                return this.imageLarge;
            }
        }
        throw new IllegalArgumentException("Unsupported image size: " + imageSize);
    }
}

