/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.dl.sources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.client.remote.XmageURLConnection;
import mage.client.util.CardLanguage;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.mage.plugins.card.dl.DownloadServiceInfo;
import org.mage.plugins.card.dl.sources.CardImageSource;
import org.mage.plugins.card.dl.sources.CardImageUrls;
import org.mage.plugins.card.images.CardDownloadData;

public enum WizardCardsImageSource implements CardImageSource
{
    instance;

    private static final Logger logger;
    private final Map<String, String> setsAliases;
    private final Map<CardLanguage, String> languageAliases;
    private final Map<String, Map<String, String>> sets;
    private final Set<String> supportedSets;
    private CardLanguage currentLanguage = CardLanguage.ENGLISH;

    @Override
    public String getSourceName() {
        return "WOTC Gatherer";
    }

    private WizardCardsImageSource() {
        this.languageAliases = new EnumMap<CardLanguage, String>(CardLanguage.class);
        this.languageAliases.put(CardLanguage.ENGLISH, "English");
        this.languageAliases.put(CardLanguage.SPANISH, "Spanish");
        this.languageAliases.put(CardLanguage.FRENCH, "French");
        this.languageAliases.put(CardLanguage.GERMAN, "German");
        this.languageAliases.put(CardLanguage.ITALIAN, "Italian");
        this.languageAliases.put(CardLanguage.PORTUGUESE, "Portuguese (Brazil)");
        this.languageAliases.put(CardLanguage.JAPANESE, "Japanese");
        this.languageAliases.put(CardLanguage.KOREAN, "Korean");
        this.languageAliases.put(CardLanguage.RUSSIAN, "Russian");
        this.languageAliases.put(CardLanguage.CHINES_SIMPLE, "Chinese Simplified");
        this.languageAliases.put(CardLanguage.CHINES_TRADITION, "Chinese Traditional ");
        this.supportedSets = new LinkedHashSet<String>();
        this.supportedSets.add("LEA");
        this.supportedSets.add("LEB");
        this.supportedSets.add("2ED");
        this.supportedSets.add("ARN");
        this.supportedSets.add("ATQ");
        this.supportedSets.add("3ED");
        this.supportedSets.add("LEG");
        this.supportedSets.add("DRK");
        this.supportedSets.add("FEM");
        this.supportedSets.add("4ED");
        this.supportedSets.add("ICE");
        this.supportedSets.add("CHR");
        this.supportedSets.add("HML");
        this.supportedSets.add("ALL");
        this.supportedSets.add("MIR");
        this.supportedSets.add("VIS");
        this.supportedSets.add("5ED");
        this.supportedSets.add("POR");
        this.supportedSets.add("WTH");
        this.supportedSets.add("TMP");
        this.supportedSets.add("STH");
        this.supportedSets.add("EXO");
        this.supportedSets.add("P02");
        this.supportedSets.add("UGL");
        this.supportedSets.add("USG");
        this.supportedSets.add("DD3DVD");
        this.supportedSets.add("DD3EVG");
        this.supportedSets.add("DD3GVL");
        this.supportedSets.add("DD3JVC");
        this.supportedSets.add("ULG");
        this.supportedSets.add("6ED");
        this.supportedSets.add("UDS");
        this.supportedSets.add("PTK");
        this.supportedSets.add("S99");
        this.supportedSets.add("MMQ");
        this.supportedSets.add("NEM");
        this.supportedSets.add("S00");
        this.supportedSets.add("PCY");
        this.supportedSets.add("INV");
        this.supportedSets.add("PLS");
        this.supportedSets.add("7ED");
        this.supportedSets.add("APC");
        this.supportedSets.add("ODY");
        this.supportedSets.add("TOR");
        this.supportedSets.add("JUD");
        this.supportedSets.add("ONS");
        this.supportedSets.add("LGN");
        this.supportedSets.add("SCG");
        this.supportedSets.add("8ED");
        this.supportedSets.add("MRD");
        this.supportedSets.add("DST");
        this.supportedSets.add("5DN");
        this.supportedSets.add("CHK");
        this.supportedSets.add("UNH");
        this.supportedSets.add("BOK");
        this.supportedSets.add("SOK");
        this.supportedSets.add("9ED");
        this.supportedSets.add("RAV");
        this.supportedSets.add("GPT");
        this.supportedSets.add("DIS");
        this.supportedSets.add("CSP");
        this.supportedSets.add("TSP");
        this.supportedSets.add("TSB");
        this.supportedSets.add("PLC");
        this.supportedSets.add("FUT");
        this.supportedSets.add("10E");
        this.supportedSets.add("MED");
        this.supportedSets.add("LRW");
        this.supportedSets.add("EVG");
        this.supportedSets.add("MOR");
        this.supportedSets.add("SHM");
        this.supportedSets.add("EVE");
        this.supportedSets.add("DRB");
        this.supportedSets.add("ME2");
        this.supportedSets.add("ALA");
        this.supportedSets.add("DD2");
        this.supportedSets.add("CON");
        this.supportedSets.add("DDC");
        this.supportedSets.add("ARB");
        this.supportedSets.add("M10");
        this.supportedSets.add("V09");
        this.supportedSets.add("HOP");
        this.supportedSets.add("ME3");
        this.supportedSets.add("ZEN");
        this.supportedSets.add("DDD");
        this.supportedSets.add("H09");
        this.supportedSets.add("WWK");
        this.supportedSets.add("DDE");
        this.supportedSets.add("ROE");
        this.supportedSets.add("ARC");
        this.supportedSets.add("M11");
        this.supportedSets.add("V10");
        this.supportedSets.add("DDF");
        this.supportedSets.add("SOM");
        this.supportedSets.add("PD2");
        this.supportedSets.add("ME4");
        this.supportedSets.add("MBS");
        this.supportedSets.add("DDG");
        this.supportedSets.add("NPH");
        this.supportedSets.add("CMD");
        this.supportedSets.add("M12");
        this.supportedSets.add("V11");
        this.supportedSets.add("DDH");
        this.supportedSets.add("ISD");
        this.supportedSets.add("PD3");
        this.supportedSets.add("DKA");
        this.supportedSets.add("DDI");
        this.supportedSets.add("AVR");
        this.supportedSets.add("PC2");
        this.supportedSets.add("M13");
        this.supportedSets.add("V12");
        this.supportedSets.add("DDJ");
        this.supportedSets.add("RTR");
        this.supportedSets.add("CM1");
        this.supportedSets.add("GTC");
        this.supportedSets.add("DDK");
        this.supportedSets.add("DGM");
        this.supportedSets.add("MMA");
        this.supportedSets.add("M14");
        this.supportedSets.add("V13");
        this.supportedSets.add("DDL");
        this.supportedSets.add("THS");
        this.supportedSets.add("C13");
        this.supportedSets.add("BNG");
        this.supportedSets.add("DDM");
        this.supportedSets.add("JOU");
        this.supportedSets.add("CNS");
        this.supportedSets.add("VMA");
        this.supportedSets.add("M15");
        this.supportedSets.add("V14");
        this.supportedSets.add("DDN");
        this.supportedSets.add("KTK");
        this.supportedSets.add("C14");
        this.supportedSets.add("FRF");
        this.supportedSets.add("DDO");
        this.supportedSets.add("DTK");
        this.supportedSets.add("TPR");
        this.supportedSets.add("MM2");
        this.supportedSets.add("ORI");
        this.supportedSets.add("V15");
        this.supportedSets.add("DDP");
        this.supportedSets.add("BFZ");
        this.supportedSets.add("EXP");
        this.supportedSets.add("C15");
        this.supportedSets.add("OGW");
        this.supportedSets.add("DDQ");
        this.supportedSets.add("W16");
        this.supportedSets.add("SOI");
        this.supportedSets.add("EMA");
        this.supportedSets.add("EMN");
        this.supportedSets.add("V16");
        this.supportedSets.add("CN2");
        this.supportedSets.add("DDR");
        this.supportedSets.add("KLD");
        this.supportedSets.add("MPS");
        this.supportedSets.add("C16");
        this.supportedSets.add("PCA");
        this.supportedSets.add("AER");
        this.supportedSets.add("MM3");
        this.supportedSets.add("DDS");
        this.supportedSets.add("W17");
        this.supportedSets.add("AKH");
        this.supportedSets.add("CMA");
        this.supportedSets.add("CM2");
        this.supportedSets.add("E01");
        this.supportedSets.add("HOU");
        this.supportedSets.add("C17");
        this.supportedSets.add("XLN");
        this.supportedSets.add("DDT");
        this.supportedSets.add("DDU");
        this.supportedSets.add("IMA");
        this.supportedSets.add("E02");
        this.supportedSets.add("V17");
        this.supportedSets.add("UST");
        this.supportedSets.add("RIX");
        this.supportedSets.add("A25");
        this.supportedSets.add("DOM");
        this.supportedSets.add("BBD");
        this.supportedSets.add("GS1");
        this.supportedSets.add("M19");
        this.supportedSets.add("C18");
        this.sets = new HashMap<String, Map<String, String>>();
        this.setsAliases = new HashMap<String, String>();
        this.setsAliases.put("2ED", "Unlimited Edition");
        this.setsAliases.put("10E", "Tenth Edition");
        this.setsAliases.put("3ED", "Revised Edition");
        this.setsAliases.put("4ED", "Fourth Edition");
        this.setsAliases.put("5DN", "Fifth Dawn");
        this.setsAliases.put("5ED", "Fifth Edition");
        this.setsAliases.put("6ED", "Classic Sixth Edition");
        this.setsAliases.put("7ED", "Seventh Edition");
        this.setsAliases.put("8ED", "Eighth Edition");
        this.setsAliases.put("9ED", "Ninth Edition");
        this.setsAliases.put("AER", "Aether Revolt");
        this.setsAliases.put("AKH", "Amonkhet");
        this.setsAliases.put("ALA", "Shards of Alara");
        this.setsAliases.put("ALL", "Alliances");
        this.setsAliases.put("ANB", "Archenemy: Nicol Bolas");
        this.setsAliases.put("APC", "Apocalypse");
        this.setsAliases.put("ARB", "Alara Reborn");
        this.setsAliases.put("ARC", "Archenemy");
        this.setsAliases.put("ARN", "Arabian Nights");
        this.setsAliases.put("ATH", "Anthologies");
        this.setsAliases.put("ATQ", "Antiquities");
        this.setsAliases.put("AVR", "Avacyn Restored");
        this.setsAliases.put("BFZ", "Battle for Zendikar");
        this.setsAliases.put("BNG", "Born of the Gods");
        this.setsAliases.put("BOK", "Betrayers of Kamigawa");
        this.setsAliases.put("BRB", "Battle Royale Box Set");
        this.setsAliases.put("BTD", "Beatdown Box Set");
        this.setsAliases.put("C13", "Commander 2013");
        this.setsAliases.put("C14", "Commander 2014");
        this.setsAliases.put("C15", "Commander 2015");
        this.setsAliases.put("C16", "Commander 2016");
        this.setsAliases.put("C17", "Commander 2017");
        this.setsAliases.put("CMA", "Commander Anthology");
        this.setsAliases.put("CM2", "Commander Anthology 2018");
        this.setsAliases.put("CHK", "Champions of Kamigawa");
        this.setsAliases.put("CHR", "Chronicles");
        this.setsAliases.put("CMD", "Magic: The Gathering-Commander");
        this.setsAliases.put("CNS", "Magic: The Gathering\u2014Conspiracy");
        this.setsAliases.put("CN2", "Conspiracy: Take the Crown");
        this.setsAliases.put("CON", "Conflux");
        this.setsAliases.put("CSP", "Coldsnap");
        this.setsAliases.put("DD2", "Duel Decks: Jace vs. Chandra");
        this.setsAliases.put("DD3DVD", "Duel Decks Anthology, Divine vs. Demonic");
        this.setsAliases.put("DD3EVG", "Duel Decks Anthology, Elves vs. Goblins");
        this.setsAliases.put("DD3GVL", "Duel Decks Anthology, Garruk vs. Liliana");
        this.setsAliases.put("DD3JVC", "Duel Decks Anthology, Jace vs. Chandra");
        this.setsAliases.put("DDC", "Duel Decks: Divine vs. Demonic");
        this.setsAliases.put("DDD", "Duel Decks: Garruk vs. Liliana");
        this.setsAliases.put("DDE", "Duel Decks: Phyrexia vs. the Coalition");
        this.setsAliases.put("DDF", "Duel Decks: Elspeth vs. Tezzeret");
        this.setsAliases.put("DDG", "Duel Decks: Knights vs. Dragons");
        this.setsAliases.put("DDH", "Duel Decks: Ajani vs. Nicol Bolas");
        this.setsAliases.put("DDI", "Duel Decks: Venser vs. Koth");
        this.setsAliases.put("DDJ", "Duel Decks: Izzet vs. Golgari");
        this.setsAliases.put("DDK", "Duel Decks: Sorin vs. Tibalt");
        this.setsAliases.put("DDL", "Duel Decks: Heroes vs. Monsters");
        this.setsAliases.put("DDM", "Duel Decks: Jace vs. Vraska");
        this.setsAliases.put("DDN", "Duel Decks: Speed vs. Cunning");
        this.setsAliases.put("DDO", "Duel Decks: Elspeth vs. Kiora");
        this.setsAliases.put("DDP", "Duel Decks: Zendikar vs. Eldrazi");
        this.setsAliases.put("DDQ", "Duel Decks: Blessed vs. Cursed");
        this.setsAliases.put("DDR", "Duel Decks: Nissa vs. Ob Nixilis");
        this.setsAliases.put("DDS", "Duel Decks: Mind vs. Might");
        this.setsAliases.put("DDT", "Duel Decks: Merfolk vs. Goblins");
        this.setsAliases.put("DDU", "Duel Decks: Elves vs. Inventors");
        this.setsAliases.put("DGM", "Dragon's Maze");
        this.setsAliases.put("DIS", "Dissension");
        this.setsAliases.put("DKA", "Dark Ascension");
        this.setsAliases.put("DKM", "Deckmasters");
        this.setsAliases.put("DRB", "From the Vault: Dragons");
        this.setsAliases.put("DRK", "The Dark");
        this.setsAliases.put("DST", "Darksteel");
        this.setsAliases.put("DTK", "Dragons of Tarkir");
        this.setsAliases.put("E01", "Archenemy: Nicol Bolas");
        this.setsAliases.put("EMN", "Eldritch Moon");
        this.setsAliases.put("EMA", "Eternal Masters");
        this.setsAliases.put("EVE", "Eventide");
        this.setsAliases.put("EVG", "Duel Decks: Elves vs. Goblins");
        this.setsAliases.put("EXO", "Exodus");
        this.setsAliases.put("FEM", "Fallen Empires");
        this.setsAliases.put("FRF", "Fate Reforged");
        this.setsAliases.put("FUT", "Future Sight");
        this.setsAliases.put("GPT", "Guildpact");
        this.setsAliases.put("PGPX", "Grand Prix");
        this.setsAliases.put("GTC", "Gatecrash");
        this.setsAliases.put("H09", "Premium Deck Series: Slivers");
        this.setsAliases.put("HML", "Homelands");
        this.setsAliases.put("HOP", "Planechase");
        this.setsAliases.put("HOU", "Hour of Devastation");
        this.setsAliases.put("ICE", "Ice Age");
        this.setsAliases.put("IMA", "Iconic Masters");
        this.setsAliases.put("INV", "Invasion");
        this.setsAliases.put("ISD", "Innistrad");
        this.setsAliases.put("JOU", "Journey into Nyx");
        this.setsAliases.put("JUD", "Judgment");
        this.setsAliases.put("KLD", "Kaladesh");
        this.setsAliases.put("KTK", "Khans of Tarkir");
        this.setsAliases.put("LEA", "Limited Edition Alpha");
        this.setsAliases.put("LEB", "Limited Edition Beta");
        this.setsAliases.put("LEG", "Legends");
        this.setsAliases.put("LGN", "Legions");
        this.setsAliases.put("LRW", "Lorwyn");
        this.setsAliases.put("M10", "Magic 2010");
        this.setsAliases.put("M11", "Magic 2011");
        this.setsAliases.put("M12", "Magic 2012");
        this.setsAliases.put("M13", "Magic 2013");
        this.setsAliases.put("M14", "Magic 2014");
        this.setsAliases.put("M15", "Magic 2015");
        this.setsAliases.put("PMEI", "Media and Collaboration Promos");
        this.setsAliases.put("MBS", "Mirrodin Besieged");
        this.setsAliases.put("ME2", "Masters Edition II");
        this.setsAliases.put("ME3", "Masters Edition III");
        this.setsAliases.put("ME4", "Masters Edition IV");
        this.setsAliases.put("MED", "Masters Edition");
        this.setsAliases.put("MIR", "Mirage");
        this.setsAliases.put("MMA", "Modern Masters");
        this.setsAliases.put("MM2", "Modern Masters 2015");
        this.setsAliases.put("MM3", "Modern Masters 2017");
        this.setsAliases.put("MMQ", "Mercadian Masques");
        this.setsAliases.put("MOR", "Morningtide");
        this.setsAliases.put("MPS", "Masterpiece Series");
        this.setsAliases.put("MRD", "Mirrodin");
        this.setsAliases.put("NEM", "Nemesis");
        this.setsAliases.put("NPH", "New Phyrexia");
        this.setsAliases.put("OGW", "Oath of the Gatewatch");
        this.setsAliases.put("ODY", "Odyssey");
        this.setsAliases.put("ONS", "Onslaught");
        this.setsAliases.put("ORI", "Magic Origins");
        this.setsAliases.put("PC2", "Planechase 2012");
        this.setsAliases.put("PCY", "Prophecy");
        this.setsAliases.put("PD2", "Premium Deck Series: Fire and Lightning");
        this.setsAliases.put("PLC", "Planar Chaos");
        this.setsAliases.put("PLS", "Planeshift");
        this.setsAliases.put("PO2", "Portal Second Age");
        this.setsAliases.put("POR", "Portal");
        this.setsAliases.put("PTK", "Portal Three Kingdoms");
        this.setsAliases.put("RAV", "Ravnica: City of Guilds");
        this.setsAliases.put("ROE", "Rise of the Eldrazi");
        this.setsAliases.put("RTR", "Return to Ravnica");
        this.setsAliases.put("S00", "Starter 2000");
        this.setsAliases.put("S99", "Starter 1999");
        this.setsAliases.put("SCG", "Scourge");
        this.setsAliases.put("SHM", "Shadowmoor");
        this.setsAliases.put("SOI", "Shadows over Innistrad");
        this.setsAliases.put("SOK", "Saviors of Kamigawa");
        this.setsAliases.put("SOM", "Scars of Mirrodin");
        this.setsAliases.put("STH", "Stronghold");
        this.setsAliases.put("THS", "Theros");
        this.setsAliases.put("TMP", "Tempest");
        this.setsAliases.put("TOR", "Torment");
        this.setsAliases.put("TPR", "Tempest Remastered");
        this.setsAliases.put("TSB", "Time Spiral Timeshifted");
        this.setsAliases.put("TSP", "Time Spiral");
        this.setsAliases.put("UDS", "Urza's Destiny");
        this.setsAliases.put("UGL", "Unglued");
        this.setsAliases.put("ULG", "Urza's Legacy");
        this.setsAliases.put("UNH", "Unhinged");
        this.setsAliases.put("USG", "Urza's Saga");
        this.setsAliases.put("V09", "From the Vault: Exiled");
        this.setsAliases.put("V10", "From the Vault: Relics");
        this.setsAliases.put("V11", "From the Vault: Legends");
        this.setsAliases.put("V12", "From the Vault: Realms");
        this.setsAliases.put("V13", "From the Vault: Twenty");
        this.setsAliases.put("V14", "From the Vault: Annihilation (2014)");
        this.setsAliases.put("V15", "From the Vault: Angels (2015)");
        this.setsAliases.put("V16", "From the Vault: Lore (2016)");
        this.setsAliases.put("VG1", "Vanguard Set 1");
        this.setsAliases.put("VG2", "Vanguard Set 2");
        this.setsAliases.put("VG3", "Vanguard Set 3");
        this.setsAliases.put("VG4", "Vanguard Set 4");
        this.setsAliases.put("VGO", "MTGO Vanguard");
        this.setsAliases.put("VIS", "Visions");
        this.setsAliases.put("VMA", "Vintage Masters");
        this.setsAliases.put("W16", "Welcome Deck 2016");
        this.setsAliases.put("W17", "Welcome Deck 2017");
        this.setsAliases.put("WTH", "Weatherlight");
        this.setsAliases.put("WWK", "Worldwake");
        this.setsAliases.put("ZEN", "Zendikar");
    }

    @Override
    public String getNextHttpImageUrl() {
        return null;
    }

    @Override
    public String getFileForHttpImage(String httpImageUrl) {
        return null;
    }

    @Override
    public boolean prepareDownloadList(DownloadServiceInfo downloadServiceInfo, List<CardDownloadData> downloadList) {
        return true;
    }

    @Override
    public CardImageUrls generateCardUrl(CardDownloadData card) throws Exception {
        String collectorId = card.getCollectorId();
        String cardSet = card.getSet();
        if (collectorId == null || cardSet == null) {
            throw new Exception("Wrong parameters for image: collector id: " + collectorId + ", card set: " + cardSet);
        }
        if (card.isFlippedSide()) {
            return null;
        }
        Map setLinks = this.sets.computeIfAbsent(cardSet, k -> this.getSetLinks(cardSet));
        if (setLinks == null || setLinks.isEmpty()) {
            return null;
        }
        String searchKey = card.getDownloadName().toLowerCase(Locale.ENGLISH).replace(" ", "").replace("&", "//");
        String link = (String)setLinks.get(searchKey);
        if (link == null) {
            int number;
            String key;
            int length = collectorId.length();
            if (Character.isLetter(collectorId.charAt(length - 1))) {
                key = searchKey + collectorId.charAt(length - 1);
                link = (String)setLinks.get(key);
            }
            if (link == null && (link = (String)setLinks.get(key = searchKey + collectorId)) == null && (number = Integer.parseInt(collectorId.substring(0, length))) > 0) {
                ArrayList l = new ArrayList(setLinks.values());
                if (l.size() >= number) {
                    link = (String)l.get(number - 1);
                } else {
                    link = (String)l.get(number - 21);
                    if (link != null) {
                        link = link.replace(Integer.toString(number - 20), Integer.toString(number - 20) + 'a');
                    }
                }
            }
        }
        if (link != null && !link.startsWith("https://")) {
            link = "https://gatherer.wizards.com" + link;
        }
        if (link != null) {
            return new CardImageUrls(link);
        }
        return null;
    }

    private Map<String, String> getSetLinks(String cardSet) {
        LinkedHashMap<String, String> setLinks = new LinkedHashMap<String, String>();
        try {
            String setNames = this.setsAliases.get(cardSet);
            if (setNames == null) {
                setNames = ((ExpansionSet)Sets.getInstance().get(cardSet)).getName();
            }
            block2: for (String setName : setNames.split("\\^")) {
                String URLSetName = setName.replaceAll(" ", "%20");
                int firstMultiverseIdLastPage = 0;
                for (int page = 0; page < 999; ++page) {
                    String searchUrl = "https://gatherer.wizards.com/Pages/Search/Default.aspx?sort=cn+&page=" + page + "&action=advanced&output=spoiler&method=visual&set=+%5B%22" + URLSetName + "%22%5D";
                    logger.debug((Object)("URL: " + searchUrl));
                    String sourceData = XmageURLConnection.downloadText(searchUrl);
                    Document doc = Jsoup.parse((String)sourceData);
                    Elements cardsImages = doc.select("img[src^=../../Handlers/]");
                    if (cardsImages.isEmpty()) continue block2;
                    for (int i = 0; i < cardsImages.size(); ++i) {
                        int pos2;
                        String cardName;
                        Integer multiverseId = Integer.parseInt(((Element)cardsImages.get(i)).attr("src").replaceAll("[^\\d]", ""));
                        if (i == 0) {
                            if (multiverseId == firstMultiverseIdLastPage) continue block2;
                            firstMultiverseIdLastPage = multiverseId;
                        }
                        if ((cardName = this.normalizeName(((Element)cardsImages.get(i)).attr("alt"))) == null || cardName.isEmpty()) continue;
                        if (cardName.equals("Forest") || cardName.equals("Swamp") || cardName.equals("Mountain") || cardName.equals("Island") || cardName.equals("Plains") || cardName.equals("Wastes")) {
                            this.getLandVariations(setLinks, cardSet, multiverseId, cardName);
                            continue;
                        }
                        String numberChar = "";
                        int pos1 = cardName.indexOf(40);
                        if (pos1 > 0 && (pos2 = cardName.indexOf(40, pos1 + 1)) > 0) {
                            numberChar = cardName.substring(pos2 + 1, pos2 + 2);
                            cardName = cardName.substring(0, pos1);
                        }
                        Integer preferredMultiverseId = this.getLocalizedMultiverseId(this.getCurrentLanguage(), multiverseId);
                        setLinks.put(cardName.toLowerCase(Locale.ENGLISH) + numberChar, WizardCardsImageSource.generateLink(preferredMultiverseId));
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)("Exception when parsing the wizards page: " + ex.getMessage()));
        }
        return setLinks;
    }

    private void getLandVariations(LinkedHashMap<String, String> setLinks, String cardSet, int multiverseId, String cardName) {
        CardCriteria criteria = new CardCriteria();
        criteria.name(cardName);
        criteria.setCodes(cardSet);
        List<CardInfo> cards = CardRepository.instance.findCards(criteria);
        String urlLandDocument = "https://gatherer.wizards.com/Pages/Card/Details.aspx?multiverseid=" + multiverseId;
        String sourceData = XmageURLConnection.downloadText(urlLandDocument);
        Document landDoc = Jsoup.parse((String)sourceData);
        Elements variations = landDoc.select("a.variationlink");
        if (!variations.isEmpty()) {
            if (variations.size() > cards.size()) {
                logger.warn((Object)("More links for lands than cards in DB found for set: " + cardSet + " Name: " + cardName));
            }
            if (variations.size() < cards.size()) {
                logger.warn((Object)("Less links for lands than cards in DB found for set: " + cardSet + " Name: " + cardName));
            }
            int iteration = 0;
            for (Element variation : variations) {
                CardInfo cardInfo;
                String colNumb = String.valueOf(iteration);
                if (cards.size() > iteration && (cardInfo = cards.get(iteration)) != null) {
                    colNumb = cardInfo.getCardNumber();
                }
                Integer landMultiverseId = Integer.parseInt(variation.attr("href").replaceAll("[^\\d]", ""));
                setLinks.put(cardName.toLowerCase(Locale.ENGLISH) + colNumb, WizardCardsImageSource.generateLink(landMultiverseId));
                ++iteration;
            }
        } else {
            setLinks.put(cardName.toLowerCase(Locale.ENGLISH), WizardCardsImageSource.generateLink(multiverseId));
        }
    }

    private static String generateLink(int landMultiverseId) {
        return "/Handlers/Image.ashx?multiverseid=" + landMultiverseId + "&type=card";
    }

    private int getLocalizedMultiverseId(CardLanguage preferredLanguage, Integer multiverseId) throws IOException {
        if (preferredLanguage.equals((Object)CardLanguage.ENGLISH)) {
            return multiverseId;
        }
        String languageName = this.languageAliases.get((Object)preferredLanguage);
        Map<String, Integer> localizedLanguageIds = this.getlocalizedMultiverseIds(multiverseId);
        if (localizedLanguageIds.containsKey(languageName)) {
            return localizedLanguageIds.get(languageName);
        }
        return multiverseId;
    }

    private Map<String, Integer> getlocalizedMultiverseIds(Integer englishMultiverseId) {
        String cardLanguagesUrl = "https://gatherer.wizards.com/Pages/Card/Languages.aspx?multiverseid=" + englishMultiverseId;
        String sourceData = XmageURLConnection.downloadText(cardLanguagesUrl);
        Document cardLanguagesDoc = Jsoup.parse((String)sourceData);
        Elements languageTableRows = cardLanguagesDoc.select("tr.cardItem");
        HashMap<String, Integer> localizedIds = new HashMap<String, Integer>();
        if (!languageTableRows.isEmpty()) {
            for (Element languageTableRow : languageTableRows) {
                Elements languageTableColumns = languageTableRow.select("td");
                Integer localizedId = Integer.parseInt(((Element)languageTableColumns.get(0)).select("a").first().attr("href").replaceAll("[^\\d]", ""));
                String languageName = ((Element)languageTableColumns.get(1)).text().trim();
                localizedIds.put(languageName, localizedId);
            }
        }
        return localizedIds;
    }

    private String normalizeName(String name) {
        if (name.contains("//") && name.indexOf(40) > 0) {
            name = name.substring(0, name.indexOf(40) - 1);
        }
        if (name.startsWith("XX")) {
            name = name.substring(name.indexOf(40) + 1, name.length() - 1);
        }
        return name.replace("\u2014", "-").replace("\u2019", "'").replace("\u00c6", "AE").replace("\u00e6", "ae").replace("\u00c3\u2020", "AE").replace("\u00c1", "A").replace("\u00e1", "a").replace("\u00c2", "A").replace("\u00e2", "a").replace("\u00d6", "O").replace("\u00f6", "o").replace("\u00db", "U").replace("\u00fb", "u").replace("\u00dc", "U").replace("\u00fc", "u").replace("\u00e9", "e").replace("&", "//").replace(" ", "").replace("Hintreland Scourge", "Hinterland Scourge");
    }

    @Override
    public CardImageUrls generateTokenUrl(CardDownloadData card) {
        return null;
    }

    @Override
    public float getAverageSizeKb() {
        return 60.0f;
    }

    @Override
    public int getTotalImages() {
        return -1;
    }

    @Override
    public boolean isTokenSource() {
        return false;
    }

    @Override
    public boolean isCardSource() {
        return true;
    }

    @Override
    public boolean isLanguagesSupport() {
        return true;
    }

    @Override
    public void setCurrentLanguage(CardLanguage cardLanguage) {
        this.currentLanguage = cardLanguage;
    }

    @Override
    public CardLanguage getCurrentLanguage() {
        return this.currentLanguage;
    }

    @Override
    public List<String> getSupportedSets() {
        return new ArrayList<String>(this.supportedSets);
    }

    @Override
    public boolean isCardImageProvided(String setCode, String cardName) {
        return this.supportedSets.contains(setCode);
    }

    static {
        logger = Logger.getLogger(WizardCardsImageSource.class);
    }
}

