/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.card.info;

import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import mage.client.util.GUISizeHelper;
import mage.client.util.gui.GuiDisplayUtil;
import mage.components.CardInfoPane;
import mage.view.CardView;
import org.mage.card.arcane.UI;

public class CardInfoPaneImpl
extends JEditorPane
implements CardInfoPane {
    public static final int TOOLTIP_WIDTH_MIN = 160;
    public static final int TOOLTIP_HEIGHT_MIN = 120;
    public static final int TOOLTIP_HEIGHT_MAX = 300;
    public static final int TOOLTIP_BORDER_WIDTH = 80;
    private int type;
    private int addWidth;
    private int addHeight;
    private boolean setSize = false;

    public CardInfoPaneImpl() {
        UI.setHTMLEditorKit(this);
        this.setEditable(false);
        this.setGUISize();
    }

    public void changeGUISize() {
        this.setGUISize();
        this.revalidate();
        this.repaint();
    }

    private void setGUISize() {
        this.addWidth = GUISizeHelper.cardTooltipLargeTextWidth;
        this.addHeight = GUISizeHelper.cardTooltipLargeTextHeight;
        this.setSize = true;
    }

    public void setCard(CardView card, Component container) {
        try {
            SwingUtilities.invokeLater(() -> {
                GuiDisplayUtil.TextLines textLines = GuiDisplayUtil.getTextLinesfromCardView(card);
                StringBuilder buffer = GuiDisplayUtil.getRulesFromCardView(card, textLines);
                this.resizeTooltipIfNeeded(container, textLines.getBasicTextLength(), textLines.getLines().size());
                this.setText(buffer.toString());
                this.setCaretPosition(0);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resizeTooltipIfNeeded(Component container, int ruleLength, int rules) {
        boolean makeBig;
        if (container == null) {
            return;
        }
        boolean bl = makeBig = rules > 5 || ruleLength > 350;
        if (this.setSize) {
            this.type = makeBig ? 0 : 1;
        }
        if (makeBig && this.type == 0) {
            this.type = 1;
            container.setSize(this.addWidth + 160 + 80, this.addHeight + 300 + 80);
            this.setSize(this.addWidth + 160, this.addHeight + 300);
        } else if (!makeBig && this.type == 1) {
            this.type = 0;
            container.setSize(this.addWidth + 160 + 80, this.addHeight + 120 + 80);
            this.setSize(this.addWidth + 160, this.addHeight + 120);
        }
    }
}

